/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sourceid.common.ExpressionMatchComparator;
import org.sourceid.common.Util;

public class ExpressionMatchHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<String> literals = new ArrayList<String>();
    private List<String> regExpressions = new ArrayList<String>();
    boolean isCaseSensitive = true;

    public ExpressionMatchHandler(Collection<String> expressions, boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        this.init(expressions);
    }

    protected Collection<String> getLiterals() {
        return this.literals;
    }

    protected List<String> getRegExpressions() {
        return this.regExpressions;
    }

    private void init(Collection<String> expressions) {
        this.regExpressions.clear();
        this.literals.clear();
        if (expressions == null) {
            return;
        }
        ExpressionMatchComparator expressionComparator = new ExpressionMatchComparator();
        for (String expression : expressions) {
            boolean isRegEx = expression.contains("*");
            if (isRegEx) {
                this.regExpressions.add(expression);
                continue;
            }
            this.literals.add(expression);
        }
        Collections.sort(this.regExpressions, expressionComparator);
    }

    public String getBestMatchedExpression(String text) {
        if (text != null) {
            for (String literal : this.literals) {
                if (literal.equals(text)) {
                    return literal;
                }
                if (this.isCaseSensitive || !literal.toLowerCase().equals(text.toLowerCase())) continue;
                return literal;
            }
            for (String regExp : this.regExpressions) {
                if (!Util.wildCardMatch(text, regExp, this.isCaseSensitive)) continue;
                return regExp;
            }
        }
        return null;
    }
}

