/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class PasswordRules {
    private static final Log LOG = LogFactory.getLog(PasswordRules.class);
    private static final boolean DEFAULT_REQUIRE_MIXED_CASE = true;
    static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MIN_NUMERIC = 1;
    private static final int DEFAULT_MIN_ALPHA = 2;
    private static final int DEFAULT_MIN_SPECIAL_CHAR = 0;
    private static final String DEFAULT_SPECIAL_CHARS = "!$%^&*()_+|~-=\\`{}[]:\";'<>?,/";
    private final boolean requireMixedCase;
    private final int minLength;
    private final int minNumeric;
    private final int minAlpha;
    private final int minSpecial;
    private final char[] specialChars;

    public PasswordRules() {
        ConfigStore configStore = ConfigStoreFarm.getConfig("password-rules");
        this.requireMixedCase = configStore.getBooleanValue("requireMixedCase", true);
        this.minLength = configStore.getIntValue("minLength", 8);
        this.minNumeric = configStore.getIntValue("minNumeric", 1);
        this.minAlpha = configStore.getIntValue("minAlpha", 2);
        this.minSpecial = configStore.getIntValue("minSpecial", 0);
        this.specialChars = configStore.getStringValue("specialChars", DEFAULT_SPECIAL_CHARS).toCharArray();
    }

    public PasswordRules(int minLengthOverride) {
        ConfigStore configStore = ConfigStoreFarm.getConfig("password-rules");
        this.requireMixedCase = configStore.getBooleanValue("requireMixedCase", true);
        int minLengthFromConfigStore = configStore.getIntValue("minLength", 8);
        if (minLengthOverride >= minLengthFromConfigStore) {
            this.minLength = minLengthOverride;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Provided minimum length [%d] is less than configured minimum length [%d]. Using the configured minimum length.", minLengthOverride, minLengthFromConfigStore));
            }
            this.minLength = minLengthFromConfigStore;
        }
        this.minNumeric = configStore.getIntValue("minNumeric", 1);
        this.minAlpha = configStore.getIntValue("minAlpha", 2);
        this.minSpecial = configStore.getIntValue("minSpecial", 0);
        this.specialChars = configStore.getStringValue("specialChars", DEFAULT_SPECIAL_CHARS).toCharArray();
    }

    public PasswordRules(int minLength, int minNumeric, int minAlpha, int minSpecial, char[] specialChars, boolean requireMixedCase) {
        this.minLength = minLength;
        this.minNumeric = minNumeric;
        this.minAlpha = minAlpha;
        this.minSpecial = minSpecial;
        this.specialChars = specialChars;
        this.requireMixedCase = requireMixedCase;
    }

    public boolean isRequireMixedCase() {
        return this.requireMixedCase;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMinNumeric() {
        return this.minNumeric;
    }

    public int getMinAlpha() {
        return this.minAlpha;
    }

    public int getMinSpecial() {
        return this.minSpecial;
    }

    public char[] getSpecialChars() {
        return this.specialChars;
    }

    public String randomValidPassword() {
        StringBuilder password = new StringBuilder(this.getMinLength());
        if (this.getMinSpecial() > 0) {
            password.append(IDGenerator.rndStr(this.getMinSpecial(), this.getSpecialChars()));
        }
        if (this.getMinNumeric() > 0) {
            password.append(IDGenerator.rndNumeric(this.getMinNumeric()));
        }
        if (this.getMinAlpha() > 0) {
            password.append(IDGenerator.rndAlpha(this.getMinAlpha()));
        }
        if (this.isRequireMixedCase()) {
            password.append(IDGenerator.rndAlpha(1).toUpperCase());
            password.append(IDGenerator.rndAlpha(1).toLowerCase());
        }
        if (password.length() < this.getMinLength()) {
            password.append(IDGenerator.rndAlphaNumeric(this.getMinLength() - password.length()));
        }
        return this.shuffleString(password.toString());
    }

    private String shuffleString(String password) {
        if (password.length() > 1) {
            String[] characters = password.split("");
            Collections.shuffle(Arrays.asList(characters));
            StringBuilder shuffled = new StringBuilder();
            for (String str : characters) {
                shuffled.append(str);
            }
            return shuffled.toString();
        }
        return password;
    }
}

