/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import com.pingidentity.sdk.SDKConstants;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.saml20.domain.AttributeContract;

public class Util {
    public static final String UTF_8 = "UTF-8";
    public static final Charset UTF8CS = Charset.forName("UTF-8");
    public static final String APPLICATION_JSON = "application/json";
    public static final String LINE_BREAK = SDKConstants.LINE_BREAK;
    public static final String WILDCARD_CHARACTER = "*";
    private static final char[] REGEX_SPECIAL_CHARS = new char[]{'[', ']', '\\', '^', '$', '.', '|', '?', '+', '(', ')', '{', '}'};
    private static String REGEX_SPECIAL_CHARS_PATTERN = null;

    public static Calendar getUtcCalendar() {
        XmlCalendar now = new XmlCalendar(new Date());
        now.setTimeZone(Util.getUtcTimeZone());
        return now;
    }

    public static TimeZone getUtcTimeZone() {
        return TimeZone.getTimeZone("UTC");
    }

    public static HashMap parseMultiValueQueryString(String query) throws UnsupportedEncodingException {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        StringTokenizer t = new StringTokenizer(query, "&");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            int index = s.indexOf("=");
            String name = s.substring(0, index);
            String value = s.substring(index + 1);
            name = URLDecoder.decode(name, UTF_8);
            value = URLDecoder.decode(value, UTF_8);
            if (retval.containsKey(name)) {
                Object o = retval.get(name);
                if (o instanceof String) {
                    String[] values = new String[]{(String)o, value};
                    retval.put(name, values);
                    continue;
                }
                int length = Array.getLength(o);
                String[] values = new String[length + 1];
                System.arraycopy(o, 0, values, 0, length);
                values[length] = value;
                retval.put(name, values);
                continue;
            }
            retval.put(name, value);
        }
        return retval;
    }

    public static Map<String, String> parseQueryString(String query, boolean doUrlDecode) {
        try {
            HashMap<String, String> retval = new HashMap<String, String>();
            StringTokenizer t = new StringTokenizer(query, "&");
            while (t.hasMoreTokens()) {
                String name;
                String s = t.nextToken();
                int index = s.indexOf("=");
                String value = null;
                if (index != -1) {
                    name = s.substring(0, index);
                    value = s.substring(index + 1);
                    if (doUrlDecode) {
                        name = URLDecoder.decode(name, UTF_8);
                        value = URLDecoder.decode(value, UTF_8);
                    }
                } else {
                    name = s;
                }
                if (retval.containsKey(name)) continue;
                retval.put(name, value);
            }
            return retval;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported????", e);
        }
    }

    public static String urlEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 unsupported?", e);
        }
    }

    public static String urlDecodeUTF8(String s) {
        try {
            return URLDecoder.decode(s, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 unsupported?", e);
        }
    }

    public static String appendQueryParams(String base, Map<String, ?> params) {
        boolean first;
        boolean hasQuery = StringUtils.contains((String)base, (String)"?");
        StringBuilder qbuf = new StringBuilder();
        boolean bl = first = !hasQuery;
        if (base != null) {
            qbuf.append(base);
        }
        if (params != null) {
            Iterator<Map.Entry<String, ?>> iterator = params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ?> o;
                Map.Entry<String, ?> entry = o = iterator.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                qbuf.append(first ? "?" : "&");
                first = false;
                if (value instanceof String) {
                    qbuf.append(key);
                    qbuf.append("=");
                    qbuf.append(Util.urlEncodeUTF8((String)value));
                    continue;
                }
                if (value instanceof Collection) {
                    boolean firstInCollection = true;
                    for (Object o1 : (Collection)value) {
                        if (!firstInCollection) {
                            qbuf.append("&");
                        }
                        firstInCollection = false;
                        qbuf.append(key);
                        qbuf.append("=");
                        String stringElement = o1.toString();
                        qbuf.append(Util.urlEncodeUTF8(stringElement));
                    }
                    continue;
                }
                if (value instanceof String[]) {
                    String[] stringElement = (String[])value;
                    boolean firstInArray = true;
                    for (String aStringElement : stringElement) {
                        if (!firstInArray) {
                            qbuf.append("&");
                        }
                        firstInArray = false;
                        qbuf.append(key);
                        qbuf.append("=");
                        qbuf.append(Util.urlEncodeUTF8(aStringElement));
                    }
                    continue;
                }
                qbuf.append(key);
                qbuf.append("=");
                qbuf.append(Util.urlEncodeUTF8(value.toString()));
            }
        }
        return qbuf.toString();
    }

    public static String createQueryString(Map<String, ?> params) {
        return Util.appendQueryParams(null, params);
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static String getUrlBase(HttpServletRequest req) throws MalformedURLException {
        URL reqURL = new URL(req.getRequestURL().toString());
        String path = req.getContextPath();
        URL baseUrl = new URL(reqURL.getProtocol(), reqURL.getHost(), reqURL.getPort(), path);
        return baseUrl.toString();
    }

    public static String canonicalizeX500DN(String inDN) {
        X500Principal x500DN = new X500Principal(inDN);
        return x500DN.getName("CANONICAL");
    }

    public static String getCN(String dn) {
        int index = dn.toLowerCase().indexOf("cn=");
        if (index == -1) {
            return null;
        }
        dn = dn.substring(index + 3);
        char[] dncs = dn.toCharArray();
        for (index = 0; index < dncs.length && (dncs[index] != ',' || index <= 0 || dncs[index - 1] == '\\'); ++index) {
        }
        return dn.substring(0, index);
    }

    public static String getKeyAlgorithmName(String fullAlgName) {
        String delim = "with";
        StringTokenizer s = new StringTokenizer(fullAlgName, delim);
        while (s.hasMoreTokens()) {
            String token = s.nextToken();
            if (!"RSA".equalsIgnoreCase(token) && !"DSA".equalsIgnoreCase(token)) continue;
            return token;
        }
        return null;
    }

    public static byte[] utf8bytes(String s) {
        try {
            return s.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 unsupported?", e);
        }
    }

    public static String listToCommaDelimString(List<String> l) {
        return Util.listToDelimString(l, ", ");
    }

    public static String setToCommaDelimString(Set<String> s) {
        LinkedList<String> l = new LinkedList<String>();
        l.addAll(s);
        return Util.listToDelimString(l, ", ");
    }

    public static String setToDelimString(Set<String> s, String delim) {
        LinkedList<String> l = new LinkedList<String>();
        l.addAll(s);
        return Util.listToDelimString(l, delim);
    }

    public static String listToDelimString(List<String> l, String delim) {
        if (l == null) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder(100);
        for (int i = 0; i < l.size(); ++i) {
            strBuilder.append(l.get(i));
            if (i >= l.size() - 1) continue;
            strBuilder.append(delim);
        }
        return strBuilder.toString();
    }

    public static void populateAttributeContractList(List<String> attributeContractList, AttributeContract attributeContract) {
        Object item;
        int i;
        List<String> sortedImmutableAttrNames = attributeContract.getSortedImmutableAttributeNames();
        List<String> sortedMutableAttrNames = attributeContract.getSortedMutableAttributeNames();
        for (i = 0; i < sortedImmutableAttrNames.size(); ++i) {
            item = sortedImmutableAttrNames.get(i);
            if (i < sortedImmutableAttrNames.size() - 1 || sortedMutableAttrNames.size() > 0) {
                item = ((String)item).trim() + ", ";
            }
            attributeContractList.add((String)item);
        }
        for (i = 0; i < sortedMutableAttrNames.size(); ++i) {
            item = sortedMutableAttrNames.get(i);
            if (i < sortedMutableAttrNames.size() - 1) {
                item = ((String)item).trim() + ", ";
            }
            attributeContractList.add((String)item);
        }
    }

    public static String stripSingleQuotes(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (String.valueOf(c).matches("'")) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean wildCardMatch(String text, String pattern) {
        Pattern p = Util.compileWildcardPattern(pattern);
        Matcher m = p.matcher(text);
        return m.matches();
    }

    public static boolean wildCardMatch(String text, String pattern, boolean isCaseSensitive) {
        if (!isCaseSensitive) {
            text = text.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        return Util.wildCardMatch(text, pattern);
    }

    public static Pattern compileWildcardPattern(String pattern) {
        pattern = pattern.replaceAll(REGEX_SPECIAL_CHARS_PATTERN, "\\\\$1");
        String wildCardPattern = StringUtils.replace((String)pattern, (String)WILDCARD_CHARACTER, (String)".*");
        return Pattern.compile(wildCardPattern, 32);
    }

    public static String toAlphanumeric(String original) {
        if (original == null) {
            return "nullId";
        }
        String returnVal = original.replaceAll("\\W", "");
        if (StringUtils.isBlank((String)returnVal)) {
            return "nullId";
        }
        return returnVal;
    }

    public static String getUrlWithLowercaseHostname(String targetResourceUrl) throws URISyntaxException {
        String schema;
        URI uri = new URI(targetResourceUrl);
        String host = uri.getHost();
        if (StringUtils.isNotBlank((String)host)) {
            targetResourceUrl = StringUtils.replaceOnce((String)targetResourceUrl, (String)host, (String)host.toLowerCase());
        }
        if (StringUtils.isNotBlank((String)(schema = uri.getScheme()))) {
            targetResourceUrl = StringUtils.replaceOnce((String)targetResourceUrl, (String)schema, (String)schema.toLowerCase());
        }
        return targetResourceUrl;
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("([");
        for (char c : REGEX_SPECIAL_CHARS) {
            sb.append("\\").append(c);
        }
        sb.append("])");
        REGEX_SPECIAL_CHARS_PATTERN = sb.toString();
    }
}

