/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.sourceid.common.PasswordRules;
import org.sourceid.common.Util;

public class ValidationUtil {
    private static final int UNSIGNED_SHORT = 65535;
    private static final String HOSTNAME_REGEX = "(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-\\_]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-\\_]*[A-Za-z0-9])";
    private static final String PORT_REGEX = "([1-9]\\d{0,4})";
    private static final String HOSTNAME_PORT_REGEX = "(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-\\_]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-\\_]*[A-Za-z0-9]):([1-9]\\d{0,4})";
    private static final String VALID_HOSTNAME_REGEX = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-\\_]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-\\_]*[A-Za-z0-9])|(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-\\_]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-\\_]*[A-Za-z0-9]):([1-9]\\d{0,4})$";
    private static final Pattern STRICT_ALPHA_NUMERIC_PATTERN = Pattern.compile("[a-zA-Z0-9]+");

    private static UrlValidator getUrlValidator(String[] schemes, long options) {
        return new UrlValidator(schemes, new RegexValidator(VALID_HOSTNAME_REGEX), options);
    }

    private static boolean isUrlPortValid(String url) {
        try {
            int port = new URI(url).getPort();
            return port <= 0 || ValidationUtil.isValidPort(String.valueOf(port));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isValidUri(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException uriEx) {
            return false;
        }
    }

    public static boolean isValidHttpOrHttpsUrl(String url) {
        long options = 10L;
        String[] schemes = new String[]{"http", "https"};
        UrlValidator httpOrHttpsUrlValidator = ValidationUtil.getUrlValidator(schemes, options);
        return httpOrHttpsUrlValidator.isValid(url) && ValidationUtil.isUrlPortValid(url);
    }

    public static boolean isValidHttpsUrl(String url) {
        long options = 10L;
        String[] schemes = new String[]{"https"};
        UrlValidator httpsUrlValidator = ValidationUtil.getUrlValidator(schemes, options);
        return httpsUrlValidator.isValid(url) && ValidationUtil.isUrlPortValid(url);
    }

    public static boolean isValidHttpsWithoutQueryStr(String url) {
        try {
            if (!ValidationUtil.isValidHttpsUrl(url)) {
                return false;
            }
            URL newUrl = new URL(url);
            return StringUtils.isBlank((String)newUrl.getQuery());
        }
        catch (MalformedURLException mal) {
            return false;
        }
    }

    public static boolean isValidHttpOrHttpsWithoutQueryStr(String url) {
        try {
            if (!ValidationUtil.isValidHttpOrHttpsUrl(url)) {
                return false;
            }
            URL newUrl = new URL(url);
            return StringUtils.isBlank((String)newUrl.getQuery());
        }
        catch (MalformedURLException mal) {
            return false;
        }
    }

    public static boolean isValidUrl(String url) {
        long options = 11L;
        UrlValidator urlValidator = ValidationUtil.getUrlValidator(null, options);
        return urlValidator.isValid(url) && ValidationUtil.isUrlPortValid(url);
    }

    public static boolean startsWithForwardSlash(String path) {
        if (StringUtils.isBlank((String)path)) {
            return false;
        }
        String legalChar = "/";
        char[] chars = path.toCharArray();
        int length = Array.getLength(chars);
        return length > 0 && String.valueOf(chars[0]).matches(legalChar);
    }

    public static boolean endsWithForwardSlash(String path) {
        String legalChar = "/";
        char[] chars = path.toCharArray();
        int length = Array.getLength(chars);
        return length > 0 && String.valueOf(chars[length - 1]).matches(legalChar);
    }

    public static boolean containsValidHexChars(String hex) {
        String illegalChars = "[^0-9a-fA-F]";
        char[] chars = hex.toCharArray();
        for (int i = 0; i < Array.getLength(chars); ++i) {
            if (!String.valueOf(chars[i]).matches(illegalChars)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNonNegInt(String inputInt) {
        try {
            int checkInt = Integer.parseInt(inputInt);
            if (checkInt < 0) {
                return false;
            }
        }
        catch (NumberFormatException n) {
            return false;
        }
        return true;
    }

    public static boolean isValidNonZeroPosInt(String inputInt) {
        try {
            int checkInt = Integer.parseInt(inputInt);
            if (checkInt <= 0) {
                return false;
            }
        }
        catch (NumberFormatException n) {
            return false;
        }
        return true;
    }

    public static boolean isValidLong(String inputLong) {
        try {
            Long.parseLong(inputLong);
        }
        catch (NumberFormatException n) {
            return false;
        }
        return true;
    }

    public static boolean isValidLong(String inputLong, long minValue) {
        return ValidationUtil.isValidLong(inputLong, minValue, Long.MAX_VALUE);
    }

    public static boolean isValidLong(String inputLong, long minValue, long maxValue) {
        boolean valid = false;
        if (ValidationUtil.isValidLong(inputLong)) {
            long longValue = Long.parseLong(inputLong);
            valid = longValue >= minValue && longValue <= maxValue;
        }
        return valid;
    }

    public static boolean isValidInt(String inputInt) {
        try {
            Integer.parseInt(inputInt);
        }
        catch (NumberFormatException n) {
            return false;
        }
        return true;
    }

    public static boolean isValidInt(String inputInt, int minValue) {
        return ValidationUtil.isValidInt(inputInt, minValue, Integer.MAX_VALUE);
    }

    public static boolean isValidInt(String inputInt, int minValue, int maxValue) {
        boolean valid = false;
        if (ValidationUtil.isValidInt(inputInt)) {
            int intValue = Integer.parseInt(inputInt);
            valid = intValue >= minValue && intValue <= maxValue;
        }
        return valid;
    }

    public static boolean isValidCookieLifeTime(String inputInt) {
        try {
            int checkInt = Integer.parseInt(inputInt);
            if (checkInt <= 0) {
                return checkInt == -1;
            }
        }
        catch (NumberFormatException n) {
            return false;
        }
        return true;
    }

    public static boolean isValidSubjectDN(String subjectDN) {
        if (StringUtils.isBlank((String)subjectDN)) {
            return false;
        }
        try {
            Util.canonicalizeX500DN(subjectDN);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isValidClassName(String className) {
        try {
            Class.forName(className);
        }
        catch (Exception e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String s) {
        boolean isAlphaNumeric = !StringUtils.isBlank((String)s);
        for (int i = 0; i < s.length() && isAlphaNumeric; isAlphaNumeric &= Character.isLetterOrDigit(s.charAt(i)), ++i) {
        }
        return isAlphaNumeric;
    }

    public static boolean isAlphaNumericStrict(String s) {
        return STRICT_ALPHA_NUMERIC_PATTERN.matcher(s).matches();
    }

    public static boolean hasOnlyOneWildcard(String url) {
        int tokenCount = 0;
        String tokenToCheck = "[\\*]";
        char[] chars = url.toCharArray();
        for (int i = 0; i < Array.getLength(chars); ++i) {
            if (!String.valueOf(chars[i]).matches(tokenToCheck)) continue;
            ++tokenCount;
        }
        return tokenCount <= 1;
    }

    public static boolean isValidPort(String port) {
        return ValidationUtil.isValidPort(port, true);
    }

    public static boolean isValidPort(String port, boolean allowZero) {
        try {
            Integer tempPort = Integer.valueOf(port);
            if (tempPort > 65535) {
                return false;
            }
            if (allowZero) {
                return tempPort >= 0;
            }
            return tempPort > 0;
        }
        catch (NumberFormatException n) {
            return false;
        }
    }

    public static boolean isValidPosUnsignedShortGreaterThanZero(String str) {
        try {
            Integer value = Integer.valueOf(str);
            return value >= 1 && value <= 65535;
        }
        catch (NumberFormatException n) {
            return false;
        }
    }

    public static boolean startsWithOnePeriodAndHasOneOther(String domain) {
        String tokenToCheck = "[.]";
        char[] chars = domain.toCharArray();
        if (chars.length > 0 && String.valueOf(chars[0]).matches(tokenToCheck)) {
            for (int i = 1; i < Array.getLength(chars); ++i) {
                if (!String.valueOf(chars[i]).matches(tokenToCheck)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isUrlProtocolConsistentWithList(List<URL> list, URL urlToTest) {
        if (urlToTest == null && list.size() > 0) {
            urlToTest = list.get(0);
        }
        for (URL url : list) {
            if (url != null && urlToTest.getProtocol().equals(url.getProtocol())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidDomainName(String domainName) {
        Pattern domainPattern = Pattern.compile("[a-zA-Z0-9.-]+");
        return domainPattern.matcher(domainName).matches();
    }

    public static boolean isPasswordValid(String password) {
        return ValidationUtil.isPasswordValid(password, null);
    }

    public static boolean isPasswordValid(String password, StringBuilder error) {
        return ValidationUtil.isPasswordValid(password, error, null);
    }

    public static boolean isPasswordValid(String password, StringBuilder error, String fieldName) {
        return ValidationUtil.isPasswordValid(password, error, fieldName, new PasswordRules());
    }

    public static boolean isPasswordValid(String password, StringBuilder error, String fieldName, int minLength) {
        return ValidationUtil.isPasswordValid(password, error, fieldName, new PasswordRules(minLength));
    }

    public static boolean isPasswordValid(String password, StringBuilder error, String fieldName, PasswordRules passwordRules) {
        boolean valid = false;
        int pwdLength = 0;
        int nbDigits = 0;
        int nbLower = 0;
        int nbUpper = 0;
        int nbAlpha = 0;
        int nbSpecial = 0;
        if (password != null) {
            pwdLength = password.length();
            for (int i = 0; i < pwdLength; ++i) {
                char c = password.charAt(i);
                if (Character.isDigit(c)) {
                    ++nbDigits;
                    continue;
                }
                if (Character.isAlphabetic(c)) {
                    ++nbAlpha;
                    if (Character.isLowerCase(c)) {
                        ++nbLower;
                        continue;
                    }
                    if (!Character.isUpperCase(c)) continue;
                    ++nbUpper;
                    continue;
                }
                if (!ArrayUtils.contains((char[])passwordRules.getSpecialChars(), (char)c)) continue;
                ++nbSpecial;
            }
        }
        if (pwdLength < passwordRules.getMinLength() || nbDigits < passwordRules.getMinNumeric() || passwordRules.isRequireMixedCase() && (nbLower < 1 || nbUpper < 1) || nbAlpha < passwordRules.getMinAlpha() || nbSpecial < passwordRules.getMinSpecial()) {
            if (error != null) {
                error.append(StringUtils.defaultIfEmpty((String)fieldName, (String)"Password"));
                error.append(" must contain ");
                if (passwordRules.getMinLength() > 0) {
                    error.append("at least ");
                    error.append(passwordRules.getMinLength());
                    error.append(" character");
                    error.append(passwordRules.getMinLength() > 1 ? "s, " : ", ");
                }
                if (passwordRules.getMinNumeric() > 0) {
                    error.append("at least ");
                    error.append(passwordRules.getMinNumeric());
                    error.append(" numeric character");
                    error.append(passwordRules.getMinNumeric() > 1 ? "s, " : ", ");
                }
                if (passwordRules.isRequireMixedCase()) {
                    error.append("at least 1 uppercase and 1 lowercase letter, ");
                }
                if (passwordRules.getMinAlpha() > 0) {
                    error.append("at least ");
                    error.append(passwordRules.getMinAlpha());
                    error.append(" alphabetic character");
                    error.append(passwordRules.getMinAlpha() > 1 ? "s, " : ", ");
                }
                if (passwordRules.getMinSpecial() > 0) {
                    error.append("at least ");
                    error.append(passwordRules.getMinSpecial());
                    error.append(" special character");
                    error.append(passwordRules.getMinSpecial() > 1 ? "s (" : " (");
                    error.append(passwordRules.getSpecialChars());
                    error.append(")");
                }
                if (", ".equals(error.substring(error.length() - 2))) {
                    error.replace(error.length() - 2, error.length(), "");
                }
                error.append(".");
            }
        } else {
            valid = true;
        }
        return valid;
    }

    public static boolean isHostnameValid(String vhn) {
        Object vhnWithProtocol = vhn;
        if (!vhn.startsWith("http://") && !vhn.startsWith("https://")) {
            vhnWithProtocol = "https://" + (String)vhnWithProtocol;
        }
        try {
            URL baseUrl = new URL((String)vhnWithProtocol);
            String baseHostName = baseUrl.getHost();
            if (!baseHostName.equals(vhn)) {
                return false;
            }
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static boolean isUniqueCharacters(String characters) {
        HashSet<Character> characterSet = new HashSet<Character>();
        for (char c : characters.toCharArray()) {
            characterSet.add(Character.valueOf(c));
        }
        return characterSet.size() == characters.length();
    }

    public static boolean isValidX509CountryEntry(String country) {
        return country.length() == 2 && country.equals(country.toUpperCase()) && country.charAt(0) >= 'A' && country.charAt(0) <= 'Z' && country.charAt(1) >= 'A' && country.charAt(1) <= 'Z';
    }
}

