/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.configservice.SysInfoHelper;
import java.io.File;
import java.util.Collection;
import java.util.Properties;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.sourceid.common.PFVelocityResourceLoader;
import org.sourceid.util.ObjectMapperFactory;

public class VelocityTemplateUtils {
    private static final ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();
    private static volatile Context toolsContext;

    public static final String toJsonArray(Collection<?> input) throws JsonProcessingException {
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(input);
    }

    public static Properties getVelocityProperties(String templateDirectory) {
        Properties props = new Properties();
        props.put("resource.loader.file.path", templateDirectory);
        props.put("resource.loader.file.cache", String.valueOf(true));
        props.put("parser.allow_hyphen_in_identifiers", String.valueOf(true));
        props.put("resource.loader.file.class", PFVelocityResourceLoader.class.getName());
        props.put("parser.space_gobbling", RuntimeConstants.SpaceGobbling.BC.toString());
        props.put("directive.if.empty_check", String.valueOf(false));
        props.put("velocimacro.enable_bc_mode", String.valueOf(true));
        props.put("event_handler.invalid_references.quiet", String.valueOf(true));
        props.put("event_handler.invalid_references.null", String.valueOf(true));
        props.put("event_handler.invalid_references.tested", String.valueOf(true));
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Context getVelocityToolContext() {
        if (toolsContext != null) return toolsContext;
        Class<ToolContext> clazz = ToolContext.class;
        synchronized (ToolContext.class) {
            if (toolsContext != null) return toolsContext;
            ToolManager toolManager = new ToolManager();
            File velocityToolsConfigFile = new File(SysInfoHelper.getSysDirInfo().getConfigDirectory() + File.separator + "velocity-tools.xml");
            if (!velocityToolsConfigFile.exists()) return toolsContext;
            toolManager.configure(SysInfoHelper.getSysDirInfo().getConfigDirectory() + File.separator + "velocity-tools.xml");
            toolsContext = toolManager.createContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return toolsContext;
        }
    }
}

