/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectBuilder;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlEncryption {
    private static Map<String, JceWrapper> algoMap = new HashMap<String, JceWrapper>();

    public static SecretKey getDataEncryptionKey(String keyValue, String alg) throws NoSuchAlgorithmException {
        JceWrapper jce = algoMap.get(alg);
        if (jce == null) {
            throw new NoSuchAlgorithmException(alg);
        }
        return new SecretKeySpec(B64.decodeToBytes((String)keyValue), jce.jceAlgorithmName);
    }

    public static SecretKey generateDataEncryptionKey(String alg) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator;
        JceWrapper jce = algoMap.get(alg);
        if (jce == null) {
            throw new NoSuchAlgorithmException(alg);
        }
        try {
            keyGenerator = KeyGenerator.getInstance(jce.jceAlgorithmName, SecurityProviderUtil.getSunJCEProviderOrEquivalent());
        }
        catch (NoSuchProviderException e) {
            keyGenerator = KeyGenerator.getInstance(jce.jceAlgorithmName);
        }
        keyGenerator.init(jce.keySize);
        return keyGenerator.generateKey();
    }

    public static boolean isEncryptionAlgorithmAvailable(String encryptionAlg) {
        boolean retV = true;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document1 = db.newDocument();
            Element root = document1.createElementNS("http://www.apache.org/ns/#simple", "apache:RootElement");
            document1.appendChild(root);
            Document document = document1;
            SecretKey symmetricKey = XmlEncryption.generateDataEncryptionKey(encryptionAlg);
            Element rootElement = document.getDocumentElement();
            XMLCipher xmlCipher = XMLCipher.getInstance((String)encryptionAlg);
            xmlCipher.init(1, (Key)symmetricKey);
            xmlCipher.getEncryptedData();
            xmlCipher.doFinal(document, rootElement, false);
        }
        catch (Exception ex) {
            retV = false;
        }
        return retV;
    }

    public static KeyInfoType encryptProofKey(XmlObject owner, Key symmetricKey, X509Certificate rpCert) throws XMLEncryptionException, XmlException {
        return XmlEncryption.encryptProofKey(owner, symmetricKey, rpCert, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
    }

    public static KeyInfoType encryptProofKey(XmlObject owner, Key symmetricKey, X509Certificate rpCert, String keyTransportAlgo) throws XMLEncryptionException, XmlException {
        Document w3doc = XmlBeansUtil.newDomNode(owner);
        KeyInfo keyInfo = XmlEncryption.encryptKey(w3doc, symmetricKey, rpCert, keyTransportAlgo);
        return KeyInfoType.Factory.parse((Node)keyInfo.getElement());
    }

    private static KeyInfo encryptKey(Document w3doc, Key symmetricKey, X509Certificate rpCert, String keyTransportAlg) throws XMLEncryptionException {
        XmlObject xDigest = XmlObjectBuilder.element(new QName("http://www.w3.org/2000/09/xmldsig#", "DigestMethod"), XmlObjectBuilder.attr("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1"));
        XmlObject xReference = XmlObjectBuilder.element(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference"), XmlObjectBuilder.element(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier"), XmlObjectBuilder.attrs(XmlObjectBuilder.attr("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1")), XmlEncryption.sha1(rpCert)));
        Element digest = XmlBeansUtil.newDomNode(xDigest).getDocumentElement();
        Element reference = XmlBeansUtil.newDomNode(xReference).getDocumentElement();
        digest = (Element)w3doc.importNode(digest, true);
        reference = (Element)w3doc.importNode(reference, true);
        XMLCipher keyCipher = XMLCipher.getInstance((String)keyTransportAlg);
        keyCipher.init(3, (Key)rpCert.getPublicKey());
        EncryptedKey encryptedKey = keyCipher.encryptKey(w3doc, symmetricKey);
        encryptedKey.getEncryptionMethod().addEncryptionMethodInformation(digest);
        KeyInfo encKeyInfo = new KeyInfo(w3doc);
        encKeyInfo.addUnknownElement(reference);
        encryptedKey.setKeyInfo(encKeyInfo);
        KeyInfo keyInfo = new KeyInfo(w3doc);
        keyInfo.add(encryptedKey);
        return keyInfo;
    }

    public static EncryptedElementType encrypt(XmlObject obj, PublicKey publicKey, String encryptionAlg, String keyTransportAlg) throws XMLEncryptionException, NoSuchAlgorithmException {
        EncryptedElementType encryptedObject;
        SecretKey symmetricKey = XmlEncryption.generateDataEncryptionKey(encryptionAlg);
        try {
            Document w3doc = XmlBeansUtil.newDomNode(obj);
            String digest = null;
            if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(keyTransportAlg)) {
                digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            }
            XMLCipher keyCipher = XMLCipher.getInstance((String)keyTransportAlg, null, (String)digest);
            keyCipher.init(3, (Key)publicKey);
            EncryptedKey encryptedKey = null;
            encryptedKey = "http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(keyTransportAlg) ? keyCipher.encryptKey(w3doc, (Key)symmetricKey, "http://www.w3.org/2009/xmlenc11#mgf1sha256", null) : keyCipher.encryptKey(w3doc, (Key)symmetricKey);
            Element rootElement = w3doc.getDocumentElement();
            XMLCipher xmlCipher = XMLCipher.getInstance((String)encryptionAlg);
            xmlCipher.init(1, (Key)symmetricKey);
            EncryptedData encryptedData = xmlCipher.getEncryptedData();
            KeyInfo keyInfo = new KeyInfo(w3doc);
            keyInfo.add(encryptedKey);
            encryptedData.setKeyInfo(keyInfo);
            xmlCipher.doFinal(w3doc, rootElement, false);
            encryptedObject = EncryptedElementType.Factory.parse((Node)w3doc.getFirstChild());
        }
        catch (Exception ex) {
            throw new XMLEncryptionException(ex, "generic.EmptyMessage", new Object[]{"Exception in encryption"});
        }
        return encryptedObject;
    }

    public static EncryptedElementType encryptWithKeyReference(XmlObject obj, X509Certificate encryptionCert, String encryptionAlg, String keyTransportAlg) throws XMLEncryptionException, NoSuchAlgorithmException {
        EncryptedElementType encryptedObject;
        SecretKey symmetricKey = XmlEncryption.generateDataEncryptionKey(encryptionAlg);
        try {
            Document w3doc = XmlBeansUtil.newDomNode(obj);
            Element rootElement = w3doc.getDocumentElement();
            XMLCipher xmlCipher = XMLCipher.getInstance((String)encryptionAlg);
            xmlCipher.init(1, (Key)symmetricKey);
            EncryptedData encryptedData = xmlCipher.getEncryptedData();
            KeyInfo keyInfo = XmlEncryption.encryptKey(w3doc, symmetricKey, encryptionCert, keyTransportAlg);
            encryptedData.setKeyInfo(keyInfo);
            xmlCipher.doFinal(w3doc, rootElement, false);
            encryptedObject = EncryptedElementType.Factory.parse((Node)w3doc.getFirstChild());
        }
        catch (Exception ex) {
            throw new XMLEncryptionException("generic.EmptyMessage", new Object[]{"Exception in encryption"}, ex);
        }
        return encryptedObject;
    }

    public static XmlObject decrypt(XmlObject encryptedObj, PkCert pkCert) throws XMLEncryptionException {
        try {
            XmlObject decryptedObject;
            Document w3doc = XmlBeansUtil.newDomNode(encryptedObj);
            NodeList encryptedNodeList = w3doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            int nNodes = encryptedNodeList.getLength();
            if (nNodes > 0) {
                for (int i = 0; i < nNodes; ++i) {
                    XMLCipher xmlCipher = XmlEncryption.getXmlCipher(pkCert);
                    Element encryptedDataElement = (Element)encryptedNodeList.item(i);
                    xmlCipher.init(2, null);
                    xmlCipher.setKEK((Key)pkCert.getPrivateKey());
                    xmlCipher.doFinal(w3doc, encryptedDataElement);
                }
                decryptedObject = XmlObject.Factory.parse((Node)w3doc.getFirstChild());
            } else {
                decryptedObject = encryptedObj;
            }
            return decryptedObject;
        }
        catch (Exception ex) {
            throw new XMLEncryptionException("generic.EmptyMessage", new Object[]{"Exception in decryption"}, ex);
        }
    }

    private static XMLCipher getXmlCipher(PkCert pkCert) throws XMLEncryptionException {
        String hsmProviderName = SecurityProviderUtil.getHSMProviderName(pkCert.isStoredOnHSM());
        if (hsmProviderName != null) {
            return XMLCipher.getProviderInstance((String)hsmProviderName);
        }
        return XMLCipher.getInstance();
    }

    public static Element decryptToDomElement(XmlObject encryptedObj, PkCert pkCert) throws XMLEncryptionException {
        try {
            Document w3doc = XmlBeansUtil.newDomNode(encryptedObj);
            NodeList encryptedNodeList = w3doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            int nNodes = encryptedNodeList.getLength();
            if (nNodes > 0) {
                for (int i = 0; i < nNodes; ++i) {
                    Element encryptedDataElement = (Element)encryptedNodeList.item(i);
                    XMLCipher xmlCipher = XmlEncryption.getXmlCipher(pkCert);
                    xmlCipher.init(2, null);
                    xmlCipher.setKEK((Key)pkCert.getPrivateKey());
                    xmlCipher.doFinal(w3doc, encryptedDataElement);
                }
            }
            return w3doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new XMLEncryptionException("generic.EmptyMessage", new Object[]{"Exception in decryption"}, ex);
        }
    }

    public static XmlObject decrypt(XmlObject encryptedObj, XmlObject encryptedKey, PkCert pkCert) throws XMLEncryptionException {
        XmlObject decryptedObject = null;
        try {
            Document w3doc = XmlBeansUtil.newDomNode(encryptedObj);
            Document tmpEncKeyNode = XmlBeansUtil.newDomNode(encryptedKey);
            Element encryptedKeyElement = (Element)w3doc.importNode(tmpEncKeyNode.getFirstChild(), true);
            NodeList encryptedNodeList = w3doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            int nNodes = encryptedNodeList.getLength();
            for (int i = 0; i < nNodes; ++i) {
                Element encryptedDataElement = (Element)encryptedNodeList.item(i);
                NodeList encryptedKeyList = encryptedDataElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
                if (encryptedKeyList == null || encryptedKeyList.getLength() == 0) {
                    Element keyInfo;
                    NodeList keyInfoList = encryptedDataElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                    if (keyInfoList == null || keyInfoList.getLength() == 0) {
                        keyInfo = w3doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                        NodeList nodes = encryptedDataElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
                        Element cipherData = (Element)nodes.item(0);
                        encryptedDataElement.insertBefore(keyInfo, cipherData);
                        keyInfo.appendChild(encryptedKeyElement);
                    } else if (keyInfoList.getLength() > 0) {
                        keyInfo = (Element)keyInfoList.item(0);
                        keyInfo.appendChild(encryptedKeyElement);
                    }
                }
                XMLCipher xmlCipher = XmlEncryption.getXmlCipher(pkCert);
                xmlCipher.init(2, null);
                xmlCipher.setKEK((Key)pkCert.getPrivateKey());
                byte[] clearBytes = xmlCipher.decryptToByteArray(encryptedDataElement);
                String clearXml = new String(clearBytes, "UTF-8");
                decryptedObject = XmlObject.Factory.parse((String)clearXml);
            }
        }
        catch (Exception ex) {
            throw new XMLEncryptionException("generic.EmptyMessage", new Object[]{"Exception in decryption: " + ex.getMessage()}, ex);
        }
        if (decryptedObject == null) {
            decryptedObject = encryptedObj;
        }
        return decryptedObject;
    }

    public static String sha1(X509Certificate cert) throws XMLEncryptionException {
        try {
            MessageDigest digest = HashUtil.getMessageDigester((HashAlgorithm)HashAlgorithm.SHA1);
            return B64.encode((byte[])digest.digest(cert.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            throw new XMLEncryptionException("Unable to calculate digest", (Exception)e);
        }
    }

    static {
        Init.init();
        String aes = "AES";
        algoMap.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", new JceWrapper("DESede", 168));
        algoMap.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", new JceWrapper(aes, 128));
        algoMap.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", new JceWrapper(aes, 192));
        algoMap.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", new JceWrapper(aes, 256));
        algoMap.put("http://www.w3.org/2009/xmlenc11#aes128-gcm", new JceWrapper(aes, 128));
        algoMap.put("http://www.w3.org/2009/xmlenc11#aes192-gcm", new JceWrapper(aes, 192));
        algoMap.put("http://www.w3.org/2009/xmlenc11#aes256-gcm", new JceWrapper(aes, 256));
    }

    private static class JceWrapper {
        String jceAlgorithmName;
        int keySize;

        JceWrapper(String jceAlgorithmName, int keySize) {
            this.jceAlgorithmName = jceAlgorithmName;
            this.keySize = keySize;
        }
    }
}

