/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.compression;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class DeflateRFC1951 {
    private static final int COMPRESSION_LEVEL = 9;
    private static final boolean NOWRAP = true;
    private static final int BUFSIZE = 655316;
    private static final int COMPRATIO = 4;
    private static final int OVERHEAD = 5;
    private static final DeflateRFC1951 instance = new DeflateRFC1951();

    private DeflateRFC1951() {
    }

    public static byte[] deflate(byte[] data) {
        return instance.doDeflate(data);
    }

    public static byte[] deflate(String data) {
        return instance.doDeflate(data);
    }

    public static String inflate(byte[] compressedData) throws DataFormatException {
        byte[] bytes = instance.doInflate(compressedData);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] inflateToBytes(byte[] compressedData) throws DataFormatException {
        return instance.doInflate(compressedData);
    }

    public byte[] doDeflate(String data) {
        byte[] dataBytes;
        try {
            dataBytes = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.doDeflate(dataBytes);
    }

    public byte[] doDeflate(byte[] dataBytes) {
        int compBufSize = 655316;
        if (compBufSize < dataBytes.length + 5) {
            compBufSize = dataBytes.length + 5;
        }
        byte[] compBuf = new byte[compBufSize];
        Deflater compresser = new Deflater(9, true);
        compresser.setInput(dataBytes);
        compresser.finish();
        int compressedDataLength = compresser.deflate(compBuf);
        byte[] compressedData = new byte[compressedDataLength];
        System.arraycopy(compBuf, 0, compressedData, 0, compressedDataLength);
        return compressedData;
    }

    public byte[] doInflate(byte[] compressedData) throws DataFormatException {
        Inflater decompresser = new Inflater(true);
        decompresser.setInput(compressedData, 0, compressedData.length);
        int decompBufSize = 655316;
        if (decompBufSize < 4 * compressedData.length) {
            decompBufSize = 4 * compressedData.length;
        }
        byte[] decompBuf = new byte[decompBufSize];
        return this.doInflate(compressedData, decompBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] doInflate(byte[] compressedData, byte[] buffer) throws DataFormatException {
        Inflater decompresser = new Inflater(true);
        decompresser.setInput(compressedData, 0, compressedData.length);
        try {
            int resultLength = decompresser.inflate(buffer);
            byte[] resultBytes = new byte[resultLength];
            System.arraycopy(buffer, 0, resultBytes, 0, resultLength);
            byte[] byArray = resultBytes;
            return byArray;
        }
        finally {
            decompresser.end();
        }
    }
}

