/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.dsig;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectBuilder;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.crypto.SignatureAlgorithms;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlComplexContentImpl;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.sourceid.common.XmlEncryption;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.protocol.dsig10.xml.SignatureDocument;
import org.sourceid.protocol.dsig10.xml.SignatureType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSignatureUtil {
    private static final QName DSIG_QN;
    private static final BouncyCastleFipsProvider bouncyCastleFipsProvider;
    private static Log log;

    public static Element findSignatureElement(Element e) {
        for (Node curChild = e.getFirstChild(); curChild != null; curChild = curChild.getNextSibling()) {
            String nameSpaceURI = curChild.getNamespaceURI();
            String localName = curChild.getLocalName();
            if (curChild.getNodeType() != 1 || nameSpaceURI == null || !nameSpaceURI.equals(DSIG_QN.getNamespaceURI()) || localName == null || !localName.equals(DSIG_QN.getLocalPart())) continue;
            return (Element)curChild;
        }
        return null;
    }

    public static Element toDomElement(XmlObject obj) {
        return XmlBeansUtil.newDomNode(obj).getDocumentElement();
    }

    public static void signXml(XmlObject obj, String signatureAlgorithm, PrivateKey key) throws SigningException {
        XmlSignatureUtil.signXml(obj, signatureAlgorithm, key, null);
    }

    @Deprecated
    public static void signXml(XmlObject obj, PrivateKey key, X509Certificate cert) throws SigningException {
        XmlSignatureUtil.signXml(obj, null, key, cert);
    }

    public static void signXml(XmlObject obj, String signatureAlgorithm, PrivateKey key, X509Certificate cert) throws SigningException {
        XmlSignatureUtil.signXml(obj, signatureAlgorithm, key, cert, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void signXml(XmlObject obj, String signatureAlgorithm, PrivateKey key, X509Certificate cert, boolean includeCertInKeyInfo, boolean includeRefInKeyInfo, boolean includeRawKeyInKeyValue) throws SigningException {
        XmlObject docObject = obj;
        QName keyqn = XmlBeansUtil.findIDAttribute(obj = XmlBeansUtil.unwrapDocumentToType(obj));
        if (keyqn == null) {
            throw new SigningException("No attribute of type xsi:ID found.");
        }
        try {
            String algorithmId;
            Document w3doc = XmlBeansUtil.newDomNode(docObject);
            Element elem = w3doc.getDocumentElement();
            String keyAlgorithm = key.getAlgorithm();
            if (!StringUtils.isBlank((String)signatureAlgorithm)) {
                algorithmId = signatureAlgorithm;
            } else {
                SignatureAlgorithms signingAlgUtils = SignatureAlgorithms.getInstance();
                boolean isSignatureAlgSupported = signingAlgUtils.isSignatureAlgorithmSupported(keyAlgorithm);
                if (!isSignatureAlgSupported) throw new SigningException("Signing key uses an unknown algorithm: " + keyAlgorithm);
                if ("RSA".equals(keyAlgorithm)) {
                    algorithmId = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                } else if ("DSA".equals(keyAlgorithm)) {
                    algorithmId = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                } else {
                    if (!"EC".equals(keyAlgorithm)) throw new SigningException("Signing key uses an unknown algorithm: " + keyAlgorithm);
                    algorithmId = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
                }
            }
            XMLSignature xsig = XmlSignatureUtil.createXmlSignature(key, w3doc, algorithmId);
            String digestUri = SignatureAlgorithms.getInstance().getDigestUri(algorithmId);
            Transforms t = new Transforms(w3doc);
            t.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            t.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            elem.appendChild(xsig.getElement());
            String eid = elem.getAttribute(keyqn.getLocalPart());
            if (eid == null || eid.length() == 0) {
                throw new SigningException("Invalid/empty ID attribute value.");
            }
            elem.setIdAttribute(keyqn.getLocalPart(), true);
            xsig.addDocument("#" + eid, t, digestUri);
            if (cert != null && includeCertInKeyInfo) {
                xsig.addKeyInfo(cert);
                if (includeRawKeyInKeyValue && !"EC".equals(keyAlgorithm)) {
                    xsig.addKeyInfo(cert.getPublicKey());
                }
            }
            xsig.sign((Key)key);
            SignatureDocument sigdoc = SignatureDocument.Factory.parse((Node)xsig.getElement());
            if (cert != null && !includeCertInKeyInfo && includeRefInKeyInfo) {
                KeyInfoType keyInfoType = sigdoc.getSignature().addNewKeyInfo();
                XmlObject xReference = XmlObjectBuilder.element(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference"), XmlObjectBuilder.element(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier"), XmlObjectBuilder.attrs(XmlObjectBuilder.attr("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1")), XmlEncryption.sha1(cert)));
                keyInfoType.set(xReference);
            }
            XmlCursor cur = sigdoc.newCursor();
            try {
                while (cur.hasNextToken()) {
                    if (cur.isNamespace()) {
                        cur.removeXml();
                        cur.toPrevToken();
                    }
                    cur.toNextToken();
                }
            }
            finally {
                cur.dispose();
            }
            XmlComplexContentImpl obj_impl = (XmlComplexContentImpl)obj;
            Object object = obj_impl.monitor();
            synchronized (object) {
                SignatureType sigtype = (SignatureType)obj_impl.get_store().add_element_user(DSIG_QN);
                sigtype.set((XmlObject)sigdoc.getSignature());
            }
            XmlSignatureUtil.logC14N(xsig, log, docObject);
            return;
        }
        catch (XmlException e) {
            throw new SigningException("Error inserting signature block.", e);
        }
        catch (XMLSecurityException e) {
            throw new SigningException("Error generating signature.", e);
        }
    }

    private static XMLSignature createXmlSignature(PrivateKey key, Document w3doc, String algorithmId) throws XMLSecurityException {
        Provider provider = SecurityProviderUtil.getHSMProvider(key);
        if (algorithmId != null) {
            if (SignatureAlgorithms.RSASSA_PSS_ALGORITHM_URI_LIST.stream().anyMatch(algorithmId::equalsIgnoreCase) && provider == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using Bouncy Castle FIPS provider for RSASSA-PSS algorithm URI: " + algorithmId));
                }
                provider = bouncyCastleFipsProvider;
            }
        }
        return new XMLSignature(w3doc, "", algorithmId, "http://www.w3.org/2001/10/xml-exc-c14n#", provider);
    }

    static void logC14N(XMLSignature xsig, Log logger, XmlObject targetXml) {
        if (logger.isDebugEnabled()) {
            try {
                SignedInfo signedInfo = xsig.getSignedInfo();
                for (int i = 0; i < signedInfo.getLength(); ++i) {
                    Reference ref = signedInfo.item(i);
                    byte[] referencedBytes = ref.getReferencedBytes();
                    log.debug((Object)("XmlObject.xmlText(): " + XmlBeansUtil.xmlText(targetXml)));
                    log.debug((Object)("Transformed XML: " + new String(referencedBytes, "UTF-8")));
                    MessageDigestAlgorithm messageDigestAlgorithm = ref.getMessageDigestAlgorithm();
                    String jceAlgorithmString = messageDigestAlgorithm.getJCEAlgorithmString();
                    MessageDigest msgDigest = MessageDigest.getInstance(jceAlgorithmString);
                    byte[] digestBytes = msgDigest.digest(referencedBytes);
                    log.debug((Object)("Digest [base64 encoded " + jceAlgorithmString + "]: " + B64.encode((byte[])digestBytes)));
                }
            }
            catch (Exception e) {
                log.debug((Object)"Unable to log c14n XML", (Throwable)e);
            }
        }
    }

    static {
        Init.init();
        DSIG_QN = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature", "ds");
        bouncyCastleFipsProvider = new BouncyCastleFipsProvider();
        log = LogFactory.getLog(XmlSignatureUtil.class);
    }
}

