/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.dsig;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.RevokedCertException;
import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.crypto.X500Util;
import com.pingidentity.crypto.X509CertPathValidatorSupport;
import java.security.Key;
import java.security.Provider;
import java.security.cert.CertPathValidatorException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.VerificationException;
import org.sourceid.common.dsig.XmlSignatureUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSignatureVerifier {
    private static final String LOCALNAME_TRANSFORM = "Transform";
    private static final String ATTRIB_NAME_ALGORITHM = "Algorithm";
    private static final int DEFAULT_MAX_TRANSFORMS = 20;
    private static final BouncyCastleFipsProvider bouncyCastleFipsProvider = new BouncyCastleFipsProvider();
    private static final Log log = LogFactory.getLog(XmlSignatureVerifier.class);
    private static final XPathExpression expr;
    private ConfigStore config;
    private X509Certificate embeddedCert;
    private X509Certificate providedCert;
    private SignatureResult signatureResult;
    private XMLSignature xmlSignature;
    private String idValue;
    private Set<TrustAnchor> trustAnchors;
    private XmlObject xmlObject;
    boolean enableSecureValidation;

    public XmlSignatureVerifier() {
        this.config = ConfigStoreFarm.getConfig(this.getClass());
        this.signatureResult = new SignatureResult();
        this.enableSecureValidation = this.config.getBooleanValue("EnableSecureValidation", true);
    }

    public XmlSignatureVerifier(Element element) throws VerificationException {
        block13: {
            this.config = ConfigStoreFarm.getConfig(this.getClass());
            this.signatureResult = new SignatureResult();
            this.enableSecureValidation = this.config.getBooleanValue("EnableSecureValidation", true);
            Element signatureElement = XmlSignatureUtil.findSignatureElement(element);
            if (signatureElement == null) {
                this.signatureResult.setStatus(SignatureStatus.NOT_PRESENT);
            } else if (!this.validateRestrictions(signatureElement)) {
                this.signatureResult.setStatus(SignatureStatus.INVALID);
            } else {
                XmlObject typeObj;
                QName keyqn;
                if (this.xmlObject == null) {
                    try {
                        this.xmlObject = XmlObject.Factory.parse((Node)element);
                    }
                    catch (XmlException e) {
                        throw new VerificationException("Error parsing XML data: ", e);
                    }
                }
                if ((keyqn = XmlBeansUtil.findIDAttribute(typeObj = XmlBeansUtil.unwrapDocumentToType(this.xmlObject))) == null) {
                    throw new VerificationException("No ID Attribute found on " + XmlBeansUtil.xmlText(this.xmlObject));
                }
                this.idValue = element.getAttribute(keyqn.getLocalPart());
                element.setIdAttribute(keyqn.getLocalPart(), true);
                try {
                    this.xmlSignature = XmlSignatureVerifier.createXmlSignature(signatureElement, this.enableSecureValidation);
                    KeyInfo keyInfo = this.xmlSignature.getKeyInfo();
                    if (keyInfo == null || !keyInfo.containsX509Data()) break block13;
                    try {
                        this.embeddedCert = keyInfo.getX509Certificate();
                    }
                    catch (NullPointerException npe) {
                        throw new VerificationException("X509Certificate element may contain malformed data", npe);
                    }
                }
                catch (XMLSecurityException e) {
                    throw new VerificationException(e);
                }
                catch (NullPointerException npe) {
                    throw new VerificationException("Signature element may contain malformed data", npe);
                }
            }
        }
    }

    public static XMLSignature createXmlSignature(Element signatureElement, boolean enableSecureValidation) throws XMLSecurityException {
        String algorithmUri = XmlSignatureVerifier.getAlgUriFromElement(signatureElement);
        if (algorithmUri != null) {
            if (SignatureAlgorithms.RSASSA_PSS_ALGORITHM_URI_LIST.stream().anyMatch(algorithmUri::equalsIgnoreCase)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using Bouncy Castle FIPS provider for RSASSA-PSS algorithm URI: " + algorithmUri));
                }
                return new XMLSignature(signatureElement, null, enableSecureValidation, (Provider)bouncyCastleFipsProvider);
            }
        }
        return new XMLSignature(signatureElement, null, enableSecureValidation);
    }

    static String getAlgUriFromElement(Element signatureElement) {
        try {
            return (String)expr.evaluate(signatureElement, XPathConstants.STRING);
        }
        catch (XPathExpressionException ex) {
            log.error((Object)"Unexpected error while applying xpath expression for finding signature algorithm in XML data", (Throwable)ex);
            return null;
        }
    }

    public XmlSignatureVerifier(XmlObject xmlObject) throws VerificationException {
        this(XmlSignatureUtil.toDomElement(xmlObject));
        this.xmlObject = xmlObject;
    }

    public void setProvidedX509Cert(X509Certificate x509Cert) {
        this.providedCert = x509Cert;
        if (this.isCertInKeyInfo() && !this.embeddedCert.equals(x509Cert)) {
            this.setInvalidStatus("provided cert does not match embedded cert");
        }
    }

    public X509Certificate getEmbeddedX509Cert() {
        return this.embeddedCert;
    }

    public void setTrustAnchors(Set<TrustAnchor> trustAnchors) {
        this.trustAnchors = trustAnchors;
    }

    public boolean isCertInKeyInfo() {
        return this.embeddedCert != null;
    }

    public boolean isCertChainValid() {
        if (Util.isEmpty(this.trustAnchors)) {
            return false;
        }
        X509CertPathValidatorSupport pathValidator = this.getPathValidator();
        return pathValidator.isPathValid();
    }

    private X509CertPathValidatorSupport getPathValidator() {
        X509Certificate[] certs = new X509Certificate[]{this.getEffectiveCert()};
        X509CertPathValidatorSupport pathValidator = new X509CertPathValidatorSupport(certs, false);
        pathValidator.addTrustAnchors(this.trustAnchors);
        return pathValidator;
    }

    public boolean hasSignature() {
        return this.signatureResult.getStatus() != SignatureStatus.NOT_PRESENT;
    }

    public boolean isCertKnownToBeRevoked() {
        Cert c = new Cert(null, this.getEffectiveCert());
        return CertificateHelper.isKnownToBeRevoked(c);
    }

    public void setExpectedSubjectDN(X500Principal expectedSubjectDN) throws VerificationException {
        if (this.signatureResult.getStatus() == null) {
            if (expectedSubjectDN == null) {
                this.setInvalidStatus("The expectedSubjectDN was not provided.");
            }
            if (!this.isCertInKeyInfo()) {
                this.setInvalidStatus("No certificate was included in the signature element.");
            }
            if (this.isCertInKeyInfo()) {
                X509CertPathValidatorSupport pathValidatorSupport = this.getPathValidator();
                try {
                    pathValidatorSupport.validate();
                }
                catch (CertPathValidatorException e) {
                    this.setInvalidStatus("Certificate path validation failed: " + e);
                }
            }
            if (this.isCertInKeyInfo()) {
                try {
                    CertificateHelper.checkRevocation(new Cert("", this.embeddedCert));
                }
                catch (RevokedCertException e) {
                    this.setInvalidStatus("The chain that anchors the certificate included in the signature element contains a revoked certificate: " + e);
                }
            }
            if (this.isCertInKeyInfo() && !X500Util.equals(this.embeddedCert.getSubjectX500Principal(), expectedSubjectDN)) {
                this.setInvalidStatus("The expected subject DN (" + expectedSubjectDN + ") does not match the subject DN of the certificate included in the signature (" + this.embeddedCert.getSubjectX500Principal());
            }
        }
    }

    public XmlObject getXmlObject() {
        return this.xmlObject;
    }

    public SignatureResult getSignatureResult() {
        this.evalSig();
        return this.signatureResult;
    }

    public SignatureStatus getSignatureStatus() {
        this.evalSig();
        return this.signatureResult.getStatus();
    }

    private void evalSig() {
        if (this.signatureResult.getStatus() == null) {
            X509Certificate cert = this.getEffectiveCert();
            if (cert == null) {
                this.signatureResult.addComment("No key/cert available in this context to evaluate the signature.");
                this.signatureResult.setStatus(SignatureStatus.UNVERIFIED);
            } else {
                try {
                    SignatureStatus status = this.xmlSignature.checkSignatureValue((Key)cert.getPublicKey()) ? SignatureStatus.VALID : SignatureStatus.INVALID;
                    this.signatureResult.setStatus(status);
                    XmlSignatureUtil.logC14N(this.xmlSignature, log, this.xmlObject);
                    this.verifySignatureReference();
                    this.verifiyNoObjectChildern();
                }
                catch (XMLSecurityException e) {
                    Object statusMessage = e.getMessage();
                    Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                    if (rootCause != null && statusMessage != null && !((String)statusMessage).equals(rootCause.getMessage())) {
                        statusMessage = e.getMessage() + "; caused by: " + rootCause.getMessage();
                    }
                    this.setInvalidStatus((String)statusMessage);
                }
            }
        }
    }

    private void verifiyNoObjectChildern() {
        if (this.xmlSignature.getObjectLength() > 0) {
            this.setInvalidStatus("Signature contains disallowed xmldsig:Object children");
        }
    }

    private void verifySignatureReference() throws XMLSecurityException {
        int numRefs = this.xmlSignature.getSignedInfo().getLength();
        if (numRefs != 1) {
            String comment = "Signature/SignedInfo must have exactly 1 Reference element but had " + numRefs;
            this.setInvalidStatus(comment);
        } else {
            Reference reference = this.xmlSignature.getSignedInfo().item(0);
            if (reference == null) {
                this.setInvalidStatus("Signature Reference was null");
            } else {
                String uri = reference.getURI();
                if (uri == null) {
                    this.setInvalidStatus("Signature Reference URI was null");
                } else if (!uri.startsWith("#")) {
                    this.setInvalidStatus("Signature Reference URI was not a document fragment reference (didn't start with #)");
                } else if (uri.length() < 2 || !this.idValue.equals(uri.substring(1))) {
                    this.setInvalidStatus("Reference URI did not point to the expected ID of the document");
                }
            }
        }
    }

    private void setInvalidStatus(String comment) {
        this.signatureResult.addComment(comment);
        this.signatureResult.setStatus(SignatureStatus.INVALID);
    }

    public X509Certificate getEffectiveCert() {
        return this.embeddedCert != null ? this.embeddedCert : this.providedCert;
    }

    public boolean hasCert() {
        return this.embeddedCert != null || this.providedCert != null;
    }

    public boolean validateRestrictions(Element signatureElement) {
        boolean validated = true;
        NodeList nodeList = signatureElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", LOCALNAME_TRANSFORM);
        if (nodeList != null) {
            int numTransforms = nodeList.getLength();
            int maxTransforms = this.config.getIntValue("MaxTransforms", 20);
            boolean allowDuplicateTransforms = this.config.getBooleanValue("AllowDuplicateTransforms", true);
            List<String> allowedTransforms = this.config.getListValue("AllowedTransforms", this.getDefaultTransforms());
            if (numTransforms > maxTransforms) {
                log.warn((Object)("SECURITY WARNING: Potential DOS attack detected - the number of transforms in the XML message has exceeded the limit(" + maxTransforms + "). Therefore, the message is rejected."));
                validated = false;
            } else {
                HashSet<String> algUriSet = new HashSet<String>();
                for (int i = 0; i < numTransforms; ++i) {
                    Node node = nodeList.item(i);
                    NamedNodeMap attributeMap = node.getAttributes();
                    Node alg = attributeMap.getNamedItem(ATTRIB_NAME_ALGORITHM);
                    String algURI = alg.getNodeValue();
                    if (!allowedTransforms.contains(algURI)) {
                        log.warn((Object)("SECURITY WARNING: The XML message contains an disallowed transform, " + algURI + ". Therefore, the message is rejected."));
                        validated = false;
                        break;
                    }
                    if (allowDuplicateTransforms) continue;
                    if (algUriSet.contains(algURI)) {
                        log.warn((Object)("SECURITY WARNING: Duplicate transforms [" + algURI + "] are found in the dsig of the XML message. Therefore, the message is rejected."));
                        validated = false;
                        break;
                    }
                    algUriSet.add(algURI);
                }
            }
            if (!validated) {
                this.signatureResult.setStatus(SignatureStatus.INVALID);
            }
        }
        return validated;
    }

    private List<String> getDefaultTransforms() {
        ArrayList<String> defaultTransforms = new ArrayList<String>();
        defaultTransforms.add("http://www.w3.org/2000/09/xmldsig#base64");
        defaultTransforms.add("http://www.w3.org/2001/10/xml-exc-c14n#");
        defaultTransforms.add("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        defaultTransforms.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        defaultTransforms.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        defaultTransforms.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        return defaultTransforms;
    }

    static {
        try {
            expr = XPathFactory.newInstance().newXPath().compile("//*[local-name()='SignatureMethod']/@Algorithm");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }
}

