/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.soap.soap11;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.soap.soap11.SoapClientException;
import org.sourceid.common.soap.soap11.SoapFaultException;
import org.sourceid.common.soap.soap11.SoapHttpConnectionPoolingManager;
import org.sourceid.common.soap.soap11.SoapHttpConnectionPoolingManagerException;
import org.sourceid.config.ConfigurationException;
import org.sourceid.protocol.soap11.xml.Body;
import org.sourceid.protocol.soap11.xml.EnvelopeDocument;
import org.sourceid.protocol.soap11.xml.Fault;
import org.w3c.dom.Node;

public class SoapClient {
    public static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    public static final String CONTENT_TYPE_HEADER_VALUE = "text/xml";
    private static Log log = LogFactory.getLog(SoapClient.class);

    private SoapClient() {
    }

    public static void flushClientsCache() {
        SoapHttpConnectionPoolingManager.getInstance().clear();
    }

    public static XmlObject sendRequest(String providerId, URL endpoint, XmlObject soapBody) throws SoapClientException, IOException {
        return SoapClient.sendRequest(providerId, endpoint, soapBody, null);
    }

    public static XmlObject sendRequest(String providerId, URL endpoint, XmlObject protoRequest, String action) throws SoapClientException, IOException {
        XmlObject soapResponse = null;
        EnvelopeDocument envelope = EnvelopeDocument.Factory.newInstance();
        envelope.addNewEnvelope().addNewBody().set(protoRequest);
        URI httpUri = null;
        try {
            httpUri = endpoint.toURI();
        }
        catch (URISyntaxException e1) {
            throw new SoapClientException("Error converting URL to URI.", e1);
        }
        HttpPost method = new HttpPost(httpUri);
        method.setHeader(CONTENT_TYPE_HEADER_NAME, CONTENT_TYPE_HEADER_VALUE);
        method.setHeader("SOAPAction", action);
        StringEntity entity = new StringEntity(XmlBeansUtil.xmlText((XmlObject)envelope));
        method.setEntity((HttpEntity)entity);
        try {
            String response = SoapHttpConnectionPoolingManager.getInstance().doRequest(providerId, endpoint, (HttpRequestBase)method);
            Node node = XmlBeansUtil.parseToNode(response);
            envelope = EnvelopeDocument.Factory.parse((Node)node);
            Body body = envelope.getEnvelope().getBody();
            XmlObject protoResponse = XmlBeansUtil.getFirstChild((XmlObject)body);
            if (protoResponse instanceof Fault) {
                Fault f = (Fault)protoResponse;
                log.error((Object)("Fault from endpoint: code = " + f.getFaultcode() + " string = " + f.getFaultstring()));
                throw new SoapFaultException("Response is a fault.", f);
            }
            soapResponse = protoResponse;
        }
        catch (SoapHttpConnectionPoolingManagerException e) {
            log.error((Object)("Unexpected status code " + e.getCode()));
            StringBuffer msg = new StringBuffer("Unexpected response status: ");
            msg.append(e.getReasonPhrase());
            msg.append(" (status code: ").append(e.getCode()).append(")");
            msg.append(Util.LINE_BREAK).append(" Response Body: ").append(e.getMessage());
            String message = msg.toString();
            log.debug((Object)message);
            throw new SoapClientException(message);
        }
        catch (SoapClientException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            log.error((Object)("Could not create client for endpoint due to configuration error: " + LogGuard.encode(endpoint.toString())), (Throwable)e);
            throw new SoapClientException("SoapClient configuration error", e);
        }
        catch (XmlException e) {
            log.error((Object)"Response is not a valid XML document.", (Throwable)e);
            throw new SoapClientException("Invalid response", e);
        }
        catch (IOException e) {
            log.error((Object)("General error while sending soap request to " + endpoint), (Throwable)e);
            throw e;
        }
        return soapResponse;
    }
}

