/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.soap.soap12;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.SoapServerSupport;
import org.sourceid.protocol.soap12.xml.Envelope;
import org.sourceid.protocol.soap12.xml.EnvelopeDocument;

public class Soap12ServerSupport
extends SoapServerSupport {
    private static Log log = LogFactory.getLog(Soap12ServerSupport.class);
    private EnvelopeDocument soapEnvelopeDocument;

    public Soap12ServerSupport(XmlObject xmlObject) {
        super(null, xmlObject);
        try {
            this.soapEnvelopeDocument = (EnvelopeDocument)xmlObject;
            Envelope envelope = this.soapEnvelopeDocument.getEnvelope();
            this.body = envelope.getBody();
            if (this.body == null) {
                throw new InvalidRequestException("No body in SOAP message");
            }
            this.bodyElements = XmlBeansUtil.getChildren(this.body);
            if (envelope.isSetHeader()) {
                this.header = envelope.getHeader();
                this.headers = XmlBeansUtil.getChildren(this.header);
            }
        }
        catch (InvalidRequestException e) {
            this.invalidRequestException = e;
        }
    }

    public EnvelopeDocument getSoapEnvelopeDocument() throws InvalidRequestException {
        this.checkThrow();
        return this.soapEnvelopeDocument;
    }
}

