/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.config;

import com.pingidentity.configservice.SysDirInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pingidentity.utils.EnvironmentVariableUtil;
import org.sourceid.config.GlobalRegistry;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class ConfigProps
extends Properties {
    private static final long serialVersionUID = -181575621992005266L;
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyFileName;
    private String absoluteFileName;

    public ConfigProps(String fileName) {
        this(fileName, true);
    }

    public ConfigProps(String fileName, boolean warnIfNotFound) {
        SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        String confDir = sysDirInfo.getConfigDirectory();
        try {
            this.absoluteFileName = confDir + File.separator + fileName;
            this.propertyFileName = fileName;
            this.load(new InputStreamReader(Files.newInputStream(Paths.get(this.absoluteFileName, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            if (warnIfNotFound) {
                this.log.warn((Object)(fileName + " config file not found.  Using defaults (if they exist). " + e));
            }
            this.log.debug((Object)(fileName + " config file not found.  Using defaults (if they exist). " + e));
        }
        this.log.debug((Object)("Loaded config props from " + fileName + " " + this.toString()));
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        super.load(reader);
        Map<String, String> envs = System.getenv();
        String prefix = EnvironmentVariableUtil.getEnvVarNamePrefix((String)this.propertyFileName);
        Map propsNameMap = EnvironmentVariableUtil.getPropertyNameMap((Properties)this);
        for (Map.Entry<String, String> env : envs.entrySet()) {
            EnvironmentVariableUtil.updateProperties((Properties)this, (String)prefix, env, (Map)propsNameMap);
        }
    }

    public boolean getBoolean(String propertyName) {
        String value = super.getProperty(propertyName);
        return Boolean.parseBoolean(value);
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = super.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public List<String> getList(String propertyName) {
        String value = super.getProperty(propertyName, "");
        String[] chunks = value.split(",");
        ArrayList<String> list = new ArrayList<String>(chunks.length);
        for (String s : chunks) {
            String trimed = s.trim();
            if (StringUtils.isBlank((String)trimed)) continue;
            list.add(trimed);
        }
        return list;
    }

    public int getInt(String propertyName, int defaultValue) {
        String value = super.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)("Invalid value: " + value + " of " + propertyName + " in " + this.propertyFileName + ". Using default value " + defaultValue));
            return defaultValue;
        }
    }

    public double getDouble(String propertyName, double defaultValue) {
        String value = super.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)("Invalid value: " + value + " of " + propertyName + " in " + this.propertyFileName + ". Using default value " + defaultValue));
            return defaultValue;
        }
    }

    public void store() {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.absoluteFileName);){
            this.store(fileOutputStream, null);
        }
        catch (IOException e) {
            this.log.error((Object)(this.propertyFileName + " config file not saved. " + e));
        }
    }
}

