/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.config;

import com.pingidentity.configservice.SysDirInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public enum ConfigStoreLocation {
    DEFAULT,
    CONF,
    DATA_DEFAULT_ZIP,
    LOCAL,
    INSTANCE;

    private static Log log;
    private static final String CONFIG_STORE_SUB_DIR = "config-store";
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();

    public String getDirectory() {
        if (this.sysDirInfo == null) {
            log.warn((Object)"SysDirInfo not configured");
            return "SysDirInfoNotConfiguredHACK";
        }
        if (this == CONF) {
            return this.sysDirInfo.getConfigDirectory();
        }
        if (this == LOCAL) {
            return this.sysDirInfo.getLocalDataDirectory();
        }
        if (this == INSTANCE) {
            return this.sysDirInfo.getInstanceDataDirectory();
        }
        if (this == DATA_DEFAULT_ZIP) {
            return this.sysDirInfo.getDataDefaultZipDirectory() + File.separator + CONFIG_STORE_SUB_DIR;
        }
        return this.sysDirInfo.getDataDirectory() + File.separator + CONFIG_STORE_SUB_DIR;
    }

    static {
        log = LogFactory.getLog(ConfigStoreLocation.class);
    }
}

