/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.config.impl;

import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.HashedPassword;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.SoapAuthStore;
import org.sourceid.config.soapauth.xml.AuthType;
import org.sourceid.config.soapauth.xml.BasicAuthType;
import org.sourceid.config.soapauth.xml.CertAuthType;
import org.sourceid.config.soapauth.xml.DirectionType;
import org.sourceid.config.soapauth.xml.NoneAuthType;
import org.sourceid.config.soapauth.xml.SoapAuth;
import org.sourceid.config.soapauth.xml.SoapAuthDocument;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

public class SoapAuthStoreImpl
implements SoapAuthStore,
AutoReloadable {
    static final String CONFIG_FILE = "sourceid-soap-auth.xml";
    final Log log = LogFactory.getLog(this.getClass());
    private Map<String, SoapAuthInfo> inByUsername = new HashMap<String, SoapAuthInfo>();
    private Map<String, SoapAuthInfo> inByDn = new HashMap<String, SoapAuthInfo>();
    private Map<String, SoapAuthInfo> inById = new HashMap<String, SoapAuthInfo>();
    private Map<String, SoapAuthInfo> outById = new HashMap<String, SoapAuthInfo>();
    protected SoapAuth soapAuth;
    private XmlLoader loader;
    private SysDirInfo sysDirInfo;
    private PkCertAndConnectionCertManager sslAuthCertManager = (PkCertAndConnectionCertManager)MgmtFactory.getSslAuthPkCertManager();
    protected FieldObfuscator fieldObfuscator;

    public SoapAuthStoreImpl() {
        this.loader = GlobalRegistry.getService(XmlLoader.class);
        this.sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        this.fieldObfuscator = FieldObfuscator.REAL;
        this.loadConfig();
    }

    @Override
    public synchronized SoapAuthInfo getByIncomingBasic(String username) {
        return this.inByUsername.get(username);
    }

    @Override
    public synchronized SoapAuthInfo getByIncomingCert(String subjectDN) {
        subjectDN = Util.canonicalizeX500DN(subjectDN);
        return this.inByDn.get(subjectDN);
    }

    @Override
    public synchronized Set<SoapAuthInfo> getAllIncomingCerts() {
        return new HashSet<SoapAuthInfo>(this.inByDn.values());
    }

    @Override
    public synchronized SoapAuthInfo getIncoming(String entityId) {
        SoapAuthInfo in = this.inById.get(entityId);
        in = in != null ? in : new SoapAuthInfo(entityId);
        return in;
    }

    @Override
    public synchronized void setIncoming(SoapAuthInfo info) {
        DirectionType incoming = this.soapAuth.getIncoming();
        this.setAuth(incoming, info, true);
    }

    private void setAuth(DirectionType direction, SoapAuthInfo soapAuthInfo, boolean isIncoming) {
        String entityId = soapAuthInfo.getEntityId();
        BasicAuthType[] basicArray = direction.getBasicArray();
        for (int i = 0; i < basicArray.length; ++i) {
            BasicAuthType basicAuthType = basicArray[i];
            if (!basicAuthType.getProviderID().equals(entityId)) continue;
            direction.removeBasic(i);
            break;
        }
        CertAuthType[] x509CertArray = direction.getX509CertArray();
        for (int i = 0; i < x509CertArray.length; ++i) {
            CertAuthType certAuthType = x509CertArray[i];
            if (!certAuthType.getProviderID().equals(entityId)) continue;
            direction.removeX509Cert(i);
            break;
        }
        NoneAuthType[] noneArray = direction.getNoneArray();
        for (int i = 0; i < noneArray.length; ++i) {
            NoneAuthType noneAuthType = noneArray[i];
            if (!noneAuthType.getProviderID().equals(entityId)) continue;
            direction.removeNone(i);
            break;
        }
        if (soapAuthInfo.isHasNoneEntry()) {
            NoneAuthType noneAuthType = direction.addNewNone();
            noneAuthType.setProviderID(entityId);
            noneAuthType.setSsl(soapAuthInfo.isSsl());
            noneAuthType.setDisableCertChainValidation(soapAuthInfo.isDisableCertChainValidation());
        }
        if (soapAuthInfo.isHasBasicEntry()) {
            BasicAuthType basicAuthType = direction.addNewBasic();
            basicAuthType.setProviderID(entityId);
            basicAuthType.setSsl(soapAuthInfo.isSsl());
            basicAuthType.setDisableCertChainValidation(soapAuthInfo.isDisableCertChainValidation());
            SoapAuthInfo.BasicAuthInfo basicAuthInfo = soapAuthInfo.getBasicAuthInfo();
            if (isIncoming) {
                SoapAuthInfo.IncomingBasicAuthInfo incomingAuth = (SoapAuthInfo.IncomingBasicAuthInfo)basicAuthInfo;
                if (incomingAuth.getNewPassword() != null) {
                    basicAuthType.setPassword(HashedPassword.fromClearText(incomingAuth.getNewPassword()).toEncodedText());
                } else {
                    basicAuthType.setPassword(incomingAuth.getEncodedPassword());
                }
            } else {
                basicAuthType.setPassword(basicAuthInfo.getEncodedPassword());
            }
            basicAuthType.setUsername(basicAuthInfo.getUsername());
        }
        if (soapAuthInfo.isHasCertEntry()) {
            CertAuthType certAuthType = direction.addNewX509Cert();
            certAuthType.setProviderID(entityId);
            SoapAuthInfo.CertAuthInfo certAuthInfo = soapAuthInfo.getCertAuthInfo();
            String alias = certAuthInfo.getAlias();
            if (alias != null) {
                this.setAlias(certAuthType, alias);
            } else {
                certAuthType.setSubjectDN(certAuthInfo.getSubjectDN());
                if (certAuthInfo.getIssuerDN() != null) {
                    certAuthType.setIssuerDN(certAuthInfo.getIssuerDN());
                }
            }
            certAuthType.setDisableCertChainValidation(soapAuthInfo.isDisableCertChainValidation());
        }
        this.save();
        this.reparse();
    }

    protected void setAlias(CertAuthType certAuthType, String alias) {
        certAuthType.setAlias(alias);
    }

    protected void save() {
        SoapAuthDocument soapAuthDocument = SoapAuthDocument.Factory.newInstance();
        soapAuthDocument.setSoapAuth(this.soapAuth);
        this.loader.save(this.sysDirInfo.getDataDirectory(), CONFIG_FILE, (XmlObject)soapAuthDocument);
    }

    @Override
    public synchronized SoapAuthInfo getOutgoing(String entityId) {
        SoapAuthInfo out = this.outById.get(entityId);
        out = out != null ? out : new SoapAuthInfo(entityId);
        return out;
    }

    @Override
    public synchronized void setOutgoing(SoapAuthInfo info) {
        DirectionType outgoing = this.soapAuth.getOutgoing();
        this.setAuth(outgoing, info, false);
    }

    private synchronized void loadConfig() {
        SoapAuthDocument soapAuthDocument = (SoapAuthDocument)this.loader.load(this.sysDirInfo.getDataDirectory(), CONFIG_FILE);
        this.soapAuth = soapAuthDocument.getSoapAuth();
        this.reparse();
    }

    public synchronized void reparse() {
        this.inByDn.clear();
        this.inById.clear();
        this.inByUsername.clear();
        this.outById.clear();
        this.loadDirection(this.soapAuth.getIncoming(), this.inById, false);
        this.loadDirection(this.soapAuth.getOutgoing(), this.outById, true);
        for (SoapAuthInfo soapAuthInfo : this.inById.values()) {
            if (soapAuthInfo.isHasBasicEntry()) {
                SoapAuthInfo.BasicAuthInfo basicAuthInfo = soapAuthInfo.getBasicAuthInfo();
                this.inByUsername.put(basicAuthInfo.getUsername(), soapAuthInfo);
            }
            if (!soapAuthInfo.isHasCertEntry()) continue;
            SoapAuthInfo.CertAuthInfo certAuthInfo = soapAuthInfo.getCertAuthInfo();
            this.inByDn.put(certAuthInfo.getSubjectDN(), soapAuthInfo);
        }
    }

    private void loadDirection(DirectionType direction, Map<String, SoapAuthInfo> map, boolean isOutgoing) {
        SoapAuthInfo soapAuthInfo;
        for (NoneAuthType noneAuthType : direction.getNoneArray()) {
            soapAuthInfo = this.checkPutGet((AuthType)noneAuthType, map);
            soapAuthInfo.setHasNoneEntry(true);
            if (!noneAuthType.getSsl()) continue;
            soapAuthInfo.setSsl(true);
        }
        for (NoneAuthType noneAuthType : direction.getBasicArray()) {
            SoapAuthInfo.BasicAuthInfo basicAuthInfo;
            soapAuthInfo = this.checkPutGet((AuthType)noneAuthType, map);
            String password = noneAuthType.getPassword();
            String username = noneAuthType.getUsername();
            if (isOutgoing) {
                basicAuthInfo = new SoapAuthInfo.OutgoingBasicAuthInfo(username, password);
                soapAuthInfo.setBasicAuthInfo(basicAuthInfo);
            } else {
                basicAuthInfo = new SoapAuthInfo.IncomingBasicAuthInfo(username, password);
                soapAuthInfo.setBasicAuthInfo(basicAuthInfo);
            }
            if (!noneAuthType.getSsl()) continue;
            soapAuthInfo.setSsl(true);
        }
        for (NoneAuthType noneAuthType : direction.getX509CertArray()) {
            soapAuthInfo = this.checkPutGet((AuthType)noneAuthType, map);
            if (noneAuthType.isSetAlias()) {
                String alias = noneAuthType.getAlias();
                this.loadCertInfo(alias, soapAuthInfo, isOutgoing);
                continue;
            }
            String subjectDN = Util.canonicalizeX500DN(noneAuthType.getSubjectDN());
            String issuerDN = null;
            if (!StringUtils.isEmpty((String)noneAuthType.getIssuerDN())) {
                issuerDN = Util.canonicalizeX500DN(noneAuthType.getIssuerDN());
            }
            soapAuthInfo.setCertAuthInfo(new SoapAuthInfo.CertAuthInfo(subjectDN, issuerDN, null, null));
        }
    }

    protected void loadCertInfo(String alias, SoapAuthInfo soapAuthInfo, boolean isOutgoing) {
        try {
            Cert cert = null;
            cert = isOutgoing ? this.sslAuthCertManager.getPkCert(alias) : this.sslAuthCertManager.getCert(alias);
            if (cert == null) {
                this.setNullCertInfo(alias, soapAuthInfo);
                return;
            }
            X509Certificate certificate = cert.getX509Certificate();
            if (!(cert.getX509Certificate() instanceof X509Certificate)) {
                throw new ConfigurationException("Certificate is of unsupported type, alias = " + alias + ", type  = " + certificate.getType() + ".");
            }
            X509Certificate x509cert = certificate;
            String subjectDN = Util.canonicalizeX500DN(x509cert.getSubjectDN().getName());
            soapAuthInfo.setCertAuthInfo(new SoapAuthInfo.CertAuthInfo(subjectDN, null, x509cert, alias));
        }
        catch (IllegalArgumentException e) {
            if (PropertyInfo.HSM_MODE.NCIPHER == PropertyInfo.getHSMMode()) {
                this.setNullCertInfo(alias, soapAuthInfo);
                return;
            }
            throw new ConfigurationException("Unable to retrieve cert from keystore, alias = " + alias + ".");
        }
    }

    private void setNullCertInfo(String alias, SoapAuthInfo soapAuthInfo) {
        soapAuthInfo.setCertAuthInfo(new SoapAuthInfo.CertAuthInfo(null, null, null, null));
        this.log.error((Object)("Cert for Soap Auth does not exist, alias = " + alias));
    }

    private SoapAuthInfo checkPutGet(AuthType authType, Map<String, SoapAuthInfo> map) {
        boolean disableCertChainValidation;
        String id = authType.getProviderID();
        SoapAuthInfo soapAuthInfo = map.get(id);
        if (soapAuthInfo == null) {
            soapAuthInfo = new SoapAuthInfo(id);
            map.put(id, soapAuthInfo);
        }
        if (disableCertChainValidation = authType.getDisableCertChainValidation()) {
            soapAuthInfo.setDisableCertChainValidation(true);
        }
        return soapAuthInfo;
    }
}

