/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.jose.jwk;

import com.pingidentity.crypto.PkCert;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.JoseException;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public final class AccessTokenMgmtJwkPublishUtil {
    private static final PkCertManager dsigPkCertManager = MgmtFactory.getDsigPkCertManager();
    private static final BearerAccessTokenMgmtPluginManager atmPluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private static final Log log = LogFactory.getLog(AccessTokenMgmtJwkPublishUtil.class);

    private AccessTokenMgmtJwkPublishUtil() {
    }

    public static String getAtmInstanceIdForKeyId(String keyId, String currentAtmInstanceId) {
        for (Map.Entry<String, Map<String, String>> instanceIdToKeyIdCertIds : atmPluginManager.getPublishableJwkKeyIdCertAlias().entrySet()) {
            Set<String> keyIdsForInstance;
            String pluginId = instanceIdToKeyIdCertIds.getKey();
            if (pluginId.equals(currentAtmInstanceId) || !(keyIdsForInstance = instanceIdToKeyIdCertIds.getValue().keySet()).contains(keyId)) continue;
            return pluginId;
        }
        return null;
    }

    public static JsonWebKeySet getAllAccessTokenManagementJWKSToPublish() {
        JsonWebKeySet jsonWebKeySet = null;
        Map<String, Map<String, String>> pluginIdToKeyIdCert = atmPluginManager.getPublishableJwkKeyIdCertAlias();
        if (!pluginIdToKeyIdCert.isEmpty()) {
            LinkedList<JsonWebKey> jsonWebKeys = new LinkedList<JsonWebKey>();
            for (Map<String, String> keyIdsToCertIds : pluginIdToKeyIdCert.values()) {
                for (Map.Entry<String, String> keyIdCertEntry : keyIdsToCertIds.entrySet()) {
                    JsonWebKey jwk = AccessTokenMgmtJwkPublishUtil.getPublicJsonWebKey(keyIdCertEntry.getValue(), keyIdCertEntry.getKey());
                    jsonWebKeys.add(jwk);
                }
            }
            jsonWebKeySet = new JsonWebKeySet(jsonWebKeys);
        }
        return jsonWebKeySet;
    }

    private static JsonWebKey getPublicJsonWebKey(String certAlias, String keyId) {
        X500PrivateCredential x500;
        X509Certificate x509Certificate;
        PublicJsonWebKey publicJsonWebKey = null;
        PkCert pkCert = dsigPkCertManager.getPkCert(certAlias);
        if (pkCert != null && (x509Certificate = (x500 = new X500PrivateCredential(pkCert.getX509Certificate(), pkCert.getPrivateKey(), pkCert.getAlias())).getCertificate()) != null) {
            try {
                publicJsonWebKey = PublicJsonWebKey.Factory.newPublicJwk((Key)x509Certificate.getPublicKey());
                publicJsonWebKey.setCertificateChain(new X509Certificate[]{x509Certificate});
                publicJsonWebKey.setKeyId(keyId);
                publicJsonWebKey.setUse("sig");
                publicJsonWebKey.setX509CertificateSha1Thumbprint(publicJsonWebKey.getX509CertificateSha1Thumbprint(true));
            }
            catch (JoseException je) {
                log.error((Object)("Unable to add Access Token Management plugin certificate with key ID: " + keyId + " to JWKS: " + je), (Throwable)je);
            }
        }
        return publicJsonWebKey;
    }
}

