/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.localidentity;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.localidentity.ConnectedIdentity;
import com.pingidentity.localidentity.DataStoreAttribute;
import com.pingidentity.localidentity.DataStoreConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.localidentity.authsource.LocalAccountAuthSource;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.AbstractLocalIdentityStorageManagerImpl;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.LocalIdentityManagementResult;
import org.sourceid.util.log.AttributeMap;

public abstract class LocalIdentityStorageManagerBaseLdapImpl
extends AbstractLocalIdentityStorageManagerImpl<DN> {
    public static final String OBJECTCLASS = "objectClass";
    private static final Log LOG = LogFactory.getLog(LocalIdentityStorageManagerBaseLdapImpl.class);

    public final Attributes getAttributes(LocalIdentityProfile localIdentityProfile, Map<String, FieldData<?>> attributesKeyValueMap, String connectedIdentitiesObjectClass, String connectedIdentityAttributeName, String thirdParty, String identityId) {
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        String objectClass = dataStoreConfig.getAttributeSource().getParameter("object_class");
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClassAttribute = new BasicAttribute(OBJECTCLASS);
        objectClassAttribute.add(objectClass);
        this.addAuxiliaryObjectClasses(dataStoreConfig, objectClassAttribute);
        objectClassAttribute.add(connectedIdentitiesObjectClass);
        attributes.put(objectClassAttribute);
        String connectedIdentityValue = LocalIdentityUtils.createConnectedIdentityValue(thirdParty, identityId);
        this.addConnectedIdentityAttribute(attributes, connectedIdentityAttributeName, connectedIdentityValue, thirdParty, localIdentityProfile, attributesKeyValueMap);
        Map<String, DataStoreAttribute> dataStoreAttributeMap = dataStoreConfig.getDataStoreMapping();
        for (Map.Entry<String, FieldData<?>> entry : attributesKeyValueMap.entrySet()) {
            DataStoreAttribute dataStoreField = dataStoreAttributeMap.get(entry.getKey());
            FieldData<?> fieldData = entry.getValue();
            attributes.put(fieldData.toAttribute(dataStoreField.getName()));
        }
        return attributes;
    }

    private void addAuxiliaryObjectClasses(DataStoreConfig dataStoreConfig, Attribute objectClassAttribute) {
        List<String> auxiliaryClassList = this.getAuxiliaryObjectClassesList(dataStoreConfig);
        for (String auxObjectClass : auxiliaryClassList) {
            objectClassAttribute.add(auxObjectClass);
        }
    }

    private List<String> getAuxiliaryObjectClassesList(DataStoreConfig dataStoreConfig) {
        String auxiliaryObjectClassesString = dataStoreConfig.getAttributeSource().getParameter("auxiliary_object_classes");
        List<String> classList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)auxiliaryObjectClassesString)) {
            String[] classes = StringUtils.split((String)auxiliaryObjectClassesString, (char)',');
            classList = Arrays.asList(classes);
        }
        return classList;
    }

    public final Attributes applyAttributeUpdate(LocalIdentityProfile localIdentityProfile, AttributeMap attributeMap, Map<String, FieldData<?>> fieldsToModify) {
        BasicAttributes attributes = new BasicAttributes();
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        String connectedIdentityAttributeName = this.getConnectedIdentityAttributeName();
        this.createConnectedIdentityAttributeForUpdate(localIdentityProfile, attributeMap, fieldsToModify, connectedIdentityAttributeName, attributes);
        Map<String, DataStoreAttribute> dataStoreAttributeMap = dataStoreConfig.getDataStoreMapping();
        for (Map.Entry<String, FieldData<?>> entry : fieldsToModify.entrySet()) {
            DataStoreAttribute dataStoreField = dataStoreAttributeMap.get(entry.getKey());
            FieldData<?> fieldData = entry.getValue();
            attributes.put(fieldData.toAttribute(dataStoreField.getName()));
        }
        List<String> auxiliaryObjectClassList = this.getAuxiliaryObjectClassesList(dataStoreConfig);
        Collection existingObjectClasses = ((AttributeValue)attributeMap.get((Object)OBJECTCLASS)).getValuesAsCollection();
        Collection union = CollectionUtils.union((Collection)existingObjectClasses, auxiliaryObjectClassList);
        if (union.size() > existingObjectClasses.size()) {
            BasicAttribute updatedObjectClassAttribute = new BasicAttribute(OBJECTCLASS);
            for (String objectClass : union) {
                updatedObjectClassAttribute.add(objectClass);
            }
            attributes.put(updatedObjectClassAttribute);
        }
        return attributes;
    }

    final BasicAttribute getPasswordAttribute(LdapDataSource dataSource, String newPassword) {
        return new BasicAttribute(dataSource.getPasswordAttribute(), newPassword);
    }

    final void removePasswordAttribute(Attributes attributes, LdapDataSource dataSource) {
        attributes.remove(dataSource.getPasswordAttribute());
    }

    final LDAPUtil getLdapUtil(AttributeSource attributeSource) throws NamingException {
        return LDAPUtil.newInstance(attributeSource.getDataSource(), (ServiceInformation)this);
    }

    final LDAPUtil getLdapUtil(LocalIdentityProfile localIdentityProfile) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        try {
            return this.getLdapUtil(attributeSource);
        }
        catch (NamingException e) {
            LOG.error((Object)("Unable to connect to data store " + e.getExplanation()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Unable to connect to data store.", (Throwable)e);
            }
            throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, LocalIdentityManagementResult.getDefaultResult());
        }
    }

    private void addConnectedIdentityAttribute(Attributes attributes, String connectedIdentityAttributeName, String connectedIdentityValue, String thirdParty, LocalIdentityProfile localIdentityProfile, Map<String, FieldData<?>> attributesKeyValueMap) {
        BasicAttribute attribute = new BasicAttribute(connectedIdentityAttributeName, connectedIdentityValue);
        if (!LocalAccountAuthSource.PF_LOCAL_ACCOUNT_AUTH_SOURCE.getId().equals(thirdParty)) {
            LocalIdentityField<?> uniqueIdField = localIdentityProfile.getFieldConfig().getUniqueIdField();
            String id = uniqueIdField.getData().getId();
            FieldData<?> fieldData = attributesKeyValueMap.get(id);
            String value = (String)fieldData.getFirstValue();
            value = LocalIdentityUtils.getFormattedUniqueId(localIdentityProfile, value);
            String localIdentityValue = LocalIdentityUtils.createConnectedIdentityValue(LocalAccountAuthSource.PF_LOCAL_ACCOUNT_AUTH_SOURCE.getId(), value);
            attribute.add(localIdentityValue);
        }
        attributes.put(attribute);
    }

    private void createConnectedIdentityAttributeForUpdate(LocalIdentityProfile localIdentityProfile, AttributeMap attributeMap, Map<String, FieldData<?>> fieldsToModify, String connectedIdentityAttributeName, Attributes results) {
        LocalIdentityField<?> uniqueIdField = localIdentityProfile.getFieldConfig().getUniqueIdField();
        AttributeValue connectedIdentity = (AttributeValue)attributeMap.get((Object)connectedIdentityAttributeName);
        FieldData<?> uniqueIdData = fieldsToModify.get(uniqueIdField.getData().getId());
        if (uniqueIdData != null) {
            BasicAttribute attr = new BasicAttribute(connectedIdentityAttributeName);
            List connectedIdentities = connectedIdentity.getValuesAsCollection().stream().map(ConnectedIdentity::new).collect(Collectors.toList());
            for (ConnectedIdentity identity : connectedIdentities) {
                String connectedIdentityValue;
                if (identity.isLocalIdentity()) {
                    String value = String.valueOf(uniqueIdData.getFirstValue());
                    String authSourceId = identity.getAuthSourceId();
                    connectedIdentityValue = LocalIdentityUtils.createConnectedIdentityValue(authSourceId, value);
                } else {
                    connectedIdentityValue = LocalIdentityUtils.createConnectedIdentityValue(identity);
                }
                attr.add(connectedIdentityValue);
            }
            results.put(attr);
        }
    }

    boolean hasPasswordAttribute(LocalIdentityProfile profile, Entry entry) {
        LdapDataSource dataSource = (LdapDataSource)profile.getDataStoreConfig().getAttributeSource().getDataSource();
        String passwordAttribute = dataSource.getPasswordAttribute();
        return entry.getAttributes().stream().anyMatch(attribute -> passwordAttribute.equals(attribute.getName()));
    }

    protected abstract Map<String, Object> getWriteSubstitutionValueMap(Map<String, FieldData<?>> var1);

    protected abstract String getConnectedIdentitiesObjectClass();

    protected abstract String getConnectedIdentityAttributeName();

    protected abstract String getConnectedIdentityAttributeStorageName();
}

