/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.localidentity;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.ldap.LDAPCrudHelper;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.passwordvalidator.LDAPPasswordPolicyViolationException;
import com.pingidentity.localidentity.DataStoreConfig;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.LdapDataStoreConfig;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityLdapDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.localidentity.attrupdates.AuthSourceAttributes;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldData;
import com.pingidentity.pingcommons.util.DNUtil;
import com.sun.jndi.ldap.LdapName;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.localidentity.LocalIdentityStorageManagerBaseLdapImpl;
import org.sourceid.localidentity.LocalIdentityStorageManagerUtils;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.localidentity.data.StringFieldData;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.LocalIdentityManagementResult;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public abstract class LocalIdentityStorageManagerLdapODBase
extends LocalIdentityStorageManagerBaseLdapImpl {
    private static final Log LOG = LogFactory.getLog(LocalIdentityStorageManagerLdapODBase.class);
    private final ObjectMapper objectMapper;

    public LocalIdentityStorageManagerLdapODBase() {
        this(ObjectMapperFactory.buildObjectMapper());
    }

    public LocalIdentityStorageManagerLdapODBase(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public LocalIdentityDTO<DN> addIdentity(LocalIdentityProfile localIdentityProfile, Map<String, FieldData<?>> fieldValues, String newPassword, String thirdParty, String identityId, String thirdPartyAttrs) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        String searchBase = ((LdapDataStoreConfig)localIdentityProfile.getDataStoreConfig()).getBaseDN();
        try {
            this.stripSpacesFromUniqueIdField(localIdentityProfile, fieldValues);
            String createPattern = attributeSource.getParameter("create_pattern").trim();
            Map<String, Object> substitutionValueMap = this.getWriteSubstitutionValueMap(fieldValues);
            String createLdapName = Substituter.substituteValues(createPattern, substitutionValueMap);
            StringBuilder s = new StringBuilder();
            createLdapName = DNUtil.escapeDN((String)createLdapName);
            s.append(createLdapName);
            if (StringUtils.isNotBlank((String)searchBase)) {
                s.append(",").append(searchBase);
            }
            LdapName ldapName = new LdapName(s.toString());
            Attributes attributes = this.getAttributes(localIdentityProfile, fieldValues, this.getConnectedIdentitiesObjectClass(), this.getConnectedIdentityAttributeName(), thirdParty, identityId);
            if (StringUtils.isNotBlank((String)thirdPartyAttrs)) {
                BasicAttribute thirdPartyAttributes = new BasicAttribute(this.getConnectedIdentityAttributeStorageName(), thirdPartyAttrs);
                attributes.put(thirdPartyAttributes);
            }
            if (StringUtils.isNotEmpty((String)newPassword)) {
                BasicAttribute passwordAttribute = this.getPasswordAttribute((LdapDataSource)attributeSource.getDataSource(), newPassword);
                attributes.put(passwordAttribute);
            }
            LDAPUtil ldapUtil = this.getLdapUtil(attributeSource);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            this.addCustomLdapControl(ldapCrudHelper, localIdentityProfile);
            ldapCrudHelper.addControl((Control)LocalIdentityStorageManagerUtils.createPostReadRequestControl());
            ReadOnlyEntry entry = ldapCrudHelper.createEntry(ldapName, attributes);
            if (entry == null) {
                return null;
            }
            return new LocalIdentityLdapDTO((Entry)entry, localIdentityProfile, this.getConnectedIdentityAttributeName(), this.getConnectedIdentityAttributeStorageName(), this.hasPasswordAttribute(localIdentityProfile, (Entry)entry));
        }
        catch (NamingException e) {
            LOG.error((Object)("Creating new user failed: " + e.getExplanation()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Creating new user failed.", (Throwable)e);
            }
            throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, LocalIdentityManagementResult.getByExplanation(localIdentityProfile, e.getExplanation()));
        }
        catch (Substituter.UnknownKeyException e) {
            this.logUnknownKeyException(e);
            throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException((Throwable)((Object)e));
        }
    }

    void stripSpacesFromUniqueIdField(LocalIdentityProfile localIdentityProfile, Map<String, FieldData<?>> fieldValues) {
        String uniqueIdFieldId;
        FieldData<?> uniqueIdFieldData;
        FieldConfig fieldConfig = Optional.ofNullable(localIdentityProfile).map(LocalIdentityProfile::getFieldConfig).orElse(null);
        if (fieldConfig != null && fieldConfig.isStripSpaceFromUniqueField() && (uniqueIdFieldData = fieldValues.get(uniqueIdFieldId = (String)Optional.ofNullable(fieldConfig).map(FieldConfig::getUniqueIdField).map(LocalIdentityField::getData).map(LocalIdentityFieldData::getId).orElse(null))) instanceof StringFieldData) {
            StringFieldData uniqueIdStringFieldData = (StringFieldData)uniqueIdFieldData;
            uniqueIdStringFieldData.stripSpacesFromValues();
        }
    }

    @Override
    public LocalIdentityDTO<DN> getIdentityByLink(LocalIdentityProfile localIdentityProfile, String thirdParty, String identityId) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        if (StringUtils.isBlank((String)identityId)) {
            throw new LocalIdentityStorageManager.IdentityNotFoundException("Link not found");
        }
        try {
            String searchBase = ((LdapDataStoreConfig)localIdentityProfile.getDataStoreConfig()).getBaseDN();
            LDAPUtil ldapUtil = this.getLdapUtil(localIdentityProfile);
            Filter filter = this.createSearchIdentityFilter(localIdentityProfile, thirdParty, identityId);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            LDAPCrudHelper.SearchCriteria criteria = new LDAPCrudHelper.SearchCriteria(searchBase, SearchScope.SUB, filter, new String[0]);
            criteria.setCount(1);
            List<SearchResultEntry> results = ldapCrudHelper.search(criteria);
            if (results.isEmpty() || results.size() > 1) {
                if (results.isEmpty()) {
                    throw new LocalIdentityStorageManager.IdentityNotFoundException("Link not found");
                }
                throw new LocalIdentityStorageManager.IdentityNotFoundException("Identity Is not unique");
            }
            SearchResultEntry searchResultEntry = results.get(0);
            DN dn = new DN(searchResultEntry.getDN());
            return this.getIdentityByDn(localIdentityProfile, dn);
        }
        catch (LDAPException | NamingException e) {
            LOG.error((Object)("Getting user link failed: " + e.getMessage()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Getting user link failed.", e);
            }
            throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e);
        }
    }

    @Override
    public boolean identityExists(LocalIdentityProfile localIdentityProfile, String thirdParty, String identityId) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        if (StringUtils.isBlank((String)identityId)) {
            throw new LocalIdentityStorageManager.IdentityNotFoundException("Link not found");
        }
        try {
            String searchBase = ((LdapDataStoreConfig)localIdentityProfile.getDataStoreConfig()).getBaseDN();
            LDAPUtil ldapUtil = this.getLdapUtil(localIdentityProfile);
            Filter filter = this.createSearchIdentityFilter(localIdentityProfile, thirdParty, identityId);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            LDAPCrudHelper.SearchCriteria criteria = new LDAPCrudHelper.SearchCriteria(searchBase, SearchScope.SUB, filter, new String[0]);
            criteria.setCount(1);
            List<SearchResultEntry> results = ldapCrudHelper.search(criteria);
            return !results.isEmpty();
        }
        catch (NamingException e) {
            LOG.error((Object)("Getting user link failed: " + e.getExplanation()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Getting user link failed.", (Throwable)e);
            }
            throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, LocalIdentityManagementResult.getDefaultResult());
        }
    }

    @Override
    public LocalIdentityDTO<DN> getIdentityByDn(LocalIdentityProfile localIdentityProfile, DN dn) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        SearchResultEntry searchResultEntry = this.lookupIdentityByDn(localIdentityProfile, dn);
        if (searchResultEntry == null) {
            return null;
        }
        return new LocalIdentityLdapDTO((Entry)searchResultEntry, localIdentityProfile, this.getConnectedIdentityAttributeName(), this.getConnectedIdentityAttributeStorageName(), this.hasPasswordAttribute(localIdentityProfile, (Entry)searchResultEntry));
    }

    private SearchResultEntry lookupIdentityByDn(LocalIdentityProfile localIdentityProfile, DN dn) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        try {
            DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
            AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
            LDAPUtil ldapUtil = this.getLdapUtil(attributeSource);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            return ldapCrudHelper.getEntry(dn, "*", "+", "ds-pwp-state-json");
        }
        catch (NamingException e) {
            LOG.error((Object)("Getting user failed: " + e.getExplanation()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Getting user failed.", (Throwable)e);
            }
            throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e);
        }
    }

    @Override
    public LocalIdentityDTO<DN> addConnectedIdentity(LocalIdentityProfile localIdentityProfile, DN dn, String authSourceId, String userId, String authSourceAttrJson) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        try {
            LDAPUtil ldapUtil = this.getLdapUtil(localIdentityProfile);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            ldapCrudHelper.addControl((Control)LocalIdentityStorageManagerUtils.createPostReadRequestControl());
            SearchResultEntry searchResultEntry = this.lookupIdentityByDn(localIdentityProfile, dn);
            if (searchResultEntry != null) {
                String connectedIdentitiesObjectClass;
                String attributeName = this.getConnectedIdentityAttributeName();
                String attributeStorageName = this.getConnectedIdentityAttributeStorageName();
                BasicAttributes updateMap = new BasicAttributes();
                AttributeMap attributeMap = ldapCrudHelper.toAttributeMap(searchResultEntry, false);
                AttributeValue objectClassValue = (AttributeValue)attributeMap.get((Object)"objectClass");
                if (!objectClassValue.hasValue(connectedIdentitiesObjectClass = this.getConnectedIdentitiesObjectClass())) {
                    Collection values = objectClassValue.getValuesAsCollection();
                    values.add(connectedIdentitiesObjectClass);
                    javax.naming.directory.Attribute objectClassAttr = this.createBasicAttribute("objectClass", values);
                    updateMap.put(objectClassAttr);
                }
                AttributeValue connectedIdentityAttribute = (AttributeValue)attributeMap.get((Object)attributeName);
                Collection<String> connectedIdentities = new ArrayList();
                if (connectedIdentityAttribute != null) {
                    connectedIdentities = connectedIdentityAttribute.getValuesAsCollection();
                }
                String connectedIdentityValue = LocalIdentityUtils.createConnectedIdentityValue(authSourceId, userId);
                connectedIdentities.add(connectedIdentityValue);
                javax.naming.directory.Attribute connectedIdentotyAttr = this.createBasicAttribute(attributeName, connectedIdentities);
                updateMap.put(connectedIdentotyAttr);
                if (StringUtils.isNotBlank((String)authSourceAttrJson)) {
                    AttributeValue connectedIdentityAttributesHolder = (AttributeValue)attributeMap.get((Object)attributeStorageName);
                    Collection<String> connectedIdentitiesAttributes = new ArrayList<String>();
                    if (connectedIdentityAttributesHolder != null) {
                        connectedIdentitiesAttributes = connectedIdentityAttributesHolder.getValuesAsCollection();
                    }
                    connectedIdentitiesAttributes.removeIf(currentAttr -> {
                        try {
                            AuthSourceAttributes attributes = AuthSourceAttributes.fromJson(currentAttr);
                            return attributes.getAuthSourceId().equals(authSourceId);
                        }
                        catch (IOException e) {
                            log.warn((Object)("Unable to parse third-party attributes for and user '" + dn + "' due to '" + e.getMessage()));
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Unable to parse attribute JSON. JSON is: " + currentAttr), (Throwable)e);
                            }
                            return false;
                        }
                    });
                    connectedIdentitiesAttributes.add(authSourceAttrJson);
                    javax.naming.directory.Attribute attributeStorageAttr = this.createBasicAttribute(attributeStorageName, connectedIdentitiesAttributes);
                    updateMap.put(attributeStorageAttr);
                }
                ReadOnlyEntry modifiedEntry = this.modifyEntry(localIdentityProfile, dn, ldapCrudHelper, updateMap);
                return new LocalIdentityLdapDTO((Entry)modifiedEntry, localIdentityProfile, attributeName, attributeStorageName, this.hasPasswordAttribute(localIdentityProfile, (Entry)modifiedEntry));
            }
            this.logIdentityNotFoundException(dn);
            throw new LocalIdentityStorageManager.IdentityNotFoundException("Requested identity is not present in the LDAP data store.");
        }
        catch (NamingException e) {
            LOG.error((Object)("Adding connected identity failed: " + e.getExplanation()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Adding connected identity failed.", (Throwable)e);
            }
            throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, LocalIdentityManagementResult.getByExplanation(localIdentityProfile, e.getExplanation()));
        }
    }

    @Override
    public void removeConnectedIdentity(LocalIdentityProfile localIdentityProfile, DN dn, String authSourceId, String userId) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        try {
            LDAPUtil ldapUtil = this.getLdapUtil(localIdentityProfile);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            SearchResultEntry entry = this.lookupIdentityByDn(localIdentityProfile, dn);
            if (entry == null) {
                this.logIdentityNotFoundException(dn);
                throw new LocalIdentityStorageManager.IdentityNotFoundException("Requested identity is not present in the LDAP data store.");
            }
            BasicAttributes modifiedAttributes = new BasicAttributes();
            AttributeMap attributeMap = ldapCrudHelper.toAttributeMap(entry, false);
            this.updateConnectedIdentityValue(authSourceId, userId, modifiedAttributes, attributeMap);
            this.updateConnectedIdentityAttributesValue(localIdentityProfile, dn, authSourceId, modifiedAttributes, attributeMap);
            this.modifyEntry(localIdentityProfile, dn, ldapCrudHelper, modifiedAttributes);
        }
        catch (NamingException e) {
            LOG.error((Object)("Removing connected identity failed: " + e.getExplanation()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Removing connected identity failed.", (Throwable)e);
            }
            throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, LocalIdentityManagementResult.getByExplanation(localIdentityProfile, e.getExplanation()));
        }
    }

    @Override
    public LocalIdentityDTO<DN> updateIdentity(LocalIdentityProfile localIdentityProfile, DN dn, Map<String, FieldData<?>> fieldsToModify) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        SearchResultEntry entry = this.lookupIdentityByDn(localIdentityProfile, dn);
        if (entry != null) {
            try {
                LDAPUtil ldapUtil = this.getLdapUtil(attributeSource);
                LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
                AttributeMap attributeMap = ldapCrudHelper.toAttributeMap(entry, false);
                Attributes attributes = this.applyAttributeUpdate(localIdentityProfile, attributeMap, fieldsToModify);
                ldapCrudHelper.addControl((Control)LocalIdentityStorageManagerUtils.createPostReadRequestControl());
                LdapName ldapName = new LdapName(entry.getDN());
                ReadOnlyEntry modifyEntry = ldapCrudHelper.modifyEntry(ldapName, attributes, 2);
                if (modifyEntry == null) {
                    return null;
                }
                return new LocalIdentityLdapDTO((Entry)modifyEntry, localIdentityProfile, this.getConnectedIdentityAttributeName(), this.getConnectedIdentityAttributeStorageName(), this.hasPasswordAttribute(localIdentityProfile, (Entry)modifyEntry));
            }
            catch (NamingException e) {
                LOG.error((Object)("Identity update failed: " + e.getExplanation()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Identity update failed.", (Throwable)e);
                }
                LocalIdentityManagementResult result = LocalIdentityManagementResult.getByExplanation(localIdentityProfile, e.getExplanation());
                throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, result);
            }
        }
        this.logIdentityNotFoundException(dn);
        throw new LocalIdentityStorageManager.IdentityNotFoundException("Requested identity is not present in the LDAP data store.");
    }

    @Override
    public LocalIdentityDTO<DN> updateAuthSourceAttributes(LocalIdentityProfile localIdentityProfile, DN dn, LocalIdentityDTO<?> localIdentityDTO, AuthSourceAttributes newAttributes) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        SearchResultEntry entry = this.lookupIdentityByDn(localIdentityProfile, dn);
        if (entry != null) {
            try {
                String attributeStorageName = this.getConnectedIdentityAttributeStorageName();
                String attributeName = this.getConnectedIdentityAttributeName();
                BasicAttributes attributes = new BasicAttributes();
                BasicAttribute connectedAttributes = new BasicAttribute(attributeStorageName);
                LDAPUtil ldapUtil = this.getLdapUtil(attributeSource);
                LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
                Map<String, AuthSourceAttributes> connectedIdentityAttributes = localIdentityDTO.getConnectedIdentityAttributes();
                connectedIdentityAttributes.put(newAttributes.getAuthSourceId(), newAttributes);
                connectedIdentityAttributes.forEach((key, value) -> connectedAttributes.add(value.toJsonString()));
                attributes.put(connectedAttributes);
                ldapCrudHelper.addControl((Control)LocalIdentityStorageManagerUtils.createPostReadRequestControl());
                LdapName ldapName = new LdapName(dn.toString());
                ReadOnlyEntry modifyEntry = ldapCrudHelper.modifyEntry(ldapName, attributes, 2);
                if (modifyEntry == null) {
                    return null;
                }
                return new LocalIdentityLdapDTO((Entry)modifyEntry, localIdentityProfile, attributeName, attributeStorageName, this.hasPasswordAttribute(localIdentityProfile, (Entry)modifyEntry));
            }
            catch (NamingException e) {
                LOG.error((Object)("Updating attributes failed: " + e.getExplanation()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Updating attributes failed:", (Throwable)e);
                }
                throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, LocalIdentityManagementResult.getByExplanation(localIdentityProfile, e.getExplanation()));
            }
        }
        this.logIdentityNotFoundException(dn);
        throw new LocalIdentityStorageManager.IdentityNotFoundException("Requested identity is not present in the LDAP data store.");
    }

    @Override
    public void deleteIdentity(LocalIdentityProfile localIdentityProfile, DN dn) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        SearchResultEntry entry = this.lookupIdentityByDn(localIdentityProfile, dn);
        if (entry != null) {
            try {
                LDAPUtil ldapUtil = this.getLdapUtil(attributeSource);
                LdapName ldapName = new LdapName(dn.toString());
                LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
                ldapCrudHelper.deleteEntry(ldapName);
            }
            catch (NamingException e) {
                LOG.error((Object)("LDAP data store interaction failed: " + e.getExplanation()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"LDAP data store interaction failed.", (Throwable)e);
                }
                throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, LocalIdentityManagementResult.getByExplanation(localIdentityProfile, e.getExplanation()));
            }
        } else {
            this.logIdentityNotFoundException(dn);
            throw new LocalIdentityStorageManager.IdentityNotFoundException("Requested identity is not present in the LDAP data store.");
        }
    }

    @Override
    public LocalIdentityDTO<DN> changePassword(LocalIdentityProfile localIdentityProfile, DN dn, String currentPassword, String newPassword) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        LdapDataSource dataSource = (LdapDataSource)attributeSource.getDataSource();
        SearchResultEntry entry = this.lookupIdentityByDn(localIdentityProfile, dn);
        if (entry != null) {
            try {
                LDAPUtil ldapUtil = this.getLdapUtil(attributeSource);
                LdapName ldapName = new LdapName(entry.getDN());
                ldapUtil.changePassword(ldapName, currentPassword, newPassword, dataSource, false);
                return this.getIdentityByDn(localIdentityProfile, dn);
            }
            catch (NamingException e) {
                LOG.error((Object)("Identity update failed: " + e.getExplanation()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Identity update failed.", (Throwable)e);
                }
                throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, LocalIdentityManagementResult.getByExplanation(localIdentityProfile, e.getExplanation()));
            }
            catch (LDAPPasswordPolicyViolationException e) {
                String exceptionMsg = "LDAPPasswordPolicyViolationException while calling changePassword. LDAP server response from '" + dataSource.getDescription() + "': " + e.getMessage();
                LOG.debug((Object)exceptionMsg);
                throw LDAPUtil.convertLDAPPasswordPolicyViolationException(exceptionMsg, e);
            }
        }
        this.logIdentityNotFoundException(dn);
        throw new LocalIdentityStorageManager.IdentityNotFoundException("Requested identity is not present in the LDAP data store.");
    }

    @Override
    public LocalIdentityDTO<DN> setPassword(LocalIdentityProfile localIdentityProfile, DN dn, String newPassword) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        AttributeSource attributeSource = localIdentityProfile.getDataStoreConfig().getAttributeSource();
        LdapDataSource dataSource = (LdapDataSource)attributeSource.getDataSource();
        SearchResultEntry entry = this.lookupIdentityByDn(localIdentityProfile, dn);
        if (entry != null) {
            try {
                LDAPUtil ldapUtil = this.getLdapUtil(attributeSource);
                BasicAttributes attributes = new BasicAttributes();
                BasicAttribute passwordAttribute = this.getPasswordAttribute(dataSource, newPassword);
                attributes.put(passwordAttribute);
                LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
                ldapCrudHelper.addControl((Control)LocalIdentityStorageManagerUtils.createPostReadRequestControl());
                LdapName ldapName = new LdapName(entry.getDN());
                ReadOnlyEntry modifyEntry = ldapCrudHelper.modifyEntry(ldapName, attributes, 2);
                if (modifyEntry == null) {
                    return null;
                }
                return new LocalIdentityLdapDTO((Entry)modifyEntry, localIdentityProfile, this.getConnectedIdentityAttributeName(), this.getConnectedIdentityAttributeStorageName(), this.hasPasswordAttribute(localIdentityProfile, (Entry)modifyEntry));
            }
            catch (NamingException e) {
                LOG.error((Object)("Identity update failed: " + e.getExplanation()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Identity update failed.", (Throwable)e);
                }
                throw new LocalIdentityStorageManager.LocalIdentityStorageManagementException(e, LocalIdentityManagementResult.getByExplanation(localIdentityProfile, e.getExplanation()));
            }
        }
        this.logIdentityNotFoundException(dn);
        throw new LocalIdentityStorageManager.IdentityNotFoundException("Requested identity is not present in the LDAP data store.");
    }

    protected abstract void addCustomLdapControl(LDAPCrudHelper var1, LocalIdentityProfile var2);

    private void logUnknownKeyException(Substituter.UnknownKeyException e) {
        LOG.error((Object)("Filter substitution failed as the authenticated attribute map does not contain the substitution key: " + e.getMessage()));
    }

    private ReadOnlyEntry modifyEntry(LocalIdentityProfile localIdentityProfile, DN dn, LDAPCrudHelper ldapCrudHelper, Attributes attributes) throws NamingException {
        LdapName ldapName = new LdapName(dn.toString());
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        this.removePasswordAttribute(attributes, (LdapDataSource)attributeSource.getDataSource());
        return ldapCrudHelper.modifyEntry(ldapName, attributes, 2);
    }

    private void logIdentityNotFoundException(DN dn) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("[%s] identity is not present in the LDAP data store.", dn.toString()));
        }
    }

    private Filter createSearchIdentityFilter(LocalIdentityProfile localIdentityProfile, String thirdParty, String identityId) {
        Filter uniqueIdFilter = this.createUniqueIdFilter(thirdParty, identityId);
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        String objectClass = dataStoreConfig.getAttributeSource().getParameter("object_class");
        if (StringUtils.isNotBlank((String)objectClass)) {
            Filter objectClassFilter = this.createObjectClassFilter(objectClass);
            return Filter.createANDFilter((Filter[])new Filter[]{uniqueIdFilter, objectClassFilter});
        }
        return uniqueIdFilter;
    }

    private Filter createUniqueIdFilter(String thirdParty, String identityId) {
        String connectedIdentityValue = LocalIdentityUtils.createConnectedIdentityValue(thirdParty, identityId);
        return Filter.createEqualityFilter((String)this.getConnectedIdentityAttributeName(), (String)connectedIdentityValue);
    }

    private Filter createObjectClassFilter(String entryObjectClass) {
        return Filter.createEqualityFilter((String)"objectClass", (String)entryObjectClass);
    }

    private void updateConnectedIdentityValue(String authSourceId, String userId, Attributes modifiedAttributes, AttributeMap attributeMap) {
        String connectedIdentityAttributeName = this.getConnectedIdentityAttributeName();
        AttributeValue connectedIdentityAttributeValue = (AttributeValue)attributeMap.get((Object)connectedIdentityAttributeName);
        if (connectedIdentityAttributeValue != null) {
            String connectedIdentityValue = LocalIdentityUtils.createConnectedIdentityValue(authSourceId, userId);
            if (connectedIdentityAttributeValue.hasValue(connectedIdentityValue)) {
                Collection connectedIdentities = connectedIdentityAttributeValue.getValuesAsCollection();
                connectedIdentities.remove(connectedIdentityValue);
                javax.naming.directory.Attribute modifyingAttr = this.createBasicAttribute(connectedIdentityAttributeName, connectedIdentities);
                modifiedAttributes.put(modifyingAttr);
            } else {
                LOG.debug((Object)"Connected identity information not found.");
            }
        } else {
            LOG.debug((Object)"Connected identity information not found.");
        }
    }

    private void updateConnectedIdentityAttributesValue(LocalIdentityProfile localIdentityProfile, DN dn, String authSourceId, Attributes modifiedAttributes, AttributeMap attributeMap) {
        LocalIdentityAuthSource profile;
        String connectedIdentityAttributeStorageName = this.getConnectedIdentityAttributeStorageName();
        AttributeValue connectedIdentityAttributes = (AttributeValue)attributeMap.get((Object)connectedIdentityAttributeStorageName);
        if (!(connectedIdentityAttributes == null || (profile = localIdentityProfile.getAuthSourceById(authSourceId)) != null && profile.getUpdatePolicy().isRetainAttributes())) {
            BasicAttribute modifyingAttr = new BasicAttribute(connectedIdentityAttributeStorageName);
            for (String attrJson : connectedIdentityAttributes.getValues()) {
                try {
                    AuthSourceAttributes attributes = AuthSourceAttributes.fromJson(attrJson);
                    if (attributes.getAuthSourceId().equals(authSourceId)) continue;
                    modifyingAttr.add(attrJson);
                }
                catch (IOException e) {
                    log.debug((Object)"Unable to remove attributes.", (Throwable)e);
                    log.error((Object)("Unable to remove third-party attribute from '" + authSourceId + "' for user '" + dn.toNormalizedString() + "' due to " + e.getMessage() + ". These will need to be removed manually."));
                }
            }
            modifiedAttributes.put(modifyingAttr);
        }
    }

    private javax.naming.directory.Attribute createBasicAttribute(String name, Collection<String> values) {
        BasicAttribute attr = new BasicAttribute(name);
        for (String connectedIdentity : values) {
            attr.add(connectedIdentity);
        }
        return attr;
    }

    @Override
    protected boolean hasPasswordAttribute(LocalIdentityProfile profile, Entry entry) {
        block5: {
            LdapDataSource dataSource = (LdapDataSource)profile.getDataStoreConfig().getAttributeSource().getDataSource();
            if (dataSource.isPingDirectoryType()) {
                Attribute passwordPolicyStateAttribute = entry.getAttribute("ds-pwp-state-json");
                if (passwordPolicyStateAttribute != null && passwordPolicyStateAttribute.hasValue()) {
                    String passwordPolicyStateJSON = passwordPolicyStateAttribute.getValue();
                    try {
                        JsonNode jsonNode = this.objectMapper.readTree(passwordPolicyStateJSON);
                        if (jsonNode.has("has-static-password")) {
                            return jsonNode.get("has-static-password").asBoolean();
                        }
                        break block5;
                    }
                    catch (JsonProcessingException e) {
                        String msg = "Failed to process the 'ds-pwp-state-json' LDAP attribute.";
                        throw new ProcessRuntimeException(msg, e);
                    }
                }
                String msg = "Failed to retrieve the `ds-pwp-state-json` LDAP virtual attribute. Please enable this attribute in line with PingDirectory security configuration best practices. This attribute is supported in PingDirectory 8.1 and later, customers running older versions are encouraged to upgrade to a supported version as soon as possible.";
                log.warn((Object)msg);
            }
        }
        return super.hasPasswordAttribute(profile, entry);
    }
}

