/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.localidentity.data;

import java.io.Serializable;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import org.apache.commons.lang.StringUtils;
import org.sourceid.localidentity.data.BaseFieldData;
import org.sourceid.localidentity.data.FieldData;

public class StringFieldData
extends BaseFieldData<String>
implements Serializable {
    private String[] values;

    public StringFieldData() {
    }

    public StringFieldData(String name, boolean multiValue, String[] values) {
        super(name, multiValue);
        this.setValues(values);
    }

    @Override
    public FieldData.Type getFieldDataType() {
        return FieldData.Type.STRING;
    }

    @Override
    public String getFirstValue() {
        if (this.values != null && this.values.length > 0) {
            return this.values[0];
        }
        return null;
    }

    public String[] getValues() {
        return this.values != null ? (String[])this.values.clone() : null;
    }

    public void setValues(String[] t) {
        this.values = t != null ? (this.isMultiValue() ? (String[])t.clone() : new String[]{t[0]}) : null;
    }

    @Override
    public Attribute toAttribute(String name) {
        BasicAttribute attribute = new BasicAttribute(name);
        if (this.isMultiValue()) {
            if (this.getValues() != null) {
                for (String s : this.getValues()) {
                    if (!StringUtils.isNotBlank((String)s)) continue;
                    attribute.add(s);
                }
            }
        } else {
            String value = this.getFirstValue();
            if (StringUtils.isNotBlank((String)value)) {
                attribute.add(value);
            }
        }
        return attribute;
    }

    public void stripSpacesFromValues() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = StringUtils.strip((String)this.values[i]);
        }
    }
}

