/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.resilience.FailureThresholdMonitor;
import com.pingidentity.resilience.NoOpFailureMonitor;
import com.pingidentity.resilience.SlidingWindowThresholdMonitor;
import com.pingidentity.resilience.action.impl.AuditLoggingFailureAction;
import comPfAuditLogging.pingidentity.AuditLogConfigs;
import comPfAuditLogging.pingidentity.AuditLogConfigsDocument;
import comPfAuditLogging.pingidentity.AuditLogSettingsType;
import comPfAuditLogging.pingidentity.EmailsToNotifyType;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.mgmt.AuditLoggingManager;
import org.sourceid.saml20.domain.AuditLoggingSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.service.util.NodeIndexRegistry;

public class AuditLoggingManagerImpl
implements AuditLoggingManager,
AutoReloadable {
    public static final String FILENAME = "audit-log-config.xml";
    public static final String NOTIFICATION_PUBLISHER = "notificationPublisher";
    private static final Log log = LogFactory.getLog(AuditLoggingManagerImpl.class);
    private final NodeIndexRegistry nodeIndexRegistry;
    private FailureThresholdMonitor auditLoggingErrorMonitor;
    private AuditLoggingSettings auditLoggingSettings;
    private final XmlLoader xmlLoader;
    private final String dataDirectory;

    public AuditLoggingManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo, NodeIndexRegistry nodeIndexRegistry) {
        this.xmlLoader = xmlLoader;
        this.dataDirectory = sysDirInfo.getDataDirectory();
        this.nodeIndexRegistry = nodeIndexRegistry;
        this.init();
    }

    private void init() {
        this.loadConfig();
        this.auditLoggingErrorMonitor = this.createMonitor();
        this.setSystemProperties();
    }

    private synchronized AuditLogConfigsDocument getAuditLogsConfigsDocument() {
        AuditLogConfigsDocument doc = null;
        if (this.xmlLoader.xmlExists(this.dataDirectory, FILENAME)) {
            try {
                doc = (AuditLogConfigsDocument)this.xmlLoader.load(this.dataDirectory, FILENAME);
            }
            catch (Exception e) {
                log.warn((Object)"Error trying to load file audit-log-config.xml", (Throwable)e);
            }
        } else {
            doc = AuditLogConfigsDocument.Factory.newInstance();
            doc.addNewAuditLogConfigs();
        }
        return doc;
    }

    private void loadConfig() {
        AuditLogConfigsDocument doc = this.getAuditLogsConfigsDocument();
        AuditLogConfigs auditLogConfigs = doc.getAuditLogConfigs();
        AuditLogSettingsType settings = auditLogConfigs.getAuditLogSettings();
        if (settings == null) {
            settings = auditLogConfigs.addNewAuditLogSettings();
        }
        AuditLoggingSettings auditLoggingSettings = new AuditLoggingSettings();
        auditLoggingSettings.setTrackAuditLogFailures(settings.getEnableTracking());
        auditLoggingSettings.setThreshold(settings.getFailureThresholdPercent() == null ? null : Integer.valueOf(settings.getFailureThresholdPercent().intValue()));
        auditLoggingSettings.setInterval(settings.getFailureThresholdPercent() == null ? null : Integer.valueOf(settings.getIntervalInSeconds().intValue()));
        auditLoggingSettings.setFailureMode(AuditLoggingSettings.AuditLoggingFailureMode.fromString(settings.getFailureMode()));
        auditLoggingSettings.setNotificationPublisherId(settings.getNotificationPublisher());
        EmailsToNotifyType emailsToNotify = settings.getEmailsToNotify();
        if (emailsToNotify == null) {
            emailsToNotify = EmailsToNotifyType.Factory.newInstance();
        }
        auditLoggingSettings.setEmailsToNotify(Arrays.asList(emailsToNotify.getEmailArray()));
        this.auditLoggingSettings = auditLoggingSettings;
    }

    private FailureThresholdMonitor createMonitor() {
        if (this.auditLoggingSettings.isTrackAuditLogFailures()) {
            return new SlidingWindowThresholdMonitor(this.getAuditLoggingSettings().getInterval(), this.getAuditLoggingSettings().getThreshold().intValue(), new AuditLoggingFailureAction(this.getAuditLoggingSettings(), this.getIpAddress(), this.getLocalNodeIndex()));
        }
        return new NoOpFailureMonitor();
    }

    private int getLocalNodeIndex() {
        return this.nodeIndexRegistry.getLocalNodeIndex();
    }

    private String getIpAddress() {
        if (ModeSupport.isStandalone()) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.debug((Object)"Unable to determine nodes IP address. Returning default value of localhost.");
                return "localhost";
            }
        }
        return this.nodeIndexRegistry.getLocalNodeAddress().toString();
    }

    @Override
    public FailureThresholdMonitor getAuditLoggingErrorMonitor() {
        return this.auditLoggingErrorMonitor;
    }

    @Override
    public AuditLoggingSettings getAuditLoggingSettings() {
        return this.auditLoggingSettings;
    }

    @Override
    public synchronized void save(AuditLoggingSettings auditLoggingSettings) {
        AuditLogConfigsDocument doc = AuditLogConfigsDocument.Factory.newInstance();
        AuditLogConfigs auditConfigs = doc.addNewAuditLogConfigs();
        AuditLogSettingsType auditSettings = auditConfigs.addNewAuditLogSettings();
        auditSettings.setFailureMode(auditLoggingSettings.getFailureMode().name());
        auditSettings.setEnableTracking(auditLoggingSettings.isTrackAuditLogFailures());
        auditSettings.setIntervalInSeconds(BigInteger.valueOf(auditLoggingSettings.getInterval().intValue()));
        auditSettings.setFailureThresholdPercent(BigInteger.valueOf(auditLoggingSettings.getThreshold().intValue()));
        auditSettings.setNotificationPublisher(auditLoggingSettings.getNotificationPublisherId());
        EmailsToNotifyType emailsToNotifyType = auditSettings.addNewEmailsToNotify();
        emailsToNotifyType.setEmailArray(auditLoggingSettings.getEmailsToNotify().toArray(new String[0]));
        auditSettings.setEmailsToNotify(emailsToNotifyType);
        this.xmlLoader.save(this.dataDirectory, FILENAME, (XmlObject)doc);
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            scope.log(AdminAuditLogger.Component.AUDIT_LOGGING_SETTINGS, AdminAuditLogger.Event.MODIFY, "Audit logging settings updated");
        }
        this.init();
    }

    private void setSystemProperties() {
        log.debug((Object)("Setting audit log failure mode to: " + this.auditLoggingSettings.getFailureMode().name()));
        System.setProperty("pf.log.audit.failure.mode", this.auditLoggingSettings.getFailureMode().name());
    }
}

