/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.mgmt.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.jwk.JwkKeyPair;
import com.pingidentity.crypto.jwk.JwkKeyPairBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.mgmt.JwkDecryptionKeyManager;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.util.json.JsonUtils;

public class JwkDecryptionKeyManagerImpl
implements JwkDecryptionKeyManager,
AutoReloadable {
    private static final Logger logger = LoggerFactory.getLogger(JwkDecryptionKeyManagerImpl.class);
    private static final String DECRYPTION_KEY_FILE = "pfdecryptkeys.jwks";
    private final transient Object encryptionKeyWriteLock = new Object();
    private final SysDirInfo sysDirInfo;

    public JwkDecryptionKeyManagerImpl(SysDirInfo sysDirInfo) {
        this.sysDirInfo = sysDirInfo;
    }

    @Override
    public Optional<List<JwkKeyPair>> getAvailableDecryptionKeys(double rollPeriodDays) {
        Path decryptionKeyPath = this.getDecryptionKeyFilePath();
        if (Files.notExists(decryptionKeyPath, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            byte[] bytes = Files.readAllBytes(decryptionKeyPath);
            if (bytes.length < 1) {
                return Optional.empty();
            }
            Map<String, Object> keysObject = JsonUtils.getInstance().readToMap(new String(bytes, StandardCharsets.UTF_8));
            if (this.checkKeysExpired((Long)keysObject.get("last_modified"), rollPeriodDays)) {
                Files.delete(decryptionKeyPath);
                return Optional.empty();
            }
            try {
                String keys = keysObject.get("keys").toString();
                String deobfuscatedKeys = Obfuscator.deobfuscate(keys);
                JsonWebKeySet oldDecryptionKeySet = new JsonWebKeySet(deobfuscatedKeys);
                if (CollectionUtils.isEmpty((Collection)oldDecryptionKeySet.getJsonWebKeys())) {
                    return Optional.empty();
                }
                List encryptionKeys = oldDecryptionKeySet.getJsonWebKeys().stream().filter(key -> key instanceof PublicJsonWebKey).map(key -> (PublicJsonWebKey)key).map(key -> new JwkKeyPairBuilder(key.getPublicKey(), key.getPrivateKey()).build()).collect(Collectors.toList());
                return Optional.of(encryptionKeys);
            }
            catch (ObfuscationException e) {
                logger.debug("Could not decrypt {}", (Object)DECRYPTION_KEY_FILE);
            }
        }
        catch (IOException e) {
            logger.debug("Failed to read {}", (Object)DECRYPTION_KEY_FILE);
        }
        catch (JoseException e) {
            logger.debug("Failed to parse and read {}", (Object)DECRYPTION_KEY_FILE);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDecryptionKeys(JsonWebKeySet keySet) {
        Object object = this.encryptionKeyWriteLock;
        synchronized (object) {
            try {
                Path decryptionKeyPath = this.getDecryptionKeyFilePath();
                if (CollectionUtils.isNotEmpty((Collection)keySet.getJsonWebKeys())) {
                    if (Files.exists(decryptionKeyPath, new LinkOption[0]) && !Files.isWritable(decryptionKeyPath)) {
                        decryptionKeyPath.toFile().setWritable(true);
                    }
                    HashMap<String, Object> keys = new HashMap<String, Object>();
                    keys.put("last_modified", System.currentTimeMillis());
                    keys.put("keys", Obfuscator.obfuscate(keySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE)));
                    ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();
                    Files.write(decryptionKeyPath, objectMapper.writeValueAsString(keys).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    decryptionKeyPath.toFile().setExecutable(false, false);
                    decryptionKeyPath.toFile().setReadable(false, false);
                    decryptionKeyPath.toFile().setReadable(true);
                }
            }
            catch (JsonProcessingException e) {
                logger.error("Error creating JSON string", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Error writing the encryption keys", (Throwable)e);
            }
        }
    }

    private Path getDecryptionKeyFilePath() {
        return FileSystems.getDefault().getPath(this.sysDirInfo.getInstanceDataDirectory(), DECRYPTION_KEY_FILE);
    }

    private boolean checkKeysExpired(Long lastModified, double rollPeriodDays) {
        DateTime difference = DateTime.now().minus(lastModified.longValue());
        double rollPeriodMillsD = rollPeriodDays * 24.0 * 60.0 * 60.0 * 1000.0;
        return (double)difference.getMillis() > 2.0 * rollPeriodMillsD;
    }
}

