/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.authorizationdetails.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.impl.JaxbXmlLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import org.sourceid.common.IDGenerator;
import org.sourceid.oauth20.authorizationdetails.AuthorizationDetailTypesManager;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailType;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.xml.sax.SAXException;

public class AuthorizationDetailTypesManagerImpl
implements AuthorizationDetailTypesManager,
AutoReloadable {
    private static final String AUTHORIZATION_DETAIL_TYPES_FILE = "authorization-detail-types.xml";
    private final Map<String, AuthorizationDetailType> authorizationDetailTypesById = new HashMap<String, AuthorizationDetailType>();
    private final Map<String, AuthorizationDetailType> authorizationDetailTypesByType = new HashMap<String, AuthorizationDetailType>();

    public AuthorizationDetailTypesManagerImpl() {
        this.loadConfig();
    }

    @Override
    public synchronized Collection<AuthorizationDetailType> getAllAuthorizationDetailTypes() {
        return new ArrayList<AuthorizationDetailType>(this.authorizationDetailTypesById.values());
    }

    @Override
    public synchronized Set<String> getTypes() {
        return this.authorizationDetailTypesByType.keySet();
    }

    @Override
    public synchronized Set<String> getIds() {
        return this.authorizationDetailTypesById.keySet();
    }

    @Override
    public synchronized AuthorizationDetailType getAuthorizationDetailTypeById(String id) {
        return this.authorizationDetailTypesById.get(id);
    }

    @Override
    public synchronized AuthorizationDetailType getAuthorizationDetailTypeByType(String authorizationDetailType) {
        return this.authorizationDetailTypesByType.get(authorizationDetailType);
    }

    @Override
    public synchronized AuthorizationDetailType save(AuthorizationDetailType authorizationDetailType) {
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            AuthorizationDetailType existingType;
            if (authorizationDetailType.getId() == null) {
                authorizationDetailType.setId(this.generateId());
            }
            AdminAuditLogger.Event saveEvent = (existingType = this.authorizationDetailTypesById.get(authorizationDetailType.getId())) != null ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.CREATE;
            this.authorizationDetailTypesById.put(authorizationDetailType.getId(), authorizationDetailType);
            if (existingType != null) {
                this.authorizationDetailTypesByType.remove(existingType.getType());
            }
            this.authorizationDetailTypesByType.put(authorizationDetailType.getType(), authorizationDetailType);
            this.saveConfiguration();
            scope.log(AdminAuditLogger.Component.OAUTH_AUTHORIZATION_DETAIL_TYPE, saveEvent, authorizationDetailType.getId());
        }
        return this.authorizationDetailTypesById.get(authorizationDetailType.getId());
    }

    private String generateId() {
        String id;
        while (this.authorizationDetailTypesById.containsKey(id = IDGenerator.rndAlphaNumeric(22))) {
        }
        return id;
    }

    @Override
    public synchronized void delete(String id) {
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            AuthorizationDetailType removed = this.authorizationDetailTypesById.remove(id);
            if (removed != null) {
                this.authorizationDetailTypesByType.remove(removed.getType());
                this.saveConfiguration();
                scope.log(AdminAuditLogger.Component.OAUTH_AUTHORIZATION_DETAIL_TYPE, AdminAuditLogger.Event.DELETE, id);
            }
        }
    }

    private void saveConfiguration() {
        AuthorizationDetailTypesConfiguration configuration = new AuthorizationDetailTypesConfiguration();
        configuration.setAuthorizationDetailTypes(this.authorizationDetailTypesById.values());
        try {
            JaxbXmlLoader<AuthorizationDetailTypesConfiguration> loader = new JaxbXmlLoader<AuthorizationDetailTypesConfiguration>(AuthorizationDetailTypesConfiguration.class);
            loader.save(MgmtFactory.getSysDirInfo().getDataDirectory(), AUTHORIZATION_DETAIL_TYPES_FILE, configuration);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unexpected error serializing config to file", e);
        }
        MgmtFactory.getSingleThreadedExecutor().execute(() -> MgmtFactory.getClientManager().reload());
    }

    private void loadConfig() {
        File file = new File(this.getStorageFileName());
        if (file.exists()) {
            JaxbXmlLoader<AuthorizationDetailTypesConfiguration> loader = new JaxbXmlLoader<AuthorizationDetailTypesConfiguration>(AuthorizationDetailTypesConfiguration.class);
            try {
                AuthorizationDetailTypesConfiguration config = loader.load(MgmtFactory.getSysDirInfo().getDataDirectory(), AUTHORIZATION_DETAIL_TYPES_FILE);
                this.authorizationDetailTypesById.clear();
                this.authorizationDetailTypesByType.clear();
                config.getAuthorizationDetailTypes().forEach(mapping -> {
                    this.authorizationDetailTypesById.put(mapping.getId(), (AuthorizationDetailType)mapping);
                    this.authorizationDetailTypesByType.put(mapping.getType(), (AuthorizationDetailType)mapping);
                });
            }
            catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Unexpected error deserializing config from file", e);
            }
        }
    }

    private String getStorageFileName() {
        String dataDirectory = MgmtFactory.getSysDirInfo().getDataDirectory();
        return dataDirectory + File.separator + AUTHORIZATION_DETAIL_TYPES_FILE;
    }

    @XmlRootElement
    public static class AuthorizationDetailTypesConfiguration {
        private Collection<AuthorizationDetailType> authorizationDetailTypes = new ArrayList<AuthorizationDetailType>();

        public Collection<AuthorizationDetailType> getAuthorizationDetailTypes() {
            return this.authorizationDetailTypes;
        }

        public void setAuthorizationDetailTypes(Collection<AuthorizationDetailType> authorizationDetailTypes) {
            this.authorizationDetailTypes = authorizationDetailTypes;
        }
    }
}

