/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.common.util.Base64URL;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.model.User;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import com.pingidentity.sdk.api.authn.model.state.Completed;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.bindings.OauthBindingGroup;
import org.sourceid.oauth20.bindings.StoredMessage;
import org.sourceid.oauth20.client.ClientAuthSupport;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientVerificationKeyResolver;
import org.sourceid.oauth20.domain.NbfTooLongAgoValidator;
import org.sourceid.oauth20.handlers.AttributesHolder;
import org.sourceid.oauth20.handlers.AuthenticationClaimHolder;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.issuer.OAuthAudienceUtils;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.HttpRequestUtil;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.oauth20.service.OAuthJwtTokenService;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.oauth20.utils.JwtProcessingUtils;
import org.sourceid.oauth20.utils.ResourceIndicatorsUtils;
import org.sourceid.openid.connect.MultiDecryptionKeyResolver;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.util.OIDCUtil;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.RelayStateSupport;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.ArtifactPersistenceServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.json.JsonUtils;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.bindings.FormPost;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.servlet.reqparam.InvalidResourceParameterException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class AuthorizationEndpointBinding
implements Binding {
    private static final Log log = LogFactory.getLog(AuthorizationEndpointBinding.class);
    public static final String OAUTH_AUTHZ = "oauth:authz";
    public static final AuthorizationRequestException CLIENT_ID_REQUIRED = new AuthorizationRequestException(null, Parameters.CLIENT_ID + " is required");
    public static final AuthorizationRequestException CLIENT_ID_INVALID = new AuthorizationRequestException(null, "Invalid " + Parameters.CLIENT_ID);
    public static final AlgorithmConstraints JWE_ALGORITHM_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.BLOCK, new String[]{"RSA1_5", "PBES2-HS256+A128KW", "PBES2-HS384+A192KW", "PBES2-HS512+A256KW"});
    private final ArtifactPersistenceService persistenceSvc;
    private final AuthzServerManager authzServerMgr;
    private final MetadataLocal metadataLocal;
    private final OAuthIssuerUtils oAuthIssuerUtils;
    private final OAuthAudienceUtils oAuthAudienceUtils;
    private final OAuthJwtTokenService oAuthJwtTokenService;
    private final ClientManager clientManager;
    private final RelayStateSupport relayStateSupport;
    private final ConfigStore sanitizeConfigStore = ConfigStoreFarm.getConfig("sanitize-fragments");
    private final ConfigStore requestObjectOptions = ConfigStoreFarm.getConfig("jwt-request-object-options");
    NbfTooLongAgoValidator nbfTooLongAgoValidator = new NbfTooLongAgoValidator(this.requestObjectOptions.getIntValue("maxPastValidityInMinutes", -1));
    private static final String MAX_AGE_ERROR = "The value of the max_age parameter must be greater than or equal to 0.";
    private static final String INVALID_REQ_URI_MESSAGE = "request_uri is invalid or expired.";
    private static final String AUTHORIZATION_DETAILS_ERROR = "The authorization_details JWT claim cannot be processed as valid JSON.";
    private static final Set<String> MAIN_PARAMETER_NAMES = Stream.of("response_type", "response_mode", "redirect_uri", Parameters.SCOPE, "access_token_manager_id", "nonce", "prompt", "acr_values", "ui_locales", "login_hint", "claims_locales", "state", "code_challenge_method", "code_challenge", "dpop_jkt").collect(Collectors.toSet());
    private static final Set<String> OTHER_PARAMETER_NAMES = Stream.of("id_token_hint", "max_age", "request", "request_uri", Parameters.CLIENT_ID, Parameters.CLIENT_SECRET, "client_assertion", "client_assertion_type", "aud", "resource", "authorization_details").collect(Collectors.toSet());
    private static final Set<String> EXCLUDED_EXTRA_PAR_PARAMETER_NAMES = Stream.of(MAIN_PARAMETER_NAMES, OTHER_PARAMETER_NAMES).flatMap(Collection::stream).collect(Collectors.toSet());

    public AuthorizationEndpointBinding() {
        this(StateMgmtFactory.getArtifactPersistenceService(), MgmtFactory.getAuthzServerManager(), MetaDataFactory.getLocalMetaData(), OAuthIssuerUtils.getInstance(), OAuthAudienceUtils.getInstance(), MgmtFactory.getOAuthJwtTokenService(), MgmtFactory.getClientManager());
    }

    public AuthorizationEndpointBinding(ArtifactPersistenceService persistenceSvc, AuthzServerManager authzServerMgr, MetadataLocal metadataLocal, OAuthIssuerUtils oAuthIssuerUtils, OAuthAudienceUtils oAuthAudienceUtils, OAuthJwtTokenService oAuthJwtTokenService, ClientManager clientManager) {
        this.persistenceSvc = persistenceSvc;
        this.authzServerMgr = authzServerMgr;
        this.metadataLocal = metadataLocal;
        this.oAuthIssuerUtils = oAuthIssuerUtils;
        this.oAuthAudienceUtils = oAuthAudienceUtils;
        this.oAuthJwtTokenService = oAuthJwtTokenService;
        this.clientManager = clientManager;
        this.relayStateSupport = new RelayStateSupport();
    }

    private AlgorithmConstraints getSigRequiredConstraints(Client client) {
        String[] algsArray;
        if (StringUtils.isNotBlank((String)client.getRequestObjectSigningAlgorithm())) {
            algsArray = new String[]{client.getRequestObjectSigningAlgorithm()};
        } else {
            List<String> algs = OpenIdConnectProviderInfo.getVerificationAlgorithmsSupported();
            if (!client.isRequireSignedRequests()) {
                algs.add("none");
            }
            algsArray = algs.toArray(new String[0]);
        }
        return new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, algsArray);
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException {
        IdpConnection idpConnection = MetadataSupport.getIdpConnection(msgCtx.getEntityId());
        OIDCSettings settings = idpConnection.getOidcSettings();
        this.checkActive(idpConnection);
        Map<String, Object> requestParams = this.getRequestParameters(req, resp, msgCtx, settings);
        resp.sendRedirect(Util.appendQueryParams(msgCtx.getEndpoint(), requestParams));
        return null;
    }

    public Map<String, Object> getRequestParameters(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx, OIDCSettings settings) throws BindingException {
        Map<String, Object> requestParams;
        if (!msgCtx.isBackChannelBinding() || StringUtils.isEmpty((String)msgCtx.getParam("state"))) {
            RelayStateSupport relayStateSupport = new RelayStateSupport();
            relayStateSupport.associate(msgCtx, req, resp, true);
            msgCtx.setParam("state", msgCtx.getRelayState());
        }
        SessionStateSupport sessionStateSupport = new SessionStateSupport();
        String key = OIDCUtil.getNonceSessionKey(msgCtx.getRelayState());
        sessionStateSupport.setAttribute(key, (Object)msgCtx.getParam("nonce"), req, resp, true);
        if (StringUtils.isNotBlank((String)settings.getRequestSigningAlgorithm())) {
            Map<String, Object> params = msgCtx.getParams();
            requestParams = new HashMap<String, Object>();
            requestParams.put(Parameters.CLIENT_ID, params.get(Parameters.CLIENT_ID));
            requestParams.put("response_type", params.get("response_type"));
            requestParams.put(Parameters.SCOPE, params.get(Parameters.SCOPE));
            requestParams.put("request", this.createRequestParam(params, settings, msgCtx.getEntityId()));
            requestParams.put("redirect_uri", msgCtx.getParam("redirect_uri"));
        } else {
            requestParams = msgCtx.getParams();
        }
        return requestParams;
    }

    @Override
    public void transportResponse(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException {
        String issuer = this.oAuthIssuerUtils.getIssuerValue(req);
        String sri = (String)msgCtx.getSupplementalContext("pi.sri");
        ResponseType responseType = this.processMessageContext(msgCtx, sri, issuer, req);
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            this.writeAuthnApiResponse(req, resp, msgCtx);
        } else if (responseType.getResponseMode() == ResponseType.ResponseMode.form_post || responseType.getResponseMode() == ResponseType.ResponseMode.form_post_jwt) {
            FormPost.post(msgCtx.getEndpoint(), msgCtx.getParams(), req, resp);
        } else {
            resp.sendRedirect(msgCtx.getEndpoint());
        }
    }

    private void writeAuthnApiResponse(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException {
        if (msgCtx.getParam("error") != null) {
            AuthenticationFailed model = new AuthenticationFailed();
            model.setCode(msgCtx.getParam("error"));
            model.setMessage(msgCtx.getParam("error_description"));
            model.setUserMessage(msgCtx.getParam("error_description"));
            model.setTrackingId(TrackingIdSupport.getTrackingId());
            AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, CommonStateSpec.FAILED.makeInstance(req, (Object)model));
        } else {
            Completed model = new Completed();
            model.setAuthorizeResponse(new HashMap());
            for (Map.Entry<String, Object> entry : msgCtx.getParams().entrySet()) {
                model.getAuthorizeResponse().put(entry.getKey(), entry.getValue().toString());
            }
            AttributesHolder holder = msgCtx.getSupplementalContext("attrs", AttributesHolder.class);
            if (holder != null && holder.getUserKeyAttributes() != null && MgmtFactory.getAuthnApiManager().isIncludeUserInfoInResponses()) {
                User user = new User();
                user.setUsername(holder.getUserKeyAttributes().getUserNameValue());
                user.setId(holder.getUserKeyAttributes().getUserKeyValue());
                model.setUser(user);
            }
            AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, CommonStateSpec.COMPLETED.makeInstance(req, (Object)model));
        }
    }

    ResponseType processMessageContext(OutMessageContext msgCtx, String sri, String issuer, HttpServletRequest request) throws BindingException {
        Object redirectUri;
        ResponseType.ResponseMode responseMode;
        String responseModeString;
        String responseTypeString;
        ResponseType respType;
        String state = msgCtx.getRelayState();
        if (state != null) {
            msgCtx.setParam("state", state);
        }
        if ((respType = new ResponseType(responseTypeString = msgCtx.getSupplementalContext("response_type", String.class), responseModeString = msgCtx.getSupplementalContext("response_mode", String.class))).has("code") && msgCtx.getParam("error") == null) {
            String userKey = msgCtx.getSupplementalContext("UK", String.class);
            String scope = (String)msgCtx.getSupplementalContext(Parameters.SCOPE);
            String authorizationDetails = (String)msgCtx.getSupplementalContext("authorization_details");
            Boolean returnScopeBigB = msgCtx.getSupplementalContext("return-scope", Boolean.class);
            boolean returnScope = returnScopeBigB != null ? returnScopeBigB : false;
            String redirectUri2 = msgCtx.getSupplementalContext("redirect_uri", String.class);
            String ctxQualifier = msgCtx.getSupplementalContext("ctxQ", String.class);
            String clientId = msgCtx.getEntityId();
            String idToken = msgCtx.getSupplementalContext("id_token", String.class);
            String idTokenJti = msgCtx.getSupplementalContext("id_token_jti", String.class);
            AuthenticationClaimHolder authenticationClaimHolder = msgCtx.getSupplementalContext("AUTHENTICATION_CLAIMS", AuthenticationClaimHolder.class);
            String codeChallenge = msgCtx.getSupplementalContext("code_challenge", String.class);
            String codeChallengeMethod = msgCtx.getSupplementalContext("code_challenge_method", String.class);
            String requestedTokenManagerId = msgCtx.getSupplementalContext("access_token_manager_id", String.class);
            String audience = msgCtx.getSupplementalContext("aud", String.class);
            Set resources = msgCtx.getSupplementalContext("resource", Set.class);
            String dpopJkt = msgCtx.getSupplementalContext("dpop_jkt", String.class);
            AccessGrantAttributesHolder grantAttrsHolder = (AccessGrantAttributesHolder)msgCtx.getSupplementalContext("access-grant-attrs");
            StoredMessage msg = new StoredMessage(clientId, userKey, scope, ctxQualifier, redirectUri2, idToken, idTokenJti, returnScope, codeChallenge, codeChallengeMethod, requestedTokenManagerId, audience, resources, grantAttrsHolder, sri, authenticationClaimHolder, respType, authorizationDetails, dpopJkt);
            ArtifactPersistenceService.Message message = new ArtifactPersistenceService.Message(msg);
            String code = msgCtx.getParam("code");
            if (code == null) {
                code = this.createCode(msgCtx);
            }
            byte[] bytes = Base64URL.decode((String)code);
            message.setHandle(bytes);
            try {
                int timeoutSeconds = this.authzServerMgr.getAuthzCodeTimeout();
                this.persistenceSvc.saveArtifact(message, timeoutSeconds);
            }
            catch (ArtifactPersistenceServiceException e) {
                throw new BindingException(e);
            }
            AsAuditLogger.setOutMsgCtx(msgCtx);
            AsAuditLogger.log("User Granted Authorization");
        }
        if (this.authzServerMgr.isIncludeIssuerInAuthzResponse() && issuer != null) {
            msgCtx.setParam("iss", issuer);
        }
        ResponseType.ResponseMode responseMode2 = responseMode = (responseMode = respType.getResponseMode()) == null ? ResponseType.ResponseMode.query : responseMode;
        if (ResponseType.ResponseMode.isJarmType(responseMode.getIdentifier())) {
            this.handleJarmResponse(request, msgCtx, respType, responseMode, issuer);
        } else if (responseMode == ResponseType.ResponseMode.query) {
            this.createQueryBaseResponse(msgCtx);
        } else if (responseMode == ResponseType.ResponseMode.fragment) {
            this.createFragmentBaseResponse(msgCtx);
        }
        if (msgCtx.getParam("error") != null && (redirectUri = msgCtx.getEndpoint()) != null && ((String)redirectUri).indexOf(35) == -1) {
            String placeholder = this.sanitizeConfigStore.getStringValue("FragmentPlaceholder", ".");
            redirectUri = (String)redirectUri + "#" + placeholder;
            msgCtx.setEndpoint((String)redirectUri);
        }
        return respType;
    }

    public String createCode(OutMessageContext msgCtx) {
        int length = this.authzServerMgr.getAuthzCodeLength();
        byte[] codeBytes = this.persistenceSvc.precomputeHandle(length);
        String code = Base64URL.encodeToString((byte[])codeBytes);
        msgCtx.setParam("code", code, true);
        AsAuditLogger.setOutAuthorizationCodeHash(code);
        return code;
    }

    @Override
    public InMessageContext receive(HttpServletRequest req, HttpServletResponse resp, Role partnerRole) throws HttpStatusCodeException, BindingException, IOException {
        try {
            return this.doReceive(req);
        }
        catch (MalformedClaimException e) {
            this.logFailure((Exception)((Object)e));
            throw new HttpStatusCodeException("The request object has a malformed claim - " + e.getMessage(), 400);
        }
        catch (AuthorizationRequestException e) {
            this.logFailure(e);
            throw new HttpStatusCodeException(e.getMessage(), 400);
        }
        catch (HttpStatusCodeException e) {
            this.logFailure(e);
            throw e;
        }
    }

    void processInbound(HttpServletRequest req, InMessageContext context, Client client) throws MalformedClaimException, AuthorizationRequestException {
        String requestObj = req.getParameter("request");
        String requestUri = req.getParameter("request_uri");
        ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_ID.toString(), (String)client.getClientId());
        if (client.isRequireSignedRequests() && StringUtils.isBlank((String)requestObj) && StringUtils.isBlank((String)requestUri)) {
            String msg = "Signed request is required";
            log.debug((Object)msg);
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, msg);
        }
        JwtClaims authzRequstParameterJwtClaims = null;
        if (StringUtils.isNotBlank((String)requestObj) && StringUtils.isNotBlank((String)requestUri)) {
            String msg = "request and request_uri parameters cannot be used together - http://openid.net/specs/openid-connect-core-1_0.html#JWTRequests";
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, msg);
        }
        if (this.isRequestObjectProcessable(client, requestObj)) {
            authzRequstParameterJwtClaims = this.getRequestJwtClaims(client, requestObj, req, context);
        }
        if (StringUtils.isNotBlank((String)requestUri)) {
            int expectedReferenceLength;
            if (!StringUtils.startsWith((String)requestUri, (String)"urn:ietf:params:oauth:request_uri:")) {
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request_uri, INVALID_REQ_URI_MESSAGE);
            }
            String encodedHandle = requestUri.substring("urn:ietf:params:oauth:request_uri:".length());
            byte[] handle = Base64URL.decode((String)encodedHandle);
            if (handle.length != (expectedReferenceLength = this.authzServerMgr.getParServerPolicy().getReferenceLength().intValue())) {
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request_uri, INVALID_REQ_URI_MESSAGE);
            }
            try {
                ArtifactPersistenceService.Message message = this.persistenceSvc.retrieveAndRemoveArtifact(handle);
                if (message == null) {
                    throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request_uri, INVALID_REQ_URI_MESSAGE);
                }
                if (!StringUtils.equals((String)message.getEntityId(), (String)client.getClientId())) {
                    throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request_uri, "Client mismatch");
                }
                HashMap requestParams = (HashMap)message.getMsg();
                context.setParams(requestParams);
                requestParams = new HashMap(requestParams);
                context.setParam("request", requestParams);
            }
            catch (ArtifactPersistenceServiceException e) {
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.server_error, "Unable to retrieve pushed authorization request", e);
            }
        } else {
            for (String name : MAIN_PARAMETER_NAMES) {
                this.getSetStringParam(req, authzRequstParameterJwtClaims, name, context);
            }
            if (this.requestObjectOptions.getBooleanValue("process-pkce-params-outside-request-object", false)) {
                String requestObjectCodeChallenge = context.getParam("code_challenge");
                if (StringUtils.isEmpty((String)requestObjectCodeChallenge)) {
                    this.getRequestParamSetStringParam(req, "code_challenge_method", context);
                }
                this.getRequestParamSetStringParam(req, "code_challenge", context);
            }
            this.getSetStringParam(req, null, "aud", context);
            this.getSetResources(req, context, authzRequstParameterJwtClaims);
            this.validateRequestedAtm(context, client);
            this.getIdTokenHintSetHintSubject(req, context, authzRequstParameterJwtClaims);
            this.getSetMaxAge(req, context, authzRequstParameterJwtClaims);
            this.getSetAuthorizationDetails(req, context, authzRequstParameterJwtClaims);
            if (context.isBackChannelBinding()) {
                this.additionalParamsForPar(req, context, authzRequstParameterJwtClaims);
            }
            if (authzRequstParameterJwtClaims != null && !context.isBackChannelBinding()) {
                context.setParam("request", authzRequstParameterJwtClaims.getClaimsMap());
            }
            if (authzRequstParameterJwtClaims != null && authzRequstParameterJwtClaims.getJwtId() != null) {
                AuditLogger.setRequestJti(authzRequstParameterJwtClaims.getJwtId());
            }
        }
        this.oAuthIssuerUtils.setMessageContextOAuthIssuerIfApplicable(req, context);
        String state = context.getParam("state");
        context.setRelayState(state);
        if (StringUtils.isNotBlank((String)context.getParam("login_hint"))) {
            context.setRequestedUserId(context.getParam("login_hint"));
        }
        if (!context.isBackChannelBinding()) {
            context.getParams().remove("state");
        }
    }

    private void additionalParamsForPar(HttpServletRequest req, InMessageContext context, JwtClaims authzRequstParameterJwtClaims) {
        if (authzRequstParameterJwtClaims != null) {
            for (String name : authzRequstParameterJwtClaims.getClaimNames()) {
                if (EXCLUDED_EXTRA_PAR_PARAMETER_NAMES.contains(name)) continue;
                Object claimValue = authzRequstParameterJwtClaims.getClaimValue(name);
                context.setParam(name, claimValue);
            }
        } else {
            for (String name : req.getParameterMap().keySet()) {
                if (EXCLUDED_EXTRA_PAR_PARAMETER_NAMES.contains(name)) continue;
                String[] values = req.getParameterValues(name);
                if (values.length == 1) {
                    context.setParam(name, values[0]);
                    continue;
                }
                if (values.length <= 1) continue;
                context.setParam(name, Arrays.asList(values));
            }
        }
    }

    private InMessageContext doReceive(HttpServletRequest req) throws HttpStatusCodeException, MalformedClaimException, IOException, AuthorizationRequestException {
        OauthBindingGroup.checkLicense();
        InMessageContext context = new InMessageContext();
        context.setIsRequest(true);
        this.checkFlagAsApiRequest(req, req.getParameter("response_mode"));
        String clientId = OauthBindingGroup.getClientIdSetEntityId(req, context);
        if (StringUtils.isBlank((String)clientId)) {
            context.setDeferredException(CLIENT_ID_REQUIRED);
            return context;
        }
        AsAuditLogger.setPartnerId(clientId);
        Client client = this.clientManager.getCachedClient(clientId);
        if (client == null) {
            context.setDeferredException(CLIENT_ID_INVALID);
            return context;
        }
        this.processInbound(req, context, client);
        this.checkFlagAsApiRequest(req, context.getParam("response_mode"));
        return context;
    }

    private void checkFlagAsApiRequest(HttpServletRequest req, String responseMode) {
        if (StringUtils.equals((String)responseMode, (String)ResponseType.ResponseMode.pi_flow.getIdentifier())) {
            AuthnApiSupport.getDefault().setApiRequest(req);
            InternalAuthnApiSupport.getDefault().setRequestBodyConsumed(req);
        }
    }

    private void getIdTokenHintSetHintSubject(HttpServletRequest req, InMessageContext context, JwtClaims claims) throws MalformedClaimException, AuthorizationRequestException {
        String idTokenHint = this.getStringParameterValue(req, claims, "id_token_hint");
        if (StringUtils.isNotBlank((String)idTokenHint)) {
            try {
                JwtConsumer idTokenHintConsumer = new JwtConsumerBuilder().setSkipAllValidators().setSkipSignatureVerification().build();
                JwtClaims idTokenHintClaims = idTokenHintConsumer.processToClaims(idTokenHint);
                String idTokenHintSubject = idTokenHintClaims.getSubject();
                context.setParam("id_token_hint", idTokenHintSubject);
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                String msg = "The id_token_hint parameter is invalid";
                log.debug((Object)(msg + " " + e.getMessage()));
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, msg);
            }
        }
    }

    private JwtClaims getRequestJwtClaims(Client client, String requestObj, HttpServletRequest req, InMessageContext inMsgCtx) throws AuthorizationRequestException {
        JwtClaims claims;
        List<String> otherRequiredClaims;
        HashSet<String> issuers = new HashSet<String>();
        issuers.add(this.metadataLocal.getBaseUrl());
        issuers.addAll(this.oAuthAudienceUtils.getAudienceValues(req));
        if (client == null || !client.isEnabled()) {
            if (client != null && !client.isEnabled()) {
                log.debug((Object)("Client " + client.getClientId() + " is disabled"));
            }
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "Unknown or invalid " + Parameters.CLIENT_ID);
        }
        ClientVerificationKeyResolver verificationKeyResolver = new ClientVerificationKeyResolver(client, false);
        MultiDecryptionKeyResolver decryptionKeyResolver = new MultiDecryptionKeyResolver(client.getSecretAsUtf8Bytes());
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setExpectedIssuer(false, client.getClientId()).registerValidator(jwtContext -> {
            JwtClaims jwtClaims = jwtContext.getJwtClaims();
            String clientIdClaimValue = jwtClaims.getStringClaimValue(Parameters.CLIENT_ID);
            if (clientIdClaimValue == null) {
                if (this.requestObjectOptions.getBooleanValue("require-client_id", false)) {
                    return "no client_id claim";
                }
            } else if (!clientIdClaimValue.equals(client.getClientId())) {
                return "The value of the client_id claim does not match the the client identified outside the request object.";
            }
            return null;
        }).setExpectedAudience(this.requestObjectOptions.getBooleanValue("require-aud", false), issuers.toArray(new String[0])).setJwsAlgorithmConstraints(this.getSigRequiredConstraints(client)).setDisableRequireSignature().setAllowedClockSkewInSeconds(60).setMaxFutureValidityInMinutes(this.requestObjectOptions.getIntValue("maxFutureValidityInMinutes", 720)).registerValidator((ErrorCodeValidator)this.nbfTooLongAgoValidator).setSkipVerificationKeyResolutionOnNone().setDecryptionKeyResolver((DecryptionKeyResolver)decryptionKeyResolver).setJweAlgorithmConstraints(JWE_ALGORITHM_CONSTRAINTS).setVerificationKeyResolver((VerificationKeyResolver)verificationKeyResolver);
        if (!inMsgCtx.isBackChannelBinding() && this.requestObjectOptions.getBooleanValue("front-channel-encryption-required", false)) {
            jwtConsumerBuilder.setEnableRequireEncryption();
        }
        if (this.requestObjectOptions.getBooleanValue("require-exp", false)) {
            jwtConsumerBuilder.setRequireExpirationTime();
        }
        if (this.requestObjectOptions.getBooleanValue("require-nbf", false)) {
            jwtConsumerBuilder.setRequireNotBefore();
        }
        if (!(otherRequiredClaims = this.requestObjectOptions.getListValue("other-required-claims", Collections.emptyList())).isEmpty()) {
            jwtConsumerBuilder.registerValidator(jwtContext -> {
                JwtClaims jwtClaims = jwtContext.getJwtClaims();
                for (String name : otherRequiredClaims) {
                    if (jwtClaims.hasClaim(name)) continue;
                    return "JWT request object is missing the " + name + " claim, which is required per configuration in jwt-request-object-options.xml";
                }
                return null;
            });
        }
        try {
            claims = JwtProcessingUtils.processEncryptedJwt(requestObj, jwtConsumerBuilder, client, ClientSecretUtils.ActivityType.REQUEST_OBJ_DECRYPTION);
            if (claims == null) {
                String msg = "Unable to successfully process the JWT request object";
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request_object, msg);
            }
        }
        catch (InvalidJwtException e) {
            log.error((Object)e);
            String msg = "Unable to successfully process the JWT request object";
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request_object, msg);
        }
        if (claims.getClaimValue("request") != null || claims.getClaimValue("request_uri") != null) {
            String msg = "request and request_uri parameters MUST NOT be included in Request Objects.";
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request_object, msg);
        }
        return claims;
    }

    private void getSetMaxAge(HttpServletRequest req, InMessageContext context, JwtClaims claims) throws AuthorizationRequestException {
        try {
            Integer maxAge = null;
            if (claims != null) {
                Number maxAgeClaim = (Number)claims.getClaimValue("max_age", Number.class);
                if (maxAgeClaim != null) {
                    maxAge = maxAgeClaim.intValue();
                }
            } else {
                String maxAgeParam = req.getParameter("max_age");
                if (StringUtils.isNotBlank((String)maxAgeParam)) {
                    maxAge = Integer.parseInt(maxAgeParam);
                }
            }
            if (maxAge != null) {
                if (maxAge < 0) {
                    throw new NumberFormatException();
                }
                context.setParam("max_age", maxAge);
            }
        }
        catch (NumberFormatException | MalformedClaimException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, MAX_AGE_ERROR);
        }
    }

    private void getSetAuthorizationDetails(HttpServletRequest req, InMessageContext context, JwtClaims claims) throws AuthorizationRequestException {
        String claimValue = null;
        if (claims == null) {
            String authorizationDetailsParam = req.getParameter("authorization_details");
            if (StringUtils.isNotBlank((String)authorizationDetailsParam)) {
                claimValue = authorizationDetailsParam;
            }
        } else {
            Object authorizationDetailsClaim = claims.getClaimValue("authorization_details");
            if (authorizationDetailsClaim != null) {
                try {
                    claimValue = JsonUtils.getInstance().writeValueAsString(authorizationDetailsClaim);
                }
                catch (JsonProcessingException e) {
                    throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_authorization_details, AUTHORIZATION_DETAILS_ERROR);
                }
            }
        }
        if (claimValue != null) {
            context.setParam("authorization_details", claimValue);
        }
    }

    private void getSetResources(HttpServletRequest req, InMessageContext context, JwtClaims claims) throws AuthorizationRequestException {
        Set<String> resources = ResourceIndicatorsUtils.getResourceParams(req, claims);
        try {
            ResourceIndicatorsUtils.validateResources(resources);
        }
        catch (RequestProcessingException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_target, e.getMessage(), e);
        }
        context.setParam("resource", resources);
    }

    private void validateRequestedAtm(InMessageContext context, Client client) throws AuthorizationRequestException {
        TokenManagerSelector selector = new TokenManagerSelector();
        try {
            selector.selectTokenManagerId(null, context.getParam("access_token_manager_id"), context.getParam("aud"), context.getParam("resource", Set.class), Scope.getScope((String)context.getParam(Parameters.SCOPE)), client);
        }
        catch (InvalidResourceParameterException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_target, e.getMessage(), e);
        }
        catch (InvalidRequestParameterException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, e.getMessage(), e);
        }
    }

    private String getStringParameterValue(HttpServletRequest req, JwtClaims jwt, String name) throws MalformedClaimException {
        return jwt != null ? jwt.getStringClaimValue(name) : HttpRequestUtil.getParameter(req, name);
    }

    private void getSetStringParam(HttpServletRequest req, JwtClaims jwt, String name, InMessageContext inMsgCtx) throws MalformedClaimException {
        String parameterValue = this.getStringParameterValue(req, jwt, name);
        if (parameterValue != null) {
            inMsgCtx.setParam(name, parameterValue);
        }
    }

    private void getRequestParamSetStringParam(HttpServletRequest req, String name, InMessageContext inMsgCtx) {
        String parameterValue;
        if (StringUtils.isEmpty((String)inMsgCtx.getParam(name)) && StringUtils.isNotEmpty((String)(parameterValue = HttpRequestUtil.getParameter(req, name)))) {
            inMsgCtx.setParam(name, parameterValue);
        }
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException {
        throw new ServletException("Unexpected problem: " + e.getMessage(), (Throwable)e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public String getUri() {
        return OAUTH_AUTHZ;
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }

    public void checkActive(ConnectionBase baseConnectionMetadata) throws BindingException {
        if (!baseConnectionMetadata.isActive()) {
            throw new BindingException(baseConnectionMetadata.getEncodedEntityId() + " is not active.");
        }
    }

    private String createRequestParam(Map<String, Object> params, OIDCSettings settings, String aud) {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setAudience(aud);
            claims.setExpirationTimeMinutesInTheFuture(60.0f);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() instanceof String[]) {
                    claims.setStringListClaim(entry.getKey(), (String[])entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("max_age")) {
                    try {
                        claims.setClaim(entry.getKey(), (Object)Integer.valueOf(String.valueOf(entry.getValue())));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new BindingException(MAX_AGE_ERROR, e);
                    }
                }
                claims.setStringClaim(entry.getKey(), String.valueOf(entry.getValue()));
            }
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setAlgorithmHeaderValue(settings.getRequestSigningAlgorithm());
            ClientAuthSupport.sign(jws, log);
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new ProcessRuntimeException("Failed to construct OIDC authentication request object: " + e, e);
        }
        catch (BindingException e) {
            throw new ProcessRuntimeException("Failed to sign OIDC authentication request object: " + e, e);
        }
    }

    private void logFailure(Exception e) {
        AuditLogger.setStatus("failure");
        AuditLogger.setEvent("OAuth");
        if (e.getCause() != null) {
            AsAuditLogger.setDescription(e.getCause().getMessage());
        } else {
            AsAuditLogger.setDescription(e.getMessage());
        }
        AuditLogger.setProtocol("OAuth20");
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"TokenAuthorize");
        AsAuditLogger.log(e.getMessage());
    }

    private boolean isRequestObjectProcessable(Client client, String requestObj) {
        if (StringUtils.isBlank((String)requestObj)) {
            log.debug((Object)"request object not present, skip processing");
            return false;
        }
        if (client.isRequireSignedRequests()) {
            String msg = "[%s] OAuth client requires signed request, processing request object";
            log.debug((Object)String.format(msg, client.getClientId()));
            return true;
        }
        if (this.requestObjectOptions.getBooleanValue("alwaysProcessTheRequestObject", false)) {
            log.debug((Object)"[alwaysProcessTheRequestObject] flag is true in the config-store, processing request object");
            return true;
        }
        log.debug((Object)"Inspecting the request object to extract the signing algorithm");
        try {
            JsonWebStructure jws = JsonWebStructure.fromCompactSerialization((String)requestObj);
            String alg = jws.getHeader("alg");
            log.debug((Object)String.format("Request object's signing algorithm is [%s]", alg));
            if ("none".equals(alg)) {
                return true;
            }
        }
        catch (JoseException e) {
            log.error((Object)"unable to inspect the request object to determine if it's signed, moving on");
            log.debug((Object)e);
        }
        log.debug((Object)String.format("Inspecting [%s] OAuth client's JWKS and JWKS URL settings.", client.getClientId()));
        boolean isJwksPresent = StringUtils.isNotBlank((String)client.getJwks());
        boolean isJwksUrlPresent = StringUtils.isNotBlank((String)client.getJwksUrl());
        if (!isJwksPresent && !isJwksUrlPresent) {
            String msg = "[%s] OAuth client requires either JWKS or JWKS URL setting to process request objects. The request object will be ignored";
            log.debug((Object)String.format(msg, client.getClientId()));
        }
        return isJwksPresent || isJwksUrlPresent;
    }

    private void handleJarmResponse(HttpServletRequest request, OutMessageContext msgCtx, ResponseType respType, ResponseType.ResponseMode responseMode, String issuer) {
        Client client = this.clientManager.getCachedClient(msgCtx.getEntityId());
        if (msgCtx.getParam("error") == null) {
            this.issueJwtAndStoreInOutMsgCtxParams(request, msgCtx, issuer, client);
        } else if (client != null) {
            this.issueJwtAndStoreInOutMsgCtxParams(request, msgCtx, issuer, client);
        }
        switch (responseMode) {
            case jwt: {
                if ("authorization_code".equals(respType.getFirstImpliedGrantType())) {
                    this.createQueryBaseResponse(msgCtx);
                    break;
                }
                this.createFragmentBaseResponse(msgCtx);
                break;
            }
            case query_jwt: {
                this.createQueryBaseResponse(msgCtx);
                break;
            }
            case fragment_jwt: {
                this.createFragmentBaseResponse(msgCtx);
                break;
            }
            case form_post_jwt: {
                msgCtx.setParams(msgCtx.getParams());
                break;
            }
            default: {
                String msg = String.format("invalid response mode: %s", new Object[]{responseMode});
                log.error((Object)msg);
                throw new ProcessRuntimeException(msg);
            }
        }
    }

    private void issueJwtAndStoreInOutMsgCtxParams(HttpServletRequest request, OutMessageContext msgCtx, String issuer, Client client) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> claims = new HashMap<String, Object>(msgCtx.getParams());
        if (!claims.containsKey("iss")) {
            claims.put("iss", issuer);
        }
        claims.put("aud", msgCtx.getEntityId());
        NumericDate date = NumericDate.now();
        date.addSeconds((long)this.authzServerMgr.getJwtSecuredAuthorizationResponseModeLifetime());
        claims.put("exp", date.getValue());
        String response = this.oAuthJwtTokenService.issueAuthorizationResponse(request, client, claims);
        params.put("response", response);
        msgCtx.setParams(params);
        msgCtx.setMaskedParamName("response");
    }

    private void createQueryBaseResponse(OutMessageContext msgCtx) {
        msgCtx.setEndpoint(Util.appendQueryParams(msgCtx.getEndpoint(), msgCtx.getParams()));
    }

    private void createFragmentBaseResponse(OutMessageContext msgCtx) {
        String tempQuery = Util.createQueryString(msgCtx.getParams());
        String fragment = StringUtils.replaceOnce((String)tempQuery, (String)"?", (String)"#");
        msgCtx.setEndpoint(msgCtx.getEndpoint() + fragment);
    }
}

