/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.Util;
import org.sourceid.oauth20.bindings.OauthBindingGroup;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.bindings.FormPost;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class OAuthClientBinding
implements Binding {
    private final boolean doPost;

    public OAuthClientBinding() {
        this(true);
    }

    public OAuthClientBinding(boolean doPost) {
        this.doPost = doPost;
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException {
        if (this.doPost) {
            FormPost.post(msgCtx.getEndpoint(), msgCtx.getParams(), req, resp);
        } else {
            resp.sendRedirect(Util.appendQueryParams(msgCtx.getEndpoint(), msgCtx.getParams()));
        }
        return null;
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) {
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) {
        InMessageContext context = new InMessageContext();
        OauthBindingGroup.getSetParam(request, "access_token", context);
        OauthBindingGroup.getSetParam(request, "token_type", context);
        OauthBindingGroup.getSetParam(request, "id_token", context);
        OauthBindingGroup.getSetParam(request, "state", context);
        OauthBindingGroup.getSetParam(request, "expires_in", context);
        OauthBindingGroup.getSetParam(request, "error", context);
        OauthBindingGroup.getSetParam(request, "error_description", context);
        OauthBindingGroup.getSetParam(request, "error_uri", context);
        return context;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) {
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public String getUri() {
        return "oauth:client";
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }
}

