/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jose4j.jwt.MalformedClaimException;
import org.sourceid.oauth20.bindings.AbstractJSONEndpointBinding;
import org.sourceid.oauth20.bindings.AuthorizationEndpointBinding;
import org.sourceid.oauth20.client.ClientAuthSupport;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.BaseClientAuthnRequestHandler;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class PushedAuthorizationRequestBinding
extends AbstractJSONEndpointBinding {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthorizationEndpointBinding authorizationEndpointBinding = new AuthorizationEndpointBinding();
    private final AuthzServerManager authzServerSettingsManager = MgmtFactory.getAuthzServerManager();
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();
    public static final String OAUTH_PAR_BINDING = "oauth:par";
    private Endpoint authorizationEndpoint;
    private OIDCSettings oidcSettings;

    public PushedAuthorizationRequestBinding() {
    }

    public PushedAuthorizationRequestBinding(String authorizationEndpointForAdminAuth, OIDCSettings oidcSettingsForAdminAuth) {
        this.authorizationEndpoint = new Endpoint("oauth:authz", authorizationEndpointForAdminAuth);
        this.oidcSettings = oidcSettingsForAdminAuth.clone();
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException {
        if (this.authzServerSettingsManager.getParServerPolicy().getStatus() == ParServerPolicy.Status.DISABLED) {
            throw new HttpStatusCodeException("PAR is not enabled", 403);
        }
        AuditLogger.setEvent("PAR");
        AuditLogger.setProtocol("OAuth20");
        AuditLogger.setRole("AS");
        this.oAuthIssuerUtils.setAuditLogVirtualServerIdIfApplicable(request);
        if (!StringUtils.equals((String)request.getMethod(), (String)"POST")) {
            String message = "PAR can only be POST";
            throw new HttpStatusCodeException(message, 405);
        }
        InMessageContext ctx = new InMessageContext(partnerRole);
        ctx.setIsRequest(true);
        ctx.setBackChannelBinding(true);
        try {
            Client client = BaseClientAuthnRequestHandler.findValidClient(request);
            ctx.setEntityId(client.getClientId());
            AsAuditLogger.setConnectionId(client.getClientId());
            if (client.getClientId() == null) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "client identification required");
            }
            if (!client.isEnabled()) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.unauthorized_client, "The requesting client is not active.");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("identified client " + client.getClientId()));
            }
            if (StringUtils.isNotBlank((String)request.getParameter("request_uri"))) {
                String s = "The request_uri authorization request parameter is not allowed in a pushed authorization request";
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, s);
            }
            this.authorizationEndpointBinding.processInbound(request, ctx, client);
        }
        catch (AccessTokenRequestException | AuthorizationRequestException e) {
            ctx.setDeferredException(e);
        }
        catch (MalformedClaimException e) {
            ctx.setDeferredException(new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "The request object has a malformed claim - " + e.getMessage()));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("processed request into inbound context params: " + ctx.getParams()));
        }
        return ctx;
    }

    @Override
    public String getUri() {
        return OAUTH_PAR_BINDING;
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException {
        Endpoint authorizationEndpoint = this.authorizationEndpoint;
        OIDCSettings oidcSettings = this.oidcSettings;
        msgCtx.setBackChannelBinding(true);
        if (authorizationEndpoint == null || oidcSettings == null) {
            IdpConnection idpConnection = MetadataSupport.getIdpConnection(msgCtx.getEntityId());
            oidcSettings = idpConnection.getOidcSettings();
            this.authorizationEndpointBinding.checkActive(idpConnection);
            authorizationEndpoint = idpConnection.getSingleSignOnServices().getPrimaryEndpoint();
        }
        this.handleOutgoingParRequests(req, resp, msgCtx, oidcSettings, authorizationEndpoint);
        return null;
    }

    private void handleOutgoingParRequests(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx, OIDCSettings oidcSettings, Endpoint authorizationEndpoint) throws BindingException, IOException {
        Map<String, Object> reqParams = this.authorizationEndpointBinding.getRequestParameters(req, resp, msgCtx, oidcSettings);
        HttpPost httpPost = new HttpPost(msgCtx.getEndpoint());
        ClientAuthSupport.populateClientAuthParam(oidcSettings, msgCtx.getParam(Parameters.CLIENT_ID), reqParams, httpPost);
        List<NameValuePair> postData = this.getNameValuePairs(reqParams);
        UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(postData, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)postEntity);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Sending the PAR Request to '%s'", msgCtx.getEndpoint()));
        }
        String responseStream = this.makeParRequest(httpPost, msgCtx);
        JsonNode jsonNode = this.processParResponse(responseStream, msgCtx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("extracting 'request_uri' attribute from the response received from '%s' endpoint", msgCtx.getEndpoint()));
        }
        String requestUri = this.getRequestUriFromJsonPayload(jsonNode, msgCtx);
        try {
            URIBuilder uriBuilder = new URIBuilder(authorizationEndpoint.getFullLocation());
            uriBuilder.addParameter(Parameters.CLIENT_ID, (String)msgCtx.getParams().get(Parameters.CLIENT_ID));
            uriBuilder.addParameter("request_uri", requestUri);
            resp.sendRedirect(uriBuilder.toString());
        }
        catch (URISyntaxException e) {
            throw new BindingException("Unable to send authorization request with request URI", e);
        }
    }

    private List<NameValuePair> getNameValuePairs(Map<String, Object> reqParams) {
        ArrayList<NameValuePair> postData = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> reqParam : reqParams.entrySet()) {
            String value = null;
            Object valueObj = reqParam.getValue();
            if (valueObj != null) {
                value = valueObj instanceof String ? (String)valueObj : valueObj.toString();
            }
            BasicNameValuePair pair = new BasicNameValuePair(reqParam.getKey(), value);
            postData.add((NameValuePair)pair);
        }
        return postData;
    }

    private String makeParRequest(HttpPost httpPost, OutMessageContext msgCtx) throws BindingException {
        try {
            return HttpConnectionPoolingManager.getInstance().doRequest((HttpRequestBase)httpPost);
        }
        catch (IOException e) {
            String errorMsg = String.format("Failed to send PAR request to '%s'", msgCtx.getEndpoint());
            throw new BindingException(errorMsg, e);
        }
    }

    private JsonNode processParResponse(String response, OutMessageContext msgCtx) throws BindingException {
        try {
            JsonParser jsonParser = new JsonFactory().createParser(response);
            return (JsonNode)this.objectMapper.readTree(jsonParser);
        }
        catch (IOException e) {
            String errorMsg = String.format("Failed to parse PAR response received from '%s'", msgCtx.getEndpoint());
            throw new BindingException(errorMsg, e);
        }
    }

    private String getRequestUriFromJsonPayload(JsonNode jsonNode, OutMessageContext msgCtx) throws BindingException {
        if (jsonNode.has("request_uri")) {
            JsonNode requestUriClaim = jsonNode.get("request_uri");
            return requestUriClaim.asText();
        }
        String errorMsg = String.format("Failed to extract the '%s' property from the PAR response received from '%s'", "request_uri", msgCtx.getEndpoint());
        throw new BindingException(errorMsg);
    }
}

