/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.bindings.AbstractJSONEndpointBinding;
import org.sourceid.oauth20.bindings.OauthBindingGroup;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.wrapper.InMessageContext;

public class TokenEndpointBinding
extends AbstractJSONEndpointBinding {
    private final Set<String> getableGrantTypes;

    public TokenEndpointBinding() {
        ConfigStore config = ConfigStoreFarm.getConfig("oauth-token-endpoint-binding");
        List<String> grantsList = config.getListValue("grant-types-that-allow-http-get", Collections.singletonList("urn:pingidentity.com:oauth2:grant_type:validate_bearer"));
        this.getableGrantTypes = new HashSet<String>(grantsList);
    }

    @Override
    public InMessageContext receive(HttpServletRequest req, HttpServletResponse response, Role partnerRole) throws HttpStatusCodeException, IOException {
        OauthBindingGroup.checkLicense();
        InMessageContext inCtx = new InMessageContext();
        inCtx.setIsRequest(true);
        OauthBindingGroup.getSetParam(req, "grant_type", inCtx);
        if (!(!"GET".equals(req.getMethod()) || "/as/token.oauth2".equals(req.getServletPath()) && this.getableGrantTypes.contains(inCtx.getParam("grant_type")))) {
            throw new HttpStatusCodeException(405);
        }
        OauthBindingGroup.getSetParam(req, Parameters.SCOPE, inCtx);
        OauthBindingGroup.getSetParam(req, "authorization_details", inCtx);
        OauthBindingGroup.getSetParam(req, "token", inCtx, true);
        OauthBindingGroup.getSetParam(req, "access_token_manager_id", inCtx);
        OauthBindingGroup.getSetParam(req, "aud", inCtx);
        OauthBindingGroup.getSetResourceParam(req, inCtx);
        OauthBindingGroup.getClientIdSetEntityId(req, inCtx);
        return inCtx;
    }

    @Override
    public String getUri() {
        return "oauth:token-endpoint";
    }
}

