/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.model.User;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import com.pingidentity.sdk.api.authn.model.state.OAuthDeviceCompleted;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.oauth20.bindings.OauthBindingGroup;
import org.sourceid.oauth20.device.DeviceAuthorizationState;
import org.sourceid.oauth20.handlers.AttributesHolder;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.saml20.adapter.state.KeyValueStateSupport;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class UserAuthorizationEndpointBinding
implements Binding {
    public static final String BINDING_URI = "oauth:user:authz:endpoint";
    private static final String OAUTH_DEVICE_MESSAGES_PAGE_TEMPLATE = "oauth.device.messages.page.template.html";
    private static final String VAR_USER_KEY = "userKey";
    private static final String VAR_USER_NAME = "userName";
    private static final String VAR_ERROR_MESSAGE_KEY = "errorMessageKey";
    private static final String VAR_USER_KEY_ATTRIBUTES = "userKeyAttributes";
    private static final String VAR_GRANT_ATTRIBUTES = "grantAttributes";
    private final KeyValueStateSupport keyValueStateSupport;
    private final OAuthIssuerUtils oAuthIssuerUtils;
    private final Log log = LogFactory.getLog(UserAuthorizationEndpointBinding.class);

    public UserAuthorizationEndpointBinding(KeyValueStateSupport keyValueStateSupport, OAuthIssuerUtils oAuthIssuerUtils) {
        this.keyValueStateSupport = keyValueStateSupport;
        this.oAuthIssuerUtils = oAuthIssuerUtils;
    }

    public UserAuthorizationEndpointBinding() {
        this(new KeyValueStateSupport(), OAuthIssuerUtils.getInstance());
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws BindingException, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        AttributesHolder userAttrs = msgCtx.getSupplementalContext("attrs", AttributesHolder.class);
        if (userAttrs != null) {
            UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
            String userKeyValue = userKeyAttrs.getUserKeyValue();
            params.put(VAR_USER_KEY_ATTRIBUTES, (Object)userKeyAttrs);
            params.put(VAR_USER_KEY, userKeyValue);
            params.put(VAR_USER_NAME, userKeyAttrs.getUserNameValue());
            params.put(VAR_GRANT_ATTRIBUTES, TemplateParamUtil.convertAttributeMapToTemplateParams(userKeyAttrs.getExtendedAttributes()));
        }
        DeviceAuthorizationState.Result result = msgCtx.getSupplementalContext("DEVICE-AUTHZ-RESULT-STATE", DeviceAuthorizationState.Result.class);
        String deviceCode = msgCtx.getSupplementalContext("device_code", String.class);
        DeviceAuthorizationState state = (DeviceAuthorizationState)this.keyValueStateSupport.getValue(deviceCode);
        if (msgCtx.getParam("error") != null) {
            this.log.error((Object)("an error occurred, " + msgCtx.getParam("error")));
            params.put(VAR_ERROR_MESSAGE_KEY, msgCtx.getParam("error"));
            if (state != null) {
                params.put(Parameters.CLIENT_ID, state.getClientId());
            }
        } else if (state == null) {
            this.log.error((Object)"Device authorization failed");
            params.put(VAR_ERROR_MESSAGE_KEY, "failed");
        } else {
            params.put(Parameters.CLIENT_ID, state.getClientId());
            if (state.isExpired()) {
                this.log.error((Object)"Device authorization timed out");
                params.put(VAR_ERROR_MESSAGE_KEY, "expired");
            } else {
                state.setAuthorized(true);
                state.setResult(result);
                this.keyValueStateSupport.setValue(state.getDeviceCode(), (Object)state);
                this.log.debug((Object)"Device authorized successfully");
                params.put("messageKey", "success");
            }
        }
        this.renderResponse(request, response, msgCtx, params);
    }

    private void renderResponse(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx, Map<String, Object> params) throws BindingException, IOException {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            this.renderApiResponse(req, resp, msgCtx, params);
        } else {
            this.renderTemplateResponse(req, resp, params);
        }
    }

    private void renderApiResponse(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx, Map<String, Object> params) throws IOException {
        String errorMessageKey = (String)params.get(VAR_ERROR_MESSAGE_KEY);
        if (errorMessageKey != null) {
            AuthenticationFailed authenticationFailed = new AuthenticationFailed();
            String errorCode = msgCtx.getParam("error");
            if (errorCode == null) {
                errorCode = "DEVICE_AUTHORIZATION_FAILED";
            }
            authenticationFailed.setCode(errorCode);
            String errorMessage = msgCtx.getParam("error_description");
            if (errorMessage == null) {
                errorMessage = "Device authorization failed.";
            }
            authenticationFailed.setMessage(errorMessage);
            authenticationFailed.setUserMessageKey("oauth.device.messages.page.template." + errorMessageKey);
            authenticationFailed.setTrackingId(TrackingIdSupport.getTrackingId());
            AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, CommonStateSpec.FAILED.makeInstance(req, (Object)authenticationFailed));
        } else {
            OAuthDeviceCompleted completed = new OAuthDeviceCompleted();
            String userKey = (String)params.get(VAR_USER_KEY);
            String username = (String)params.get(VAR_USER_NAME);
            if ((userKey != null || username != null) && MgmtFactory.getAuthnApiManager().isIncludeUserInfoInResponses()) {
                User user = new User();
                user.setUsername(username);
                user.setId(userKey);
                completed.setUser(user);
            }
            AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, CommonStateSpec.OAUTH_DEVICE_COMPLETED.makeInstance(req, (Object)completed));
        }
    }

    private void renderTemplateResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws BindingException {
        try {
            ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
            renderer.render(req, resp, OAUTH_DEVICE_MESSAGES_PAGE_TEMPLATE, params);
        }
        catch (ResponseTemplateRendererException e) {
            throw new BindingException(e.getMessage());
        }
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws HttpStatusCodeException {
        String userCodeParam;
        OauthBindingGroup.checkLicense();
        InMessageContext inMsgCtx = new InMessageContext();
        inMsgCtx.setIsRequest(true);
        String responseModeParam = request.getParameter("response_mode");
        if (StringUtils.isNotBlank((String)responseModeParam)) {
            this.checkFlagAsApiRequest(request, responseModeParam);
            inMsgCtx.setParam("response_mode", responseModeParam, false);
        }
        if (StringUtils.isNotBlank((String)(userCodeParam = request.getParameter("user_code")))) {
            inMsgCtx.setParam("user_code", userCodeParam, false);
        }
        this.oAuthIssuerUtils.setMessageContextOAuthIssuerIfApplicable(request, inMsgCtx);
        return inMsgCtx;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException, RenderPageException {
        throw new ServletException("Unexpected problem: " + e.getMessage(), (Throwable)e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public String getUri() {
        return BINDING_URI;
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }

    private void checkFlagAsApiRequest(HttpServletRequest req, String responseMode) {
        if (StringUtils.equals((String)responseMode, (String)ResponseType.ResponseMode.pi_flow.getIdentifier())) {
            AuthnApiSupport.getDefault().setApiRequest(req);
            InternalAuthnApiSupport.getDefault().setRequestBodyConsumed(req);
        }
    }
}

