/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.device;

import com.pingidentity.common.util.TimeUtil;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.Serializable;
import java.time.ZoneOffset;

public class DeviceAuthorizationState
implements Serializable {
    private static final long serialVersionUID = 201807150001L;
    private final String clientId;
    private final long expiresAt;
    private final Scope requestedScope;
    private final String deviceCode;
    private final String userCode;
    private final AuthorizationDetails requestedAuthorizationDetails;
    private Boolean authorized = null;
    private Result result;

    public DeviceAuthorizationState(String clientId, long expiresAt, Scope requestedScope, String deviceCode, String userCode, AuthorizationDetails requestedAuthorizationDetails) {
        this.clientId = clientId;
        this.expiresAt = expiresAt;
        this.requestedScope = requestedScope;
        this.deviceCode = deviceCode;
        this.userCode = userCode;
        this.requestedAuthorizationDetails = requestedAuthorizationDetails;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public Boolean getAuthorized() {
        return this.authorized;
    }

    public void setAuthorized(Boolean authorized) {
        this.authorized = authorized;
    }

    public Scope getRequestedScope() {
        return this.requestedScope;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public boolean isExpired() {
        return TimeUtil.getCurrentUtcLocalDateTime().toEpochSecond(ZoneOffset.UTC) > this.expiresAt;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public AuthorizationDetails getRequestedAuthorizationDetails() {
        return this.requestedAuthorizationDetails;
    }

    public static final class Result
    implements Serializable {
        private final String userKey;
        private final Scope approvedScope;
        private final AccessGrantAttributesHolder grantAttrHolder;
        private final String ctxQualifier;
        private final boolean returnScope;
        private final String sri;
        private final AuthorizationDetails approvedAuthorizationDetails;

        public Result(String userKey, Scope approvedScope, AccessGrantAttributesHolder grantAttrHolder, String ctxQualifier, boolean returnScope, String sri, AuthorizationDetails approvedAuthorizationDetails) {
            this.userKey = userKey;
            this.approvedScope = approvedScope;
            this.grantAttrHolder = grantAttrHolder;
            this.ctxQualifier = ctxQualifier;
            this.returnScope = returnScope;
            this.sri = sri;
            this.approvedAuthorizationDetails = approvedAuthorizationDetails;
        }

        public String getUserKey() {
            return this.userKey;
        }

        public Scope getApprovedScope() {
            return this.approvedScope;
        }

        public AccessGrantAttributesHolder getGrantAttrHolder() {
            return this.grantAttrHolder;
        }

        public String getCtxQualifier() {
            return this.ctxQualifier;
        }

        public boolean isReturnScope() {
            return this.returnScope;
        }

        public String getSri() {
            return this.sri;
        }

        public AuthorizationDetails getApprovedAuthorizationDetails() {
            return this.approvedAuthorizationDetails;
        }
    }
}

