/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.device;

import com.google.common.annotations.VisibleForTesting;
import org.sourceid.common.IDGenerator;
import org.sourceid.oauth20.domain.DeviceFlowSettings;

public class DeviceFlowCodeUtils {
    private static final String USER_CODE_PREFIX = "user-code-";
    private final DeviceFlowSettings settings;

    public DeviceFlowCodeUtils(DeviceFlowSettings settings) {
        this.settings = settings;
    }

    public String generateUserCode() {
        int segmentLength = this.settings.getSegmentLength();
        int length = this.settings.getCodeLength();
        if (segmentLength > 0) {
            length += this.settings.getCodeLength() / segmentLength;
            int remainder = this.settings.getCodeLength() % segmentLength;
            if (remainder == 0) {
                --length;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(IDGenerator.rndStr(length, this.settings.getCharacterSet()));
        int i = segmentLength;
        while (segmentLength > 0 && i < length - 1) {
            stringBuilder.setCharAt(i, this.settings.getSegmentSeparator());
            i = i + segmentLength + 1;
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    String stripSegmentSeparator(String userCode) {
        if (userCode.indexOf(this.settings.getSegmentSeparator()) < 0) {
            return userCode;
        }
        String[] split = userCode.split(String.valueOf(this.settings.getSegmentSeparator()));
        StringBuilder result = new StringBuilder();
        for (String s : split) {
            result.append(s);
        }
        return result.toString();
    }

    public String generateDeviceCode() {
        return IDGenerator.rndAlphaNumeric(this.settings.getDeviceCodeLength());
    }

    public String normalizeUserCode(String userCode) {
        if (userCode == null) {
            return null;
        }
        String tmp = this.settings.isCaseSensitiveVerification() ? userCode : userCode.toUpperCase();
        return USER_CODE_PREFIX + this.stripSegmentSeparator(tmp);
    }
}

