/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.device.impl;

import com.pingidentity.configservice.AutoReloadable;
import org.sourceid.oauth20.device.DeviceFlowCodeUtils;
import org.sourceid.oauth20.device.DeviceFlowCodes;
import org.sourceid.oauth20.device.DeviceFlowManager;
import org.sourceid.oauth20.domain.DeviceFlowSettings;

public class DeviceFlowManagerImpl
implements DeviceFlowManager,
AutoReloadable {
    private DeviceFlowCodeUtils deviceFlowCodeUtils;

    public DeviceFlowManagerImpl() {
        this.loadConfig();
    }

    private void loadConfig() {
        DeviceFlowSettings deviceFlowSettings = DeviceFlowSettings.makeInstance();
        this.deviceFlowCodeUtils = new DeviceFlowCodeUtils(deviceFlowSettings);
    }

    @Override
    public DeviceFlowCodes generateCodes() {
        String userCode = this.deviceFlowCodeUtils.generateUserCode();
        String deviceCode = this.deviceFlowCodeUtils.generateDeviceCode();
        return new DeviceFlowCodes(userCode, deviceCode);
    }

    @Override
    public String normalizeUserCode(String userCode) {
        return this.deviceFlowCodeUtils.normalizeUserCode(userCode);
    }
}

