/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.ActivationCodeCheckMode;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerSettings;
import org.sourceid.oauth20.domain.ClientCredentialAccessTokenMapping;
import org.sourceid.oauth20.domain.CorsSettings;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.PersistentGrantAttribute;

public interface AuthzServerManager {
    public AuthzServerSettings getAuthzServerSettings();

    public void save(AuthzServerSettings var1);

    public int getAuthzCodeTimeout();

    public int getAuthzCodeLength();

    public boolean isRestrictPlainPKCE();

    public boolean isIncludeIssuerInAuthzResponse();

    public boolean defaultRefreshTokenRollingPolicy();

    public int getRefreshTokenRollingGracePeriod();

    public long getRefreshRollingInterval();

    public String getRefreshRollingIntervalTimeUnit();

    public boolean reuseExistingPersistentGrant(String var1);

    public boolean isEnableOAuth();

    public int getRefreshTokenLength();

    public String getScopeWhitelist();

    public Long getGlobalPersistentGrantExpirationTime();

    public String getGlobalPersistentGrantExpirationTimeUnit();

    public Long getGlobalPersistentGrantIdleTimeout();

    public String getGlobalPersistentGrantIdleTimeoutTimeUnit();

    public List<PersistentGrantAttribute> getPersistentGrantExtendedAttributes();

    public List<String> getAllowedOrigins();

    public AttributeContract getKeyNameContract();

    public AttributeContract getKeyOnlyContract();

    public AttributeContract getClientCredentialsContract();

    public List<String> getDefaultPersistentGrantAttributes();

    public ConfigurablePluginInstance getAdminWebServicePcv();

    public String getAtmIdForOAuthGrantManagement();

    public String getScopeForOAuthGrantManagement();

    public CorsSettings getCorsSettings();

    public String getTokenEndpointBaseUrl();

    public String getUserAuthzUrl();

    public String getRegisteredAuthzPath();

    public int getPendingAuthzTimeout();

    public int getDevicePollingInterval();

    public boolean isBypassActivationCodeConfirmation();

    public ActivationCodeCheckMode getActivationCodeCheckMode();

    public boolean isEnableCookielessUserAuthzAuthnApi();

    public boolean isReturnIdTokenOnOpenIdWithDeviceAuthorizationGrant();

    public String getExternalConsentAdapterId();

    public String getReturnedScopeAttributeName();

    public String getReturnedAuthorizationDetailsAttributeName();

    public String getAuthzConsentSetting();

    public ParServerPolicy getParServerPolicy();

    public boolean allowUnidentifiedClientROCreds();

    public boolean allowUnidentifiedClientExtensionGrants();

    public PluginToUserKeyAttrMapping getPwdCredValidatorToUserKeyMapping(String var1);

    public Collection<PluginToUserKeyAttrMapping> getPwdCredValidatorToUserKeyMappings();

    public UserKeyAttrMapping getAdapterToUserKeyMapping(String var1);

    public Collection<PluginToUserKeyAttrMapping> getAdapterToUserKeyMappings();

    public ApcToUserKeyAttrMapping getApcToUserKeyMapping(String var1);

    public Collection<ApcToUserKeyAttrMapping> getApcToUserKeyMappings();

    public TeppToUserKeyAttrMapping getTeppToUserKeyMapping(String var1);

    public Collection<TeppToUserKeyAttrMapping> getTeppToUserKeyMappings();

    public Collection<ClientCredentialAccessTokenMapping> getClientCredentialsToAccessTokenMappings();

    public ClientCredentialAccessTokenMapping getClientCredsToAccessTokenMapping(String var1);

    public UserKeyToAccessTokenMapping getDefaultUserKeyToAccessTokenMapping(String var1);

    public Collection<UserKeyToAccessTokenMapping> getUserKeyToAccessTokenMappings();

    public Collection<UserKeyToAccessTokenMapping> getEnabledUserKeyToAccessTokenMappings();

    public UserKeyToAccessTokenMapping getUserKeyToAccessTokenMapping(String var1);

    public UserKeyToAccessTokenMapping getUserKeyToAccessTokenMapping(String var1, String var2);

    public Collection<UserKeyToAccessTokenMapping> getUserKeyToAccessTokenMappingsForContext(String var1);

    public Map<String, ? super AttributeMapping> getAdapterIdToUserKeyMappingsWithDSInUse(String var1);

    public Map<String, ? super AttributeMapping> getApcToUserKeyMappingsWithDSInUse(String var1);

    public Map<String, ? super AttributeMapping> getTeppToUserKeyMappingsWithDSInUse(String var1);

    public Map<String, ? super AttributeMapping> getValidatorIdToUserKeyMappingsWithDSInUse(String var1);

    public Map<String, ? super AttributeMapping> getUserKeyToAccessTokenMappingsWithDSInUse(String var1);

    public Map<String, ? super AttributeMapping> getUserKeyToAccessTokenMappingsWithAdapterInUse(String var1);

    public Map<String, ? super AttributeMapping> getUserKeyToAccessTokenMappingsWithPCVInUse(String var1);

    public Collection<AccessTokenMapping> getAccessTokenMappings();

    public void saveAccessTokenMappings(Collection<AccessTokenMapping> var1);

    public void savePwdCredValidatorToUserKeyMappings(Collection<PluginToUserKeyAttrMapping> var1, boolean var2);

    public void savePwdCredValidatorToUserKeyMapping(PluginToUserKeyAttrMapping var1, boolean var2);

    public void saveAdapterToUserKeyMappings(Collection<PluginToUserKeyAttrMapping> var1, boolean var2);

    public void saveApcToUserKeyMappings(Collection<ApcToUserKeyAttrMapping> var1, boolean var2);

    public void saveApcToUserKeyMapping(ApcToUserKeyAttrMapping var1, boolean var2);

    public void saveTeppToUserKeyMappings(Collection<TeppToUserKeyAttrMapping> var1, boolean var2);

    public void saveTeppToUserKeyMapping(TeppToUserKeyAttrMapping var1, boolean var2);

    public void saveAdapterToUserKeyMapping(PluginToUserKeyAttrMapping var1, boolean var2);

    public void saveClientCredsToAccessTokenMapping(String var1, ClientCredentialAccessTokenMapping var2);

    public void saveUserKeyToAccessTokenMappings(Collection<UserKeyToAccessTokenMapping> var1);

    public void saveUserKeyToAccessTokenMapping(String var1, UserKeyToAccessTokenMapping var2);

    public void deletePwdCredValidatorToUserKeyMapping(String var1);

    public void deleteAdapterToUserKeyMapping(String var1);

    public void deleteApcToUserKeyMapping(String var1);

    public void deleteTeppToUserKeyMapping(String var1);

    public void deleteUserKeyToAccessTokenMapping(String var1);

    public void deleteUserKeyToAccessTokenMappingsForContext(String var1);

    public void deleteClientCredentialToAccessTokenMapping(String var1);

    public void upgradeLegacyUserKeyToAccessTokenMappingIds();

    public void upgradeLegacyConfigStoreSettings();

    public void handleLegacyClientCredentialToAccessTokenMappingIds();

    public boolean allowAutoAuthz(String var1);

    public boolean isDataSourceInUse(String var1);

    public boolean isApcInUse(String var1);

    public int getClientSecretRetentionPeriod();

    public int getMaxRetainedClientSecondarySecrets();

    public boolean isRelaxedAudienceValidation();

    public int getJwtSecuredAuthorizationResponseModeLifetime();

    public boolean isRevokeReplayedRefreshToken();

    public boolean isDpopProofRequireNonce();

    public int getDpopProofLifetimeSeconds();

    public boolean isDpopProofEnforceReplayPrevention();

    public boolean isBypassAuthorizationForApprovedConsents();

    public int getConsentLifetimeDays();

    public boolean isRevokeRefreshTokenForFailedIssuanceCriteria();

    public boolean isRequireOfflineAccessScopeToIssueRefreshTokens();

    public boolean isOfflineAccessRequireConsentPrompt();

    public boolean isPersistentGrantExpiryBasedOnIdleTimeout();
}

