/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.ActivationCodeCheckMode;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.ClientCredentialAccessTokenMapping;
import org.sourceid.oauth20.domain.CorsSettings;
import org.sourceid.oauth20.domain.CorsSettingsUtil;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.PersistentGrantAttribute;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class AuthzServerSettings {
    private AttributeContract keyNameContract;
    private AttributeContract keyOnlyContract;
    private Map<String, UserKeyToAccessTokenMapping> userKeyToAccessTokenMappings;
    private Map<String, PluginToUserKeyAttrMapping> adapterIdToUserKeyMappings;
    private Map<String, PluginToUserKeyAttrMapping> validatorIdToUserKeyMappings;
    private Map<String, ApcToUserKeyAttrMapping> apcIdToUserKeyMappings;
    private Map<String, TeppToUserKeyAttrMapping> teppToUserKeyAttrMappings;
    private List<PersistentGrantAttribute> persistentGrantExtendedAttributes = new LinkedList<PersistentGrantAttribute>();
    private List<String> allowedOrigins = new LinkedList<String>();
    private Map<String, ClientCredentialAccessTokenMapping> clientCredsToAccessTokenMappings;
    private int authzCodeTimeout;
    private int authzCodeLength;
    private boolean restrictPlainPkce;
    private boolean includeIssuerInAuthzResponse;
    private boolean defaultRefreshTokenRollingPolicy;
    private int refreshTokenRollingGracePeriod;
    private long refreshRollingInterval;
    private String refreshTokenRollingIntervalTimeUnit = "h";
    private int refreshTokenLength;
    private Set<String> grantTypesToReusePersistentGrants;
    private Set<String> grantTypesToAllowAutoAuthzForExistingPersistentGrants;
    private ConfigurablePluginInstance adminWsPcv;
    private String atmIdForOAuthGrantManagement;
    private String scopeForOAuthGrantManagement;
    private Long globalPersistentGrantExpirationTime;
    private String globalPersistentGrantExpirationTimeUnit;
    private Long globalPersistentGrantIdleTimeout;
    private String globalPersistentGrantIdleTimeoutTimeUnit;
    private CorsSettings corsSettings;
    private String tokenEndpointBaseUrl;
    private String userAuthzUrl;
    private String registeredAuthzPath;
    private int pendingAuthzTimeout;
    private int devicePollingInterval;
    private boolean bypassActivationCodeConfirmation;
    private ActivationCodeCheckMode activationCodeCheckMode = ActivationCodeCheckMode.AFTER_AUTHENTICATION;
    private boolean enableCookielessUserAuthzAuthnApi;
    private boolean returnIdTokenOnOpenIdWithDeviceAuthzGrant;
    private String authzConsentSetting;
    private String externalConsentAdapterId;
    private String returnedScopeAttributeName;
    private String returnedAuthorizationDetailsAttributeName;
    private ParServerPolicy parServerPolicy;
    private boolean allowUnidentifiedClientROCreds;
    private boolean allowUnidentifiedClientExtensionGrants;
    private int clientSecretRetentionPeriod;
    private int jwtSecuredAuthorizationResponseModeLifetime;
    private boolean dpopProofRequireNonce;
    private int dpopProofLifetimeSeconds;
    private boolean dpopProofEnforceReplayPrevention;
    private boolean bypassAuthorizationForApprovedConsents;
    private int consentLifetimeDays;
    private boolean requireOfflineAccessScopeToIssueRefreshTokens;
    private boolean offlineAccessRequireConsentPrompt;
    private static final List<String> DEFAULT_URL_PATTERNS = Arrays.asList("/pf/JWKS", "/as/token.oauth2", "/as/revoke_token.oauth2", "/idp/userinfo.openid", "/.well-known/openid-configuration", "/as/bc-auth.ciba", "/pf-ws/rest/oauth/grants(/*)?");

    public AuthzServerSettings() {
    }

    public AuthzServerSettings(AuthzServerSettings copy) {
        this.keyNameContract = new AttributeContract(copy.getKeyNameContract());
        this.keyOnlyContract = new AttributeContract(copy.getKeyOnlyContract());
        this.userKeyToAccessTokenMappings = copy.getUserKeyToAccessTokenMappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new UserKeyToAccessTokenMapping((AccessTokenMapping)entry.getValue())));
        this.adapterIdToUserKeyMappings = copy.getAdapterIdToUserKeyMappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new PluginToUserKeyAttrMapping((PluginToUserKeyAttrMapping)entry.getValue())));
        this.validatorIdToUserKeyMappings = copy.getValidatorIdToUserKeyMappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new PluginToUserKeyAttrMapping((PluginToUserKeyAttrMapping)entry.getValue())));
        this.apcIdToUserKeyMappings = copy.getApcIdToUserKeyMappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ApcToUserKeyAttrMapping((ApcToUserKeyAttrMapping)entry.getValue())));
        this.teppToUserKeyAttrMappings = copy.getTeppToUserKeyAttrMappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new TeppToUserKeyAttrMapping((TeppToUserKeyAttrMapping)entry.getValue())));
        this.persistentGrantExtendedAttributes = copy.getPersistentGrantExtendedAttributes().stream().map(persistentGrantAttribute -> new PersistentGrantAttribute(persistentGrantAttribute.getName())).collect(Collectors.toList());
        this.allowedOrigins = new LinkedList<String>(copy.getAllowedOrigins());
        this.clientCredsToAccessTokenMappings = copy.getClientCredsToAccessTokenMappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ClientCredentialAccessTokenMapping((AccessTokenMapping)entry.getValue())));
        this.authzCodeTimeout = copy.getAuthzCodeTimeout();
        this.authzCodeLength = copy.getAuthzCodeLength();
        this.restrictPlainPkce = copy.isRestrictPlainPkce();
        this.includeIssuerInAuthzResponse = copy.isIncludeIssuerInAuthzResponse();
        this.defaultRefreshTokenRollingPolicy = copy.isDefaultRefreshTokenRollingPolicy();
        this.refreshTokenRollingGracePeriod = copy.getRefreshTokenRollingGracePeriod();
        this.refreshRollingInterval = copy.getRefreshRollingInterval();
        this.refreshTokenRollingIntervalTimeUnit = copy.getRefreshTokenRollingIntervalTimeUnit();
        this.refreshTokenLength = copy.getRefreshTokenLength();
        this.grantTypesToReusePersistentGrants = new HashSet<String>(copy.getGrantTypesToReusePersistentGrants());
        this.grantTypesToAllowAutoAuthzForExistingPersistentGrants = new HashSet<String>(copy.getGrantTypesToAllowAutoAuthzForExistingPersistentGrants());
        if (copy.getAdminWsPcv() != null) {
            PasswordCredentialValidatorManager pcvMgr = MgmtFactory.getCredentialValidatorManager();
            this.adminWsPcv = pcvMgr.getInstance(copy.getAdminWsPcv().getId());
        }
        this.atmIdForOAuthGrantManagement = copy.getAtmIdForOAuthGrantManagement();
        this.scopeForOAuthGrantManagement = copy.getScopeForOAuthGrantManagement();
        this.globalPersistentGrantExpirationTime = copy.getGlobalPersistentGrantExpirationTime();
        this.globalPersistentGrantExpirationTimeUnit = copy.getGlobalPersistentGrantExpirationTimeUnit();
        this.globalPersistentGrantIdleTimeout = copy.getGlobalPersistentGrantIdleTimeout();
        this.globalPersistentGrantIdleTimeoutTimeUnit = copy.getGlobalPersistentGrantIdleTimeoutTimeUnit();
        this.corsSettings = new CorsSettingsUtil().getCorsSettings("cors-configuration", DEFAULT_URL_PATTERNS, this.allowedOrigins);
        this.tokenEndpointBaseUrl = copy.getTokenEndpointBaseUrl();
        this.userAuthzUrl = copy.getUserAuthzUrl();
        this.registeredAuthzPath = copy.getRegisteredAuthzPath();
        this.pendingAuthzTimeout = copy.getPendingAuthzTimeout();
        this.devicePollingInterval = copy.getDevicePollingInterval();
        this.bypassActivationCodeConfirmation = copy.isBypassActivationCodeConfirmation();
        this.activationCodeCheckMode = copy.getActivationCodeCheckMode();
        this.enableCookielessUserAuthzAuthnApi = copy.isEnableCookielessUserAuthzAuthnApi();
        this.returnIdTokenOnOpenIdWithDeviceAuthzGrant = copy.isReturnIdTokenOnOpenIdWithDeviceAuthzGrant();
        this.authzConsentSetting = copy.getAuthzConsentSetting();
        this.externalConsentAdapterId = copy.getExternalConsentAdapterId();
        this.returnedScopeAttributeName = copy.getReturnedScopeAttributeName();
        this.returnedAuthorizationDetailsAttributeName = copy.getReturnedAuthorizationDetailsAttributeName();
        ParServerPolicy parServerPolicy = new ParServerPolicy();
        ParServerPolicy copyParServerPolicy = copy.getParServerPolicy();
        if (copyParServerPolicy != null) {
            parServerPolicy.setTimeoutSeconds(copyParServerPolicy.getTimeoutSeconds());
            parServerPolicy.setReferenceLength(copyParServerPolicy.getReferenceLength());
            parServerPolicy.setStatus(copyParServerPolicy.getStatus());
        }
        this.parServerPolicy = parServerPolicy;
        this.allowUnidentifiedClientROCreds = copy.isAllowUnidentifiedClientROCreds();
        this.allowUnidentifiedClientExtensionGrants = copy.isAllowUnidentifiedClientExtensionGrants();
        this.clientSecretRetentionPeriod = copy.getClientSecretRetentionPeriod();
        this.jwtSecuredAuthorizationResponseModeLifetime = copy.getJwtSecuredAuthorizationResponseModeLifetime();
        this.dpopProofRequireNonce = copy.isDpopProofRequireNonce();
        this.dpopProofLifetimeSeconds = copy.getDpopProofLifetimeSeconds();
        this.dpopProofEnforceReplayPrevention = copy.isDpopProofEnforceReplayPrevention();
        this.bypassAuthorizationForApprovedConsents = copy.isBypassAuthorizationForApprovedConsents();
        this.consentLifetimeDays = copy.getConsentLifetimeDays();
        this.requireOfflineAccessScopeToIssueRefreshTokens = copy.isRequireOfflineAccessScopeToIssueRefreshTokens();
        this.offlineAccessRequireConsentPrompt = copy.isOfflineAccessRequireConsentPrompt();
    }

    public AttributeContract getKeyNameContract() {
        return this.keyNameContract;
    }

    public void setKeyNameContract(AttributeContract keyNameContract) {
        this.keyNameContract = keyNameContract;
    }

    public AttributeContract getKeyOnlyContract() {
        return this.keyOnlyContract;
    }

    public void setKeyOnlyContract(AttributeContract keyOnlyContract) {
        this.keyOnlyContract = keyOnlyContract;
    }

    public Map<String, UserKeyToAccessTokenMapping> getUserKeyToAccessTokenMappings() {
        return this.userKeyToAccessTokenMappings;
    }

    public void setUserKeyToAccessTokenMappings(Map<String, UserKeyToAccessTokenMapping> userKeyToAccessTokenMappings) {
        this.userKeyToAccessTokenMappings = userKeyToAccessTokenMappings;
    }

    public Map<String, PluginToUserKeyAttrMapping> getAdapterIdToUserKeyMappings() {
        return this.adapterIdToUserKeyMappings;
    }

    public void setAdapterIdToUserKeyMappings(Map<String, PluginToUserKeyAttrMapping> adapterIdToUserKeyMappings) {
        this.adapterIdToUserKeyMappings = adapterIdToUserKeyMappings;
    }

    public Map<String, PluginToUserKeyAttrMapping> getValidatorIdToUserKeyMappings() {
        return this.validatorIdToUserKeyMappings;
    }

    public void setValidatorIdToUserKeyMappings(Map<String, PluginToUserKeyAttrMapping> validatorIdToUserKeyMappings) {
        this.validatorIdToUserKeyMappings = validatorIdToUserKeyMappings;
    }

    public Map<String, ApcToUserKeyAttrMapping> getApcIdToUserKeyMappings() {
        return this.apcIdToUserKeyMappings;
    }

    public void setApcIdToUserKeyMappings(Map<String, ApcToUserKeyAttrMapping> apcIdToUserKeyMappings) {
        this.apcIdToUserKeyMappings = apcIdToUserKeyMappings;
    }

    public Map<String, TeppToUserKeyAttrMapping> getTeppToUserKeyAttrMappings() {
        return this.teppToUserKeyAttrMappings;
    }

    public void setTeppToUserKeyAttrMappingMap(Map<String, TeppToUserKeyAttrMapping> teppToUserKeyAttrMappings) {
        this.teppToUserKeyAttrMappings = teppToUserKeyAttrMappings;
    }

    public List<PersistentGrantAttribute> getPersistentGrantExtendedAttributes() {
        return this.persistentGrantExtendedAttributes;
    }

    public void setPersistentGrantExtendedAttributes(List<PersistentGrantAttribute> persistentGrantExtendedAttributes) {
        this.persistentGrantExtendedAttributes = persistentGrantExtendedAttributes;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins == null ? new LinkedList<String>() : allowedOrigins;
    }

    public Map<String, ClientCredentialAccessTokenMapping> getClientCredsToAccessTokenMappings() {
        return this.clientCredsToAccessTokenMappings;
    }

    public void setClientCredsToAccessTokenMappings(Map<String, ClientCredentialAccessTokenMapping> clientCredsToAccessTokenMappings) {
        this.clientCredsToAccessTokenMappings = clientCredsToAccessTokenMappings;
    }

    public int getAuthzCodeTimeout() {
        return this.authzCodeTimeout;
    }

    public void setAuthzCodeTimeout(int authzCodeTimeout) {
        this.authzCodeTimeout = authzCodeTimeout;
    }

    public int getAuthzCodeLength() {
        return this.authzCodeLength;
    }

    public void setAuthzCodeLength(int authzCodeLength) {
        this.authzCodeLength = authzCodeLength;
    }

    public boolean isRestrictPlainPkce() {
        return this.restrictPlainPkce;
    }

    public void setRestrictPlainPkce(boolean restrictPlainPkce) {
        this.restrictPlainPkce = restrictPlainPkce;
    }

    public boolean isIncludeIssuerInAuthzResponse() {
        return this.includeIssuerInAuthzResponse;
    }

    public void setIncludeIssuerInAuthzResponse(boolean includeIssuerInAuthzResponse) {
        this.includeIssuerInAuthzResponse = includeIssuerInAuthzResponse;
    }

    public boolean isDefaultRefreshTokenRollingPolicy() {
        return this.defaultRefreshTokenRollingPolicy;
    }

    public void setDefaultRefreshTokenRollingPolicy(boolean defaultRefreshTokenRollingPolicy) {
        this.defaultRefreshTokenRollingPolicy = defaultRefreshTokenRollingPolicy;
    }

    public int getRefreshTokenRollingGracePeriod() {
        return this.refreshTokenRollingGracePeriod;
    }

    public void setRefreshTokenRollingGracePeriod(int refreshTokenRollingGracePeriod) {
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
    }

    public long getRefreshRollingInterval() {
        return this.refreshRollingInterval;
    }

    public void setRefreshRollingInterval(long refreshRollingInterval) {
        this.refreshRollingInterval = refreshRollingInterval;
    }

    public String getRefreshTokenRollingIntervalTimeUnit() {
        return this.refreshTokenRollingIntervalTimeUnit;
    }

    public void setRefreshTokenRollingIntervalTimeUnit(String refreshTokenRollingIntervalTimeUnit) {
        this.refreshTokenRollingIntervalTimeUnit = refreshTokenRollingIntervalTimeUnit;
    }

    public int getRefreshTokenLength() {
        return this.refreshTokenLength;
    }

    public void setRefreshTokenLength(int refreshTokenLength) {
        this.refreshTokenLength = refreshTokenLength;
    }

    public Set<String> getGrantTypesToReusePersistentGrants() {
        return this.grantTypesToReusePersistentGrants;
    }

    public void setGrantTypesToReusePersistentGrants(Set<String> grantTypesToReusePersistentGrants) {
        this.grantTypesToReusePersistentGrants = grantTypesToReusePersistentGrants;
    }

    public Set<String> getGrantTypesToAllowAutoAuthzForExistingPersistentGrants() {
        return this.grantTypesToAllowAutoAuthzForExistingPersistentGrants;
    }

    public void setGrantTypesToAllowAutoAuthzForExistingPersistentGrants(Set<String> grantTypesToAllowAutoAuthzForExistingPersistentGrants) {
        this.grantTypesToAllowAutoAuthzForExistingPersistentGrants = grantTypesToAllowAutoAuthzForExistingPersistentGrants;
    }

    public ConfigurablePluginInstance getAdminWsPcv() {
        return this.adminWsPcv;
    }

    public void setAdminWsPcv(ConfigurablePluginInstance adminWsPcv) {
        this.adminWsPcv = adminWsPcv;
    }

    public String getAtmIdForOAuthGrantManagement() {
        return this.atmIdForOAuthGrantManagement;
    }

    public void setAtmIdForOAuthGrantManagement(String atmIdForOAuthGrantManagement) {
        this.atmIdForOAuthGrantManagement = atmIdForOAuthGrantManagement;
    }

    public String getScopeForOAuthGrantManagement() {
        return this.scopeForOAuthGrantManagement;
    }

    public void setScopeForOAuthGrantManagement(String scopeForOAuthGrantManagement) {
        this.scopeForOAuthGrantManagement = scopeForOAuthGrantManagement;
    }

    public Long getGlobalPersistentGrantExpirationTime() {
        return this.globalPersistentGrantExpirationTime;
    }

    public void setGlobalPersistentGrantExpirationTime(Long globalPersistentGrantExpirationTime) {
        this.globalPersistentGrantExpirationTime = globalPersistentGrantExpirationTime;
    }

    public String getGlobalPersistentGrantExpirationTimeUnit() {
        return this.globalPersistentGrantExpirationTimeUnit;
    }

    public void setGlobalPersistentGrantExpirationTimeUnit(String globalPersistentGrantExpirationTimeUnit) {
        if ("min".equals(globalPersistentGrantExpirationTimeUnit)) {
            globalPersistentGrantExpirationTimeUnit = "n";
        }
        this.globalPersistentGrantExpirationTimeUnit = globalPersistentGrantExpirationTimeUnit;
    }

    public Long getGlobalPersistentGrantIdleTimeout() {
        return this.globalPersistentGrantIdleTimeout;
    }

    public void setGlobalPersistentGrantIdleTimeout(Long globalPersistentGrantIdleTimeout) {
        this.globalPersistentGrantIdleTimeout = globalPersistentGrantIdleTimeout;
    }

    public String getGlobalPersistentGrantIdleTimeoutTimeUnit() {
        return this.globalPersistentGrantIdleTimeoutTimeUnit;
    }

    public void setGlobalPersistentGrantIdleTimeoutTimeUnit(String globalPersistentGrantIdleTimeoutTimeUnit) {
        this.globalPersistentGrantIdleTimeoutTimeUnit = globalPersistentGrantIdleTimeoutTimeUnit;
    }

    public CorsSettings getCorsSettings() {
        return this.corsSettings;
    }

    public void setCorsSettings(CorsSettings corsSettings) {
        this.corsSettings = corsSettings;
    }

    public String getTokenEndpointBaseUrl() {
        return this.tokenEndpointBaseUrl;
    }

    public void setTokenEndpointBaseUrl(String tokenEndpointBaseUrl) {
        this.tokenEndpointBaseUrl = tokenEndpointBaseUrl;
    }

    public String getUserAuthzUrl() {
        return this.userAuthzUrl;
    }

    public void setUserAuthzUrl(String userAuthzUrl) {
        this.userAuthzUrl = userAuthzUrl;
    }

    public String getRegisteredAuthzPath() {
        return this.registeredAuthzPath;
    }

    public void setRegisteredAuthzPath(String registeredAuthzPath) {
        this.registeredAuthzPath = registeredAuthzPath;
    }

    public int getPendingAuthzTimeout() {
        return this.pendingAuthzTimeout;
    }

    public void setPendingAuthzTimeout(int pendingAuthzTimeout) {
        this.pendingAuthzTimeout = pendingAuthzTimeout;
    }

    public int getDevicePollingInterval() {
        return this.devicePollingInterval;
    }

    public void setDevicePollingInterval(int devicePollingInterval) {
        this.devicePollingInterval = devicePollingInterval;
    }

    public boolean isBypassActivationCodeConfirmation() {
        return this.bypassActivationCodeConfirmation;
    }

    public void setBypassActivationCodeConfirmation(boolean bypassActivationCodeConfirmation) {
        this.bypassActivationCodeConfirmation = bypassActivationCodeConfirmation;
    }

    public ActivationCodeCheckMode getActivationCodeCheckMode() {
        return this.activationCodeCheckMode;
    }

    public void setActivationCodeCheckMode(ActivationCodeCheckMode activationCodeCheckMode) {
        this.activationCodeCheckMode = activationCodeCheckMode;
    }

    public boolean isEnableCookielessUserAuthzAuthnApi() {
        return this.enableCookielessUserAuthzAuthnApi;
    }

    public void setEnableCookielessUserAuthzAuthnApi(boolean enableCookielessUserAuthzAuthnApi) {
        this.enableCookielessUserAuthzAuthnApi = enableCookielessUserAuthzAuthnApi;
    }

    public boolean isReturnIdTokenOnOpenIdWithDeviceAuthzGrant() {
        return this.returnIdTokenOnOpenIdWithDeviceAuthzGrant;
    }

    public void setReturnIdTokenOnOpenIdWithDeviceAuthzGrant(boolean returnIdTokenOnOpenIdWithDeviceAuthzGrant) {
        this.returnIdTokenOnOpenIdWithDeviceAuthzGrant = returnIdTokenOnOpenIdWithDeviceAuthzGrant;
    }

    public String getAuthzConsentSetting() {
        return this.authzConsentSetting;
    }

    public void setAuthzConsentSetting(String authzConsentSetting) {
        this.authzConsentSetting = authzConsentSetting;
    }

    public String getExternalConsentAdapterId() {
        return this.externalConsentAdapterId;
    }

    public void setExternalConsentAdapterId(String externalConsentAdapterId) {
        this.externalConsentAdapterId = externalConsentAdapterId;
    }

    public String getReturnedScopeAttributeName() {
        return this.returnedScopeAttributeName;
    }

    public void setReturnedScopeAttributeName(String returnedScopeAttributeName) {
        this.returnedScopeAttributeName = returnedScopeAttributeName;
    }

    public String getReturnedAuthorizationDetailsAttributeName() {
        return this.returnedAuthorizationDetailsAttributeName;
    }

    public void setReturnedAuthorizationDetailsAttributeName(String returnedAuthorizationDetailsAttributeName) {
        this.returnedAuthorizationDetailsAttributeName = returnedAuthorizationDetailsAttributeName;
    }

    public ParServerPolicy getParServerPolicy() {
        return this.parServerPolicy;
    }

    public void setParServerPolicy(ParServerPolicy parServerPolicy) {
        this.parServerPolicy = parServerPolicy;
    }

    public boolean isEnableOAuth() {
        return true;
    }

    public boolean isAllowUnidentifiedClientROCreds() {
        return this.allowUnidentifiedClientROCreds;
    }

    public void setAllowUnidentifiedClientROCreds(boolean allowUnidentifiedClientROCreds) {
        this.allowUnidentifiedClientROCreds = allowUnidentifiedClientROCreds;
    }

    public boolean isAllowUnidentifiedClientExtensionGrants() {
        return this.allowUnidentifiedClientExtensionGrants;
    }

    public void setAllowUnidentifiedClientExtensionGrants(boolean allowUnidentifiedClientExtensionGrants) {
        this.allowUnidentifiedClientExtensionGrants = allowUnidentifiedClientExtensionGrants;
    }

    public List<String> getDefaultUrlPatterns() {
        return Collections.unmodifiableList(DEFAULT_URL_PATTERNS);
    }

    public void setClientSecretRetentionPeriod(int clientSecretRetentionPeriod) {
        this.clientSecretRetentionPeriod = clientSecretRetentionPeriod;
    }

    public int getClientSecretRetentionPeriod() {
        return this.clientSecretRetentionPeriod;
    }

    public int getJwtSecuredAuthorizationResponseModeLifetime() {
        return this.jwtSecuredAuthorizationResponseModeLifetime;
    }

    public void setJwtSecuredAuthorizationResponseModeLifetime(int jwtSecuredAuthorizationResponseModeLifetime) {
        this.jwtSecuredAuthorizationResponseModeLifetime = jwtSecuredAuthorizationResponseModeLifetime;
    }

    public boolean isDpopProofRequireNonce() {
        return this.dpopProofRequireNonce;
    }

    public void setDpopProofRequireNonce(boolean dpopProofRequireNonce) {
        this.dpopProofRequireNonce = dpopProofRequireNonce;
    }

    public int getDpopProofLifetimeSeconds() {
        return this.dpopProofLifetimeSeconds;
    }

    public void setDpopProofLifetimeSeconds(int dpopProofLifetimeSeconds) {
        this.dpopProofLifetimeSeconds = dpopProofLifetimeSeconds;
    }

    public boolean isDpopProofEnforceReplayPrevention() {
        return this.dpopProofEnforceReplayPrevention;
    }

    public void setDpopProofEnforceReplayPrevention(boolean dpopProofEnforceReplayPrevention) {
        this.dpopProofEnforceReplayPrevention = dpopProofEnforceReplayPrevention;
    }

    public boolean isBypassAuthorizationForApprovedConsents() {
        return this.bypassAuthorizationForApprovedConsents;
    }

    public void setBypassAuthorizationForApprovedConsents(boolean bypassAuthorizationForApprovedConsents) {
        this.bypassAuthorizationForApprovedConsents = bypassAuthorizationForApprovedConsents;
    }

    public int getConsentLifetimeDays() {
        return this.consentLifetimeDays;
    }

    public void setConsentLifetimeDays(int consentLifetimeDays) {
        this.consentLifetimeDays = consentLifetimeDays;
    }

    public boolean isRequireOfflineAccessScopeToIssueRefreshTokens() {
        return this.requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public void setRequireOfflineAccessScopeToIssueRefreshTokens(boolean requireOfflineAccessScopeToIssueRefreshTokens) {
        this.requireOfflineAccessScopeToIssueRefreshTokens = requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public boolean isOfflineAccessRequireConsentPrompt() {
        return this.offlineAccessRequireConsentPrompt;
    }

    public void setOfflineAccessRequireConsentPrompt(boolean offlineAccessRequireConsentPrompt) {
        this.offlineAccessRequireConsentPrompt = offlineAccessRequireConsentPrompt;
    }
}

