/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.Sanitizer;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ClientAuthorizationDetailTypesSanitizer
implements Sanitizer<Client> {
    private final Set<String> availableAuthorizationDetailTypes = MgmtFactory.getAuthorizationDetailTypesManager().getTypes();

    @Override
    public Client sanitize(Client client) {
        if (client == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(client.getAuthorizationDetailTypes())) {
            client.setAuthorizationDetailTypes(client.getAuthorizationDetailTypes().stream().filter(this.availableAuthorizationDetailTypes::contains).collect(Collectors.toList()));
        }
        return client;
    }
}

