/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.google.common.base.Enums;
import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.unboundid.ldap.sdk.Filter;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.directory.api.util.GeneralizedTime;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AbstractClientManagerImpl;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientAuthorizationDetailTypesSanitizer;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientScopeSanitizer;
import org.sourceid.oauth20.domain.SupplementalInfoHelper;
import org.sourceid.openid.connect.domain.ClientRegistrationParameters;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.ClientManagerTranslator;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public abstract class ClientManagerBaseLdapImpl
extends AbstractClientManagerImpl {
    private static final Log log = LogFactory.getLog(ClientManagerBaseLdapImpl.class);
    private final ClientManagerTranslator translator = new ClientManagerTranslator();
    private static final int JWKS_ATTRIBUTE_SIZE = 8192;
    public static final String CONFIG_FILE_NAME = "org.sourceid.oauth20.domain.ClientManagerLdapImpl";
    public static final String OBJECTCLASS = "objectClass";
    public static final String OBJECT_CLASS_CLIENT_NAME = "clientObjectClass";
    public static final String OBJECT_CLASS_CLIENT_DEFAULT_VALUE = "pf-oauth-client";
    public static final String ATTRIBUTE_CREATE_TIMESTAMP = "createTimestamp";
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.oauth20.domain.ClientManagerLdapImpl");
    private final int SEARCH_FILTER_LIMIT = this.configStore.getIntValue("search-filter-limit", 1000);
    private String jndiName;
    private String searchBase;
    private String objectClassClient;
    private String attributeClientId;
    private String attributeClientName;
    private String attributeRefreshRolling;
    private String attributeLogoUrl;
    private String attributeHashedSecret;
    private String attributeDescription;
    private String attributePersistentGrantExpType;
    private String attributePersistentGrantExpTime;
    private String attributePersistentGrantExpTimeUnit;
    private String attributeBypassApprovalPage;
    private String attributeGrantType;
    private String attributeRedirectUri;
    private String attributeRestrictScopes;
    private String attributeRestrictedScopes;
    private String attributeLogoutUri;
    private String attributeAuthnType;
    private String attributeClientCertIssuerDn;
    private String attributeClientCertSubjectDn;
    private String attributeJwksUrl;
    private String attributeJwks;
    private String attributeEnforceReplayPrevention;
    private String attributeRequireSignedRequests;
    private String attributeLastModified;
    private String attributeSupplementalInfo;
    private int searchClientCount;

    ClientManagerBaseLdapImpl() {
        this.reload();
    }

    abstract int getSupplementalInfoAttributeSize();

    @Override
    public void reload() {
        super.reload();
        this.jndiName = this.configStore.getStringValue("PingFederateDSJNDIName", null);
        this.searchBase = this.configStore.getStringValue("SearchBase", "");
        this.searchClientCount = this.configStore.getIntValue("search-client-count", 2000);
        this.objectClassClient = this.configStore.getStringValue(OBJECT_CLASS_CLIENT_NAME, OBJECT_CLASS_CLIENT_DEFAULT_VALUE);
        this.attributeClientId = this.configStore.getStringValue(AttributeType.CLIENT_ID.getName(), AttributeType.CLIENT_ID.getDefaultValue());
        this.attributeClientName = this.configStore.getStringValue(AttributeType.CLIENT_NAME.getName(), AttributeType.CLIENT_NAME.getDefaultValue());
        this.attributeRefreshRolling = this.configStore.getStringValue(AttributeType.REFRESH_ROLLING.getName(), AttributeType.REFRESH_ROLLING.getDefaultValue());
        this.attributeLogoUrl = this.configStore.getStringValue(AttributeType.LOGO_URL.getName(), AttributeType.LOGO_URL.getDefaultValue());
        this.attributeHashedSecret = this.configStore.getStringValue(AttributeType.HASHED_SECRET.getName(), AttributeType.HASHED_SECRET.getDefaultValue());
        this.attributeDescription = this.configStore.getStringValue(AttributeType.DESCRIPTION.getName(), AttributeType.DESCRIPTION.getDefaultValue());
        this.attributePersistentGrantExpType = this.configStore.getStringValue(AttributeType.PERSISTENT_GRANT_EXP_TYPE.getName(), AttributeType.PERSISTENT_GRANT_EXP_TYPE.getDefaultValue());
        this.attributePersistentGrantExpTime = this.configStore.getStringValue(AttributeType.PERSISTENT_GRANT_EXP_TIME.getName(), AttributeType.PERSISTENT_GRANT_EXP_TIME.getDefaultValue());
        this.attributePersistentGrantExpTimeUnit = this.configStore.getStringValue(AttributeType.PERSISTENT_GRANT_EXP_TIME_UNIT.getName(), AttributeType.PERSISTENT_GRANT_EXP_TIME_UNIT.getDefaultValue());
        this.attributeBypassApprovalPage = this.configStore.getStringValue(AttributeType.BYPASS_APPROVAL_PAGE.getName(), AttributeType.BYPASS_APPROVAL_PAGE.getDefaultValue());
        this.attributeGrantType = this.configStore.getStringValue(AttributeType.GRANT_TYPE.getName(), AttributeType.GRANT_TYPE.getDefaultValue());
        this.attributeRedirectUri = this.configStore.getStringValue(AttributeType.REDIRECT_URI.getName(), AttributeType.REDIRECT_URI.getDefaultValue());
        this.attributeRestrictScopes = this.configStore.getStringValue(AttributeType.RESTRICT_SCOPES.getName(), AttributeType.RESTRICT_SCOPES.getDefaultValue());
        this.attributeRestrictedScopes = this.configStore.getStringValue(AttributeType.RESTRICTED_SCOPES.getName(), AttributeType.RESTRICTED_SCOPES.getDefaultValue());
        this.attributeLogoutUri = this.configStore.getStringValue(AttributeType.LOGOUT_URI.getName(), AttributeType.LOGOUT_URI.getDefaultValue());
        this.attributeAuthnType = this.configStore.getStringValue(AttributeType.AUTHN_TYPE.getName(), AttributeType.AUTHN_TYPE.getDefaultValue());
        this.attributeClientCertIssuerDn = this.configStore.getStringValue(AttributeType.CLIENT_CERT_ISSUER_DN.getName(), AttributeType.CLIENT_CERT_ISSUER_DN.getDefaultValue());
        this.attributeClientCertSubjectDn = this.configStore.getStringValue(AttributeType.CLIENT_CERT_SUBJECT_DN.getName(), AttributeType.CLIENT_CERT_SUBJECT_DN.getDefaultValue());
        this.attributeJwksUrl = this.configStore.getStringValue(AttributeType.JWKS_URL.getName(), AttributeType.JWKS_URL.getDefaultValue());
        this.attributeJwks = this.configStore.getStringValue(AttributeType.JWKS.getName(), AttributeType.JWKS.getDefaultValue());
        this.attributeEnforceReplayPrevention = this.configStore.getStringValue(AttributeType.ENFORCE_REPLAY_PREVENTION.getName(), AttributeType.ENFORCE_REPLAY_PREVENTION.getDefaultValue());
        this.attributeRequireSignedRequests = this.configStore.getStringValue(AttributeType.REQUIRE_SIGNED_REQUESTS.getName(), AttributeType.REQUIRE_SIGNED_REQUESTS.getDefaultValue());
        this.attributeLastModified = this.configStore.getStringValue(AttributeType.LAST_MODIFIED.getName(), AttributeType.LAST_MODIFIED.getDefaultValue());
        this.attributeSupplementalInfo = this.configStore.getStringValue(AttributeType.SUPPLEMENTAL_INFO.getName(), AttributeType.SUPPLEMENTAL_INFO.getDefaultValue());
        try {
            this.validateConfiguration();
        }
        catch (ClientManager.ClientManagementException e) {
            log.error((Object)e);
        }
    }

    public final void validateConfiguration() {
        if (StringUtils.isEmpty((String)this.jndiName)) {
            throw new ClientManager.ClientManagementException("The Client Management data store is not defined.");
        }
        if (StringUtils.isEmpty((String)this.objectClassClient)) {
            throw new ClientManager.ClientManagementException("The Client Management object class name is not defined.");
        }
    }

    public ConfigStore getConfigStore() {
        return this.configStore;
    }

    public LdapDataSource getLdapDataSource() {
        this.validateConfiguration();
        return MgmtFactory.getDataSourceManager().getLdapDataSource(this.jndiName);
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public String getObjectClassClient() {
        return this.objectClassClient;
    }

    public String getAttributeClientId() {
        return this.attributeClientId;
    }

    public String getAttributeClientName() {
        return this.attributeClientName;
    }

    public String getAttributeRefreshRolling() {
        return this.attributeRefreshRolling;
    }

    public String getAttributeLogoUrl() {
        return this.attributeLogoUrl;
    }

    public String getAttributeHashedSecret() {
        return this.attributeHashedSecret;
    }

    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    public String getAttributePersistentGrantExpType() {
        return this.attributePersistentGrantExpType;
    }

    public String getAttributePersistentGrantExpTime() {
        return this.attributePersistentGrantExpTime;
    }

    public String getAttributePersistentGrantExpTimeUnit() {
        return this.attributePersistentGrantExpTimeUnit;
    }

    public String getAttributeBypassApprovalPage() {
        return this.attributeBypassApprovalPage;
    }

    public String getAttributeGrantType() {
        return this.attributeGrantType;
    }

    public String getAttributeRedirectUri() {
        return this.attributeRedirectUri;
    }

    public String getAttributeRestrictScopes() {
        return this.attributeRestrictScopes;
    }

    public String getAttributeRestrictedScopes() {
        return this.attributeRestrictedScopes;
    }

    public String getAttributeLogoutUri() {
        return this.attributeLogoutUri;
    }

    public String getAttributeAuthnType() {
        return this.attributeAuthnType;
    }

    public String getAttributeClientCertIssuerDn() {
        return this.attributeClientCertIssuerDn;
    }

    public String getAttributeClientCertSubjectDn() {
        return this.attributeClientCertSubjectDn;
    }

    public String getAttributeJwksUrl() {
        return this.attributeJwksUrl;
    }

    public String getAttributeJwks() {
        return this.attributeJwks;
    }

    public String getAttributeEnforceReplayPrevention() {
        return this.attributeEnforceReplayPrevention;
    }

    public String getAttributeRequireSignedRequests() {
        return this.attributeRequireSignedRequests;
    }

    public String getAttributeLastModified() {
        return this.attributeLastModified;
    }

    public String getAttributeCreationTime() {
        return ATTRIBUTE_CREATE_TIMESTAMP;
    }

    public String getAttributeSupplementalInfo() {
        return this.attributeSupplementalInfo;
    }

    @Override
    public boolean isBackendDatabase() {
        return true;
    }

    @Override
    public boolean isDataSourceInUse(String datasourceId) {
        return datasourceId != null && datasourceId.equals(this.jndiName);
    }

    private List<Filter> getGrantTypeFilterList(SearchCriteria searchCriteria) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        for (String grantType : this.getTargetGrantTypeSet(searchCriteria.getFilterBy())) {
            filterList.add(Filter.createSubstringFilter((String)this.getAttributeGrantType(), null, (String[])new String[]{grantType}, null));
        }
        return filterList;
    }

    private List<Filter> getSupplementalInfoFilterList(SearchCriteria searchCriteria) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (searchCriteria.getFilterBy() != null) {
            searchCriteria.getFilterBy().forEach(filterItem -> {
                if (filterItem != null) {
                    switch (AbstractClientManagerImpl.FilterableField.valueOf(filterItem.getFieldName())) {
                        case CIBA_POLICY_ID: 
                        case DEFAULT_ATM_ID: 
                        case OIDC_POLICY_ID: 
                        case TEPP_ID: {
                            String attributeName = this.getAttributeName((SearchCriteria.FilterItem)filterItem);
                            if (attributeName == null) break;
                            String attributeValue = filterItem.getValue() == null ? null : filterItem.getValue().toString();
                            String encodedSupplementalValue = SupplementalInfoHelper.encode(attributeName, attributeValue);
                            filterList.add(Filter.createEqualityFilter((String)this.getAttributeSupplementalInfo(), (String)encodedSupplementalValue));
                            break;
                        }
                    }
                }
            });
        }
        return filterList;
    }

    private List<Filter> getOauthClientAttributeFilterList(SearchCriteria searchCriteria) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (searchCriteria.getFilterBy() != null) {
            searchCriteria.getFilterBy().forEach(filterItem -> {
                if (filterItem != null) {
                    switch (AbstractClientManagerImpl.FilterableField.valueOf(filterItem.getFieldName())) {
                        case CERT_ISSUER_ID: {
                            String attributeName = this.getAttributeName((SearchCriteria.FilterItem)filterItem);
                            if (attributeName == null) break;
                            if (filterItem.getValue() == null) {
                                Filter filterToNegate = Filter.createPresenceFilter((String)attributeName);
                                filterList.add(Filter.createNOTFilter((Filter)filterToNegate));
                                break;
                            }
                            filterList.add(Filter.createEqualityFilter((String)attributeName, (String)filterItem.getValue().toString()));
                            break;
                        }
                    }
                }
            });
        }
        return filterList;
    }

    private String getAttributeName(SearchCriteria.FilterItem filterItem) {
        if (filterItem != null) {
            switch (AbstractClientManagerImpl.FilterableField.valueOf(filterItem.getFieldName())) {
                case CIBA_POLICY_ID: {
                    return "CIBA_POLICY_ID";
                }
                case DEFAULT_ATM_ID: {
                    return "DEFAULT_ATM_ID";
                }
                case OIDC_POLICY_ID: {
                    return ClientRegistrationParameters.PING_POLICY_GROUP_ID;
                }
                case TEPP_ID: {
                    return "TOKEN_EXCHANGE_PROCESSOR_POLICY_ID";
                }
                case CERT_ISSUER_ID: {
                    return this.getAttributeClientCertIssuerDn();
                }
                case GRANT_TYPE: {
                    return this.getAttributeGrantType();
                }
            }
        }
        return null;
    }

    @Override
    public Client doGetClient(String clientId) {
        if (StringUtils.isBlank((String)clientId)) {
            return null;
        }
        try {
            String searchCriteria = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)OBJECTCLASS, (String)this.getObjectClassClient()), Filter.createEqualityFilter((String)this.getAttributeClientId(), (String)clientId)}).toString();
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.getSearchBase(), searchCriteria, 2);
            List<AttributeMap> result = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).getAttributesOfMatchingObjects(ldapOptions);
            if (!result.isEmpty()) {
                for (AttributeMap attributeMap : result) {
                    Client client = this.getClient(attributeMap);
                    if (!StringUtils.equals((String)client.getClientId(), (String)clientId)) continue;
                    return client;
                }
            }
            return null;
        }
        catch (NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
    }

    @Override
    public Collection<Client> doGetClients() {
        try {
            String searchCriteria = Filter.createEqualityFilter((String)OBJECTCLASS, (String)this.getObjectClassClient()).toString();
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.getSearchBase(), searchCriteria, 2);
            return this.fetchClients(ldapOptions);
        }
        catch (NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
    }

    @Override
    public Collection<String> getValidClients(List<String> clientIds) {
        if (clientIds == null || clientIds.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            HashSet<String> result = new HashSet<String>();
            for (int partition = 0; partition <= (clientIds.size() - 1) / this.SEARCH_FILTER_LIMIT; ++partition) {
                boolean isLastPartition = partition == (clientIds.size() - 1) / this.SEARCH_FILTER_LIMIT;
                Filter filter = Filter.createEqualityFilter((String)OBJECTCLASS, (String)this.getObjectClassClient());
                List clientFilters = clientIds.subList(partition * this.SEARCH_FILTER_LIMIT, isLastPartition ? clientIds.size() : (partition + 1) * this.SEARCH_FILTER_LIMIT).stream().map(clientId -> Filter.createEqualityFilter((String)this.getAttributeClientId(), (String)clientId)).collect(Collectors.toList());
                filter = Filter.createANDFilter((Filter[])new Filter[]{filter, Filter.createORFilter(clientFilters)});
                LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.getSearchBase(), filter.toString(), 2);
                ldapOptions.setAttributes(new String[]{this.getAttributeClientId()});
                this.fetchClients(ldapOptions).forEach(client -> result.add(client.getClientId()));
            }
            return result;
        }
        catch (NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
    }

    @Override
    public int getDatastoreSearchClientCount() {
        return this.searchClientCount;
    }

    public final Client getClient(AttributeMap attributeMap) {
        Client client = new Client();
        client.setClientId(attributeMap.getSingleValue(this.getAttributeClientId()));
        client.setName(attributeMap.getSingleValue(this.getAttributeClientName()));
        client.setRefreshRolling(attributeMap.getSingleValue(this.getAttributeRefreshRolling()));
        client.setLogoUrl(attributeMap.getSingleValue(this.getAttributeLogoUrl()));
        client.setEncodedSecret(attributeMap.getSingleValue(this.getAttributeHashedSecret()));
        client.setDescription(attributeMap.getSingleValue(this.getAttributeDescription()));
        client.setPersistentGrantExpirationType(attributeMap.getSingleValue(this.getAttributePersistentGrantExpType()));
        String attributePersistentGrantExpTime = attributeMap.getSingleValue(this.getAttributePersistentGrantExpTime());
        client.setPersistentGrantExpirationTime(attributePersistentGrantExpTime != null ? Long.parseLong(attributePersistentGrantExpTime) : 0L);
        String persistentGrantExpTimeUnit = attributeMap.getSingleValue(this.getAttributePersistentGrantExpTimeUnit());
        client.setPersistentGrantExpirationTimeUnit(persistentGrantExpTimeUnit != null ? persistentGrantExpTimeUnit : "d");
        client.setBypassApprovalPage(Boolean.parseBoolean(attributeMap.getSingleValue(this.getAttributeBypassApprovalPage())));
        if (attributeMap.get((Object)this.getAttributeGrantType()) != null) {
            client.setGrantTypes(((AttributeValue)attributeMap.get((Object)this.getAttributeGrantType())).getValuesAsHashSet());
        }
        if (attributeMap.get((Object)this.getAttributeRedirectUri()) != null) {
            client.setRedirectUris(new ArrayList<String>(((AttributeValue)attributeMap.get((Object)this.getAttributeRedirectUri())).getValuesAsCollection()));
        }
        client.setRestrictScopes(Boolean.parseBoolean(attributeMap.getSingleValue(this.getAttributeRestrictScopes())));
        if (attributeMap.get((Object)this.getAttributeRestrictedScopes()) != null) {
            client.setRestrictedScopes(new ArrayList<String>(((AttributeValue)attributeMap.get((Object)this.getAttributeRestrictedScopes())).getValuesAsCollection()));
        }
        if (attributeMap.get((Object)this.getAttributeLogoutUri()) != null) {
            client.setLogoutUris(new ArrayList<String>(((AttributeValue)attributeMap.get((Object)this.getAttributeLogoutUri())).getValuesAsCollection()));
        }
        if (attributeMap.get((Object)this.getAttributeAuthnType()) != null) {
            client.setClientAuthnType(ClientAuthenticationType.valueOf((String)attributeMap.getSingleValue(this.getAttributeAuthnType())));
        }
        client.setClientCertIssuerDn(attributeMap.getSingleValue(this.getAttributeClientCertIssuerDn()));
        client.setClientCertSubjectDn(attributeMap.getSingleValue(this.getAttributeClientCertSubjectDn()));
        client.setJwksUrl(attributeMap.getSingleValue(this.getAttributeJwksUrl()));
        String jwks = this.getJWKS((AttributeValue)attributeMap.get((Object)this.getAttributeJwks()));
        client.setJwks(jwks);
        client.setJsonWebKeys(this.getJsonWebKeySet(jwks));
        client.setEnforceReplayPrevention(Boolean.valueOf(attributeMap.getSingleValue(this.getAttributeEnforceReplayPrevention())));
        client.setRequireSignedRequests(Boolean.parseBoolean(attributeMap.getSingleValue(this.getAttributeRequireSignedRequests())));
        String lastModifiedValue = attributeMap.getSingleValue(this.getAttributeLastModified());
        if (StringUtils.isNotBlank((String)lastModifiedValue)) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(Long.parseLong(lastModifiedValue));
            client.setLastModified(cal);
        }
        this.getSupplementalInfo((AttributeValue)attributeMap.get((Object)this.getAttributeSupplementalInfo()), client);
        String creationTimeValue = attributeMap.getSingleValue(this.getAttributeCreationTime());
        if (StringUtils.isNotBlank((String)creationTimeValue)) {
            try {
                GeneralizedTime creationTime = new GeneralizedTime(creationTimeValue);
                client.setCreationTime(creationTime.getCalendar());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return client;
    }

    public final Attributes getAttributes(Client client) {
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClassAttr = new BasicAttribute(OBJECTCLASS);
        objectClassAttr.add("top");
        objectClassAttr.add(this.getObjectClassClient());
        attributes.put(objectClassAttr);
        attributes.put(new BasicAttribute(this.getAttributeClientId(), client.getClientId()));
        long lastModified = client.getLastModifiedDate() == null ? System.currentTimeMillis() : client.getLastModified().getTimeInMillis();
        attributes.put(new BasicAttribute(this.getAttributeLastModified(), String.valueOf(lastModified)));
        this.addStringAttribute(attributes, this.getAttributeClientName(), client.getName());
        this.addStringAttribute(attributes, this.getAttributeRefreshRolling(), client.getRefreshRolling());
        this.addStringAttribute(attributes, this.getAttributeLogoUrl(), client.getLogoUrl());
        this.addStringAttribute(attributes, this.getAttributeHashedSecret(), client.getEncodedSecret());
        this.addStringAttribute(attributes, this.getAttributeDescription(), client.getDescription());
        this.addStringAttribute(attributes, this.getAttributePersistentGrantExpType(), client.getPersistentGrantExpirationType());
        this.addStringAttribute(attributes, this.getAttributePersistentGrantExpTime(), client.getPersistentGrantExpirationTime() != null ? String.valueOf(client.getPersistentGrantExpirationTime()) : null);
        this.addStringAttribute(attributes, this.getAttributePersistentGrantExpTimeUnit(), client.getPersistentGrantExpirationTimeUnit());
        this.addStringAttribute(attributes, this.getAttributeBypassApprovalPage(), String.valueOf(client.isBypassApprovalPage()).toUpperCase());
        this.addCollectionAttributeIfNotEmpty(attributes, this.getAttributeGrantType(), client.getGrantTypes());
        this.addCollectionAttributeIfNotEmpty(attributes, this.getAttributeRedirectUri(), client.getRedirectUris());
        this.addStringAttribute(attributes, this.getAttributeRestrictScopes(), String.valueOf(client.isRestrictScopes()).toUpperCase());
        this.addCollectionAttributeIfNotEmpty(attributes, this.getAttributeRestrictedScopes(), client.isRestrictScopes() ? client.getRestrictedScopes() : null);
        this.addCollectionAttributeIfNotEmpty(attributes, this.getAttributeLogoutUri(), client.getLogoutUris());
        if (client.getClientAuthnType() != null) {
            attributes.put(new BasicAttribute(this.getAttributeAuthnType(), client.getClientAuthnType().toString()));
        }
        this.addStringAttribute(attributes, this.getAttributeClientCertIssuerDn(), client.getClientCertIssuerDn());
        this.addStringAttribute(attributes, this.getAttributeClientCertSubjectDn(), client.getClientCertSubjectDn());
        this.addStringAttribute(attributes, this.getAttributeJwksUrl(), client.getJwksUrl());
        this.setJWKS(attributes, this.getAttributeJwks(), client.getJwks());
        this.addStringAttribute(attributes, this.getAttributeEnforceReplayPrevention(), String.valueOf(Boolean.TRUE.equals(client.isEnforceReplayPrevention())).toUpperCase());
        this.addStringAttribute(attributes, this.getAttributeRequireSignedRequests(), String.valueOf(client.isRequireSignedRequests()).toUpperCase());
        this.setSupplementalInfo(attributes, this.getAttributeSupplementalInfo(), client);
        return attributes;
    }

    public final List<String> getSortBy(String orderBy) {
        AbstractClientManagerImpl.SORT_BY sort_by;
        if (orderBy != null && (sort_by = (AbstractClientManagerImpl.SORT_BY)((Object)Enums.getIfPresent(AbstractClientManagerImpl.SORT_BY.class, (String)orderBy).orNull())) != null) {
            switch (sort_by) {
                case Id: {
                    return Collections.singletonList(this.getAttributeClientId());
                }
                case Name: {
                    return Collections.singletonList(this.getAttributeClientName());
                }
                case ModificationTime: {
                    return Collections.singletonList(this.getAttributeLastModified());
                }
                case CreationTime: {
                    return Collections.singletonList(this.getAttributeCreationTime());
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public SearchResult<Client> search(SearchCriteria searchCriteria) {
        try {
            List<Filter> supplementalInfoFilterList;
            List<Filter> oauthClientAttributeFilterList;
            List<Filter> grantTypeFilterList;
            int fromIndex = searchCriteria.getStartIndex() + 1;
            Filter filter = Filter.createEqualityFilter((String)OBJECTCLASS, (String)this.getObjectClassClient());
            if (StringUtils.isNotBlank((String)searchCriteria.getQuery())) {
                String[] subAny = new String[]{searchCriteria.getQuery()};
                Filter idFilter = Filter.createSubstringFilter((String)this.getAttributeClientId(), null, (String[])subAny, null);
                Filter nameFilter = Filter.createSubstringFilter((String)this.getAttributeClientName(), null, (String[])subAny, null);
                filter = Filter.createANDFilter((Filter[])new Filter[]{filter, Filter.createORFilter((Filter[])new Filter[]{idFilter, nameFilter})});
            }
            if (!(grantTypeFilterList = this.getGrantTypeFilterList(searchCriteria)).isEmpty()) {
                filter = Filter.createANDFilter((Filter[])new Filter[]{filter, Filter.createORFilter(grantTypeFilterList)});
            }
            if (!(oauthClientAttributeFilterList = this.getOauthClientAttributeFilterList(searchCriteria)).isEmpty()) {
                filter = Filter.createANDFilter((Filter[])new Filter[]{filter, Filter.createANDFilter(oauthClientAttributeFilterList)});
            }
            if (!(supplementalInfoFilterList = this.getSupplementalInfoFilterList(searchCriteria)).isEmpty()) {
                filter = Filter.createANDFilter((Filter[])new Filter[]{filter, Filter.createANDFilter(supplementalInfoFilterList)});
            }
            String ldapSearchCriteria = filter.toString();
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.getSearchBase(), ldapSearchCriteria, 2);
            ldapOptions.setStartIndex(fromIndex);
            ldapOptions.setResultsPerPage(searchCriteria.getItemsRequested());
            ldapOptions.setSortBy(this.getSortBy(searchCriteria.getOrderBy()));
            ldapOptions.setSortReverseOrder(SearchCriteria.Order.DESC.equals((Object)searchCriteria.getOrder()));
            ldapOptions.setRetrieveLastElement(false);
            Collection<Client> searchResults = this.fetchClients(ldapOptions);
            return new SearchResult<Client>(searchCriteria.getStartIndex(), new ArrayList<Client>(searchResults));
        }
        catch (NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
    }

    public final Collection<Client> fetchClients(LDAPUtilOptions ldapOptions) throws NamingException {
        ClientScopeSanitizer clientScopeSanitizer = new ClientScopeSanitizer();
        ClientAuthorizationDetailTypesSanitizer clientAuthorizationDetailTypesSanitizer = new ClientAuthorizationDetailTypesSanitizer();
        return LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).getAttributesOfMatchingObjects(ldapOptions).parallelStream().map(this::getClient).map(c -> this.doSanitize((Client)c, clientScopeSanitizer, clientAuthorizationDetailTypesSanitizer)).collect(Collectors.toList());
    }

    public final void setAuditLogParams() {
        AsAuditLogger.setDescription("LDAP Exception");
        AuditLogger.setStatus("failure");
    }

    private void addStringAttribute(Attributes attributes, String name, String value) {
        BasicAttribute attribute = new BasicAttribute(name);
        if (StringUtils.isNotBlank((String)value)) {
            attribute.add(value);
        }
        attributes.put(attribute);
    }

    private <T> void addCollectionAttributeIfNotEmpty(Attributes attributes, String name, Collection<T> value) {
        BasicAttribute restrictedScopesAttribute = new BasicAttribute(name);
        if (value != null) {
            for (T t : value) {
                restrictedScopesAttribute.add(t);
            }
        }
        attributes.put(restrictedScopesAttribute);
    }

    private String getJWKS(AttributeValue jwksAttributeValue) {
        if (jwksAttributeValue != null && !jwksAttributeValue.getValuesAsCollection().isEmpty()) {
            if (!jwksAttributeValue.isMultiValue()) {
                String encodedJwks = jwksAttributeValue.getValue();
                if (StringUtils.isNotBlank((String)encodedJwks)) {
                    return Base64URL.decodeToString((String)encodedJwks, (String)StandardCharsets.UTF_8.name());
                }
            } else {
                CharSequence[] values = new String[jwksAttributeValue.getValuesAsCollection().size()];
                for (String chunk : jwksAttributeValue.getValues()) {
                    String[] split = chunk.split(":");
                    int i = Integer.parseInt(split[0]);
                    values[i] = split[1];
                }
                String encodedJwks = String.join((CharSequence)"", values);
                return Base64URL.decodeToString((String)encodedJwks, (String)StandardCharsets.UTF_8.name());
            }
        }
        return null;
    }

    private void setJWKS(Attributes attributes, String name, String jwksValue) {
        if (StringUtils.isNotBlank((String)jwksValue)) {
            BasicAttribute jwksAttribute = new BasicAttribute(name);
            String encodedJwks = Base64URL.encodeToString((byte[])Util.utf8bytes(jwksValue));
            int encodedJwksLength = encodedJwks.length();
            if (encodedJwksLength < 8192) {
                jwksAttribute.add(encodedJwks);
            } else {
                int bufferForIndexStorage = 4;
                int chunkSize = 8192 - bufferForIndexStorage;
                int chunks = encodedJwksLength / chunkSize + 1;
                for (int i = 0; i < chunks; ++i) {
                    int beginIndex = i * chunkSize;
                    int endIndex = (i + 1) * chunkSize;
                    if (endIndex >= encodedJwksLength) {
                        endIndex = encodedJwksLength;
                    }
                    String attributeValue = String.format("%03d:%s", i, encodedJwks.substring(beginIndex, endIndex));
                    jwksAttribute.add(attributeValue);
                }
            }
            attributes.put(jwksAttribute);
        } else {
            attributes.put(new BasicAttribute(name));
        }
    }

    private void getSupplementalInfo(AttributeValue supplementalInfoAttributeValue, Client client) {
        if (supplementalInfoAttributeValue != null) {
            List<String> values = StreamSupport.stream(supplementalInfoAttributeValue.getValues().spliterator(), false).collect(Collectors.toList());
            for (Map.Entry<String, String> entry : SupplementalInfoHelper.decode(values).entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                client.setSupplementalInfo(key, this.isStringEmptyOrNullValue(value) ? null : value);
            }
        }
        this.translator.copyExtendedParamsFromSupplementalInfo(client);
    }

    private void setSupplementalInfo(Attributes attributes, String name, Client client) {
        Map<String, String> supplementalInfo = client.getSupplementalInfo();
        this.translator.copyExtendedParamsToSupplementalInfo(client);
        if (supplementalInfo != null && !supplementalInfo.isEmpty()) {
            BasicAttribute supplementalInfoAttribute = new BasicAttribute(name);
            for (Map.Entry<String, String> entry : supplementalInfo.entrySet()) {
                List<String> encoded = SupplementalInfoHelper.encode(entry.getKey(), entry.getValue(), this.getSupplementalInfoAttributeSize());
                for (String attr : encoded) {
                    supplementalInfoAttribute.add(attr);
                }
            }
            attributes.put(supplementalInfoAttribute);
        }
    }

    private List<JsonWebKey> getJsonWebKeySet(String jwks) {
        try {
            if (StringUtils.isNotBlank((String)jwks)) {
                return new JsonWebKeySet(jwks).getJsonWebKeys();
            }
        }
        catch (JoseException e) {
            log.error((Object)e.getMessage());
            log.debug((Object)e.getStackTrace());
        }
        return Collections.emptyList();
    }

    private boolean isStringEmptyOrNullValue(String input) {
        return StringUtils.isEmpty((String)input) || "NULL".equals(input.toUpperCase());
    }

    public static enum AttributeType {
        CLIENT_ID("clientId", "pf-oauth-client-id"),
        CLIENT_NAME("clientName", "pf-oauth-client-name"),
        REFRESH_ROLLING("refreshRolling", "pf-oauth-client-refresh-rolling"),
        LOGO_URL("logoUrl", "pf-oauth-client-logo-url"),
        HASHED_SECRET("hashedSecret", "pf-oauth-client-hashed-secret"),
        DESCRIPTION("description", "pf-oauth-client-description"),
        PERSISTENT_GRANT_EXP_TYPE("persistentGrantExpType", "pf-oauth-client-persistent-grant-exp-type"),
        PERSISTENT_GRANT_EXP_TIME("persistentGrantExpTime", "pf-oauth-client-persistent-grant-exp-time"),
        PERSISTENT_GRANT_EXP_TIME_UNIT("persistentGrantExpTimeUnit", "pf-oauth-client-persistent-grant-exp-time-unit"),
        BYPASS_APPROVAL_PAGE("bypassApprovalPage", "pf-oauth-client-bypass-approval-page"),
        GRANT_TYPE("grantType", "pf-oauth-client-grant-type"),
        REDIRECT_URI("redirectUri", "pf-oauth-client-redirect-uri"),
        RESTRICT_SCOPES("restrictScopes", "pf-oauth-client-restrict-scopes"),
        RESTRICTED_SCOPES("restrictedScopes", "pf-oauth-client-restricted-scopes"),
        LOGOUT_URI("logoutUri", "pf-oauth-client-logout-uri"),
        AUTHN_TYPE("authnType", "pf-oauth-client-authn-type"),
        CLIENT_CERT_ISSUER_DN("clientCertIssuerDn", "pf-oauth-client-client-cert-issuer-dn"),
        CLIENT_CERT_SUBJECT_DN("clientCertSubjectDn", "pf-oauth-client-client-cert-subject-dn"),
        JWKS_URL("jwksUrl", "pf-oauth-client-jwks-url"),
        JWKS("jwks", "pf-oauth-client-jwks"),
        ENFORCE_REPLAY_PREVENTION("enforceReplayPrevention", "pf-oauth-client-enforce-replay-prevention"),
        REQUIRE_SIGNED_REQUESTS("requireSignedRequests", "pf-oauth-client-require-signed-requests"),
        LAST_MODIFIED("lastModified", "pf-oauth-client-last-modified"),
        SUPPLEMENTAL_INFO("supplementalInfo", "pf-oauth-client-supplemental-info");

        private final String name;
        private final String defaultValue;

        private AttributeType(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

