/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.google.common.base.Enums;
import com.pingidentity.sdk.SearchCriteria;
import com.pingidentity.sdk.oauth20.ClientData;
import com.pingidentity.sdk.oauth20.ClientStorageManagementException;
import com.pingidentity.sdk.oauth20.ClientStorageManager;
import com.pingidentity.sdk.oauth20.ClientStorageManagerV2;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.oauth.client.xmlbinding.ClientDocument;
import org.sourceid.oauth.client.xmlbinding.ClientType;
import org.sourceid.oauth20.domain.AbstractClientManagerImpl;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthorizationDetailTypesSanitizer;
import org.sourceid.oauth20.domain.ClientFieldsSanitizer;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientScopeSanitizer;
import org.sourceid.oauth20.domain.DelegatingClientStorageManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.ClientManagerTranslator;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class ClientManagerGenericImpl
extends AbstractClientManagerImpl {
    private static ClientStorageManagerV2 CLIENT_STORAGE_MANAGERV2;
    private static final Log log;
    private ClientManagerTranslator translator = new ClientManagerTranslator();

    @Override
    public Client doGetClient(String clientId) {
        ClientData clientData;
        Client client = null;
        try {
            clientData = CLIENT_STORAGE_MANAGERV2.getClient(clientId);
        }
        catch (ClientStorageManagementException e) {
            this.setAuditLogParams();
            throw new ClientManager.ClientManagementException(e.getMessage(), e.getCause());
        }
        if (clientData != null) {
            client = this.getClient(clientData);
        }
        return this.doSanitize(client, new ClientScopeSanitizer(), new ClientFieldsSanitizer(), new ClientAuthorizationDetailTypesSanitizer());
    }

    @Override
    public Collection<Client> doGetClients() {
        Collection clientDataCollection;
        ArrayList<Client> clients = new ArrayList<Client>();
        try {
            clientDataCollection = CLIENT_STORAGE_MANAGERV2.getClients();
        }
        catch (ClientStorageManagementException e) {
            this.setAuditLogParams();
            throw new ClientManager.ClientManagementException(e.getMessage(), e.getCause());
        }
        for (ClientData clientData : clientDataCollection) {
            Client client = this.getClient(clientData);
            clients.add(client);
        }
        return clients;
    }

    @Override
    public void doAddClient(Client client) {
        try {
            XmlCalendar date = new XmlCalendar(new Date());
            client.setLastModified((Calendar)date);
            client.setCreationTime((Calendar)date);
            ClientData clientData = this.getClientData(client);
            CLIENT_STORAGE_MANAGERV2.addClient(clientData);
        }
        catch (ClientStorageManagementException e) {
            this.setAuditLogParams();
            throw new ClientManager.ClientManagementException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new ClientManager.ClientManagementException("Error converting client to clientData", e.getCause());
        }
    }

    @Override
    public void doAddClients(Collection<Client> clients) {
        for (Client client : clients) {
            try {
                XmlCalendar date = new XmlCalendar(new Date());
                client.setLastModified((Calendar)date);
                client.setCreationTime((Calendar)date);
                ClientData clientData = this.getClientData(client);
                CLIENT_STORAGE_MANAGERV2.addClient(clientData);
            }
            catch (ClientStorageManagementException e) {
                this.setAuditLogParams();
                throw new ClientManager.ClientManagementException(e.getMessage(), e.getCause());
            }
            catch (Exception e) {
                throw new ClientManager.ClientManagementException("Error converting client to clientData", e.getCause());
            }
        }
    }

    @Override
    protected void doDeleteClient(String clientId) {
        try {
            CLIENT_STORAGE_MANAGERV2.deleteClient(clientId);
        }
        catch (ClientStorageManagementException e) {
            this.setAuditLogParams();
            throw new ClientManager.ClientManagementException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public Client doUpdateClient(Client client) {
        Client updatedClient;
        client.setLastModified((Calendar)new XmlCalendar(new Date()));
        try {
            ClientData clientData = this.getClientData(client);
            CLIENT_STORAGE_MANAGERV2.updateClient(clientData);
            ClientData updatedClientData = CLIENT_STORAGE_MANAGERV2.getClient(client.getClientId());
            updatedClient = this.getClient(updatedClientData);
        }
        catch (ClientStorageManagementException e) {
            this.setAuditLogParams();
            throw new ClientManager.ClientManagementException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new ClientManager.ClientManagementException(e.getMessage(), e.getCause());
        }
        return updatedClient;
    }

    @Override
    public int getClientCount() {
        return -1;
    }

    @Override
    public boolean isDataSourceInUse(String datasourceId) {
        return false;
    }

    @Override
    public int getDatastoreSearchClientCount() {
        return -1;
    }

    @Override
    public boolean isBackendDatabase() {
        return true;
    }

    public Client getClient(ClientData clientData) {
        ClientDocument clientDoc = this.translator.clientDataToClientDocument(clientData);
        ClientType xmlClient = clientDoc.getClient();
        Client client = this.translator.clientFromXmlClient(xmlClient);
        client.setPersistentGrantExpirationTime(this.translator.getPersistentGrantExpirationTimeValueToStore(client));
        return this.doSanitize(client, new ClientScopeSanitizer(), new ClientFieldsSanitizer(), new ClientAuthorizationDetailTypesSanitizer());
    }

    @Override
    public Client getCachedClient(String clientId) {
        try {
            return clientId != null ? (Client)((Optional)this.engineClientsCache.get((Object)clientId)).orElse(null) : null;
        }
        catch (ExecutionException e) {
            throw new ClientManager.ClientManagementException(e.getCause());
        }
    }

    private ClientData getClientData(Client client) {
        ClientDocument clientDoc = ClientDocument.Factory.newInstance();
        ClientType xmlClient = clientDoc.addNewClient();
        this.translator.fillXmClientFromClient(xmlClient, client);
        return this.translator.clientDocumentToClientData(client.getClientId(), client.getName(), client.getLastModified().getTime(), client.getCreationTime().getTime(), clientDoc);
    }

    private void setAuditLogParams() {
        AsAuditLogger.setDescription("Database Exception");
        AuditLogger.setStatus("failure");
    }

    @Override
    public SearchResult<Client> search(org.sourceid.util.domain.SearchCriteria searchCriteria) {
        try {
            Collection searchResults = CLIENT_STORAGE_MANAGERV2.search(this.convertClientSearchCriteria(searchCriteria));
            List<Client> searchResultsClient = searchResults.stream().map(this::getClient).collect(Collectors.toList());
            Collection<Client> clients = this.filterClientCollectionByFilterFields(searchResultsClient, searchCriteria);
            return new SearchResult<Client>(searchCriteria.getStartIndex(), new ArrayList<Client>(clients));
        }
        catch (ClientStorageManagementException e) {
            throw new ClientManager.ClientManagementException("Failed to search clients.", e);
        }
    }

    private SearchCriteria convertClientSearchCriteria(org.sourceid.util.domain.SearchCriteria searchCriteria) {
        SearchCriteria criteria = new SearchCriteria.Builder(searchCriteria.getStartIndex(), searchCriteria.getItemsRequested()).query(searchCriteria.getQuery()).build();
        if (StringUtils.isNotBlank((String)searchCriteria.getOrderBy())) {
            criteria.addOrderBy(new SearchCriteria.OrderByItem(this.getSortFieldName(searchCriteria.getOrderBy()), this.getOrder(searchCriteria.getOrder())));
        }
        return criteria;
    }

    private SearchCriteria.Order getOrder(SearchCriteria.Order order) {
        switch (order) {
            case ASC: {
                return SearchCriteria.Order.ASC;
            }
            case DESC: {
                return SearchCriteria.Order.DESC;
            }
        }
        throw new IllegalArgumentException("Invalid order: " + order);
    }

    private String getSortFieldName(String orderBy) {
        AbstractClientManagerImpl.SORT_BY sort_by = (AbstractClientManagerImpl.SORT_BY)((Object)Enums.getIfPresent(AbstractClientManagerImpl.SORT_BY.class, (String)orderBy).orNull());
        if (sort_by != null) {
            switch (sort_by) {
                case Id: {
                    return "CLIENT_ID";
                }
                case Name: {
                    return "CLIENT_NAME";
                }
                case ModificationTime: {
                    return "LAST_MODIFIED_DATE";
                }
                case CreationTime: {
                    return "CREATION_DATE";
                }
            }
        }
        throw new IllegalArgumentException("Invalid field Name;" + orderBy);
    }

    static {
        log = LogFactory.getLog(ClientManagerGenericImpl.class);
        try {
            CLIENT_STORAGE_MANAGERV2 = MgmtFactory.getClientStorageManagerV2();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to getClientStorageManagerV2. Attempting to get ClientStorageManager");
            ClientStorageManager v1Instance = MgmtFactory.getClientStorageManager();
            CLIENT_STORAGE_MANAGERV2 = new DelegatingClientStorageManager(v1Instance);
        }
    }
}

