/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AbstractClientManagerImpl;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthorizationDetailTypesSanitizer;
import org.sourceid.oauth20.domain.ClientFieldsSanitizer;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientManagerLdapADImpl;
import org.sourceid.oauth20.domain.ClientManagerLdapOracleImpl;
import org.sourceid.oauth20.domain.ClientManagerLdapPingDSImpl;
import org.sourceid.oauth20.domain.ClientManagerLdapPingDirectoryImpl;
import org.sourceid.oauth20.domain.ClientScopeSanitizer;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;

public final class ClientManagerLdapImpl
extends AbstractClientManagerImpl {
    private static final Log log = LogFactory.getLog(ClientManagerLdapImpl.class);
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.oauth20.domain.ClientManagerLdapImpl");
    private ClientManager clientManager;

    public ClientManagerLdapImpl() {
        this.reload();
    }

    @Override
    public synchronized void reload() {
        super.reload();
        String jndiName = this.configStore.getStringValue("PingFederateDSJNDIName", null);
        if (StringUtils.isBlank((String)jndiName) || MgmtFactory.getDataSourceManager().getLdapDataSource(jndiName) == null) {
            log.error((Object)"Invalid \"PingFederateDSJNDIName\" configuration value, please verify the configuration and try again.");
        } else {
            LdapDataSource ldapDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(jndiName);
            if (ldapDataSource != null) {
                LdapInfo.LdapType ldapType = ldapDataSource.getLdapType();
                switch (ldapType) {
                    case PingDirectory: {
                        this.clientManager = new ClientManagerLdapPingDirectoryImpl();
                        break;
                    }
                    case PingDS: {
                        this.clientManager = new ClientManagerLdapPingDSImpl();
                        break;
                    }
                    case ActiveDirectory: {
                        this.clientManager = new ClientManagerLdapADImpl();
                        break;
                    }
                    case SunDirectoryServer: 
                    case OracleUnifiedDirectory: {
                        this.clientManager = new ClientManagerLdapOracleImpl();
                        break;
                    }
                    default: {
                        String message = String.format("%s is an unsupported LDAP datastore for Client storage, please change your configuration to a supported datastore.", ldapType);
                        log.error((Object)message);
                    }
                }
                if (ldapDataSource.isGatewayEnabled()) {
                    log.warn((Object)"LDAP Data Source is a PingOne Gateway enabled data source which is an UNSUPPORTED configuration.");
                }
            }
        }
    }

    @Override
    public Client getCachedClient(String clientId) {
        try {
            return clientId != null ? (Client)((Optional)this.engineClientsCache.get((Object)clientId)).orElse(null) : null;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new ClientManager.ClientManagementException(e.getCause());
        }
    }

    private void validateConfiguration() {
        if (this.clientManager == null) {
            throw new ClientManager.ClientManagementException("Client manager is not initialized, please verify the configuration and try again.");
        }
    }

    @Override
    public Client getClient(String clientId) {
        this.validateConfiguration();
        return this.doSanitize(this.clientManager.getClient(clientId), new ClientScopeSanitizer(), new ClientFieldsSanitizer(), new ClientAuthorizationDetailTypesSanitizer());
    }

    @Override
    protected Client doGetClient(String clientId) {
        throw new UnsupportedOperationException("This method cannot be executed");
    }

    @Override
    public Collection<Client> getClients() {
        this.validateConfiguration();
        return this.clientManager.getClients();
    }

    @Override
    public Collection<Client> doGetClients() {
        throw new UnsupportedOperationException("This method cannot be executed");
    }

    @Override
    public Collection<String> getValidClients(List<String> clientIds) {
        this.validateConfiguration();
        return this.clientManager.getValidClients(clientIds);
    }

    @Override
    public void addClient(Client client) {
        this.validateConfiguration();
        this.clientManager.addClient(client);
    }

    @Override
    public void doAddClient(Client client) {
    }

    @Override
    public void addClients(Collection<Client> clients) {
        this.validateConfiguration();
        this.clientManager.addClients(clients);
    }

    @Override
    protected void doAddClients(Collection<Client> clients) {
    }

    @Override
    public void deleteClient(String clientId) {
        this.validateConfiguration();
        this.clientManager.deleteClient(clientId);
    }

    @Override
    protected void doDeleteClient(String clientId) {
    }

    @Override
    public Client updateClient(Client client) {
        this.validateConfiguration();
        return this.clientManager.updateClient(client);
    }

    @Override
    protected Client doUpdateClient(Client client) {
        throw new UnsupportedOperationException("This method cannot be executed");
    }

    @Override
    public boolean isDataSourceInUse(String datasourceId) {
        return this.clientManager != null && this.clientManager.isDataSourceInUse(datasourceId);
    }

    @Override
    public int getDatastoreSearchClientCount() {
        this.validateConfiguration();
        return ((AbstractClientManagerImpl)this.clientManager).getDatastoreSearchClientCount();
    }

    @Override
    public boolean isBackendDatabase() {
        return true;
    }

    @Override
    public SearchResult<Client> search(SearchCriteria searchCriteria) {
        this.validateConfiguration();
        return this.clientManager.search(searchCriteria);
    }
}

