/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.jdbc.WarningsForHsqlDb;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.oauth.client.xmlbinding.ClientType;
import org.sourceid.oauth.client.xmlbinding.ClientsDocument;
import org.sourceid.oauth.client.xmlbinding.ClientsType;
import org.sourceid.oauth20.domain.AbstractClientManagerImpl;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthorizationDetailTypesSanitizer;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientScopeSanitizer;
import org.sourceid.oauth20.domain.NewClientFile;
import org.sourceid.oauth20.domain.OAuthClientIndexDb;
import org.sourceid.oauth20.domain.OAuthClientIndexDbEntry;
import org.sourceid.saml20.domain.ReplicationRecord;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.SelectiveReplicationClientValidator;
import org.sourceid.saml20.state.SizeLimitProps;
import org.sourceid.util.ClientManagerTranslator;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class ClientManagerXmlFileImpl
extends AbstractClientManagerImpl {
    private static final Log log = LogFactory.getLog(ClientManagerXmlFileImpl.class);
    private ClientManagerTranslator translator = new ClientManagerTranslator();
    private static final String XML_EXTENSION = ".xml";
    private static final String EXTENSION = ".xml";
    private static final String CFG_CLIENTS_PER_DIRECTORY = "ClientsPerDirectory";
    private static final String CFG_MIGRATION_COMPLETE_8_4 = "MigrationComplete8.4";
    private static final String DELTA_REPLICATION_STATE_FILE_NAME = "clients-delta-repl-state.json";
    private ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.oauth20.domain.ClientManagerXmlFileImpl");
    private XmlLoader xmlLoader;
    private String clientsDirectory;
    private int maxSizeClientsMap;
    private ObjectMapper objectMapper;
    private Map<String, Client> clientsMap = new ClientMap<Client>();
    private boolean allClientsLoaded = false;
    private OAuthClientIndexDb oauthClientIndexDb = MgmtFactory.getOAuthClientIndexDb();
    private DeltaReplicationState deltaReplState;

    public ClientManagerXmlFileImpl(SysDirInfo sysDirInfo, XmlLoader xmlLoader) {
        this.objectMapper = this.makeObjectMapper();
        this.xmlLoader = xmlLoader;
        this.clientsDirectory = sysDirInfo.getDataDirectory() + File.separator + "oauth-clients";
        SizeLimitProps config = new SizeLimitProps();
        this.maxSizeClientsMap = config.getClientManagerMaxSizeClientsMap();
        this.reload();
    }

    @Override
    public synchronized Client doGetClient(String clientId) {
        Client client = this.clientsMap.get(clientId);
        if (client == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Client: " + clientId + " not in cache. Attempting to load."));
            }
            this.loadClientFromStore(clientId);
            client = this.clientsMap.get(clientId);
        }
        return client;
    }

    protected synchronized void loadAllClientsFromStore() {
        log.debug((Object)"Loading all clients...");
        Collection<OAuthClientIndexDbEntry> entries = this.oauthClientIndexDb.getAllEntries();
        int clientsLoaded = 0;
        for (OAuthClientIndexDbEntry entry : entries) {
            this.loadClient(entry);
            if (++clientsLoaded % 1000 != 0) continue;
            log.debug((Object)("Loaded " + clientsLoaded + " clients"));
        }
        log.debug((Object)("Finished loading clients, total clients loaded = " + clientsLoaded));
    }

    @Override
    public synchronized Collection<Client> getClients() {
        this.loadAllClients();
        ArrayList<Client> collCopy = new ArrayList<Client>(this.clientsMap.size());
        collCopy.addAll(this.clientsMap.values());
        return collCopy;
    }

    @Override
    public Collection<Client> doGetClients() {
        throw new UnsupportedOperationException("This method cannot be executed");
    }

    protected synchronized void loadAllClients() {
        if (!this.allClientsLoaded) {
            this.allClientsLoaded = true;
            this.loadAllClientsFromStore();
        }
    }

    @Override
    public synchronized int getClientCount() {
        Collection<OAuthClientIndexDbEntry> entries = this.oauthClientIndexDb.getAllEntries();
        return entries.size();
    }

    @Override
    public synchronized void addClient(Client client) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.addClients(Collections.singletonList(client));
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_CLIENTS, AdminAuditLogger.Event.CREATE, client.getClientId());
        }
    }

    @Override
    public void doAddClient(Client client) {
        throw new UnsupportedOperationException("This method cannot be executed");
    }

    @Override
    public synchronized void addClients(Collection<Client> clients) {
        for (Client client : clients) {
            if (this.oauthClientIndexDb.getEntry(client.getClientId()) != null) {
                this.setAuditLogParams();
                throw new ClientManager.ClientManagementException("Error adding client. Client with ID " + client.getClientId() + " already exists");
            }
            XmlCalendar date = new XmlCalendar(new Date());
            client.setCreationTime((Calendar)date);
            client.setLastModified((Calendar)date);
            this.saveClient(client);
        }
        MgmtFactory.getSingleThreadedExecutor().execute(() -> WarningsForHsqlDb.getInstance().logWarningsForHsqlDbUse());
    }

    @Override
    protected void doAddClients(Collection<Client> clients) {
        throw new UnsupportedOperationException("This method cannot be executed");
    }

    @Override
    protected synchronized void doDeleteClient(String clientId) {
        if (this.oauthClientIndexDb.getEntry(clientId) == null) {
            this.setAuditLogParams();
            throw new ClientManager.ClientNonexistentException("Error deleting client. Client " + clientId + " not found");
        }
        try {
            this.deleteClientFromStore(clientId, true);
        }
        catch (Exception e) {
            String message = "Error deleting client " + clientId;
            log.error((Object)message, (Throwable)e);
            this.setAuditLogParams();
            throw new ClientManager.ClientManagementException(message, e);
        }
        this.clientsMap.remove(clientId);
        MgmtFactory.getSingleThreadedExecutor().execute(() -> WarningsForHsqlDb.getInstance().logWarningsForHsqlDbUse());
        this.checkAndPerformSelectiveDelete(clientId);
    }

    private void checkAndPerformSelectiveDelete(String clientId) {
        if (this.selectiveReplicationEnabled()) {
            ReplicationRecord deleteRecord = this.createPartialReplicationForClientDelete(clientId);
            MgmtFactory.getMediator().applySelectiveReplicationRecords(Collections.singletonList(deleteRecord), this);
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                auditLoggerScope.log(AdminAuditLogger.Component.CLUSTER_MANAGEMENT, AdminAuditLogger.Event.SELECTIVE_REPLICATE, clientId);
            }
        }
    }

    public synchronized void deleteClientFromLegacyFileSystem(String clientId) {
        String filename = this.filenameFromClientId(clientId);
        try {
            this.xmlLoader.delete(this.clientsDirectory, filename);
        }
        catch (Exception e) {
            String message = "Error deleting client " + clientId;
            log.error((Object)message, (Throwable)e);
            this.setAuditLogParams();
            throw new ClientManager.ClientManagementException(message, e);
        }
        this.clientsMap.remove(clientId);
    }

    @Override
    public synchronized Client updateClient(Client client) {
        OAuthClientIndexDbEntry entry = this.oauthClientIndexDb.getEntry(client.getClientId());
        if (entry == null) {
            this.setAuditLogParams();
            throw new ClientManager.ClientNonexistentException("Error updating client. Client " + client.getClientId() + " not found");
        }
        client.setFileSystemPath(entry.getFileSystemPath());
        client.setLastModified((Calendar)new XmlCalendar(new Date()));
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            Client updatedClient = this.saveClient(client);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_CLIENTS, AdminAuditLogger.Event.MODIFY, client.getClientId());
            Client client2 = updatedClient;
            return client2;
        }
    }

    @Override
    protected Client doUpdateClient(Client client) {
        throw new UnsupportedOperationException("This method cannot be executed");
    }

    @Override
    public boolean isDataSourceInUse(String datasourceId) {
        return false;
    }

    @Override
    public int getDatastoreSearchClientCount() {
        return -1;
    }

    @Override
    public boolean isBackendDatabase() {
        return false;
    }

    @Override
    public synchronized void reload() {
        this.ensureClientsDirExists();
        this.loadDeltaReplicationState();
        this.clearInMemoryMaps();
        this.migrateClients();
        this.indexClients();
        this.clearInMemoryMaps();
    }

    private String filenameFromClientId(String clientId) {
        String hash = HashUtil.hashToHexString((String)clientId, (HashAlgorithm)HashAlgorithm.SHA1);
        return hash + ".xml";
    }

    private Client saveClient(Client client) {
        try {
            if (client.getFileSystemPath() == null) {
                String filename = this.filenameFromClientId(client.getClientId());
                int entryCount = this.oauthClientIndexDb.getEntryCount();
                client.setFileSystemPath(this.newFileSystemPath(entryCount, filename));
            }
            this.checkAndPerformSelectiveReplication(client);
            this.saveClientToXmlFile(client, client.getFileSystemPath());
            if (this.deltaReplState.removeTombstones(client.getClientId())) {
                this.saveDeltaReplicationState();
            }
        }
        catch (Exception e) {
            String message = "Error saving client " + client.getClientId();
            log.error((Object)message, (Throwable)e);
            this.setAuditLogParams();
            throw new ClientManager.ClientManagementException(message, e);
        }
        Client result = this.getClientFromFile(new File(this.getAbsolutePath(client.getFileSystemPath())));
        if (result == null) {
            this.setAuditLogParams();
            throw new ClientManager.ClientManagementException("Failed to reload client " + client.getClientId() + " after saving");
        }
        if (!this.allClientsLoaded) {
            log.debug((Object)("Loaded client " + client.getClientId() + " into cache, size = " + this.clientsMap.size()));
        }
        this.clientsMap.put(client.getClientId(), this.doSanitize(result, new ClientScopeSanitizer(), new ClientAuthorizationDetailTypesSanitizer()));
        return result;
    }

    private void checkAndPerformSelectiveReplication(Client client) {
        SelectiveReplicationClientValidator selectiveReplicationClientValidator;
        if (this.selectiveReplicationEnabled() && (selectiveReplicationClientValidator = new SelectiveReplicationClientValidator(client)).checkSelectiveReplicationClient()) {
            ReplicationRecord record = this.createPartialReplicationRecord(client);
            MgmtFactory.getMediator().applySelectiveReplicationRecords(Collections.singletonList(record), this);
            client.setSelectiveReplicationTime((Calendar)new XmlCalendar(new Date()));
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                auditLoggerScope.log(AdminAuditLogger.Component.CLUSTER_MANAGEMENT, AdminAuditLogger.Event.SELECTIVE_REPLICATE, client.getClientId());
            }
        }
    }

    private ReplicationRecord createPartialReplicationForClientDelete(String clientToDelete) {
        return ReplicationRecord.ofTombstone(clientToDelete);
    }

    private ReplicationRecord createPartialReplicationRecord(Client clientToReplicate) {
        String id = clientToReplicate.getClientId();
        byte[] data = this.serializeClient(clientToReplicate);
        return new ReplicationRecord(id, data);
    }

    private void saveClientToXmlFile(Client client, String relativePath) {
        ClientsDocument doc = ClientsDocument.Factory.newInstance();
        ClientsType clientsType = doc.addNewClients();
        ClientType xmlClient = clientsType.addNewClient();
        this.translator.fillXmClientFromClient(xmlClient, client);
        File file = new File(this.getAbsolutePath(relativePath));
        this.xmlLoader.save(file.getParent(), file.getName(), (XmlObject)doc);
        this.indexClient(client, file.lastModified());
    }

    private Client loadClientFromXmlFile(String directory, String filename) {
        List<Client> clients = this.loadClientsFromXmlFile(directory, filename);
        if (clients.size() > 0) {
            if (clients.size() > 1) {
                log.warn((Object)("Found more than one client in file " + filename));
            }
            return clients.get(0);
        }
        return null;
    }

    private List<Client> loadClientsFromXmlFile(String directory, String filename) {
        ArrayList<Client> result = new ArrayList<Client>();
        XmlObject xmlObj = null;
        try {
            xmlObj = this.xmlLoader.load(directory, filename);
        }
        catch (Exception e) {
            log.warn((Object)("Error trying to load file " + filename), (Throwable)e);
        }
        if (xmlObj instanceof ClientsDocument) {
            ClientsDocument clientsDoc = (ClientsDocument)xmlObj;
            ClientsType clientsType = clientsDoc.getClients();
            if (clientsType != null) {
                for (ClientType xmlClient : clientsType.getClientArray()) {
                    result.add(this.translator.clientFromXmlClient(xmlClient));
                }
            }
        } else {
            log.warn((Object)("File " + filename + " does not conform to expected schema"));
        }
        return result;
    }

    private void setAuditLogParams() {
        AsAuditLogger.setDescription("File I/O Exception");
        AuditLogger.setStatus("failure");
    }

    private synchronized int getMaxSizeClientMap() {
        return this.maxSizeClientsMap;
    }

    private void ensureClientsDirExists() {
        File clientsDir = this.getClientsDirectory();
        if (!clientsDir.exists() && !clientsDir.mkdirs()) {
            throw new ConfigurationException("Failed to create directory " + clientsDir);
        }
    }

    private synchronized void checkPurgeClient(Client client) {
        if (!this.allClientsLoaded && this.clientsMap.size() > this.getMaxSizeClientMap()) {
            log.debug((Object)("Reached max oauth client cache size (" + this.getMaxSizeClientMap() + "), purging least-recently-accessed client " + client.getClientId()));
            this.clientsMap.remove(client.getClientId());
        }
    }

    private String newFileSystemPath(int currEntryCount, String filename) {
        int dirIndex = currEntryCount / this.getClientsPerDirectory();
        return dirIndex + File.separator + filename;
    }

    private int getClientsPerDirectory() {
        return this.configStore.getIntValue(CFG_CLIENTS_PER_DIRECTORY, 1000);
    }

    private void migrateClients() {
        if (this.configStore.getBooleanValue(CFG_MIGRATION_COMPLETE_8_4, false)) {
            return;
        }
        log.info((Object)"Migrating clients to new storage format ...");
        File clientsFolder = new File(this.clientsDirectory);
        File[] xmlFiles = clientsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        int clientsMigrated = 0;
        if (xmlFiles != null) {
            for (File file : xmlFiles) {
                Client client = this.getClientFromFile(new File(this.clientsDirectory + File.separator, file.getName()));
                if (client == null) continue;
                try {
                    client.setFileSystemPath(this.newFileSystemPath(clientsMigrated, file.getName()));
                    this.saveClientToXmlFile(client, client.getFileSystemPath());
                    this.deleteClientFromLegacyFileSystem(client.getClientId());
                    log.info((Object)("Migrated client " + client.getClientId() + " from file " + file + " to file " + this.getAbsolutePath(client.getFileSystemPath())));
                    if (++clientsMigrated % 1000 != 0) continue;
                    log.info((Object)("Migrated " + clientsMigrated + " clients"));
                }
                catch (Exception e) {
                    log.error((Object)("An error occurred while migrating OAuth client " + client.getClientId() + " from file " + file + " to file " + this.getAbsolutePath(client.getFileSystemPath())), (Throwable)e);
                }
            }
        }
        this.configStore.setBooleanValue(CFG_MIGRATION_COMPLETE_8_4, true);
        log.info((Object)("Finished migrating, total clients migrated = " + clientsMigrated));
    }

    public synchronized void indexClients() {
        File connsDir;
        File[] fileList;
        log.debug((Object)"Indexing clients ...");
        int clientsIndexed = 0;
        Collection<NewClientFile> newClientFiles = this.oauthClientIndexDb.getNewClientFiles();
        if (newClientFiles.size() > 0) {
            for (NewClientFile connFile : newClientFiles) {
                File file = new File(this.getAbsolutePath(connFile.getFilePath()));
                if (!file.exists()) continue;
                this.indexClientFile(file);
                if (++clientsIndexed % 1000 != 0) continue;
                log.debug((Object)("Indexed " + clientsIndexed + " clients"));
            }
            this.oauthClientIndexDb.deleteNewClientFiles();
        } else if (this.oauthClientIndexDb.getEntryCount() == 0 && (fileList = (connsDir = new File(this.clientsDirectory)).listFiles()) != null) {
            for (File file : fileList) {
                if (!file.isDirectory()) continue;
                clientsIndexed = this.indexDirectory(file, clientsIndexed);
            }
        }
        log.debug((Object)("Finished indexing, total clients indexed = " + clientsIndexed));
    }

    private int indexDirectory(File dir, int clientsIndexed) {
        File[] fileList = dir.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
                this.indexClientFile(file);
                if (++clientsIndexed % 1000 != 0) continue;
                log.debug((Object)("Indexed " + clientsIndexed + " clients"));
            }
        }
        return clientsIndexed;
    }

    private String getAbsolutePath(OAuthClientIndexDbEntry entry) {
        return this.getAbsolutePath(entry.getFileSystemPath());
    }

    private String getAbsolutePath(String relativePath) {
        return new File(this.getClientsDirectory(), relativePath).getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Client getClientFromFile(File file) {
        try (FileInputStream inStream = new FileInputStream(file);){
            Client client = this.loadClientFromXmlFile(file.getParent(), file.getName());
            if (client == null) {
                log.warn((Object)("No client found in file " + file));
                Client client2 = null;
                return client2;
            }
            client.setFileSystemPath(file.getParentFile().getName() + File.separator + file.getName());
            Client client3 = client;
            return client3;
        }
        catch (IOException e) {
            log.warn((Object)("Error loading client from " + file), (Throwable)e);
            return null;
        }
    }

    private void indexClientFile(File file) {
        Client client = this.getClientFromFile(file);
        if (client != null) {
            this.indexClient(client, file.lastModified());
        }
    }

    private void indexClient(Client client, long fileLastModified) {
        long lastModified = fileLastModified;
        Calendar clientLastModified = client.getLastModified();
        if (clientLastModified != null) {
            lastModified = clientLastModified.getTimeInMillis();
        }
        this.oauthClientIndexDb.saveEntry(new OAuthClientIndexDbEntry(client.getClientId(), client.getFileSystemPath(), lastModified));
        this.clientsMap.remove(client.getClientId());
    }

    private boolean loadClient(OAuthClientIndexDbEntry entry) {
        Client client = this.getClientFromFile(new File(this.getAbsolutePath(entry)));
        if (client != null) {
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(entry.getLastModifiedMillis());
            client.setLastModified(lastModified);
            if (!this.allClientsLoaded) {
                log.debug((Object)("Loaded client " + entry.getClientId() + " into cache, size = " + this.clientsMap.size()));
            }
            this.clientsMap.put(client.getClientId(), this.doSanitize(client, new ClientScopeSanitizer(), new ClientAuthorizationDetailTypesSanitizer()));
            return true;
        }
        return false;
    }

    protected synchronized boolean loadClientFromStore(String clientId) {
        OAuthClientIndexDbEntry entry = this.oauthClientIndexDb.getEntry(clientId);
        if (entry == null) {
            log.debug((Object)("No client entry found for client id " + clientId));
            return false;
        }
        return this.loadClient(entry);
    }

    protected synchronized void deleteClientFromStore(String id, boolean createTombstone) {
        NewClientFile newClientFile;
        boolean clientDeleted = false;
        OAuthClientIndexDbEntry entry = this.oauthClientIndexDb.getEntry(id);
        if (entry != null) {
            String fileName;
            String directory;
            File file = new File(this.getAbsolutePath(entry));
            if (file.exists() && !this.xmlLoader.delete(directory = file.getParent(), fileName = file.getName())) {
                throw new ConfigurationException("Failed to delete file " + file);
            }
            this.oauthClientIndexDb.deleteEntry(entry.getClientId());
            clientDeleted = true;
        }
        if ((newClientFile = this.oauthClientIndexDb.getNewClientFile(id)) != null) {
            File file = new File(this.getAbsolutePath(newClientFile.getFilePath()));
            if (file.exists() && !file.delete()) {
                throw new ConfigurationException("Failed to delete file " + file);
            }
            this.oauthClientIndexDb.deleteNewClientFile(id);
            clientDeleted = true;
        }
        if (createTombstone && clientDeleted) {
            this.deltaReplState.addTombstone(new OAuthClientTombstone(id, new Date()));
            this.saveDeltaReplicationState();
        }
    }

    private void loadDeltaReplicationState() {
        this.deltaReplState = new DeltaReplicationState();
        this.deltaReplState.setTombstoneTrackingStartTime(new Date());
        File replStateFile = this.getDeltaReplicationStateFile();
        if (replStateFile.exists()) {
            try {
                this.deltaReplState = (DeltaReplicationState)this.objectMapper.readValue(replStateFile, DeltaReplicationState.class);
                if (this.deltaReplState.getTombstoneTrackingStartTime() == null) {
                    this.deltaReplState.setTombstoneTrackingStartTime(new Date());
                    this.saveDeltaReplicationState();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error loading file " + replStateFile), (Throwable)e);
            }
        } else {
            this.saveDeltaReplicationState();
        }
    }

    private File getDeltaReplicationStateFile() {
        return new File(MgmtFactory.getSysDirInfo().getReplicationDirectory(), DELTA_REPLICATION_STATE_FILE_NAME);
    }

    private void saveDeltaReplicationState() {
        File replStateFile = this.getDeltaReplicationStateFile();
        if (!replStateFile.getParentFile().exists() && !replStateFile.getParentFile().mkdirs()) {
            throw new ConfigurationException("Failed to create directory " + replStateFile.getParentFile());
        }
        try {
            this.objectMapper.writeValue(replStateFile, (Object)this.deltaReplState);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error saving file " + replStateFile, e);
        }
    }

    protected synchronized void clearInMemoryMaps() {
        log.debug((Object)"Clearing clients cache");
        this.clientsMap.clear();
        this.allClientsLoaded = false;
    }

    @Override
    public synchronized String getManagedDirectoryName() {
        return "oauth-clients";
    }

    @Override
    public synchronized Iterator<ReplicationRecord> getReplicationRecords(Date startTime) {
        Collection<OAuthClientTombstone> tombstones;
        Collection<OAuthClientIndexDbEntry> entries;
        log.trace((Object)("Getting replication records starting from " + startTime));
        if (startTime == null) {
            entries = this.oauthClientIndexDb.getAllEntries();
            tombstones = new ArrayList<OAuthClientTombstone>(this.deltaReplState.getTombstones());
        } else {
            entries = this.oauthClientIndexDb.getEntriesModifiedSince(startTime);
            tombstones = this.deltaReplState.getTombstones().stream().filter(t -> t.getTimestamp().after(startTime)).collect(Collectors.toList());
        }
        return new RecordIterator(tombstones, entries);
    }

    @Override
    public synchronized void beginFullReplication() {
        this.cleanOAuthIndexDirectoryAndDatabase();
    }

    @Override
    public synchronized void clearReplicationState() {
        File replStateFile = this.getDeltaReplicationStateFile();
        if (replStateFile.exists() && !replStateFile.delete()) {
            throw new ConfigurationException("Failed to delete file " + replStateFile);
        }
        this.loadDeltaReplicationState();
    }

    @Override
    public boolean isValidPartialEntry(String entryId) {
        return false;
    }

    @Override
    public String extractIdFromEntryId(String entryId) {
        return null;
    }

    @Override
    public byte[] mergePartialEntry(byte[] partialEntry, byte[] entry) {
        return entry;
    }

    @Override
    public synchronized void importReplicationRecords(Collection<ReplicationRecord> records, boolean createTombstones) {
        int entryCount = this.oauthClientIndexDb.getEntryCount() + this.oauthClientIndexDb.getNewClientFileCount();
        for (ReplicationRecord record : records) {
            if (record.isTombstone()) {
                log.debug((Object)("Deleting client " + record.getId()));
                this.clientsMap.remove(record.getId());
                this.deleteClientFromStore(record.getId(), createTombstones);
                continue;
            }
            log.debug((Object)("Deploying replicated client data for client " + record.getId()));
            OAuthClientIndexDbEntry entry = this.oauthClientIndexDb.getEntry(record.getId());
            String relativePath = entry == null ? this.newFileSystemPath(entryCount++, this.filenameFromClientId(record.getId())) : entry.getFileSystemPath();
            File file = new File(this.getAbsolutePath(relativePath));
            try {
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new ConfigurationException("Failed to create directory " + file.getParentFile());
                }
                Files.write(file.toPath(), record.getData(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new ConfigurationException("Error importing client file", e);
            }
            this.oauthClientIndexDb.addNewClientFiles(Arrays.asList(new NewClientFile(record.getId(), relativePath)));
        }
        log.debug((Object)("Importing replication records: saved " + records.size() + " clients to disk"));
    }

    @Override
    public synchronized void reloadUpdatedEntries() {
        this.indexClients();
        this.allClientsLoaded = false;
    }

    @Override
    public synchronized void deleteTombstones(Date endTime) {
        log.debug((Object)("Deleting tombstones earlier than " + endTime));
        this.deltaReplState.removeTombstones(endTime);
        this.saveDeltaReplicationState();
    }

    @Override
    public synchronized Date getLatestUpdateTimestamp() {
        Date latestUpdate = this.oauthClientIndexDb.getLatestUpdateTimestamp();
        Date latestDelete = this.deltaReplState.getLatestDeleteTimestamp();
        if (latestDelete.after(latestUpdate)) {
            latestUpdate = latestDelete;
        }
        return latestUpdate;
    }

    @Override
    public boolean supportsSelectiveReplication() {
        return true;
    }

    @Override
    public boolean selectiveReplicationEnabled() {
        return MgmtFactory.getClusterSettingsManager().isEnableSelectiveReplicationForClients();
    }

    @Override
    public synchronized Date getTombstoneTrackingStartTime() {
        return this.deltaReplState.getTombstoneTrackingStartTime();
    }

    private byte[] serializeClient(Client client) {
        byte[] byArray;
        ClientsDocument doc = ClientsDocument.Factory.newInstance();
        ClientsType clientsType = doc.addNewClients();
        ClientType xmlClient = clientsType.addNewClient();
        this.translator.fillXmClientFromClient(xmlClient, client);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            XmlOptions options = XmlBeansUtil.getXmlOptions();
            options.setSavePrettyPrint();
            options.setSavePrettyPrintIndent(4);
            doc.save((OutputStream)outStream, options);
            byArray = outStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException("Error serializing client", e);
            }
        }
        outStream.close();
        return byArray;
    }

    private ObjectMapper makeObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return mapper;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    protected static class DeltaReplicationState {
        private Date tombstoneTrackingStartTime;
        private List<OAuthClientTombstone> tombstones = new ArrayList<OAuthClientTombstone>();
        private Date latestDeleteTimestamp = new Date(0L);

        public void addTombstone(OAuthClientTombstone tombstone) {
            this.tombstones.add(tombstone);
            this.latestDeleteTimestamp = tombstone.getTimestamp();
        }

        public boolean removeTombstones(String clientId) {
            boolean result = false;
            Iterator<OAuthClientTombstone> tombstoneIter = this.tombstones.iterator();
            while (tombstoneIter.hasNext()) {
                OAuthClientTombstone tombstone = tombstoneIter.next();
                if (!StringUtils.equals((String)tombstone.getId(), (String)clientId)) continue;
                tombstoneIter.remove();
                result = true;
            }
            return result;
        }

        public void removeTombstones(Date endTime) {
            Iterator<OAuthClientTombstone> iter = this.tombstones.iterator();
            while (iter.hasNext()) {
                OAuthClientTombstone tombstone = iter.next();
                if (endTime != null && !tombstone.getTimestamp().before(endTime)) continue;
                iter.remove();
            }
            this.tombstoneTrackingStartTime = endTime;
        }

        public List<OAuthClientTombstone> getTombstones() {
            return Collections.unmodifiableList(this.tombstones);
        }

        public void setTombstones(List<OAuthClientTombstone> deletedConns) {
            this.tombstones = deletedConns;
        }

        public Date getLatestDeleteTimestamp() {
            return this.latestDeleteTimestamp;
        }

        public Date getTombstoneTrackingStartTime() {
            return this.tombstoneTrackingStartTime;
        }

        public void setTombstoneTrackingStartTime(Date startTime) {
            this.tombstoneTrackingStartTime = startTime;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    protected static class OAuthClientTombstone {
        private String id;
        private Date timestamp;

        public OAuthClientTombstone() {
        }

        public OAuthClientTombstone(String id, Date timestamp) {
            this.id = id;
            this.timestamp = timestamp;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }
    }

    private class RecordIterator
    implements Iterator<ReplicationRecord> {
        private Collection<OAuthClientTombstone> tombstones;
        private Collection<OAuthClientIndexDbEntry> dbEntries;

        public RecordIterator(Collection<OAuthClientTombstone> tombstones, Collection<OAuthClientIndexDbEntry> dbEntries) {
            this.tombstones = tombstones;
            this.dbEntries = dbEntries;
        }

        @Override
        public boolean hasNext() {
            return !this.tombstones.isEmpty() || !this.dbEntries.isEmpty();
        }

        @Override
        public ReplicationRecord next() {
            if (!this.tombstones.isEmpty()) {
                Iterator<OAuthClientTombstone> iter = this.tombstones.iterator();
                OAuthClientTombstone tombstone = iter.next();
                iter.remove();
                return ReplicationRecord.ofTombstone(tombstone.getId());
            }
            if (!this.dbEntries.isEmpty()) {
                Iterator<OAuthClientIndexDbEntry> iter = this.dbEntries.iterator();
                OAuthClientIndexDbEntry dbEntry = iter.next();
                iter.remove();
                Client client = ClientManagerXmlFileImpl.this.getClient(dbEntry.getClientId());
                byte[] data = new byte[]{};
                if (client != null) {
                    data = ClientManagerXmlFileImpl.this.serializeClient(client);
                }
                return new ReplicationRecord(dbEntry.getClientId(), data);
            }
            throw new NoSuchElementException();
        }
    }

    private class ClientMap<T extends Client>
    extends LinkedHashMap<String, T> {
        public ClientMap() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, T> entry) {
            ClientManagerXmlFileImpl.this.checkPurgeClient((Client)entry.getValue());
            return false;
        }
    }
}

