/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.B64;
import com.pingidentity.crypto.HashedPassword;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.oauth20.domain.ClientSecretRetentionHelper;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class ClientSecondarySecretSet
implements Serializable {
    private static final long serialVersionUID = 1238791L;
    private List<ClientSecondarySecret> secondarySecrets;

    public ClientSecondarySecretSet() {
        this.secondarySecrets = new ArrayList<ClientSecondarySecret>();
    }

    public ClientSecondarySecretSet(String encodedSecretSet) {
        SerializableClientSecondarySecretSet serializableClientSecondarySecretSet = this.readSecretSet(encodedSecretSet);
        this.secondarySecrets = serializableClientSecondarySecretSet.getSecrets();
    }

    public List<ClientSecondarySecret> getSecondarySecrets() {
        return this.secondarySecrets;
    }

    public void addSecondarySecret(String secondarySecret, String reversibleSecret, Date expiryTime) {
        ClientSecondarySecret newSecret = ClientSecondarySecret.fromClearTextSecret(secondarySecret, reversibleSecret, expiryTime);
        this.doAddSecondarySecret(newSecret);
    }

    public void addEncodedSecondarySecret(String encodedSecret, String reversibleSecret, Date expiryTime) {
        ClientSecondarySecret newSecret = ClientSecondarySecret.fromEncodedSecret(encodedSecret, reversibleSecret, expiryTime);
        this.doAddSecondarySecret(newSecret);
    }

    private void doAddSecondarySecret(ClientSecondarySecret newSecret) {
        boolean alreadyPresent = false;
        int maxSecondarySecrets = ClientSecretRetentionHelper.getMaxRetainedClientSecondarySecrets();
        for (ClientSecondarySecret secondarySecret : this.secondarySecrets) {
            if (!secondarySecret.getSecret().equals(newSecret.getSecret())) continue;
            alreadyPresent = true;
            secondarySecret.setExpiryTime(newSecret.getExpiryTime());
        }
        if (!alreadyPresent) {
            this.secondarySecrets.add(newSecret);
        }
        if (this.secondarySecrets.size() > maxSecondarySecrets) {
            this.secondarySecrets = this.secondarySecrets.stream().sorted(Comparator.comparing(ClientSecondarySecret::getExpiryTime).reversed()).limit(maxSecondarySecrets).collect(Collectors.toList());
        }
    }

    public boolean validateSecret(String secret) {
        for (ClientSecondarySecret secondarySecret : this.secondarySecrets) {
            if (this.isSecretExpired(secondarySecret) || !secondarySecret.hashedSecret.checkSecret(secret)) continue;
            return true;
        }
        return false;
    }

    public String getSerializedSecondarySecrets() {
        this.removeExpiredSecondarySecrets();
        ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            String serialized = objectMapper.writeValueAsString((Object)new SerializableClientSecondarySecretSet(this));
            return B64.encode((String)serialized);
        }
        catch (JsonProcessingException e) {
            throw new ProcessRuntimeException("Unexpected error serializing secondary secret set", e);
        }
    }

    public void removeExpiredSecondarySecrets() {
        ArrayList<ClientSecondarySecret> newList = new ArrayList<ClientSecondarySecret>();
        for (ClientSecondarySecret secondarySecret : this.secondarySecrets) {
            if (this.isSecretExpired(secondarySecret)) continue;
            newList.add(secondarySecret);
        }
        this.secondarySecrets = newList;
    }

    public boolean isSecretExpired(ClientSecondarySecret secret) {
        Instant expiry;
        Instant now = Instant.now();
        return now.isAfter(expiry = secret.getExpiryTime().toInstant());
    }

    public SerializableClientSecondarySecretSet readSecretSet(String encodedSecrets) {
        ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            String decodedSecrets = B64.decodeToString((String)encodedSecrets);
            return (SerializableClientSecondarySecretSet)objectMapper.readerFor(SerializableClientSecondarySecretSet.class).readValue(decodedSecrets);
        }
        catch (JsonProcessingException e) {
            throw new ProcessRuntimeException("Unexpected error deserializing secondary secret set", e);
        }
    }

    private static class SerializableClientSecondarySecret {
        private String secret;
        private String reversibleSecret;
        private String expiryTime;

        public SerializableClientSecondarySecret() {
        }

        public SerializableClientSecondarySecret(ClientSecondarySecret clientSecondarySecret) {
            this.secret = clientSecondarySecret.getSecret();
            this.reversibleSecret = clientSecondarySecret.getReversibleSecret();
            this.expiryTime = Long.toString(clientSecondarySecret.getExpiryTime().getTime());
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public String getReversibleSecret() {
            return this.reversibleSecret;
        }

        public void setReversibleSecret(String reversibleSecret) {
            this.reversibleSecret = reversibleSecret;
        }

        public String getExpiryTime() {
            return this.expiryTime;
        }

        public void setExpiryTime(String expiryTime) {
            this.expiryTime = expiryTime;
        }
    }

    private static class SerializableClientSecondarySecretSet {
        private List<SerializableClientSecondarySecret> secrets;

        public SerializableClientSecondarySecretSet() {
        }

        public SerializableClientSecondarySecretSet(ClientSecondarySecretSet secretSet) {
            this.secrets = secretSet.getSecondarySecrets().stream().map(secret -> new SerializableClientSecondarySecret((ClientSecondarySecret)secret)).collect(Collectors.toList());
        }

        public List<ClientSecondarySecret> getSecrets() {
            ArrayList<ClientSecondarySecret> secretList = new ArrayList<ClientSecondarySecret>();
            for (SerializableClientSecondarySecret serializableSecret : this.secrets) {
                Date expiryTime = new Date(Long.parseLong(serializableSecret.getExpiryTime()));
                ClientSecondarySecret clientSecondarySecret = ClientSecondarySecret.fromEncodedSecret(serializableSecret.getSecret(), serializableSecret.getReversibleSecret(), expiryTime);
                secretList.add(clientSecondarySecret);
            }
            return secretList;
        }

        public void setSecrets(List<SerializableClientSecondarySecret> secrets) {
            this.secrets = secrets;
        }
    }

    public static class ClientSecondarySecret
    implements Serializable {
        private static final long serialVersionUID = 1L;
        transient HashedPassword hashedSecret;
        String reversibleSecret;
        Date expiryTime;

        public static ClientSecondarySecret fromEncodedSecret(String encoded, String reversibleSecret, Date expiryTime) {
            return new ClientSecondarySecret(HashedPassword.fromEncodedText(encoded), reversibleSecret, expiryTime);
        }

        public static ClientSecondarySecret fromClearTextSecret(String encoded, String reversibleSecret, Date expiryTime) {
            return new ClientSecondarySecret(HashedPassword.fromClearText(encoded), reversibleSecret, expiryTime);
        }

        public ClientSecondarySecret(HashedPassword hashedSecret, String reversibleSecret, Date expiryTime) {
            this.hashedSecret = hashedSecret;
            this.reversibleSecret = reversibleSecret;
            this.expiryTime = expiryTime == null ? null : new Date(expiryTime.getTime());
        }

        public String getSecret() {
            return this.hashedSecret.toEncodedText();
        }

        public String getReversibleSecret() {
            return this.reversibleSecret;
        }

        public Date getExpiryTime() {
            return this.expiryTime == null ? null : new Date(this.expiryTime.getTime());
        }

        public void setExpiryTime(Date expiryTime) {
            this.expiryTime = expiryTime == null ? null : new Date(expiryTime.getTime());
        }

        public void setReversibleSecret(String reversibleSecret) {
            this.reversibleSecret = reversibleSecret;
        }
    }
}

