/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.ClientParam;

public class ClientSetting
implements Cloneable {
    private Map<String, ClientParam> extendedMetadataParams = new HashMap<String, ClientParam>();
    private boolean enableDynamicClientRegistration;
    private boolean enableDynamicClientRegistrationManagement;
    private boolean rotateRegistrationAccessToken;
    private boolean rotateClientSecret;
    private boolean allowClientDelete;
    private boolean disableRegistrationAccessTokens;
    private boolean requireInitialAccessToken;
    private String initialAccessTokenScope;
    private boolean restrictCommonScopes;
    private Set<String> restrictedCommonScopes;
    private Set<String> allowedExclusiveScopes;
    private Set<String> allowedAuthorizationDetailTypes;
    private List<String> policyPlugins;
    private static final String ROLL = "true";
    private static final String DONT_ROLL = "false";
    private boolean enforceReplayPrevention;
    private String refreshRolling;
    private String persistentGrantExpirationType;
    private Long persistentGrantExpirationTime;
    private String persistentGrantExpirationTimeUnit;
    private String persistentGrantIdleTimeoutType;
    private Long persistentGrantIdleTimeout;
    private String persistentGrantIdleTimeoutTimeUnit;
    private String idTokenSigningAlgorithm;
    private String policyGroupId;
    private boolean requireSignedRequests;
    private String defaultAccessTokenManagerId;
    private boolean restrictToDefaultAccessTokenManager;
    private String clientCertIssuerDn;
    private String deviceFlowSettingType;
    private String userAuthzUrlOverride;
    private Integer pendingAuthzTimeoutOverride;
    private Integer devicePollingIntervalOverride;
    private Boolean bypassActivationCodeConfirmationOverride;
    private boolean requireProofKeyForCodeExchange;
    private Long refreshTokenRollingInterval;
    private String refreshTokenRollingIntervalTimeUnit;
    private String refreshTokenRollingIntervalType;
    private String clientSecretRetentionPeriodType;
    private Integer clientSecretRetentionPeriod;
    private boolean retainClientSecret;
    private boolean cibaRequireSignedRequests;
    private String cibaPolicyId;
    private int cibaPollingInterval = 3;
    public static final int CIBA_POLLING_INTERVAL_DEFAULT = 3;
    private String tokenExchangeProcessorPolicyId;
    private String refreshTokenRollingGracePeriodType;
    private Integer refreshTokenRollingGracePeriod;
    private String requireOfflineAccessScopeToIssueRefreshTokens;
    private String offlineAccessRequireConsentPrompt;
    private String lockoutMaxMaliciousActionsType;
    private Integer lockoutMaxMaliciousActions;
    private Boolean requireJwtSecuredAuthorizationResponseMode;
    private Calendar extendedMetadataParamsLastModified;

    public Map<String, ClientParam> getExtendedMetadataParams() {
        return this.extendedMetadataParams;
    }

    public void setExtendedMetadataParams(Map<String, ClientParam> extendedMetadataParams) {
        this.extendedMetadataParams = extendedMetadataParams;
    }

    public boolean isEnableDynamicClientRegistration() {
        return this.enableDynamicClientRegistration;
    }

    public void setEnableDynamicClientRegistration(boolean enableDynamicClientRegistration) {
        this.enableDynamicClientRegistration = enableDynamicClientRegistration;
    }

    public boolean isRequireInitialAccessToken() {
        return this.requireInitialAccessToken;
    }

    public void setRequireInitialAccessToken(boolean requireInitialAccessToken) {
        this.requireInitialAccessToken = requireInitialAccessToken;
    }

    public String getInitialAccessTokenScope() {
        return this.initialAccessTokenScope;
    }

    public void setInitialAccessTokenScope(String initialAccessTokenScope) {
        this.initialAccessTokenScope = initialAccessTokenScope;
    }

    public boolean isRestrictCommonScopes() {
        return this.restrictCommonScopes;
    }

    public void setRestrictCommonScopes(boolean restrictCommonScopes) {
        this.restrictCommonScopes = restrictCommonScopes;
    }

    public Set<String> getRestrictedCommonScopes() {
        return this.restrictedCommonScopes;
    }

    public void setRestrictedCommonScopes(Set<String> restrictedCommonScopes) {
        this.restrictedCommonScopes = restrictedCommonScopes;
    }

    public Set<String> getAllowedExclusiveScopes() {
        return this.allowedExclusiveScopes;
    }

    public void setAllowedExclusiveScopes(Set<String> allowedExclusiveScopes) {
        this.allowedExclusiveScopes = allowedExclusiveScopes;
    }

    public Set<String> getAllowedAuthorizationDetailTypes() {
        return this.allowedAuthorizationDetailTypes;
    }

    public void setAllowedAuthorizationDetailTypes(Set<String> allowedAuthorizationDetailTypes) {
        this.allowedAuthorizationDetailTypes = allowedAuthorizationDetailTypes;
    }

    public boolean isEnforceReplayPrevention() {
        return this.enforceReplayPrevention;
    }

    public void setEnforceReplayPrevention(boolean enforceReplayPrevention) {
        this.enforceReplayPrevention = enforceReplayPrevention;
    }

    public String getRefreshRolling() {
        if (this.refreshRolling == null) {
            return null;
        }
        if (this.refreshRolling.equals("0")) {
            return DONT_ROLL;
        }
        if (this.refreshRolling.equals("1")) {
            return ROLL;
        }
        return this.refreshRolling.toLowerCase();
    }

    public void setRefreshRolling(String refreshRolling) {
        this.refreshRolling = refreshRolling != null ? refreshRolling.trim() : null;
    }

    public String getPersistentGrantExpirationType() {
        return this.persistentGrantExpirationType;
    }

    public void setPersistentGrantExpirationType(String persistentGrantExpirationType) {
        this.persistentGrantExpirationType = persistentGrantExpirationType;
    }

    public Long getPersistentGrantExpirationTime() {
        return this.persistentGrantExpirationTime;
    }

    public void setPersistentGrantExpirationTime(Long persistentGrantExpirationTime) {
        this.persistentGrantExpirationTime = persistentGrantExpirationTime;
    }

    public String getPersistentGrantExpirationTimeUnit() {
        return this.persistentGrantExpirationTimeUnit;
    }

    public void setPersistentGrantExpirationTimeUnit(String persistentGrantExpirationTimeUnit) {
        if ("min".equals(persistentGrantExpirationTimeUnit)) {
            persistentGrantExpirationTimeUnit = "n";
        }
        this.persistentGrantExpirationTimeUnit = persistentGrantExpirationTimeUnit;
    }

    public String getPersistentGrantIdleTimeoutType() {
        return this.persistentGrantIdleTimeoutType;
    }

    public void setPersistentGrantIdleTimeoutType(String persistentGrantIdleTimeoutType) {
        this.persistentGrantIdleTimeoutType = persistentGrantIdleTimeoutType;
    }

    public Long getPersistentGrantIdleTimeout() {
        return this.persistentGrantIdleTimeout;
    }

    public void setPersistentGrantIdleTimeout(Long persistentGrantIdleTimeout) {
        this.persistentGrantIdleTimeout = persistentGrantIdleTimeout;
    }

    public String getPersistentGrantIdleTimeoutTimeUnit() {
        return this.persistentGrantIdleTimeoutTimeUnit;
    }

    public void setPersistentGrantIdleTimeoutTimeUnit(String persistentGrantIdleTimeoutTimeUnit) {
        if ("min".equals(persistentGrantIdleTimeoutTimeUnit)) {
            persistentGrantIdleTimeoutTimeUnit = "n";
        }
        this.persistentGrantIdleTimeoutTimeUnit = persistentGrantIdleTimeoutTimeUnit;
    }

    public String getIdTokenSigningAlgorithm() {
        return this.idTokenSigningAlgorithm;
    }

    public void setIdTokenSigningAlgorithm(String idTokenSigningAlgorithm) {
        this.idTokenSigningAlgorithm = idTokenSigningAlgorithm;
    }

    public String getPolicyGroupId() {
        return this.policyGroupId;
    }

    public void setPolicyGroupId(String policyGroupId) {
        this.policyGroupId = policyGroupId;
    }

    public boolean isRequireSignedRequests() {
        return this.requireSignedRequests;
    }

    public void setRequireSignedRequests(boolean requireSignedRequests) {
        this.requireSignedRequests = requireSignedRequests;
    }

    public String getDefaultAccessTokenManagerId() {
        return this.defaultAccessTokenManagerId;
    }

    public void setDefaultAccessTokenManagerId(String defaultAccessTokenManagerId) {
        this.defaultAccessTokenManagerId = defaultAccessTokenManagerId;
    }

    public boolean isRestrictToDefaultAccessTokenManager() {
        return this.restrictToDefaultAccessTokenManager;
    }

    public void setRestrictToDefaultAccessTokenManager(boolean restrict) {
        this.restrictToDefaultAccessTokenManager = restrict;
    }

    public List<String> getPolicyPlugins() {
        return this.policyPlugins;
    }

    public void setPolicyPlugins(List<String> policyPlugins) {
        this.policyPlugins = policyPlugins;
    }

    public String getClientCertIssuerDn() {
        return this.clientCertIssuerDn;
    }

    public void setClientCertIssuerDn(String clientCertIssuerDn) {
        this.clientCertIssuerDn = clientCertIssuerDn;
    }

    public String getDeviceFlowSettingType() {
        String result = this.deviceFlowSettingType;
        if (StringUtils.isBlank((String)result)) {
            result = "SERVER_DEFAULT";
        }
        return result;
    }

    public void setDeviceFlowSettingType(String deviceFlowSettingType) {
        this.deviceFlowSettingType = deviceFlowSettingType;
    }

    public String getUserAuthzUrlOverride() {
        return this.userAuthzUrlOverride;
    }

    public void setUserAuthzUrlOverride(String userAuthzUrlOverride) {
        this.userAuthzUrlOverride = userAuthzUrlOverride;
    }

    public Integer getPendingAuthzTimeoutOverride() {
        return this.pendingAuthzTimeoutOverride;
    }

    public void setPendingAuthzTimeoutOverride(Integer pendingAuthzTimeoutOverride) {
        this.pendingAuthzTimeoutOverride = pendingAuthzTimeoutOverride;
    }

    public Integer getDevicePollingIntervalOverride() {
        return this.devicePollingIntervalOverride;
    }

    public void setDevicePollingIntervalOverride(Integer devicePollingIntervalOverride) {
        this.devicePollingIntervalOverride = devicePollingIntervalOverride;
    }

    public Boolean getBypassActivationCodeConfirmationOverride() {
        return this.bypassActivationCodeConfirmationOverride;
    }

    public void setBypassActivationCodeConfirmationOverride(Boolean bypassActivationCodeConfirmationOverride) {
        this.bypassActivationCodeConfirmationOverride = bypassActivationCodeConfirmationOverride;
    }

    public boolean isRequireProofKeyForCodeExchange() {
        return this.requireProofKeyForCodeExchange;
    }

    public void setRequireProofKeyForCodeExchange(boolean requireProofKeyForCodeExchange) {
        this.requireProofKeyForCodeExchange = requireProofKeyForCodeExchange;
    }

    public ClientSetting clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ClientSetting settings = new ClientSetting();
        settings.setEnableDynamicClientRegistration(this.enableDynamicClientRegistration);
        settings.setRequireInitialAccessToken(this.requireInitialAccessToken);
        settings.setInitialAccessTokenScope(this.initialAccessTokenScope);
        settings.setRestrictCommonScopes(this.restrictCommonScopes);
        HashSet<String> restrictedScope = new HashSet<String>();
        restrictedScope.addAll(this.restrictedCommonScopes);
        settings.setRestrictedCommonScopes(restrictedScope);
        HashSet<String> allowedScopes = new HashSet<String>();
        allowedScopes.addAll(this.allowedExclusiveScopes);
        settings.setAllowedExclusiveScopes(allowedScopes);
        settings.setAllowedAuthorizationDetailTypes(this.allowedAuthorizationDetailTypes);
        settings.setPolicyPlugins(new ArrayList<String>(this.policyPlugins));
        settings.setEnforceReplayPrevention(this.enforceReplayPrevention);
        settings.setRefreshRolling(this.refreshRolling);
        settings.setRefreshTokenRollingInterval(this.refreshTokenRollingInterval);
        settings.setRefreshTokenRollingIntervalTimeUnit(this.refreshTokenRollingIntervalTimeUnit);
        settings.setRefreshTokenRollingIntervalType(this.refreshTokenRollingIntervalType);
        settings.setPersistentGrantExpirationType(this.persistentGrantExpirationType);
        settings.setPersistentGrantExpirationTime(this.persistentGrantExpirationTime);
        settings.setPersistentGrantExpirationTimeUnit(this.persistentGrantExpirationTimeUnit);
        settings.setPersistentGrantIdleTimeoutType(this.persistentGrantIdleTimeoutType);
        settings.setPersistentGrantIdleTimeout(this.persistentGrantIdleTimeout);
        settings.setPersistentGrantIdleTimeoutTimeUnit(this.persistentGrantIdleTimeoutTimeUnit);
        settings.setIdTokenSigningAlgorithm(this.idTokenSigningAlgorithm);
        settings.setPolicyGroupId(this.policyGroupId);
        settings.setRequireSignedRequests(this.requireSignedRequests);
        settings.setDefaultAccessTokenManagerId(this.defaultAccessTokenManagerId);
        settings.setRestrictToDefaultAccessTokenManager(this.restrictToDefaultAccessTokenManager);
        settings.setClientCertIssuerDn(this.clientCertIssuerDn);
        settings.setDeviceFlowSettingType(this.deviceFlowSettingType);
        settings.setUserAuthzUrlOverride(this.userAuthzUrlOverride);
        settings.setPendingAuthzTimeoutOverride(this.pendingAuthzTimeoutOverride);
        settings.setDevicePollingIntervalOverride(this.devicePollingIntervalOverride);
        settings.setBypassActivationCodeConfirmationOverride(this.bypassActivationCodeConfirmationOverride);
        settings.setRequireProofKeyForCodeExchange(this.requireProofKeyForCodeExchange);
        settings.setExtendedMetadataParams(this.extendedMetadataParams);
        settings.setCibaRequireSignedRequests(this.cibaRequireSignedRequests);
        settings.setCibaPolicyId(this.cibaPolicyId);
        settings.setCibaPollingInterval(this.cibaPollingInterval);
        settings.setTokenExchangeProcessorPolicyId(this.tokenExchangeProcessorPolicyId);
        settings.setEnableDynamicClientRegistrationManagement(this.enableDynamicClientRegistrationManagement);
        settings.setRotateClientSecret(this.rotateClientSecret);
        settings.setRotateRegistrationAccessToken(this.rotateRegistrationAccessToken);
        settings.setAllowClientDelete(this.allowClientDelete);
        settings.setDisableRegistrationAccessTokens(this.disableRegistrationAccessTokens);
        settings.setRetainClientSecret(this.retainClientSecret);
        settings.setClientSecretRetentionPeriodType(this.clientSecretRetentionPeriodType);
        settings.setClientSecretRetentionPeriod(this.clientSecretRetentionPeriod);
        settings.setRequireOfflineAccessScopeToIssueRefreshTokens(this.requireOfflineAccessScopeToIssueRefreshTokens);
        settings.setOfflineAccessRequireConsentPrompt(this.offlineAccessRequireConsentPrompt);
        settings.setLockoutMaxMaliciousActionsType(this.lockoutMaxMaliciousActionsType);
        settings.setLockoutMaxMaliciousActions(this.lockoutMaxMaliciousActions);
        return settings;
    }

    public boolean isCibaRequireSignedRequests() {
        return this.cibaRequireSignedRequests;
    }

    public void setCibaRequireSignedRequests(boolean cibaRequireSignedRequests) {
        this.cibaRequireSignedRequests = cibaRequireSignedRequests;
    }

    public String getCibaPolicyId() {
        return this.cibaPolicyId;
    }

    public void setCibaPolicyId(String cibaPolicyId) {
        this.cibaPolicyId = cibaPolicyId;
    }

    public int getCibaPollingInterval() {
        return this.cibaPollingInterval;
    }

    public void setCibaPollingInterval(int cibaPollingInterval) {
        this.cibaPollingInterval = cibaPollingInterval;
    }

    public String getTokenExchangeProcessorPolicyId() {
        return this.tokenExchangeProcessorPolicyId;
    }

    public void setTokenExchangeProcessorPolicyId(String tokenExchangeProcessorPolicyId) {
        this.tokenExchangeProcessorPolicyId = tokenExchangeProcessorPolicyId;
    }

    public boolean isEnableDynamicClientRegistrationManagement() {
        return this.enableDynamicClientRegistrationManagement;
    }

    public void setEnableDynamicClientRegistrationManagement(boolean enableDynamicClientRegistrationManagement) {
        this.enableDynamicClientRegistrationManagement = enableDynamicClientRegistrationManagement;
    }

    public boolean isRotateRegistrationAccessToken() {
        return this.rotateRegistrationAccessToken;
    }

    public void setRotateRegistrationAccessToken(boolean rotateRegistrationAccessToken) {
        this.rotateRegistrationAccessToken = rotateRegistrationAccessToken;
    }

    public boolean isRotateClientSecret() {
        return this.rotateClientSecret;
    }

    public void setRotateClientSecret(boolean rotateClientSecret) {
        this.rotateClientSecret = rotateClientSecret;
    }

    public boolean isAllowClientDelete() {
        return this.allowClientDelete;
    }

    public void setAllowClientDelete(boolean allowClientDelete) {
        this.allowClientDelete = allowClientDelete;
    }

    public boolean isDisableRegistrationAccessTokens() {
        return this.disableRegistrationAccessTokens;
    }

    public void setDisableRegistrationAccessTokens(boolean disableRegistrationAccessTokens) {
        this.disableRegistrationAccessTokens = disableRegistrationAccessTokens;
    }

    public Long getRefreshTokenRollingInterval() {
        return this.refreshTokenRollingInterval;
    }

    public void setRefreshTokenRollingInterval(Long refreshTokenRollingInterval) {
        this.refreshTokenRollingInterval = refreshTokenRollingInterval;
    }

    public String getRefreshTokenRollingIntervalTimeUnit() {
        return this.refreshTokenRollingIntervalTimeUnit;
    }

    public void setRefreshTokenRollingIntervalTimeUnit(String refreshTokenRollingIntervalTimeUnit) {
        this.refreshTokenRollingIntervalTimeUnit = refreshTokenRollingIntervalTimeUnit;
    }

    public String getRefreshTokenRollingIntervalType() {
        return this.refreshTokenRollingIntervalType;
    }

    public void setRefreshTokenRollingIntervalType(String refreshTokenRollingIntervalType) {
        this.refreshTokenRollingIntervalType = refreshTokenRollingIntervalType;
    }

    public String getRefreshTokenRollingGracePeriodType() {
        return this.refreshTokenRollingGracePeriodType;
    }

    public void setRefreshTokenRollingGracePeriodType(String refreshTokenRollingGracePeriodType) {
        this.refreshTokenRollingGracePeriodType = refreshTokenRollingGracePeriodType;
    }

    public Integer getRefreshTokenRollingGracePeriod() {
        return this.refreshTokenRollingGracePeriod;
    }

    public void setRefreshTokenRollingGracePeriod(Integer refreshTokenRollingGracePeriod) {
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
    }

    public String getClientSecretRetentionPeriodType() {
        return this.clientSecretRetentionPeriodType;
    }

    public void setClientSecretRetentionPeriodType(String clientSecretRetentionPeriodType) {
        this.clientSecretRetentionPeriodType = clientSecretRetentionPeriodType;
    }

    public Integer getClientSecretRetentionPeriod() {
        return this.clientSecretRetentionPeriod;
    }

    public void setClientSecretRetentionPeriod(Integer clientSecretRetentionPeriod) {
        this.clientSecretRetentionPeriod = clientSecretRetentionPeriod;
    }

    public boolean isRetainClientSecret() {
        return this.retainClientSecret;
    }

    public void setRetainClientSecret(boolean retainClientSecret) {
        this.retainClientSecret = retainClientSecret;
    }

    public Boolean getRequireJwtSecuredAuthorizationResponseMode() {
        return this.requireJwtSecuredAuthorizationResponseMode;
    }

    public void setRequireJwtSecuredAuthorizationResponseMode(Boolean requireJwtSecuredAuthorizationResponseMode) {
        this.requireJwtSecuredAuthorizationResponseMode = requireJwtSecuredAuthorizationResponseMode;
    }

    public Calendar getExtendedMetadataParamsLastModified() {
        return this.extendedMetadataParamsLastModified;
    }

    public void setExtendedMetadataParamsLastModified(Calendar extendedMetadataParamsLastModified) {
        this.extendedMetadataParamsLastModified = extendedMetadataParamsLastModified;
    }

    public String getRequireOfflineAccessScopeToIssueRefreshTokens() {
        return this.requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public void setRequireOfflineAccessScopeToIssueRefreshTokens(String requireOfflineAccessScopeToIssueRefreshTokens) {
        this.requireOfflineAccessScopeToIssueRefreshTokens = requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public String getOfflineAccessRequireConsentPrompt() {
        return this.offlineAccessRequireConsentPrompt;
    }

    public void setOfflineAccessRequireConsentPrompt(String offlineAccessRequireConsentPrompt) {
        this.offlineAccessRequireConsentPrompt = offlineAccessRequireConsentPrompt;
    }

    public String getLockoutMaxMaliciousActionsType() {
        return this.lockoutMaxMaliciousActionsType;
    }

    public void setLockoutMaxMaliciousActionsType(String lockoutMaxMaliciousActionsType) {
        this.lockoutMaxMaliciousActionsType = lockoutMaxMaliciousActionsType;
    }

    public Integer getLockoutMaxMaliciousActions() {
        return this.lockoutMaxMaliciousActions;
    }

    public void setLockoutMaxMaliciousActions(Integer lockoutMaxMaliciousActions) {
        this.lockoutMaxMaliciousActions = lockoutMaxMaliciousActions;
    }
}

