/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.oauth.client.setting.xmlbinding.ClientSettingDocument;
import org.sourceid.oauth.client.setting.xmlbinding.ClientSettingType;
import org.sourceid.oauth.client.setting.xmlbinding.ExtendedMetadataType;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.ClientSettingsAuthorizationDetailTypesSanitizer;
import org.sourceid.oauth20.domain.ClientSettingsScopeSanitizer;
import org.sourceid.oauth20.domain.Sanitizer;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public class ClientSettingManagerImpl
implements ClientSettingManager,
AutoReloadable {
    public static final String FILENAME = "oauth-client-settings.xml";
    private final XmlLoader xmlLoader;
    private final SysDirInfo sysDirInfo;
    private ClientSetting clientSetting = null;

    public ClientSettingManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this.xmlLoader = xmlLoader;
        this.sysDirInfo = sysDirInfo;
        this.reloadFromXml();
    }

    private synchronized void reloadFromXml() {
        this.clientSetting = new ClientSetting();
        ClientSettingDocument doc = this.getClientSettingDoc();
        ClientSettingType xmlClientSetting = doc.getClientSetting();
        Map<String, ClientParam> extendedMetadataParams = this.getExtendedMetadataParams(xmlClientSetting);
        this.clientSetting.setExtendedMetadataParams(extendedMetadataParams);
        this.clientSetting.setEnableDynamicClientRegistration(xmlClientSetting.getEnableDynamicClientRegistration());
        this.clientSetting.setRequireInitialAccessToken(xmlClientSetting.getRequireInitialAccessToken());
        this.clientSetting.setInitialAccessTokenScope(xmlClientSetting.getInitialAccessTokenScope());
        this.clientSetting.setRestrictCommonScopes(xmlClientSetting.getRestrictScopes());
        this.clientSetting.setRestrictedCommonScopes(new HashSet<String>(Arrays.asList(xmlClientSetting.getRestrictedScopeArray())));
        this.clientSetting.setAllowedExclusiveScopes(new HashSet<String>(Arrays.asList(xmlClientSetting.getAllowedExclusiveScopesArray())));
        this.clientSetting.setAllowedAuthorizationDetailTypes(new HashSet<String>(Arrays.asList(xmlClientSetting.getAllowedAuthorizationDetailsTypesArray())));
        this.clientSetting.setPolicyPlugins(Arrays.asList(xmlClientSetting.getPolciyPluginsArray()));
        this.clientSetting.setEnforceReplayPrevention(xmlClientSetting.getEnforceOneTimeJWT());
        long idleTimeoutWindow = xmlClientSetting.getPersistentGrantIdleTimeout();
        String idleTimeoutType = this.getPersistentGrantTimeSettingType(idleTimeoutWindow);
        String idleTimeoutTimeUnit = "d";
        if ("OVERRIDE_SERVER_DEFAULT".equals(idleTimeoutType)) {
            idleTimeoutTimeUnit = xmlClientSetting.getPersistentGrantIdleTimeoutTimeUnit();
        }
        this.clientSetting.setPersistentGrantIdleTimeoutType(idleTimeoutType);
        this.clientSetting.setPersistentGrantIdleTimeout(idleTimeoutWindow);
        this.clientSetting.setPersistentGrantIdleTimeoutTimeUnit(idleTimeoutTimeUnit);
        String refreshRolling = null;
        if (xmlClientSetting.isSetRefreshRolling()) {
            refreshRolling = Boolean.toString(xmlClientSetting.getRefreshRolling());
        }
        this.clientSetting.setRefreshRolling(refreshRolling);
        if (StringUtils.isEmpty((String)xmlClientSetting.getRefreshRollingInterval())) {
            this.clientSetting.setRefreshTokenRollingInterval(null);
            this.clientSetting.setRefreshTokenRollingIntervalTimeUnit(null);
        } else {
            this.clientSetting.setRefreshTokenRollingInterval(Long.parseLong(xmlClientSetting.getRefreshRollingInterval()));
            this.clientSetting.setRefreshTokenRollingIntervalTimeUnit(xmlClientSetting.getRefreshRollingIntervalTimeUnit());
        }
        long expTime = xmlClientSetting.getPersistentGrantExpirationTime();
        String expType = this.getPersistentGrantTimeSettingType(expTime);
        String expTimeUnit = "d";
        if ("OVERRIDE_SERVER_DEFAULT".equals(expType)) {
            expTimeUnit = xmlClientSetting.getPersistentGrantExpirationTimeUnit();
        }
        this.clientSetting.setPersistentGrantExpirationType(expType);
        this.clientSetting.setPersistentGrantExpirationTime(expTime);
        this.clientSetting.setPersistentGrantExpirationTimeUnit(expTimeUnit);
        this.clientSetting.setIdTokenSigningAlgorithm(xmlClientSetting.getIdTokenSigningAlgorithm());
        this.clientSetting.setPolicyGroupId(xmlClientSetting.getPolicyGroupId());
        this.clientSetting.setRequireSignedRequests(xmlClientSetting.getIsRequireSignedRequest());
        this.clientSetting.setDefaultAccessTokenManagerId(xmlClientSetting.getDefaultAccessTokenManagerId());
        this.clientSetting.setRestrictToDefaultAccessTokenManager(xmlClientSetting.getRestrictToDefaultAccessTokenManager());
        this.clientSetting.setClientCertIssuerDn(xmlClientSetting.getClientCertIssuerDN());
        this.clientSetting.setDeviceFlowSettingType(xmlClientSetting.getDeviceFlowSettingType());
        this.clientSetting.setUserAuthzUrlOverride(xmlClientSetting.getUserAuthzUrlOverride());
        if (xmlClientSetting.getPendingAuthzTimeoutOverride() > 0) {
            this.clientSetting.setPendingAuthzTimeoutOverride(xmlClientSetting.getPendingAuthzTimeoutOverride());
        }
        if (xmlClientSetting.getDevicePollingIntervalOverride() > 0) {
            this.clientSetting.setDevicePollingIntervalOverride(xmlClientSetting.getDevicePollingIntervalOverride());
        }
        if (xmlClientSetting.isSetBypassActivationCodeConfirmationOverride()) {
            this.clientSetting.setBypassActivationCodeConfirmationOverride(xmlClientSetting.getBypassActivationCodeConfirmationOverride());
        }
        if (xmlClientSetting.isSetRequireProofKeyForCodeExchange()) {
            this.clientSetting.setRequireProofKeyForCodeExchange(xmlClientSetting.getRequireProofKeyForCodeExchange());
        }
        this.clientSetting.setCibaPolicyId(xmlClientSetting.getCibaPolicyId());
        this.clientSetting.setCibaRequireSignedRequests(xmlClientSetting.getCibaRequireSignedRequests());
        if (xmlClientSetting.getCibaPollingInterval() > 0L) {
            this.clientSetting.setCibaPollingInterval((int)xmlClientSetting.getCibaPollingInterval());
        }
        this.clientSetting.setTokenExchangeProcessorPolicyId(xmlClientSetting.getTokenExchangeProcessorPolicyId());
        this.clientSetting.setRefreshTokenRollingGracePeriodType(xmlClientSetting.getRefreshTokenRollingGracePeriodType());
        if (xmlClientSetting.isSetRefreshTokenRollingGracePeriod() && xmlClientSetting.getRefreshTokenRollingGracePeriod() >= 0) {
            this.clientSetting.setRefreshTokenRollingGracePeriod(xmlClientSetting.getRefreshTokenRollingGracePeriod());
        }
        this.clientSetting.setEnableDynamicClientRegistrationManagement(xmlClientSetting.getEnableDynamicClientRegistrationManagement());
        this.clientSetting.setRotateClientSecret(xmlClientSetting.getRotateClientSecret());
        this.clientSetting.setRotateRegistrationAccessToken(xmlClientSetting.getRotateRegistrationAccessToken());
        this.clientSetting.setAllowClientDelete(xmlClientSetting.getAllowClientDelete());
        this.clientSetting.setDisableRegistrationAccessTokens(xmlClientSetting.getDisableRegistrationAccessTokens());
        this.clientSetting.setRetainClientSecret(xmlClientSetting.getRetainClientSecret());
        if (xmlClientSetting.getClientSecretRetentionPeriod() > 0) {
            this.clientSetting.setClientSecretRetentionPeriod(xmlClientSetting.getClientSecretRetentionPeriod());
        }
        this.clientSetting.setClientSecretRetentionPeriodType(xmlClientSetting.getClientSecretRetentionPeriodType());
        this.clientSetting.setRequireJwtSecuredAuthorizationResponseMode(xmlClientSetting.getRequireJwtSecuredAuthorizationResponseMode());
        if (xmlClientSetting.isSetExtendedMetataLastModified()) {
            this.clientSetting.setExtendedMetadataParamsLastModified(xmlClientSetting.getExtendedMetataLastModified());
        }
        this.clientSetting.setRequireOfflineAccessScopeToIssueRefreshTokens(xmlClientSetting.getRequireOfflineAccessScopeToIssueRefreshTokens());
        this.clientSetting.setOfflineAccessRequireConsentPrompt(xmlClientSetting.getOfflineAccessRequireConsentPrompt());
        this.clientSetting.setLockoutMaxMaliciousActionsType(xmlClientSetting.getLockoutMaxMaliciousActionsType());
        if ("SERVER_DEFAULT".equals(this.clientSetting.getLockoutMaxMaliciousActionsType())) {
            this.clientSetting.setLockoutMaxMaliciousActions(null);
        } else if (xmlClientSetting.isSetLockoutMaxMaliciousActions() && xmlClientSetting.getLockoutMaxMaliciousActions() >= 0) {
            this.clientSetting.setLockoutMaxMaliciousActions(xmlClientSetting.getLockoutMaxMaliciousActions());
        }
    }

    private ClientSettingDocument getClientSettingDoc() {
        ClientSettingDocument clientSettingDocument;
        String dataDir = this.sysDirInfo.getDataDirectory();
        if (this.xmlLoader.xmlExists(dataDir, FILENAME)) {
            XmlObject xmlObject = this.xmlLoader.load(dataDir, FILENAME);
            clientSettingDocument = (ClientSettingDocument)xmlObject;
        } else {
            clientSettingDocument = ClientSettingDocument.Factory.newInstance();
            clientSettingDocument.addNewClientSetting();
        }
        return clientSettingDocument;
    }

    @Override
    public void saveClientSetting(ClientSetting clientSetting) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doSaveClientSetting(clientSetting);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_CLIENT_REGISTRATION_SETTINGS, AdminAuditLogger.Event.MODIFY);
        }
    }

    private synchronized void doSaveClientSetting(ClientSetting clientSetting) {
        String requireOfflineAccessScopeToIssueRTs;
        ClientSettingDocument clientSettingDocument = this.getClientSettingDoc();
        ExtendedMetadataType[] extendedMetadata = this.getExtendedMetadataParams(clientSetting.getExtendedMetadataParams());
        ClientSettingType xmlClientSetting = clientSettingDocument.getClientSetting();
        xmlClientSetting.setExtendedMetadataArray(extendedMetadata);
        xmlClientSetting.setEnableDynamicClientRegistration(clientSetting.isEnableDynamicClientRegistration());
        xmlClientSetting.setRequireInitialAccessToken(clientSetting.isRequireInitialAccessToken());
        xmlClientSetting.setInitialAccessTokenScope(clientSetting.getInitialAccessTokenScope());
        xmlClientSetting.setRestrictScopes(clientSetting.isRestrictCommonScopes());
        xmlClientSetting.setRestrictedScopeArray(clientSetting.getRestrictedCommonScopes() != null ? clientSetting.getRestrictedCommonScopes().toArray(new String[clientSetting.getRestrictedCommonScopes().size()]) : new String[]{});
        xmlClientSetting.setAllowedExclusiveScopesArray(clientSetting.getAllowedExclusiveScopes() != null ? clientSetting.getAllowedExclusiveScopes().toArray(new String[clientSetting.getAllowedExclusiveScopes().size()]) : new String[]{});
        xmlClientSetting.setAllowedAuthorizationDetailsTypesArray(clientSetting.getAllowedAuthorizationDetailTypes() != null ? clientSetting.getAllowedAuthorizationDetailTypes().toArray(new String[clientSetting.getAllowedAuthorizationDetailTypes().size()]) : new String[]{});
        List<String> policyPlugins = clientSetting.getPolicyPlugins();
        String[] policyPluginArray = policyPlugins != null ? policyPlugins.toArray(new String[policyPlugins.size()]) : new String[]{};
        xmlClientSetting.setPolciyPluginsArray(policyPluginArray);
        xmlClientSetting.setEnforceOneTimeJWT(clientSetting.isEnforceReplayPrevention());
        if (clientSetting.getRefreshRolling() != null) {
            xmlClientSetting.setRefreshRolling(Boolean.parseBoolean(clientSetting.getRefreshRolling()));
        } else if (xmlClientSetting.isSetRefreshRolling()) {
            xmlClientSetting.unsetRefreshRolling();
        }
        if (clientSetting.getRefreshTokenRollingInterval() == null) {
            xmlClientSetting.setRefreshRollingInterval(null);
            xmlClientSetting.setRefreshRollingIntervalTimeUnit(null);
        } else {
            xmlClientSetting.setRefreshRollingInterval(Long.toString(clientSetting.getRefreshTokenRollingInterval()));
            String refreshTokenRollingIntervalTimeUnit = clientSetting.getRefreshTokenRollingIntervalTimeUnit() == null ? "h" : clientSetting.getRefreshTokenRollingIntervalTimeUnit();
            xmlClientSetting.setRefreshRollingIntervalTimeUnit(refreshTokenRollingIntervalTimeUnit);
        }
        xmlClientSetting.setPersistentGrantExpirationTime(this.getPersistentGrantTimeSettingValueToStore(clientSetting.getPersistentGrantExpirationType(), clientSetting.getPersistentGrantExpirationTime()));
        if (clientSetting.getPersistentGrantExpirationTimeUnit() != null) {
            xmlClientSetting.setPersistentGrantExpirationTimeUnit(clientSetting.getPersistentGrantExpirationTimeUnit());
        }
        xmlClientSetting.setPersistentGrantIdleTimeout(this.getPersistentGrantTimeSettingValueToStore(clientSetting.getPersistentGrantIdleTimeoutType(), clientSetting.getPersistentGrantIdleTimeout()));
        if (clientSetting.getPersistentGrantIdleTimeoutTimeUnit() != null) {
            xmlClientSetting.setPersistentGrantIdleTimeoutTimeUnit(clientSetting.getPersistentGrantIdleTimeoutTimeUnit());
        }
        xmlClientSetting.setIdTokenSigningAlgorithm(clientSetting.getIdTokenSigningAlgorithm());
        xmlClientSetting.setPolicyGroupId(clientSetting.getPolicyGroupId());
        xmlClientSetting.setIsRequireSignedRequest(clientSetting.isRequireSignedRequests());
        xmlClientSetting.setDefaultAccessTokenManagerId(clientSetting.getDefaultAccessTokenManagerId());
        xmlClientSetting.setRestrictToDefaultAccessTokenManager(clientSetting.isRestrictToDefaultAccessTokenManager());
        xmlClientSetting.setClientCertIssuerDN(clientSetting.getClientCertIssuerDn());
        xmlClientSetting.setDeviceFlowSettingType(clientSetting.getDeviceFlowSettingType());
        if (StringUtils.isNotBlank((String)clientSetting.getUserAuthzUrlOverride())) {
            xmlClientSetting.setUserAuthzUrlOverride(clientSetting.getUserAuthzUrlOverride());
        } else if (xmlClientSetting.isSetUserAuthzUrlOverride()) {
            xmlClientSetting.unsetUserAuthzUrlOverride();
        }
        if (clientSetting.getPendingAuthzTimeoutOverride() != null) {
            xmlClientSetting.setPendingAuthzTimeoutOverride(clientSetting.getPendingAuthzTimeoutOverride().intValue());
        } else if (xmlClientSetting.isSetPendingAuthzTimeoutOverride()) {
            xmlClientSetting.unsetPendingAuthzTimeoutOverride();
        }
        if (clientSetting.getDevicePollingIntervalOverride() != null) {
            xmlClientSetting.setDevicePollingIntervalOverride(clientSetting.getDevicePollingIntervalOverride().intValue());
        } else if (xmlClientSetting.isSetDevicePollingIntervalOverride()) {
            xmlClientSetting.unsetDevicePollingIntervalOverride();
        }
        if (clientSetting.getBypassActivationCodeConfirmationOverride() != null) {
            xmlClientSetting.setBypassActivationCodeConfirmationOverride(clientSetting.getBypassActivationCodeConfirmationOverride().booleanValue());
        } else if (xmlClientSetting.isSetBypassActivationCodeConfirmationOverride()) {
            xmlClientSetting.unsetBypassActivationCodeConfirmationOverride();
        }
        xmlClientSetting.setRequireProofKeyForCodeExchange(clientSetting.isRequireProofKeyForCodeExchange());
        xmlClientSetting.setCibaPolicyId(clientSetting.getCibaPolicyId());
        xmlClientSetting.setCibaPollingInterval((long)clientSetting.getCibaPollingInterval());
        xmlClientSetting.setCibaRequireSignedRequests(clientSetting.isCibaRequireSignedRequests());
        xmlClientSetting.setTokenExchangeProcessorPolicyId(clientSetting.getTokenExchangeProcessorPolicyId());
        xmlClientSetting.setRefreshTokenRollingGracePeriodType(clientSetting.getRefreshTokenRollingGracePeriodType());
        if (clientSetting.getRefreshTokenRollingGracePeriod() != null) {
            xmlClientSetting.setRefreshTokenRollingGracePeriod(clientSetting.getRefreshTokenRollingGracePeriod().intValue());
        } else if (xmlClientSetting.isSetRefreshTokenRollingGracePeriod()) {
            xmlClientSetting.unsetRefreshTokenRollingGracePeriod();
        }
        xmlClientSetting.setEnableDynamicClientRegistrationManagement(clientSetting.isEnableDynamicClientRegistrationManagement());
        xmlClientSetting.setRotateClientSecret(clientSetting.isRotateClientSecret());
        xmlClientSetting.setRetainClientSecret(clientSetting.isRetainClientSecret());
        xmlClientSetting.setClientSecretRetentionPeriodType(clientSetting.getClientSecretRetentionPeriodType());
        if (clientSetting.getClientSecretRetentionPeriod() != null) {
            xmlClientSetting.setClientSecretRetentionPeriod(clientSetting.getClientSecretRetentionPeriod().intValue());
        }
        xmlClientSetting.setRotateRegistrationAccessToken(clientSetting.isRotateRegistrationAccessToken());
        xmlClientSetting.setAllowClientDelete(clientSetting.isAllowClientDelete());
        xmlClientSetting.setDisableRegistrationAccessTokens(clientSetting.isDisableRegistrationAccessTokens());
        if (clientSetting.getRequireJwtSecuredAuthorizationResponseMode() != null) {
            xmlClientSetting.setRequireJwtSecuredAuthorizationResponseMode(clientSetting.getRequireJwtSecuredAuthorizationResponseMode().booleanValue());
        } else if (xmlClientSetting.isSetRequireJwtSecuredAuthorizationResponseMode()) {
            xmlClientSetting.unsetRequireJwtSecuredAuthorizationResponseMode();
        }
        if (clientSetting.getExtendedMetadataParamsLastModified() != null) {
            xmlClientSetting.setExtendedMetataLastModified(clientSetting.getExtendedMetadataParamsLastModified());
        }
        if (StringUtils.isNotBlank((String)(requireOfflineAccessScopeToIssueRTs = clientSetting.getRequireOfflineAccessScopeToIssueRefreshTokens()))) {
            xmlClientSetting.setRequireOfflineAccessScopeToIssueRefreshTokens(requireOfflineAccessScopeToIssueRTs);
            if ("Yes".equals(requireOfflineAccessScopeToIssueRTs)) {
                xmlClientSetting.setOfflineAccessRequireConsentPrompt(clientSetting.getOfflineAccessRequireConsentPrompt());
            } else if (xmlClientSetting.isSetOfflineAccessRequireConsentPrompt()) {
                xmlClientSetting.unsetOfflineAccessRequireConsentPrompt();
            }
        } else {
            if (xmlClientSetting.isSetRequireOfflineAccessScopeToIssueRefreshTokens()) {
                xmlClientSetting.unsetRequireOfflineAccessScopeToIssueRefreshTokens();
            }
            if (xmlClientSetting.isSetOfflineAccessRequireConsentPrompt()) {
                xmlClientSetting.unsetOfflineAccessRequireConsentPrompt();
            }
        }
        xmlClientSetting.setLockoutMaxMaliciousActionsType(clientSetting.getLockoutMaxMaliciousActionsType());
        if ("OVERRIDE_SERVER_DEFAULT".equals(clientSetting.getLockoutMaxMaliciousActionsType())) {
            if (clientSetting.getLockoutMaxMaliciousActions() != null) {
                xmlClientSetting.setLockoutMaxMaliciousActions(clientSetting.getLockoutMaxMaliciousActions().intValue());
            }
        } else if (xmlClientSetting.isSetLockoutMaxMaliciousActions()) {
            xmlClientSetting.unsetLockoutMaxMaliciousActions();
        }
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), FILENAME, (XmlObject)clientSettingDocument);
        this.reloadFromXml();
    }

    @Override
    public synchronized ClientSetting getClientSetting() {
        return this.sanitizeClientSettings(this.clientSetting, new ClientSettingsScopeSanitizer(), new ClientSettingsAuthorizationDetailTypesSanitizer());
    }

    private ClientSetting sanitizeClientSettings(ClientSetting clientSetting, Sanitizer<ClientSetting> ... sanitizers) {
        ClientSetting sanitizedSettings = clientSetting;
        for (Sanitizer<ClientSetting> sanitizer : sanitizers) {
            sanitizedSettings = sanitizer.sanitize(sanitizedSettings);
        }
        return sanitizedSettings;
    }

    private Map<String, ClientParam> getExtendedMetadataParams(ClientSettingType clientXmlType) {
        HashMap<String, ClientParam> extendedMetadata = new HashMap<String, ClientParam>();
        ExtendedMetadataType[] extendedMetadataParams = clientXmlType.getExtendedMetadataArray();
        if (extendedMetadataParams != null) {
            for (int i = 0; i < extendedMetadataParams.length; ++i) {
                String name = extendedMetadataParams[i].getParameterName();
                String desc = extendedMetadataParams[i].getParameterDescription();
                boolean isMultiValued = extendedMetadataParams[i].getIsMultiValued();
                extendedMetadata.put(name, new ClientParam(desc, isMultiValued));
            }
        }
        return extendedMetadata;
    }

    private ExtendedMetadataType[] getExtendedMetadataParams(Map<String, ClientParam> extendedMetadataParams) {
        ExtendedMetadataType[] extendedMetdataParamTypes = null;
        if (extendedMetadataParams != null) {
            ArrayList<ExtendedMetadataType> extendedMetadataElements = new ArrayList<ExtendedMetadataType>(extendedMetadataParams.size());
            for (Map.Entry<String, ClientParam> entry : extendedMetadataParams.entrySet()) {
                ExtendedMetadataType metadataType = ExtendedMetadataType.Factory.newInstance();
                metadataType.setParameterName(entry.getKey());
                String desc = entry.getValue() == null ? "" : entry.getValue().getParamDescription();
                metadataType.setParameterDescription(desc);
                metadataType.setIsMultiValued(entry.getValue().isMultiValued());
                extendedMetadataElements.add(metadataType);
            }
            extendedMetdataParamTypes = new ExtendedMetadataType[extendedMetadataElements.size()];
            extendedMetadataElements.toArray(extendedMetdataParamTypes);
        }
        return extendedMetdataParamTypes;
    }

    protected long getPersistentGrantTimeSettingValueToStore(String timeSettingType, Long timeSettingValue) {
        long valueToStore = 0L;
        if (timeSettingType != null) {
            switch (timeSettingType) {
                case "OVERRIDE_SERVER_DEFAULT": {
                    if (timeSettingValue == null) break;
                    valueToStore = timeSettingValue;
                    break;
                }
                case "NONE": {
                    valueToStore = -1L;
                    break;
                }
            }
        }
        return valueToStore;
    }

    protected String getPersistentGrantTimeSettingType(long storeValue) {
        String settingType = "SERVER_DEFAULT";
        if (storeValue > 0L) {
            settingType = "OVERRIDE_SERVER_DEFAULT";
        } else if (storeValue < 0L) {
            settingType = "NONE";
        }
        return settingType;
    }

    @Override
    public synchronized void saveExtendedProperties(Map<String, ClientParam> extendedMetadataParams) {
        ClientSetting settings = this.clientSetting.clone();
        settings.setExtendedMetadataParams(extendedMetadataParams);
        settings.setExtendedMetadataParamsLastModified((Calendar)new XmlCalendar(new Date()));
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doSaveClientSetting(settings);
            auditLoggerScope.log(AdminAuditLogger.Component.EXTENDED_PROPERTIES, AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized Map<String, ClientParam> getExtendedProperties() {
        return this.clientSetting.getExtendedMetadataParams();
    }
}

