/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.Sanitizer;
import org.sourceid.oauth20.domain.ScopeUtil;

public class ClientSettingsScopeSanitizer
implements Sanitizer<ClientSetting> {
    private Set<String> availableScopesAndGroups = ScopeUtil.getScopeAndGroupNames();
    private Set<String> availableExclusiveScopesAndGroups = ScopeUtil.getExclusiveScopeAndGroupNames();

    @Override
    public ClientSetting sanitize(ClientSetting clientSetting) {
        if (clientSetting == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(clientSetting.getRestrictedCommonScopes())) {
            clientSetting.setRestrictedCommonScopes(clientSetting.getRestrictedCommonScopes().stream().filter(this.availableScopesAndGroups::contains).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(clientSetting.getAllowedExclusiveScopes())) {
            clientSetting.setAllowedExclusiveScopes(clientSetting.getAllowedExclusiveScopes().stream().filter(this.availableExclusiveScopesAndGroups::contains).collect(Collectors.toSet()));
        }
        return clientSetting;
    }
}

