/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.security.Key;
import java.util.List;
import java.util.stream.Collectors;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.jwk.VerificationJwkSelector;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.HmacKey;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;
import org.sourceid.oauth20.domain.Client;

public final class ClientVerificationSecretResolver
implements VerificationKeyResolver {
    private final Client client;
    private Key selectedKey = null;

    public ClientVerificationSecretResolver(Client client) {
        this.client = client;
    }

    public Key resolveKey(JsonWebSignature jsonWebSignature, List<JsonWebStructure> list) throws UnresolvableKeyException {
        try {
            List symmetricKeys = this.client.getAllReversibleSecretsAsUtf8Bytes().stream().map(HmacKey::new).map(OctetSequenceJsonWebKey::new).collect(Collectors.toList());
            Key key = new VerificationJwkSelector().selectWithVerifySignatureDisambiguate(jsonWebSignature, symmetricKeys).getKey();
            if (key != null) {
                this.selectedKey = key;
            }
            return key;
        }
        catch (JoseException e) {
            throw new RuntimeException("Error creating verification key resolver for client secrets", e);
        }
    }

    public Key getSelectedKey() {
        return this.selectedKey;
    }
}

