/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.util.StringUtil;

public class CorsSettings {
    private List<String> urlPatterns = new ArrayList<String>();
    private List<String> allowedOriginsList = new ArrayList<String>();
    private List<String> allowedMethods = new ArrayList<String>();
    private List<String> allowedHeaders = new ArrayList<String>();
    private int preflightMaxAge;
    private static final String ANY_ORIGIN = "*";
    private static final String DEFAULT_ALLOWED_ORIGINS = "";

    public CorsSettings() {
    }

    public CorsSettings(CorsSettings other) {
        this.allowedHeaders = new ArrayList<String>(other.getAllowedHeaders());
        this.allowedMethods = new ArrayList<String>(other.getAllowedMethods());
        this.allowedOriginsList = new ArrayList<String>(other.getAllowedOriginsList());
        this.urlPatterns = new ArrayList<String>(other.getUrlPatterns());
        this.preflightMaxAge = other.getPreflightMaxAge();
    }

    public List<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setUrlPatterns(List<String> urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public List<String> getAllowedOriginsList() {
        return this.allowedOriginsList;
    }

    public void setAllowedOriginsList(List<String> allowedOriginsList) {
        this.allowedOriginsList = allowedOriginsList;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public int getPreflightMaxAge() {
        return this.preflightMaxAge;
    }

    public void setPreflightMaxAge(int preflightMaxAge) {
        this.preflightMaxAge = preflightMaxAge;
    }

    public boolean isAnyOriginAllowed() {
        String allowedOriginsConfig = StringUtils.join(this.getAllowedOriginsList(), (char)',');
        return this.generateAllowedOrigins(allowedOriginsConfig, DEFAULT_ALLOWED_ORIGINS);
    }

    public boolean isAnyHeadersAllowed() {
        return this.isAnyHeadersAllowed(this.allowedHeaders);
    }

    private boolean isAnyHeadersAllowed(List<String> allowedHeaders) {
        return allowedHeaders.contains(ANY_ORIGIN);
    }

    private boolean generateAllowedOrigins(String allowedOriginsConfig, String defaultOrigin) {
        String[] allowedOrigins;
        if (allowedOriginsConfig == null) {
            allowedOriginsConfig = defaultOrigin;
        }
        for (String allowedOrigin : allowedOrigins = StringUtil.csvSplit((String)allowedOriginsConfig)) {
            if (allowedOrigin.length() <= 0 || !ANY_ORIGIN.equals(allowedOrigin)) continue;
            return true;
        }
        return false;
    }
}

