/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.sdk.oauth20.registration.ClientAuthType;
import com.pingidentity.sdk.oauth20.registration.DynamicClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.Util;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ClientUtil;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.openid.ciba.CibaDeliveryMode;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DynamicOAuthClient
extends Client
implements DynamicClient {
    private static final Log log = LogFactory.getLog(DynamicOAuthClient.class);
    private String softwareStatement;
    private String secret;

    public DynamicOAuthClient(Client client) {
        super(client);
    }

    public DynamicOAuthClient() {
    }

    public String getSoftwareStatement() {
        return this.softwareStatement;
    }

    public void setSoftwareStatement(String softwareStatement) {
        this.softwareStatement = softwareStatement;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public void setSecret(String secret) {
        super.setSecret(secret);
        this.secret = secret;
    }

    public void generateSecret(int length) {
        String secret = IDGenerator.rndAlphaNumeric(length);
        super.setSecret(secret);
        this.secret = secret;
    }

    public String getClientAuthenticationType() {
        return ClientAuthenticationType.toClientAuthnType((ClientAuthenticationType)super.getClientAuthnType());
    }

    public DynamicClient.Status setClientAuthenticationType(String authenticationType) {
        try {
            ClientAuthType type = ClientAuthType.valueOf((String)authenticationType.toLowerCase());
            this.setClientAuthnType(type.getDomainClientAuthnType());
            return DynamicClient.Status.SUCCESS;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("[" + authenticationType + "] is not a supported authentication type."));
            return DynamicClient.Status.FAILURE;
        }
    }

    public List<String> getScopes() {
        return this.getRestrictedScopes();
    }

    public void setScopes(List<String> scopes) {
        ClientUtil.setScopes(scopes, this);
    }

    public List<String> getAllowedAuthorizationDetailsTypes() {
        return this.getAuthorizationDetailTypes();
    }

    public void setAllowedAuthorizationDetailsTypes(List<String> authorizationDetailsTypes) {
        ClientUtil.setAuthorizationDetailsTypes(authorizationDetailsTypes, this);
    }

    public Set<String> getClientMetadataKeys() {
        Set<String> extendedParamKeys = MgmtFactory.getClientSettingManager().getClientSetting().getExtendedMetadataParams().keySet();
        Set<String> supplementalInfoKeys = this.getSupplementalInfo().keySet();
        HashSet<String> result = new HashSet<String>();
        result.addAll(extendedParamKeys);
        result.addAll(supplementalInfoKeys);
        return result;
    }

    public List<String> getClientMetadataValues(String key) {
        List extendedParamElements = this.getExtendedParams().get(key).getElements();
        if (extendedParamElements != null && !extendedParamElements.isEmpty()) {
            return extendedParamElements;
        }
        String supplementalInfo = this.getSupplementalInfo(key);
        if (StringUtils.isNotBlank((String)supplementalInfo)) {
            return Collections.singletonList(supplementalInfo);
        }
        return Collections.emptyList();
    }

    public DynamicClient.Status addClientMetadataValues(String key, List<String> values) {
        boolean supplementalInfoContainsKey;
        Map<String, ClientParam> metadataParams = MgmtFactory.getClientSettingManager().getClientSetting().getExtendedMetadataParams();
        Map<String, String> supplementalInfo = this.getSupplementalInfo();
        boolean metadataContainsKey = metadataParams != null && !metadataParams.isEmpty() && metadataParams.containsKey(key);
        boolean bl = supplementalInfoContainsKey = supplementalInfo != null && !supplementalInfo.isEmpty() && supplementalInfo.containsKey(key);
        if (!metadataContainsKey && !supplementalInfoContainsKey) {
            return DynamicClient.Status.INVALID_KEY;
        }
        if (metadataContainsKey) {
            ParamValues paramValues = new ParamValues();
            paramValues.setElements(values);
            this.addExtendedParam(key, paramValues);
        } else {
            if (values.size() > 1) {
                return DynamicClient.Status.MULTI_VALUE_NOT_ALLOWED;
            }
            this.setSupplementalInfo(key, values.get(0));
        }
        return DynamicClient.Status.SUCCESS;
    }

    public String getCibaDeliveryMode() {
        CibaDeliveryMode deliveryMode = this.getCibaTokenDeliveryMode();
        return deliveryMode != null ? deliveryMode.name() : null;
    }

    public void setCibaDeliveryMode(String mode) {
        CibaDeliveryMode cibaDeliveryMode = CibaDeliveryMode.lookupByName(mode);
        this.setCibaTokenDeliveryMode(cibaDeliveryMode);
    }

    public boolean isCibaSupportUserCode() {
        return BooleanUtils.toBoolean((Boolean)this.isCibaUserCodeSupported());
    }

    public void setCibaSupportUserCode(boolean supportUserCode) {
        this.setCibaUserCodeSupported(supportUserCode);
    }

    public String getFrontChannelLogoutUri() {
        List<String> logoutUris;
        if (this.getLogoutMode() == ClientLogoutMode.OIDC_FRONT_CHANNEL && !Util.isEmpty(logoutUris = this.getLogoutUris())) {
            return logoutUris.get(0);
        }
        return null;
    }

    public void setFrontChannelLogoutUri(String frontchannelLogoutUri) {
        if (StringUtils.isNotBlank((String)frontchannelLogoutUri)) {
            this.setLogoutUris(Arrays.asList(frontchannelLogoutUri));
        } else {
            this.setLogoutUris(new ArrayList<String>());
        }
    }
}

