/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Objects;

public class JWKSEndpointDynamicKeysSetting {
    private boolean publishCertificates;
    private String certOrgName;
    private String certOrgUnitName;
    private String certCountry;
    private String certState;
    private String certCity;

    private JWKSEndpointDynamicKeysSetting() {
    }

    public boolean isPublishCertificates() {
        return this.publishCertificates;
    }

    public String getCertOrgName() {
        return this.certOrgName;
    }

    public String getCertOrgUnitName() {
        return this.certOrgUnitName;
    }

    public String getCertCountry() {
        return this.certCountry;
    }

    public String getCertState() {
        return this.certState;
    }

    public String getCertCity() {
        return this.certCity;
    }

    public String toString() {
        return "JWKSEndpointDynamicKeysSetting{publishCertificates=" + this.publishCertificates + ", certOrgName='" + this.certOrgName + "', certOrgUnitName='" + this.certOrgUnitName + "', certCountry='" + this.certCountry + "', certState='" + this.certState + "', certCity='" + this.certCity + "'}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWKSEndpointDynamicKeysSetting that = (JWKSEndpointDynamicKeysSetting)o;
        return this.publishCertificates == that.publishCertificates && Objects.equals(this.certOrgName, that.certOrgName) && Objects.equals(this.certOrgUnitName, that.certOrgUnitName) && Objects.equals(this.certCountry, that.certCountry) && Objects.equals(this.certState, that.certState) && Objects.equals(this.certCity, that.certCity);
    }

    public int hashCode() {
        return Objects.hash(this.publishCertificates, this.certOrgName, this.certOrgUnitName, this.certCountry, this.certState, this.certCity);
    }

    public static class Builder {
        private final boolean publishCertificates;
        private String certOrgName;
        private String certOrgUnitName;
        private String certCountry;
        private String certState;
        private String certCity;

        public Builder(boolean publishCertificates) {
            this.publishCertificates = publishCertificates;
        }

        public Builder(JWKSEndpointDynamicKeysSetting other) {
            this.publishCertificates = other.publishCertificates;
            this.certOrgName = other.certOrgName;
            this.certOrgUnitName = other.certOrgUnitName;
            this.certCountry = other.certCountry;
            this.certState = other.certState;
            this.certCity = other.certCity;
        }

        public Builder certOrgName(String certOrgName) {
            this.certOrgName = certOrgName;
            return this;
        }

        public Builder certOrgUnitName(String certOrgUnitName) {
            this.certOrgUnitName = certOrgUnitName;
            return this;
        }

        public Builder certCountry(String certCountry) {
            this.certCountry = certCountry;
            return this;
        }

        public Builder certState(String certState) {
            this.certState = certState;
            return this;
        }

        public Builder certCity(String certCity) {
            this.certCity = certCity;
            return this;
        }

        public JWKSEndpointDynamicKeysSetting build() {
            JWKSEndpointDynamicKeysSetting dynamicKeys = new JWKSEndpointDynamicKeysSetting();
            dynamicKeys.publishCertificates = this.publishCertificates;
            dynamicKeys.certOrgName = this.certOrgName;
            dynamicKeys.certOrgUnitName = this.certOrgUnitName;
            dynamicKeys.certCountry = this.certCountry;
            dynamicKeys.certState = this.certState;
            dynamicKeys.certCity = this.certCity;
            return dynamicKeys;
        }
    }
}

