/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.JwtContext;

public class NbfTooLongAgoValidator
implements ErrorCodeValidator {
    private int nbfMaxPast;

    public NbfTooLongAgoValidator(int maxMinutesInThePast) {
        this.nbfMaxPast = maxMinutesInThePast;
    }

    public ErrorCodeValidator.Error validate(JwtContext jwtContext) throws MalformedClaimException {
        NumericDate evaluationTime;
        long deltaInSeconds;
        NumericDate notBefore = jwtContext.getJwtClaims().getNotBefore();
        if (this.nbfMaxPast > 0 && notBefore != null && (deltaInSeconds = (evaluationTime = NumericDate.now()).getValue() - notBefore.getValue()) > (long)this.nbfMaxPast * 60L) {
            String errMsg = "The Not Before (nbf=" + notBefore + ") claim value cannot be more than " + this.nbfMaxPast + " minutes in the past relative to the evaluation time " + evaluationTime;
            return new ErrorCodeValidator.Error(17, errMsg);
        }
        return null;
    }
}

