/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.common.util.JDBCHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.NewClientFile;
import org.sourceid.oauth20.domain.OAuthClientIndexDb;
import org.sourceid.oauth20.domain.OAuthClientIndexDbEntry;
import org.sourceid.saml20.metadata.partner.IndexDb;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class OAuthClientIndexDbImpl
extends IndexDb
implements OAuthClientIndexDb {
    private static final String CLIENT_ID = "CLIENT_ID";
    private static final String FILE_PATH = "FILE_PATH";
    private static final String MODIFIED_TIME = "MODIFIED_TIME";
    private static final String ALL_COLUMNS = StringUtils.join(Arrays.asList("CLIENT_ID", "FILE_PATH", "MODIFIED_TIME"), (String)",");
    private static final String SQL_CREATE_OAUTH_INDEX_TABLE = "CREATE TABLE IF NOT EXISTS OAUTH_CLIENT_INDEX(CLIENT_ID VARCHAR(256) PRIMARY KEY, FILE_PATH VARCHAR(256) NOT NULL, MODIFIED_TIME BIGINT, PRIMARY KEY (CLIENT_ID))";
    private static final String SQL_UPDATE_CLIENT = "MERGE INTO OAUTH_CLIENT_INDEX(" + ALL_COLUMNS + ") VALUES(?,?,?)";
    private static final String SQL_DELETE_CLIENT = "DELETE FROM OAUTH_CLIENT_INDEX WHERE CLIENT_ID=?";
    private static final String SQL_DELETE_CLIENTS = "DELETE FROM OAUTH_CLIENT_INDEX LIMIT ?";
    private static final String SQL_SELECT_CLIENT = "SELECT " + ALL_COLUMNS + " FROM OAUTH_CLIENT_INDEX WHERE CLIENT_ID = ?";
    private static final String SQL_SELECT_ALL_CLIENTS = "SELECT " + ALL_COLUMNS + " FROM OAUTH_CLIENT_INDEX";
    private static final String SQL_SELECT_CLIENT_COUNT = "SELECT COUNT(*) FROM OAUTH_CLIENT_INDEX";
    private static final String SQL_SELECT_CLIENTS_MODIFIED_SINCE = "SELECT " + ALL_COLUMNS + " FROM OAUTH_CLIENT_INDEX WHERE MODIFIED_TIME >= ?";
    private static final String SQL_SELECT_LATEST_UPDATE_TIMESTAMP = "SELECT MAX(MODIFIED_TIME) FROM OAUTH_CLIENT_INDEX";
    private static final String SQL_CREATE_NEW_CLIENT_FILES_TABLE = "CREATE TABLE IF NOT EXISTS NEW_CLIENT_FILES(CLIENT_ID VARCHAR(256) PRIMARY KEY, FILE_PATH VARCHAR(256) NOT NULL)";
    private static final String SQL_ADD_NEW_CLIENT_FILE = "MERGE INTO NEW_CLIENT_FILES(CLIENT_ID, FILE_PATH) VALUES (?,?)";
    private static final String SQL_SELECT_NEW_CLIENT_FILES = "SELECT CLIENT_ID, FILE_PATH FROM NEW_CLIENT_FILES";
    private static final String SQL_SELECT_NEW_CLIENT_FILE = "SELECT CLIENT_ID, FILE_PATH FROM NEW_CLIENT_FILES WHERE CLIENT_ID = ?";
    private static final String SQL_DELETE_NEW_CLIENT_FILES = "DELETE FROM NEW_CLIENT_FILES";
    private static final String SQL_DELETE_NEW_CLIENT_FILE = "DELETE FROM NEW_CLIENT_FILES WHERE CLIENT_ID = ?";
    private static final String SQL_SELECT_NEW_CLIENT_FILE_COUNT = "SELECT COUNT(*) FROM NEW_CLIENT_FILES";

    public OAuthClientIndexDbImpl() {
        this.createTables();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    private void createTables() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.execute(SQL_CREATE_OAUTH_INDEX_TABLE);
            helper.execute(SQL_CREATE_NEW_CLIENT_FILES_TABLE);
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error creating oauth index tables/indexes", e);
        }
    }

    public String getServiceName() {
        return "oauth-client-index-db";
    }

    @Override
    public void saveEntry(OAuthClientIndexDbEntry client) {
        this.saveEntries(Collections.singletonList(client));
    }

    @Override
    public void saveEntries(Collection<OAuthClientIndexDbEntry> clients) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.setAutoCommit(false);
            PreparedStatement statement = helper.getPreparedStatement(SQL_UPDATE_CLIENT);
            for (OAuthClientIndexDbEntry client : clients) {
                statement.setString(1, client.getClientId());
                statement.setString(2, client.getFileSystemPath());
                statement.setLong(3, client.getLastModifiedMillis());
                statement.execute();
            }
            helper.commit();
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public Collection<OAuthClientIndexDbEntry> getAllEntries() {
        ArrayList<OAuthClientIndexDbEntry> result = new ArrayList<OAuthClientIndexDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_ALL_CLIENTS);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                result.add(this.entryFromResultSet(resultSet));
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public void deleteEntry(String clientId) {
        this.deleteEntries(Collections.singletonList(clientId));
    }

    @Override
    public void deleteEntries(Collection<String> ids) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.setAutoCommit(false);
            PreparedStatement statement = helper.getPreparedStatement(SQL_DELETE_CLIENT);
            for (String clientId : ids) {
                statement.setString(1, clientId);
                statement.execute();
            }
            helper.commit();
        }
    }

    @Override
    public void deleteAllEntries() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement;
            helper.setAutoCommit(false);
            int deleted = 0;
            do {
                statement = helper.getPreparedStatement(SQL_DELETE_CLIENTS);
                statement.setInt(1, 1000);
            } while ((deleted = statement.executeUpdate()) == 1000);
            helper.commit();
        }
    }

    @Override
    public OAuthClientIndexDbEntry getEntry(String clientId) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CLIENT);
            statement.setString(1, clientId);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                OAuthClientIndexDbEntry oAuthClientIndexDbEntry = this.entryFromResultSet(resultSet);
                return oAuthClientIndexDbEntry;
            }
            OAuthClientIndexDbEntry oAuthClientIndexDbEntry = null;
            return oAuthClientIndexDbEntry;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public int getEntryCount() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_CLIENT_COUNT);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting client count", e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public void deleteNewClientFiles() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_DELETE_NEW_CLIENT_FILES);
            statement.execute();
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error deleting new client files", e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public void deleteNewClientFile(String id) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_DELETE_NEW_CLIENT_FILE);
            statement.setString(1, id);
            statement.execute();
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error deleting new client file", e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public Collection<NewClientFile> getNewClientFiles() {
        JDBCHelper helper = this.newJDBCHelper();
        try {
            ArrayList<NewClientFile> results = new ArrayList<NewClientFile>();
            helper.getPreparedStatement(SQL_SELECT_NEW_CLIENT_FILES);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                results.add(this.newClientFileFromResultSet(resultSet));
            }
            ArrayList<NewClientFile> arrayList = results;
            if (helper != null) {
                helper.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (helper != null) {
                    try {
                        helper.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new ProcessRuntimeException("Error getting new client files", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public NewClientFile getNewClientFile(String id) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_NEW_CLIENT_FILE);
            statement.setString(1, id);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                NewClientFile newClientFile = this.newClientFileFromResultSet(resultSet);
                return newClientFile;
            }
            NewClientFile newClientFile = null;
            return newClientFile;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting new client file", e);
        }
    }

    private NewClientFile newClientFileFromResultSet(ResultSet resultSet) throws SQLException {
        return new NewClientFile(resultSet.getString(CLIENT_ID), resultSet.getString(FILE_PATH));
    }

    private OAuthClientIndexDbEntry entryFromResultSet(ResultSet resultSet) throws SQLException {
        return new OAuthClientIndexDbEntry(resultSet.getString(CLIENT_ID), resultSet.getString(FILE_PATH), resultSet.getLong(MODIFIED_TIME));
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public Collection<OAuthClientIndexDbEntry> getEntriesModifiedSince(Date startTime) {
        ArrayList<OAuthClientIndexDbEntry> result = new ArrayList<OAuthClientIndexDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CLIENTS_MODIFIED_SINCE);
            statement.setLong(1, startTime.getTime());
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                OAuthClientIndexDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entries", e);
        }
        return result;
    }

    @Override
    public void addNewClientFiles(Collection<NewClientFile> clientFiles) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.setAutoCommit(false);
            PreparedStatement statement = helper.getPreparedStatement(SQL_ADD_NEW_CLIENT_FILE);
            for (NewClientFile clientFile : clientFiles) {
                statement.setString(1, clientFile.getClientId());
                statement.setString(2, clientFile.getFilePath());
                statement.execute();
            }
            helper.commit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public Date getLatestUpdateTimestamp() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_LATEST_UPDATE_TIMESTAMP);
            ResultSet resultSet = helper.getResultSet();
            if (!resultSet.next()) throw new ProcessRuntimeException("Query for latest update timestamp returned NULL");
            Date date = new Date(resultSet.getLong(1));
            return date;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting latest update timestamp", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public int getNewClientFileCount() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_NEW_CLIENT_FILE_COUNT);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting new client file count", e);
        }
    }
}

