/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.dpop;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.oauth20.AccessToken;
import com.pingidentity.sdk.oauth20.IssuedAccessToken;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.EmbeddedJwkVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.sourceid.auth.AuthorizationHeaderSupport;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.dpop.InvalidDpopProofException;
import org.sourceid.oauth20.dpop.NonceUtil;
import org.sourceid.oauth20.dpop.UseDpopNonceException;
import org.sourceid.oauth20.issuer.OAuthAudienceUtils;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.InternalPersistentGrantAttributes;
import org.sourceid.oauth20.token.TokenIntrospectResponse;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.BearerAssertionReplayPreventionServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.ResourceEvaluator;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public final class DpopUtil {
    private static final Log log = LogFactory.getLog(DpopUtil.class);
    public static final String DPOP_TOKEN_TYPE = "DPoP";
    private static final String DPOP_PROOF_HEADER_NAME = "DPoP";
    private static final String DPOP_PROOF_HEADER_PARAM_TYPE_VALUE = "application/dpop+jwt";
    private static final String DPOP_NONCE_HEADER_NAME = "DPoP-Nonce";
    private static final String CONFIRMATION_CLAIM_NAME = "cnf";
    private static final String JWK_THUMBPRINT_CLAIM_NAME = "jkt";
    private static final List<String> SUPPORTED_SIGNING_ALGORITHMS = Collections.unmodifiableList(Stream.of("RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "PS256", "PS384", "PS512").collect(Collectors.toList()));
    private static final AlgorithmConstraints ALGORITHM_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, SUPPORTED_SIGNING_ALGORITHMS.toArray(new String[0]));
    private static final AuthzServerManager AUTHZ_SERVER_MANAGER = MgmtFactory.getAuthzServerManager();
    private static final AssertionReplayPreventionService REPLAY_PREVENTION_SERVICE = StateMgmtFactory.getBearerAssertionReplayPreventionSvc();
    private static final ResourceEvaluator RESOURCE_EVALUATOR = new ResourceEvaluator();
    private static final ConfigStore CONFIG = ConfigStoreFarm.getConfig("org.sourceid.oauth20.dpop.DpopUtil");
    private static final int MAX_JTI_LENGTH = CONFIG.getIntValue("MaxJtiLength", 50);

    public static List<String> getSupportedSigningAlgorithms() {
        return SUPPORTED_SIGNING_ALGORITHMS;
    }

    public static String validateDpopProofInHeader(HttpServletRequest request, boolean isDpopProofRequired) throws InvalidDpopProofException, UseDpopNonceException {
        return DpopUtil.validateDpopProofInHeader(request, isDpopProofRequired, null, null);
    }

    public static String validateDpopProofInHeader(HttpServletRequest request, boolean isDpopProofRequired, String token, AccessToken accessToken) throws InvalidDpopProofException, UseDpopNonceException {
        if (token != null && accessToken == null || token == null && accessToken != null) {
            throw new IllegalArgumentException("access token string and access token must be either both null or both not null");
        }
        String dpopProofJwt = DpopUtil.getDpopProofJwtFromHeader(request);
        if (dpopProofJwt == null) {
            if (isDpopProofRequired) {
                AsAuditLogger.setDescription("DPoP header not found");
                throw new InvalidDpopProofException("DPoP header not found");
            }
            return null;
        }
        EmbeddedJwkVerificationKeyResolver embeddedJwkVerificationKeyResolver = new EmbeddedJwkVerificationKeyResolver();
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setExpectedType(true, DPOP_PROOF_HEADER_PARAM_TYPE_VALUE).setJwsAlgorithmConstraints(ALGORITHM_CONSTRAINTS).setVerificationKeyResolver((VerificationKeyResolver)embeddedJwkVerificationKeyResolver).setRequireJwtId().setRequireIssuedAt().build();
        try {
            JwtClaims jwtClaims = jwtConsumer.processToClaims(dpopProofJwt);
            DpopUtil.validateHtmClaim(request, jwtClaims);
            DpopUtil.validateHtuClaim(request, jwtClaims);
            DpopUtil.validateJtiClaim(jwtClaims);
            DpopUtil.validateIatNonceClaim(jwtClaims);
            String jkt = embeddedJwkVerificationKeyResolver.getJwk().calculateBase64urlEncodedThumbprint("SHA-256");
            if (token != null) {
                DpopUtil.validateProtectedResourceDpopBoundAccessToken(token, accessToken, jkt, jwtClaims);
            }
            return jkt;
        }
        catch (InvalidJwtException e) {
            log.debug((Object)("DPoP proof JWT is invalid: " + ExceptionUtil.toStringWithCauses(e)));
            AsAuditLogger.setDescription("The DPoP proof is invalid or expired");
            throw new InvalidDpopProofException("The DPoP proof is invalid or expired");
        }
    }

    public static void addJwkThumbprintConfirmationMethodToAttributeMap(AttributeMap attributes, String jwkThumbprint) {
        if (jwkThumbprint != null) {
            AttributeValue jktConfirmationMethodAttrValue = new AttributeValue(Collections.emptyList(), Collections.singletonList(Collections.singletonMap(JWK_THUMBPRINT_CLAIM_NAME, jwkThumbprint)));
            attributes.put(CONFIRMATION_CLAIM_NAME, jktConfirmationMethodAttrValue);
        }
    }

    public static void addJwkThumbprintToAccessGrantAttributesHolder(AccessGrantAttributesHolder accessGrantAttributesHolder, String jwkThumbprint) {
        if (jwkThumbprint == null) {
            return;
        }
        AttributeValue jwkThumbprintAttrValue = new AttributeValue(jwkThumbprint);
        accessGrantAttributesHolder.getExtendedGrantAttrs().put(InternalPersistentGrantAttributes.DPOP_JWK_THUMBPRINT.getKey(), jwkThumbprintAttrValue);
    }

    public static String getJwkThumbprintFromAccessGrantAttributesHolder(AccessGrantAttributesHolder accessGrantAttributesHolder) {
        return accessGrantAttributesHolder.getExtendedGrantAttrs().getSingleValue(InternalPersistentGrantAttributes.DPOP_JWK_THUMBPRINT.getKey());
    }

    public static boolean isJwkThumbprintMatching(String jwkThumbprint1, String jwkThumbprint2) {
        return Arrays.equals(Base64Url.decode((String)jwkThumbprint1), Base64Url.decode((String)jwkThumbprint2));
    }

    public static IssuedAccessToken covertToDPoPBoundAccessTokenIfNecessary(IssuedAccessToken issuedAccessToken, Map<String, AttributeValue> attributes) {
        if (DpopUtil.isDpopBoundAccessToken(attributes)) {
            return new IssuedAccessToken(issuedAccessToken.getTokenValue(), "DPoP", issuedAccessToken.getExpiresAt());
        }
        return issuedAccessToken;
    }

    public static void covertToDPoPBoundAccessTokenIntrospectResponseIfNecessary(TokenIntrospectResponse.Builder accessTokenResponseBuilder, Map<String, AttributeValue> attributes) {
        if (DpopUtil.isDpopBoundAccessToken(attributes)) {
            accessTokenResponseBuilder.setTokenType("DPoP");
        }
    }

    public static void addDpopNonceToHeader(HttpServletRequest request, boolean isDpopProofRequired, BiConsumer<String, String> addHeaderConsumer) {
        boolean addDpopNonceToHeader = false;
        if (AUTHZ_SERVER_MANAGER.isDpopProofRequireNonce()) {
            if (isDpopProofRequired) {
                addDpopNonceToHeader = true;
            } else {
                try {
                    addDpopNonceToHeader = DpopUtil.getDpopProofJwtFromHeader(request) != null;
                }
                catch (InvalidDpopProofException invalidDpopProofException) {
                    // empty catch block
                }
            }
        }
        if (addDpopNonceToHeader) {
            long validUntilTimeMillis = System.currentTimeMillis() + (long)AUTHZ_SERVER_MANAGER.getDpopProofLifetimeSeconds() * 1000L;
            String nonce = NonceUtil.toNonce(validUntilTimeMillis);
            addHeaderConsumer.accept(DPOP_NONCE_HEADER_NAME, nonce);
        }
    }

    public static String getAccessTokenFromAuthorizationHeader(HttpServletRequest request) {
        return AuthorizationHeaderSupport.getAuthTokenValue(request, "DPoP");
    }

    public static boolean isDpopBoundAccessToken(Map<String, AttributeValue> attributes) {
        return DpopUtil.getJwkThumbprintConfirmation(attributes) != null;
    }

    private static String getJwkThumbprintConfirmation(Map<String, AttributeValue> attributes) {
        AttributeValue cnf = attributes.get(CONFIRMATION_CLAIM_NAME);
        if (cnf == null) {
            return null;
        }
        Object objectValue = cnf.getObjectValue();
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof Map) {
            return (String)((Map)objectValue).get(JWK_THUMBPRINT_CLAIM_NAME);
        }
        return null;
    }

    private static String getDpopProofJwtFromHeader(HttpServletRequest request) throws InvalidDpopProofException {
        String dpopProofJwt = null;
        Enumeration dpopHeaders = request.getHeaders("DPoP");
        while (dpopHeaders.hasMoreElements()) {
            String dpopValue = (String)dpopHeaders.nextElement();
            if (dpopProofJwt == null) {
                dpopProofJwt = dpopValue;
                continue;
            }
            AsAuditLogger.setDescription("Multiple DPoP headers found");
            throw new InvalidDpopProofException("Multiple DPoP headers found");
        }
        return dpopProofJwt;
    }

    private static void validateJtiClaim(JwtClaims jwtClaims) throws InvalidDpopProofException {
        String jti;
        if (!AUTHZ_SERVER_MANAGER.isDpopProofEnforceReplayPrevention()) {
            return;
        }
        try {
            jti = jwtClaims.getJwtId();
        }
        catch (MalformedClaimException e) {
            log.debug((Object)("The jti is malformed: " + ExceptionUtil.toStringWithCauses(e)));
            AsAuditLogger.setDescription("The jti is malformed");
            throw new InvalidDpopProofException("The jti is malformed");
        }
        if (jti == null) {
            AsAuditLogger.setDescription("The jti claim is required");
            throw new InvalidDpopProofException("The jti claim is required");
        }
        if (jti.length() > MAX_JTI_LENGTH) {
            AsAuditLogger.setDescription("The jti is too large");
            throw new InvalidDpopProofException("The jti is too large");
        }
        String assertionId = jti + ":" + jwtClaims.getClaimValueAsString("htu");
        Calendar expiry = Util.getUtcCalendar();
        expiry.add(13, AUTHZ_SERVER_MANAGER.getDpopProofLifetimeSeconds());
        try {
            if (REPLAY_PREVENTION_SERVICE.isReplay(assertionId, expiry)) {
                AsAuditLogger.setDescription("The DPoP proof has previously been processed");
                throw new InvalidDpopProofException("The DPoP proof has previously been processed");
            }
        }
        catch (BearerAssertionReplayPreventionServiceException e) {
            log.debug((Object)("Unable to perform DPoP proof replay check: " + ExceptionUtil.toStringWithCauses(e)));
            AsAuditLogger.setDescription("Unable to perform DPoP proof replay check");
            throw new InvalidDpopProofException("Unable to perform DPoP proof replay check");
        }
    }

    private static void validateHtmClaim(HttpServletRequest request, JwtClaims jwtClaims) throws InvalidDpopProofException {
        String htmClaim = jwtClaims.getClaimValueAsString("htm");
        if (htmClaim == null) {
            AsAuditLogger.setDescription("The htm claim is required");
            throw new InvalidDpopProofException("The htm claim is required");
        }
        if (!htmClaim.equalsIgnoreCase(request.getMethod())) {
            AsAuditLogger.setDescription("The htm claim is invalid");
            throw new InvalidDpopProofException("The htm claim is invalid");
        }
    }

    private static void validateHtuClaim(HttpServletRequest request, JwtClaims jwtClaims) throws InvalidDpopProofException {
        String htuClaim = jwtClaims.getClaimValueAsString("htu");
        if (htuClaim == null) {
            AsAuditLogger.setDescription("The htu claim is required");
            throw new InvalidDpopProofException("The htu claim is required");
        }
        Set<String> oauthVirtualIssuerHostnames = OAuthAudienceUtils.getInstance().getAudienceValues(request).stream().map(aud -> {
            try {
                return new URL((String)aud).getHost();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        String requestUrl = OAuthIssuerUtils.getInstance().getOAuthIssuerFromRequest(request) != null ? OAuthIssuerUtils.getInstance().getOAuthIssuerFromRequest(request).constructCurrentRequestUrl(request) : request.getRequestURL().toString();
        ResourceEvaluator.Result result = RESOURCE_EVALUATOR.isResourceMatch(htuClaim, requestUrl, oauthVirtualIssuerHostnames);
        if (!result.isMatch()) {
            log.debug((Object)("The htu claim is invalid: " + result.getMessage()));
            AsAuditLogger.setDescription("The htu claim is invalid");
            throw new InvalidDpopProofException("The htu claim is invalid");
        }
    }

    private static void validateIatNonceClaim(JwtClaims jwtClaims) throws UseDpopNonceException, InvalidDpopProofException {
        String nonce = jwtClaims.getClaimValueAsString("nonce");
        if (nonce == null && AUTHZ_SERVER_MANAGER.isDpopProofRequireNonce()) {
            AsAuditLogger.setDescription("nonce is required in DPoP proof");
            throw new UseDpopNonceException("nonce is required in DPoP proof");
        }
        long evaluationTimeMillis = System.currentTimeMillis();
        if (nonce != null && AUTHZ_SERVER_MANAGER.isDpopProofRequireNonce()) {
            long validUntilTimeMillis = NonceUtil.fromNonce(nonce);
            if (validUntilTimeMillis < evaluationTimeMillis) {
                log.debug((Object)("The nonce validity time " + validUntilTimeMillis + " is before the evaluation time " + evaluationTimeMillis));
                AsAuditLogger.setDescription("The nonce is invalid or expired");
                throw new InvalidDpopProofException("The nonce is invalid or expired");
            }
        } else {
            try {
                NumericDate iat = jwtClaims.getIssuedAt();
                long validUntilTimeMillis = iat.getValueInMillis() + (long)AUTHZ_SERVER_MANAGER.getDpopProofLifetimeSeconds() * 1000L;
                if (validUntilTimeMillis < evaluationTimeMillis) {
                    log.debug((Object)("The iat validity time " + validUntilTimeMillis + " is before the evaluation time " + evaluationTimeMillis));
                    AsAuditLogger.setDescription("The iat claim is invalid or expired");
                    throw new InvalidDpopProofException("The iat claim is invalid or expired");
                }
            }
            catch (MalformedClaimException e) {
                log.debug((Object)("The iat is malformed: " + ExceptionUtil.toStringWithCauses(e)));
                AsAuditLogger.setDescription("The iat is malformed");
                throw new InvalidDpopProofException("The iat is malformed");
            }
        }
    }

    private static void validateProtectedResourceDpopBoundAccessToken(String token, AccessToken accessToken, String jktFromDpopProof, JwtClaims jwtClaimsFromDpopProof) throws InvalidDpopProofException {
        if (token == null && accessToken == null) {
            throw new IllegalArgumentException("token and access token must not be null");
        }
        Map attributes = accessToken.getAttributes();
        String jktBoundToAccessToken = DpopUtil.getJwkThumbprintConfirmation(attributes);
        if (jktBoundToAccessToken == null) {
            return;
        }
        if (!jktFromDpopProof.equals(jktBoundToAccessToken)) {
            log.debug((Object)("The jkt confirmation claim '" + jktBoundToAccessToken + "' does not match the key bound to the access token '" + jktBoundToAccessToken + "'"));
            AsAuditLogger.setDescription("Invalid DPoP key binding");
            throw new InvalidDpopProofException("Invalid DPoP key binding");
        }
        String athFromDpopProof = jwtClaimsFromDpopProof.getClaimValueAsString("ath");
        if (athFromDpopProof == null) {
            AsAuditLogger.setDescription("The ath claim is required");
            throw new InvalidDpopProofException("The ath claim is required");
        }
        byte[] bytes = HashUtil.hashToBytes((String)token, (HashAlgorithm)HashAlgorithm.SHA256);
        String tokenHash = Base64URL.encodeToString((byte[])bytes);
        if (!athFromDpopProof.equals(tokenHash)) {
            log.debug((Object)("The ath claim  '" + athFromDpopProof + "' does not match the hash of the access token '" + tokenHash + "'"));
            AsAuditLogger.setDescription("The ath claim does not match the hash of the access token");
            throw new InvalidDpopProofException("The ath claim does not match the hash of the access token");
        }
    }

    private DpopUtil() {
    }
}

