/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.dpop;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwe.kdf.KdfUtil;
import org.jose4j.keys.AesKey;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.JoseException;
import org.jose4j.mac.MacUtil;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PFInternalTokenSettingsManager;

public final class NonceUtil {
    private static final Log log = LogFactory.getLog(DpopUtil.class);
    private static final int ENC_KEY_LENGTH = 256;
    private static final int MAC_KEY_LENGTH = 256;
    private static final int TAG_LENGTH = 12;
    private static final int IV_LENGTH = 16;
    private static final String CIPHER_ALG = "AES/CBC/PKCS5Padding";
    private static final String MAC_ALG = "HmacSHA256";
    private static final String DERIVED_MAC_KEY_ALG = "RAW";
    private static final String CONTEXT_QUALIFIER = "dpop noncer";
    private static final String ENC_QUALIFIER = "enc/";
    private static final String MAC_QUALIFIER = "hmac/";
    private static final PFInternalTokenSettingsManager PF_INTERNAL_TOKEN_SETTINGS_MANAGER = MgmtFactory.getPFInternalTokenSettingsManager();

    public static String toNonce(long validUntilTimeMillis) {
        try {
            byte[] timeBytes = ByteUtil.getBytes((long)validUntilTimeMillis);
            byte[] mainKey = PF_INTERNAL_TOKEN_SETTINGS_MANAGER.getPFInternalTokenSettings().getCurrentSecret();
            KdfUtil kdf = new KdfUtil();
            byte[] derivedEncryptionKey = kdf.kdf(mainKey, 256, CIPHER_ALG, ENC_QUALIFIER, CONTEXT_QUALIFIER);
            byte[] derivedMacKey = kdf.kdf(mainKey, 256, MAC_ALG, MAC_QUALIFIER, CONTEXT_QUALIFIER);
            Mac mac = MacUtil.getInitializedMac((String)MAC_ALG, (Key)new SecretKeySpec(derivedMacKey, DERIVED_MAC_KEY_ALG));
            IvParameterSpec ivSpec = new IvParameterSpec(ByteUtil.randomBytes((int)16), 0, 16);
            Cipher cipher = Cipher.getInstance(CIPHER_ALG);
            cipher.init(1, (Key)new AesKey(derivedEncryptionKey), ivSpec);
            byte[] cipherTextBytes = cipher.doFinal(timeBytes);
            byte[] iv = cipher.getIV();
            byte[] macOverCipherTextAndIv = mac.doFinal(ByteUtil.concat((byte[][])new byte[][]{cipherTextBytes, iv}));
            byte[] tag = ByteUtil.subArray((byte[])macOverCipherTextAndIv, (int)0, (int)12);
            byte[] concatenatedBytes = ByteUtil.concat((byte[][])new byte[][]{iv, cipherTextBytes, tag});
            return Base64Url.encode((byte[])concatenatedBytes);
        }
        catch (GeneralSecurityException | JoseException e) {
            log.error((Object)"Failed to encrypt nonce", e);
            throw new RuntimeException("Failed to encrypt nonce", e);
        }
    }

    public static long fromNonce(String nonce) {
        try {
            byte[] concatenatedBytes = Base64Url.decode((String)nonce);
            byte[] iv = ByteUtil.subArray((byte[])concatenatedBytes, (int)0, (int)16);
            KdfUtil kdf = new KdfUtil();
            byte[] mainKey = PF_INTERNAL_TOKEN_SETTINGS_MANAGER.getPFInternalTokenSettings().getCurrentSecret();
            byte[] derivedEncryptionKey = kdf.kdf(mainKey, 256, CIPHER_ALG, ENC_QUALIFIER, CONTEXT_QUALIFIER);
            byte[] derivedMacKey = kdf.kdf(mainKey, 256, MAC_ALG, MAC_QUALIFIER, CONTEXT_QUALIFIER);
            Cipher cipher = Cipher.getInstance(CIPHER_ALG);
            cipher.init(2, (Key)new AesKey(derivedEncryptionKey), new IvParameterSpec(iv));
            int cipherTextLength = concatenatedBytes.length - 28;
            byte[] cipherTextBytes = ByteUtil.subArray((byte[])concatenatedBytes, (int)16, (int)cipherTextLength);
            byte[] tag = ByteUtil.subArray((byte[])concatenatedBytes, (int)(cipherTextLength + 16), (int)12);
            Mac mac = MacUtil.getInitializedMac((String)MAC_ALG, (Key)new SecretKeySpec(derivedMacKey, DERIVED_MAC_KEY_ALG));
            byte[] macOverCipherTextAndIv = mac.doFinal(ByteUtil.concat((byte[][])new byte[][]{cipherTextBytes, iv}));
            if (ByteUtil.secureEquals((byte[])tag, (byte[])ByteUtil.subArray((byte[])macOverCipherTextAndIv, (int)0, (int)12))) {
                byte[] clearTextBytes = cipher.doFinal(cipherTextBytes);
                return ByteBuffer.wrap(clearTextBytes).getLong();
            }
            return -1L;
        }
        catch (Exception e) {
            log.debug((Object)("Failed to decrypt nonce: " + ExceptionUtil.toStringWithCauses(e)));
            return -1L;
        }
    }

    private NonceUtil() {
    }
}

