/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.exchange.domain;

import com.pingidentity.common.domain.WithDefaultInstanceSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicy;

public class TokenExchangeGeneratorPolicies
implements WithDefaultInstanceSupport<String> {
    private Map<String, TokenExchangeGeneratorPolicy> policies = new HashMap<String, TokenExchangeGeneratorPolicy>();
    private String defaultInstanceId;

    @Override
    public boolean hasDefaultInstanceId() {
        return StringUtils.isNotBlank((String)this.getDefaultInstanceId());
    }

    @Override
    public String getDefaultInstanceId() {
        return this.defaultInstanceId;
    }

    @Override
    public void setDefaultInstanceId(String defaultInstanceId) {
        this.defaultInstanceId = defaultInstanceId;
    }

    @Override
    public boolean containsConfigureInstances() {
        return !this.policies.isEmpty();
    }

    @Override
    public boolean containsInstance(String id) {
        return this.policies.containsKey(id);
    }

    public Map<String, TokenExchangeGeneratorPolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Map<String, TokenExchangeGeneratorPolicy> policies) {
        this.policies = policies;
    }

    public void addPolicy(TokenExchangeGeneratorPolicy tokenExchangeGeneratorPolicy) {
        this.policies.put(tokenExchangeGeneratorPolicy.getId(), tokenExchangeGeneratorPolicy);
    }

    public void removePolicy(String id) {
        this.policies.remove(id);
    }

    public TokenExchangeGeneratorPolicy getPolicy(String id) {
        return this.policies.get(id);
    }

    public Set<String> getPolicyIds() {
        return this.policies.keySet();
    }

    public Set<String> getPolicyNames() {
        return this.policies.values().stream().map(TokenExchangeGeneratorPolicy::getName).collect(Collectors.toSet());
    }
}

