/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.exchange.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorMapping;
import org.sourceid.saml20.domain.util.HierarchicalResourceMatchingUtil;

public class TokenExchangeGeneratorPolicy {
    private String id;
    private String name;
    private String defaultTokenType;
    private List<String> resourceUris = new ArrayList<String>();
    private List<TokenExchangeGeneratorMapping> mappings = new ArrayList<TokenExchangeGeneratorMapping>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultTokenType() {
        return this.defaultTokenType;
    }

    public void setDefaultTokenType(String defaultTokenType) {
        this.defaultTokenType = defaultTokenType;
    }

    public List<String> getResourceUris() {
        return this.resourceUris;
    }

    public void setResourceUris(List<String> resourceUris) {
        this.resourceUris = resourceUris;
    }

    public List<TokenExchangeGeneratorMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<TokenExchangeGeneratorMapping> mappings) {
        this.mappings = mappings;
    }

    public void addMapping(TokenExchangeGeneratorMapping mapping) {
        this.mappings.add(mapping);
    }

    public TokenExchangeGeneratorMapping getDefaultMapping() {
        if (StringUtils.isBlank((String)this.defaultTokenType)) {
            return null;
        }
        return this.mappings.stream().filter(mapping -> mapping.getTokenType().equals(this.defaultTokenType)).findFirst().orElse(null);
    }

    public TokenExchangeGeneratorMapping getMapping(String requestedTokenType) {
        if (StringUtils.isBlank((String)requestedTokenType)) {
            return null;
        }
        return this.mappings.stream().filter(mapping -> mapping.getTokenType().equals(requestedTokenType)).findFirst().orElse(null);
    }

    public boolean matchRequestedResource(String requestedResource) {
        return HierarchicalResourceMatchingUtil.match(requestedResource, this.resourceUris);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenExchangeGeneratorPolicy that = (TokenExchangeGeneratorPolicy)o;
        return this.id.equals(that.id) && this.name.equals(that.name) && Objects.equals(this.defaultTokenType, that.defaultTokenType) && Objects.equals(this.resourceUris, that.resourceUris) && Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.defaultTokenType, this.resourceUris, this.mappings);
    }
}

